/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.modules;

import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModuleFinder;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModuleInfo;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\nR\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleGraph;", "", "finder", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleFinder;", "(Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleFinder;)V", "moduleInfo", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo;", "getAllDependencies", "", "moduleNames", "kotlin-compiler"})
public final class JavaModuleGraph {
    private final Function1<String, JavaModuleInfo> moduleInfo;

    @NotNull
    public final List<String> getAllDependencies(@NotNull List<String> moduleNames) {
        Intrinsics.checkParameterIsNotNull(moduleNames, "moduleNames");
        LinkedHashSet<String> visited2 = SetsKt.linkedSetOf("java.base");
        Function1<String, Unit> dfs$ = new Function1<String, Unit>(this, visited2){
            final /* synthetic */ JavaModuleGraph this$0;
            final /* synthetic */ LinkedHashSet $visited;

            public final void invoke(@NotNull String module) {
                Intrinsics.checkParameterIsNotNull(module, "module");
                if (!this.$visited.add(module)) {
                    return;
                }
                JavaModuleInfo javaModuleInfo = (JavaModuleInfo)JavaModuleGraph.access$getModuleInfo$p(this.this$0).invoke(module);
                if (javaModuleInfo == null) {
                    return;
                }
                JavaModuleInfo moduleInfo2 = javaModuleInfo;
                for (JavaModuleInfo.Requires dependency : moduleInfo2.getRequires()) {
                    if (!dependency.isTransitive()) continue;
                    this.invoke(dependency.getModuleName());
                }
            }
            {
                this.this$0 = javaModuleGraph;
                this.$visited = linkedHashSet;
                super(1);
            }
        };
        Iterable $receiver$iv = moduleNames;
        for (Object element$iv : $receiver$iv) {
            String p1 = (String)element$iv;
            dfs$.invoke(p1);
        }
        return CollectionsKt.toList((Iterable)visited2);
    }

    public JavaModuleGraph(@NotNull JavaModuleFinder finder) {
        Intrinsics.checkParameterIsNotNull(finder, "finder");
        this.moduleInfo = LockBasedStorageManager.NO_LOCKS.createMemoizedFunctionWithNullableValues((Function1)new Function1<String, JavaModuleInfo>(finder){

            @Nullable
            public final JavaModuleInfo invoke(@NotNull String p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return ((JavaModuleFinder)this.receiver).findModule(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(JavaModuleFinder.class);
            }

            public final String getName() {
                return "findModule";
            }

            public final String getSignature() {
                return "findModule(Ljava/lang/String;)Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo;";
            }
        });
    }

    @NotNull
    public static final /* synthetic */ Function1 access$getModuleInfo$p(JavaModuleGraph $this) {
        return $this.moduleInfo;
    }
}

