/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassOwnerEx;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiElementFinderImpl
extends PsiElementFinder
implements DumbAware {
    private final Project myProject;
    private final JavaFileManager myFileManager;

    public PsiElementFinderImpl(Project project, JavaFileManager javaFileManager) {
        this.myProject = project;
        this.myFileManager = javaFileManager;
    }

    @Override
    public PsiClass findClass(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope) {
        if (qualifiedName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/PsiElementFinderImpl", "findClass"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/PsiElementFinderImpl", "findClass"));
        }
        return this.myFileManager.findClass(qualifiedName2, scope);
    }

    @Override
    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope) {
        if (qualifiedName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/PsiElementFinderImpl", "findClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/PsiElementFinderImpl", "findClasses"));
        }
        PsiClass[] psiClassArray = this.myFileManager.findClasses(qualifiedName2, scope);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFinderImpl", "findClasses"));
        }
        return psiClassArray;
    }

    @Override
    public PsiPackage findPackage(@NotNull String qualifiedName2) {
        if (qualifiedName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/PsiElementFinderImpl", "findPackage"));
        }
        return this.myFileManager.findPackage(qualifiedName2);
    }

    @Override
    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/PsiElementFinderImpl", "getSubPackages"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/PsiElementFinderImpl", "getSubPackages"));
        }
        HashMap<String, PsiPackage> packagesMap = new HashMap<String, PsiPackage>();
        String qualifiedName2 = psiPackage.getQualifiedName();
        for (PsiDirectory dir : psiPackage.getDirectories(scope)) {
            PsiDirectory[] subDirs;
            for (PsiDirectory subDir : subDirs = dir.getSubdirectories()) {
                String subQualifiedName;
                PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(subDir);
                if (aPackage == null || !(subQualifiedName = aPackage.getQualifiedName()).startsWith(qualifiedName2) || packagesMap.containsKey(subQualifiedName)) continue;
                packagesMap.put(aPackage.getQualifiedName(), aPackage);
            }
        }
        packagesMap.remove(qualifiedName2);
        PsiPackage[] psiPackageArray = packagesMap.values().toArray(new PsiPackage[packagesMap.size()]);
        if (psiPackageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFinderImpl", "getSubPackages"));
        }
        return psiPackageArray;
    }

    @Override
    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/PsiElementFinderImpl", "getClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/PsiElementFinderImpl", "getClasses"));
        }
        PsiClass[] psiClassArray = this.getClasses(null, psiPackage, scope);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFinderImpl", "getClasses"));
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public PsiClass[] getClasses(@Nullable String shortName, @NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/PsiElementFinderImpl", "getClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/PsiElementFinderImpl", "getClasses"));
        }
        ArrayList<PsiClass> list2 = null;
        String packageName = psiPackage.getQualifiedName();
        for (PsiDirectory dir : psiPackage.getDirectories(scope)) {
            PsiClass[] classes2 = JavaDirectoryService.getInstance().getClasses(dir);
            if (classes2.length == 0) continue;
            if (list2 == null) {
                list2 = new ArrayList<PsiClass>();
            }
            for (PsiClass aClass2 : classes2) {
                String qualifiedName2 = aClass2.getQualifiedName();
                if (qualifiedName2 != null) {
                    qualifiedName2 = StringUtil.getPackageName(qualifiedName2);
                }
                if (!Comparing.strEqual(qualifiedName2, packageName) || shortName != null && !shortName.equals(aClass2.getName())) continue;
                list2.add(aClass2);
            }
        }
        if (list2 == null) {
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFinderImpl", "getClasses"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        if (list2.size() > 1) {
            ContainerUtil.quickSort(list2, PsiClassUtil.createScopeComparator(scope));
        }
        PsiClass[] psiClassArray = list2.toArray(new PsiClass[list2.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFinderImpl", "getClasses"));
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/PsiElementFinderImpl", "getClassNames"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/PsiElementFinderImpl", "getClassNames"));
        }
        HashSet<String> names2 = null;
        FileIndexFacade facade = FileIndexFacade.getInstance(this.myProject);
        for (PsiDirectory dir : psiPackage.getDirectories(scope)) {
            for (PsiFile file2 : dir.getFiles()) {
                Set<String> inFile;
                VirtualFile vFile;
                if (!(file2 instanceof PsiClassOwner) || file2.getViewProvider().getLanguages().size() != 1 || (vFile = file2.getVirtualFile()) != null && !(file2 instanceof PsiCompiledElement) && !facade.isInSourceContent(vFile) && (!scope.isForceSearchingInLibrarySources() || !StubTreeLoader.getInstance().canHaveStub(vFile))) continue;
                Set<String> set = inFile = file2 instanceof PsiClassOwnerEx ? ((PsiClassOwnerEx)file2).getClassNames() : PsiElementFinderImpl.getClassNames(((PsiClassOwner)file2).getClasses());
                if (inFile.isEmpty()) continue;
                if (names2 == null) {
                    names2 = new HashSet<String>();
                }
                names2.addAll(inFile);
            }
        }
        Set<String> set = names2 == null ? Collections.emptySet() : names2;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFinderImpl", "getClassNames"));
        }
        return set;
    }

    @Override
    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, final @NotNull GlobalSearchScope scope, final @NotNull Processor<PsiDirectory> consumer, boolean includeLibrarySources) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/PsiElementFinderImpl", "processPackageDirectories"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/PsiElementFinderImpl", "processPackageDirectories"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/PsiElementFinderImpl", "processPackageDirectories"));
        }
        final PsiManager psiManager = PsiManager.getInstance(this.myProject);
        return PackageIndex.getInstance(this.myProject).getDirsByPackageName(psiPackage.getQualifiedName(), includeLibrarySources).forEach((Processor<VirtualFile>)new ReadActionProcessor<VirtualFile>(){

            @Override
            public boolean processInReadAction(VirtualFile dir) {
                if (!scope.contains(dir)) {
                    return true;
                }
                PsiDirectory psiDir = psiManager.findDirectory(dir);
                return psiDir == null || consumer.process(psiDir);
            }
        });
    }
}

