/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.NotNullProducer;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.RetinaImage;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.WeakHashMap;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.InvocationEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.GrayFilter;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.undo.UndoManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.java2d.SunGraphicsEnvironment;

public class UIUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ui.UIUtil");
    private static final StyleSheet DEFAULT_HTML_KIT_CSS;
    private static final AtomicNotNullLazyValue<Boolean> X_RENDER_ACTIVE;
    private static final String[] STANDARD_FONT_SIZES;
    private static final GrayFilter DEFAULT_GRAY_FILTER;
    private static final GrayFilter DARCULA_GRAY_FILTER;
    public static final Pattern CLOSE_TAG_PATTERN;
    public static Key<Integer> KEEP_BORDER_SIDES;
    private static Key<UndoManager> UNDO_MANAGER;
    private static final AbstractAction REDO_ACTION;
    private static final AbstractAction UNDO_ACTION;
    private static final Color UNFOCUSED_SELECTION_COLOR;
    private static final Color ACTIVE_HEADER_COLOR;
    private static final Color INACTIVE_HEADER_COLOR;
    private static final Color BORDER_COLOR;
    public static final Color CONTRAST_BORDER_COLOR;
    public static final Color SIDE_PANEL_BACKGROUND;
    public static final Color AQUA_SEPARATOR_FOREGROUND_COLOR;
    public static final Color AQUA_SEPARATOR_BACKGROUND_COLOR;
    public static final Color TRANSPARENT_COLOR;
    public static final Insets PANEL_REGULAR_INSETS;
    public static final Insets PANEL_SMALL_INSETS;
    public static final Border DEBUG_MARKER_BORDER;
    private static volatile Pair<String, Integer> ourSystemFontData;
    private static final Ref<Boolean> ourRetina;
    private static Boolean jreHiDPI;
    private static boolean jreHiDPI_earlierVersion;
    private static final Map<Class, Ref<Method>> ourDefaultIconMethodsCache;
    public static final Color GTK_AMBIANCE_TEXT_COLOR;
    public static final Color GTK_AMBIANCE_BACKGROUND_COLOR;
    public static final Key<Iterable<? extends Component>> NOT_IN_HIERARCHY_COMPONENTS;
    private static final Function<Component, JBIterable<Component>> COMPONENT_CHILDREN;
    private static final Function.Mono<Component> COMPONENT_PARENT;
    private static final Color DECORATED_ROW_BG_COLOR;
    private static final DocumentAdapter SET_TEXT_CHECKER;

    private static void blockATKWrapper() {
        if (!SystemInfo.isLinux || !Registry.is("linux.jdk.accessibility.atkwrapper.block")) {
            return;
        }
        if (ScreenReader.isEnabled("org.GNOME.Accessibility.AtkWrapper")) {
            System.setProperty("javax.accessibility.assistive_technologies", "java.lang.Object");
            LOG.info("org.GNOME.Accessibility.AtkWrapper is blocked, see IDEA-149219");
        }
    }

    private UIUtil() {
    }

    public static boolean isJreHiDPI() {
        return UIUtil.isJreHiDPI(null);
    }

    public static boolean isJreHiDPI(@Nullable GraphicsConfiguration gc) {
        return UIUtil.isJreHiDPIEnabled() && JBUI.isHiDPI(JBUI.sysScale(gc));
    }

    public static boolean isJreHiDPIEnabled() {
        if (jreHiDPI != null) {
            return jreHiDPI;
        }
        jreHiDPI = false;
        jreHiDPI_earlierVersion = true;
        if (SystemInfo.isLinux) {
            return false;
        }
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (ge instanceof SunGraphicsEnvironment) {
                Method m = ReflectionUtil.getDeclaredMethod(SunGraphicsEnvironment.class, "isUIScaleOn", new Class[0]);
                jreHiDPI = (Boolean)m.invoke((Object)ge, new Object[0]);
                jreHiDPI_earlierVersion = false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (SystemInfo.isMac) {
            jreHiDPI = !SystemInfo.isAppleJvm;
            return jreHiDPI;
        }
        return jreHiDPI;
    }

    static boolean isJreHiDPI_earlierVersion() {
        UIUtil.isJreHiDPIEnabled();
        return jreHiDPI_earlierVersion;
    }

    public static Object getClientProperty(Object component, @NotNull Object key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/ui/UIUtil", "getClientProperty"));
        }
        return component instanceof JComponent ? ((JComponent)component).getClientProperty(key) : null;
    }

    public static <T> T getClientProperty(Object component, @NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/ui/UIUtil", "getClientProperty"));
        }
        return (T)UIUtil.getClientProperty(component, key);
    }

    public static void drawLine(Graphics g, int x1, int y1, int x2, int y2) {
        g.drawLine(x1, y1, x2, y2);
    }

    public static Font getLabelFont() {
        return UIManager.getFont("Label.font");
    }

    public static Color getLabelForeground() {
        return UIManager.getColor("Label.foreground");
    }

    public static Color getTreeTextBackground() {
        return UIManager.getColor("Tree.textBackground");
    }

    public static Color getListBackground() {
        if (UIUtil.isUnderNimbusLookAndFeel()) {
            Color color = UIManager.getColor("List.background");
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        }
        return UIUtil.isUnderGTKLookAndFeel() ? UIUtil.getTreeTextBackground() : UIManager.getColor("List.background");
    }

    public static boolean isUnderNimbusLookAndFeel() {
        return UIManager.getLookAndFeel().getName().contains("Nimbus");
    }

    public static boolean isUnderAquaLookAndFeel() {
        return SystemInfo.isMac && UIManager.getLookAndFeel().getName().contains("Mac OS X");
    }

    public static boolean isUnderDarcula() {
        return UIManager.getLookAndFeel().getName().contains("Darcula");
    }

    public static boolean isUnderIntelliJLaF() {
        return UIManager.getLookAndFeel().getName().contains("IntelliJ");
    }

    public static boolean isUnderGTKLookAndFeel() {
        return SystemInfo.isXWindow && UIManager.getLookAndFeel().getName().contains("GTK");
    }

    public static void drawDottedRectangle(Graphics g, int x, int y, int x1, int y1) {
        int i1;
        for (i1 = x; i1 <= x1; i1 += 2) {
            UIUtil.drawLine(g, i1, y, i1, y);
        }
        for (i1 = y + (i1 != x1 + 1 ? 2 : 1); i1 <= y1; i1 += 2) {
            UIUtil.drawLine(g, x1, i1, x1, i1);
        }
        for (i1 = x1 - (i1 != y1 + 1 ? 2 : 1); i1 >= x; i1 -= 2) {
            UIUtil.drawLine(g, i1, y1, i1, y1);
        }
        for (i1 = y1 - (i1 != x - 1 ? 2 : 1); i1 >= y; i1 -= 2) {
            UIUtil.drawLine(g, x, i1, x, i1);
        }
    }

    @NotNull
    public static BufferedImage createImage(int width, int height, int type2) {
        if (UIUtil.isJreHiDPI()) {
            BufferedImage bufferedImage = RetinaImage.create(width, height, type2);
            if (bufferedImage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/UIUtil", "createImage"));
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, type2);
        if (bufferedImage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/UIUtil", "createImage"));
        }
        return bufferedImage;
    }

    public static void drawImage(Graphics g, Image image, int x, int y, ImageObserver observer) {
        UIUtil.drawImage(g, image, x, y, -1, -1, observer);
    }

    public static void drawImage(Graphics g, Image image, int x, int y, int width, int height, ImageObserver observer) {
        if (image instanceof JBHiDPIScaledImage) {
            Image img = ((JBHiDPIScaledImage)image).getDelegate();
            if (img == null) {
                img = image;
            }
            int dstw = width;
            int dsth = height;
            if (width == -1 && height == -1) {
                dstw = ImageUtil.getUserWidth(image);
                dsth = ImageUtil.getUserHeight(image);
            }
            int srcw = ImageUtil.getRealWidth(image);
            int srch = ImageUtil.getRealHeight(image);
            g.drawImage(img, x, y, x + dstw, y + dsth, 0, 0, srcw, srch, observer);
        } else if (width == -1 && height == -1) {
            g.drawImage(image, x, y, observer);
        } else {
            g.drawImage(image, x, y, x + width, y + height, 0, 0, width, height, observer);
        }
    }

    public static void dispatchAllInvocationEvents() {
        while (UIUtil.dispatchInvocationEvent()) {
        }
    }

    public static boolean dispatchInvocationEvent() {
        assert (EdtInvocationManager.getInstance().isEventDispatchThread()) : Thread.currentThread() + "; EDT: " + UIUtil.getEventQueueThread();
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        AWTEvent event = eventQueue.peekEvent();
        if (event == null) {
            return false;
        }
        try {
            event = eventQueue.getNextEvent();
            if (event instanceof InvocationEvent) {
                eventQueue.getClass().getDeclaredMethod("dispatchEvent", AWTEvent.class).invoke((Object)eventQueue, event);
            }
        }
        catch (InvocationTargetException e) {
            ExceptionUtil.rethrowAllAsUnchecked(e.getCause());
        }
        catch (Exception e) {
            LOG.error(e);
        }
        return true;
    }

    private static Thread getEventQueueThread() {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        try {
            Method method = ReflectionUtil.getDeclaredMethod(EventQueue.class, "getDispatchThread", new Class[0]);
            return (Thread)method.invoke((Object)eventQueue, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/util/ui/UIUtil", "invokeLaterIfNeeded"));
        }
        if (EdtInvocationManager.getInstance().isEventDispatchThread()) {
            runnable.run();
        } else {
            EdtInvocationManager.getInstance().invokeLater(runnable);
        }
    }

    public static void initSystemFontData() {
        Font winFont;
        if (ourSystemFontData != null) {
            return;
        }
        Font font = UIUtil.getLabelFont();
        Float forcedScale = null;
        if (Registry.is("ide.ui.scale.override")) {
            forcedScale = Float.valueOf((float)Registry.get("ide.ui.scale").asDouble());
        } else if (SystemInfo.isLinux && !SystemInfo.isJetbrainsJvm) {
            float scale = UIUtil.getScreenScale();
            if (scale > 1.0f) {
                forcedScale = Float.valueOf(scale);
            }
        } else if (SystemInfo.isWindows && (winFont = (Font)Toolkit.getDefaultToolkit().getDesktopProperty("win.messagebox.font")) != null) {
            font = winFont;
        }
        if (forcedScale != null) {
            font = font.deriveFont(12.0f * forcedScale.floatValue());
        }
        ourSystemFontData = Pair.create(font.getName(), font.getSize());
    }

    @Nullable
    public static Pair<String, Integer> getSystemFontData() {
        return ourSystemFontData;
    }

    private static float getScreenScale() {
        int dpi = 96;
        try {
            dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        float scale = 1.0f;
        scale = dpi < 120 ? 1.0f : (dpi < 144 ? 1.25f : (dpi < 168 ? 1.5f : (dpi < 192 ? 1.75f : 2.0f)));
        return scale;
    }

    @NotNull
    public static JBIterable<Component> uiChildren(@Nullable Component component) {
        if (!(component instanceof Container)) {
            JBIterable<Component> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/UIUtil", "uiChildren"));
            }
            return jBIterable;
        }
        Container container2 = (Container)component;
        JBIterable<Component> jBIterable = JBIterable.of(container2.getComponents());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/UIUtil", "uiChildren"));
        }
        return jBIterable;
    }

    static {
        UIUtil.blockATKWrapper();
        HTMLEditorKit kit = new HTMLEditorKit();
        DEFAULT_HTML_KIT_CSS = kit.getStyleSheet();
        kit.setStyleSheet(null);
        X_RENDER_ACTIVE = new AtomicNotNullLazyValue<Boolean>(){

            @Override
            @NotNull
            protected Boolean compute() {
                Boolean bl;
                if (!SystemInfo.isXWindow) {
                    Boolean bl2 = false;
                    if (bl2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/UIUtil$1", "compute"));
                    }
                    return bl2;
                }
                try {
                    Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("sun.awt.X11GraphicsEnvironment");
                    Method method = clazz.getMethod("isXRenderAvailable", new Class[0]);
                    bl = (Boolean)method.invoke(null, new Object[0]);
                }
                catch (Throwable e) {
                    Boolean bl3 = false;
                    if (bl3 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/UIUtil$1", "compute"));
                    }
                    return bl3;
                }
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/UIUtil$1", "compute"));
                }
                return bl;
            }
        };
        STANDARD_FONT_SIZES = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
        DEFAULT_GRAY_FILTER = new GrayFilter(true, 70);
        DARCULA_GRAY_FILTER = new GrayFilter(true, 20);
        CLOSE_TAG_PATTERN = Pattern.compile("<\\s*([^<>/ ]+)([^<>]*)/\\s*>", 2);
        KEEP_BORDER_SIDES = Key.create("keepBorderSides");
        UNDO_MANAGER = Key.create("undoManager");
        REDO_ACTION = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoManager manager = (UndoManager)UIUtil.getClientProperty(e.getSource(), UNDO_MANAGER);
                if (manager != null && manager.canRedo()) {
                    manager.redo();
                }
            }
        };
        UNDO_ACTION = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoManager manager = (UndoManager)UIUtil.getClientProperty(e.getSource(), UNDO_MANAGER);
                if (manager != null && manager.canUndo()) {
                    manager.undo();
                }
            }
        };
        UNFOCUSED_SELECTION_COLOR = Gray._212;
        ACTIVE_HEADER_COLOR = new Color(160, 186, 213);
        INACTIVE_HEADER_COLOR = Gray._128;
        BORDER_COLOR = Color.LIGHT_GRAY;
        CONTRAST_BORDER_COLOR = new JBColor(new NotNullProducer<Color>(){
            final Color color = new JBColor(0x9B9B9B, 0x282828);

            @Override
            @NotNull
            public Color produce() {
                if (SystemInfo.isMac && UIUtil.isUnderIntelliJLaF()) {
                    Gray gray = Gray.xC9;
                    if (gray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/UIUtil$4", "produce"));
                    }
                    return gray;
                }
                Color color = this.color;
                if (color == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/UIUtil$4", "produce"));
                }
                return color;
            }
        });
        SIDE_PANEL_BACKGROUND = new JBColor(new NotNullProducer<Color>(){
            final JBColor myDefaultValue = new JBColor(new Color(15133680), new Color(4080460));

            @Override
            @NotNull
            public Color produce() {
                Color color = UIManager.getColor("SidePanel.background");
                Color color2 = color == null ? this.myDefaultValue : color;
                if (color2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/UIUtil$5", "produce"));
                }
                return color2;
            }
        });
        AQUA_SEPARATOR_FOREGROUND_COLOR = new JBColor(Gray._190, Gray.x51);
        AQUA_SEPARATOR_BACKGROUND_COLOR = new JBColor(Gray._240, Gray.x51);
        TRANSPARENT_COLOR = new Color(0, 0, 0, 0);
        PANEL_REGULAR_INSETS = new Insets(8, 12, 8, 12);
        PANEL_SMALL_INSETS = new Insets(5, 8, 5, 8);
        DEBUG_MARKER_BORDER = new Border(){

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(0, 0, 0, 0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                Graphics g2 = g.create();
                try {
                    g2.setColor(JBColor.RED);
                    UIUtil.drawDottedRectangle(g2, x, y, x + width - 1, y + height - 1);
                }
                finally {
                    g2.dispose();
                }
            }

            @Override
            public boolean isBorderOpaque() {
                return true;
            }
        };
        ourRetina = Ref.create(SystemInfo.isMac ? null : Boolean.valueOf(false));
        ourDefaultIconMethodsCache = new ConcurrentHashMap<Class, Ref<Method>>();
        GTK_AMBIANCE_TEXT_COLOR = new Color(223, 219, 210);
        GTK_AMBIANCE_BACKGROUND_COLOR = new Color(67, 66, 63);
        NOT_IN_HIERARCHY_COMPONENTS = Key.create("NOT_IN_HIERARCHY_COMPONENTS");
        COMPONENT_CHILDREN = new Function<Component, JBIterable<Component>>(){

            @Override
            public JBIterable<Component> fun(@NotNull Component c) {
                if (c == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/ui/UIUtil$18", "fun"));
                }
                JBIterable<Object> result2 = c instanceof JMenu ? JBIterable.of(((JMenu)c).getMenuComponents()) : (c instanceof JComboBox && UIUtil.isUnderAquaLookAndFeel() ? JBIterable.empty() : UIUtil.uiChildren(c));
                if (c instanceof JComponent) {
                    JPopupMenu jpm;
                    JComponent jc = (JComponent)c;
                    Iterable<? extends Component> orphans = UIUtil.getClientProperty((Object)jc, NOT_IN_HIERARCHY_COMPONENTS);
                    if (orphans != null) {
                        result2 = result2.append(orphans);
                    }
                    if ((jpm = jc.getComponentPopupMenu()) != null && jpm.isVisible() && jpm.getInvoker() == jc) {
                        result2 = result2.append(Collections.singletonList(jpm));
                    }
                }
                return result2;
            }
        };
        COMPONENT_PARENT = new Function.Mono<Component>(){

            @Override
            public Component fun(Component c) {
                return c.getParent();
            }
        };
        DECORATED_ROW_BG_COLOR = new JBColor(new Color(242, 245, 249), new Color(65, 69, 71));
        SET_TEXT_CHECKER = new DocumentAdapter(){

            @Override
            protected void textChanged(DocumentEvent e) {
                Document document = e.getDocument();
                if (document instanceof AbstractDocument) {
                    StackTraceElement[] stackTrace;
                    for (StackTraceElement element : stackTrace = new Throwable().getStackTrace()) {
                        UndoableEditListener[] undoableEditListeners;
                        if (!element.getClassName().equals(JTextComponent.class.getName()) || !element.getMethodName().equals("setText")) continue;
                        for (final UndoableEditListener listener : undoableEditListeners = ((AbstractDocument)document).getUndoableEditListeners()) {
                            if (!(listener instanceof UndoManager)) continue;
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    ((UndoManager)listener).discardAllEdits();
                                }
                            };
                            SwingUtilities.invokeLater(runnable);
                            return;
                        }
                    }
                }
            }
        };
    }

    static final class DetectRetinaKit {
        private static final WeakHashMap<GraphicsDevice, Boolean> devicesToRetinaSupportCacheMap = new WeakHashMap();

        static boolean isOracleMacRetinaDevice(GraphicsDevice device) {
            if (SystemInfo.isAppleJvm) {
                return false;
            }
            Boolean isRetina = (Boolean)devicesToRetinaSupportCacheMap.get(device);
            if (isRetina != null) {
                return isRetina;
            }
            Method getScaleFactorMethod = null;
            try {
                getScaleFactorMethod = Class.forName("sun.awt.CGraphicsDevice").getMethod("getScaleFactor", new Class[0]);
            }
            catch (ClassNotFoundException e) {
                LOG.debug("CGraphicsDevice.getScaleFactor(): not an Oracle Mac JDK or API has been changed");
            }
            catch (NoSuchMethodException e) {
                LOG.debug("CGraphicsDevice.getScaleFactor(): not an Oracle Mac JDK or API has been changed");
            }
            catch (Exception e) {
                LOG.debug(e);
                LOG.debug("CGraphicsDevice.getScaleFactor(): probably it is Java 9");
            }
            try {
                isRetina = getScaleFactorMethod == null || (Integer)getScaleFactorMethod.invoke((Object)device, new Object[0]) != 1;
            }
            catch (IllegalAccessException e) {
                LOG.debug("CGraphicsDevice.getScaleFactor(): Access issue");
                isRetina = false;
            }
            catch (InvocationTargetException e) {
                LOG.debug("CGraphicsDevice.getScaleFactor(): Invocation issue");
                isRetina = false;
            }
            catch (IllegalArgumentException e) {
                LOG.debug("object is not an instance of declaring class: " + device.getClass().getName());
                isRetina = false;
            }
            devicesToRetinaSupportCacheMap.put((Object)device, (Object)isRetina);
            return isRetina;
        }
    }
}

