/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.jvm.JvmBindingContextSlices;
import org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionInfo;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/RuntimeAssertionsTypeChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "()V", "checkType", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expressionTypeWithSmartCast", "c", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "kotlin-compiler"})
public final class RuntimeAssertionsTypeChecker
implements AdditionalTypeChecker {
    public static final RuntimeAssertionsTypeChecker INSTANCE;

    @Override
    public void checkType(@NotNull KtExpression expression2, @NotNull KotlinType expressionType, @NotNull KotlinType expressionTypeWithSmartCast, @NotNull ResolutionContext<?> c) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(expressionType, "expressionType");
        Intrinsics.checkParameterIsNotNull(expressionTypeWithSmartCast, "expressionTypeWithSmartCast");
        Intrinsics.checkParameterIsNotNull(c, "c");
        if (TypeUtils.noExpectedType(c.expectedType)) {
            return;
        }
        KotlinType kotlinType = c.expectedType;
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "c.expectedType");
        RuntimeAssertionInfo assertionInfo2 = RuntimeAssertionInfo.Companion.create(kotlinType, expressionType, new RuntimeAssertionInfo.DataFlowExtras(c, expression2, expressionType){
            private final DataFlowValue dataFlowValue;
            final /* synthetic */ ResolutionContext $c;
            final /* synthetic */ KtExpression $expression;
            final /* synthetic */ KotlinType $expressionType;

            public boolean getCanBeNull() {
                return this.$c.dataFlowInfo.getStableNullability(this.dataFlowValue).canBeNull();
            }

            @NotNull
            public Set<KotlinType> getPossibleTypes() {
                return this.$c.dataFlowInfo.getCollectedTypes(this.dataFlowValue);
            }

            @NotNull
            public String getPresentableText() {
                String string = StringUtil.trimMiddle(this.$expression.getText(), 50);
                Intrinsics.checkExpressionValueIsNotNull(string, "StringUtil.trimMiddle(expression.text, 50)");
                return string;
            }
            {
                this.$c = $captured_local_variable$0;
                this.$expression = $captured_local_variable$1;
                this.$expressionType = $captured_local_variable$2;
                this.dataFlowValue = DataFlowValueFactory.createDataFlowValue($captured_local_variable$1, $captured_local_variable$2, $captured_local_variable$0);
            }
        });
        if (assertionInfo2 != null) {
            c.trace.record(JvmBindingContextSlices.RUNTIME_ASSERTION_INFO, expression2, assertionInfo2);
        }
    }

    private RuntimeAssertionsTypeChecker() {
        INSTANCE = this;
    }

    static {
        new RuntimeAssertionsTypeChecker();
    }
}

