/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.modules;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModuleInfo;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001:\u0002\u0014\u0015J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H&J\u0018\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\fH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule;", "", "isBinary", "", "()Z", "moduleInfoFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getModuleInfoFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "moduleRoot", "getModuleRoot", "name", "", "getName", "()Ljava/lang/String;", "exports", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "exportsTo", "moduleName", "Automatic", "Explicit", "kotlin-compiler"})
public interface JavaModule {
    @NotNull
    public String getName();

    @NotNull
    public VirtualFile getModuleRoot();

    @Nullable
    public VirtualFile getModuleInfoFile();

    public boolean isBinary();

    public boolean exports(@NotNull FqName var1);

    public boolean exportsTo(@NotNull FqName var1, @NotNull String var2);

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0016\u0010\n\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule$Automatic;", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule;", "name", "", "moduleRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;)V", "isBinary", "", "()Z", "moduleInfoFile", "getModuleInfoFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getModuleRoot", "getName", "()Ljava/lang/String;", "exports", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "exportsTo", "moduleName", "toString", "kotlin-compiler"})
    public static final class Automatic
    implements JavaModule {
        @NotNull
        private final String name;
        @NotNull
        private final VirtualFile moduleRoot;

        @Override
        @Nullable
        public VirtualFile getModuleInfoFile() {
            return null;
        }

        @Override
        public boolean isBinary() {
            return true;
        }

        @Override
        public boolean exports(@NotNull FqName packageFqName) {
            Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
            return true;
        }

        @Override
        public boolean exportsTo(@NotNull FqName packageFqName, @NotNull String moduleName) {
            Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
            Intrinsics.checkParameterIsNotNull(moduleName, "moduleName");
            return true;
        }

        @NotNull
        public String toString() {
            return this.getName();
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public VirtualFile getModuleRoot() {
            return this.moduleRoot;
        }

        public Automatic(@NotNull String name, @NotNull VirtualFile moduleRoot) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(moduleRoot, "moduleRoot");
            this.name = name;
            this.moduleRoot = moduleRoot;
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0011H\u0016J\b\u0010\u0019\u001a\u00020\u0011H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule$Explicit;", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule;", "moduleInfo", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo;", "moduleRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "moduleInfoFile", "isBinary", "", "(Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vfs/VirtualFile;Z)V", "()Z", "getModuleInfo", "()Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo;", "getModuleInfoFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getModuleRoot", "name", "", "getName", "()Ljava/lang/String;", "exports", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "exportsTo", "moduleName", "toString", "kotlin-compiler"})
    public static final class Explicit
    implements JavaModule {
        @NotNull
        private final JavaModuleInfo moduleInfo;
        @NotNull
        private final VirtualFile moduleRoot;
        @NotNull
        private final VirtualFile moduleInfoFile;
        private final boolean isBinary;

        @Override
        @NotNull
        public String getName() {
            return this.moduleInfo.getModuleName();
        }

        @Override
        public boolean exports(@NotNull FqName packageFqName) {
            boolean bl;
            block1: {
                Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
                Iterable $receiver$iv = this.moduleInfo.getExports();
                for (Object element$iv : $receiver$iv) {
                    JavaModuleInfo.Exports $fqName_toModules = (JavaModuleInfo.Exports)element$iv;
                    FqName fqName2 = $fqName_toModules.component1();
                    List<String> toModules = $fqName_toModules.component2();
                    if (!(Intrinsics.areEqual(fqName2, packageFqName) && toModules.isEmpty())) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        @Override
        public boolean exportsTo(@NotNull FqName packageFqName, @NotNull String moduleName) {
            boolean bl;
            block1: {
                Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
                Intrinsics.checkParameterIsNotNull(moduleName, "moduleName");
                Iterable $receiver$iv = this.moduleInfo.getExports();
                for (Object element$iv : $receiver$iv) {
                    JavaModuleInfo.Exports $fqName_toModules = (JavaModuleInfo.Exports)element$iv;
                    FqName fqName2 = $fqName_toModules.component1();
                    List<String> toModules = $fqName_toModules.component2();
                    if (!(Intrinsics.areEqual(fqName2, packageFqName) && (toModules.isEmpty() || toModules.contains(moduleName)))) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        @NotNull
        public String toString() {
            return this.getName();
        }

        @NotNull
        public final JavaModuleInfo getModuleInfo() {
            return this.moduleInfo;
        }

        @Override
        @NotNull
        public VirtualFile getModuleRoot() {
            return this.moduleRoot;
        }

        @Override
        @NotNull
        public VirtualFile getModuleInfoFile() {
            return this.moduleInfoFile;
        }

        @Override
        public boolean isBinary() {
            return this.isBinary;
        }

        public Explicit(@NotNull JavaModuleInfo moduleInfo, @NotNull VirtualFile moduleRoot, @NotNull VirtualFile moduleInfoFile, boolean isBinary) {
            Intrinsics.checkParameterIsNotNull(moduleInfo, "moduleInfo");
            Intrinsics.checkParameterIsNotNull(moduleRoot, "moduleRoot");
            Intrinsics.checkParameterIsNotNull(moduleInfoFile, "moduleInfoFile");
            this.moduleInfo = moduleInfo;
            this.moduleRoot = moduleRoot;
            this.moduleInfoFile = moduleInfoFile;
            this.isBinary = isBinary;
        }
    }
}

