/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiVariableEx;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.JavaDummyHolder;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.RowIcon;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiLocalVariableImpl
extends CompositePsiElement
implements PsiLocalVariable,
PsiVariableEx,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiLocalVariableImpl");
    private volatile String myCachedName;

    public PsiLocalVariableImpl() {
        this(LOCAL_VARIABLE);
    }

    protected PsiLocalVariableImpl(IElementType type2) {
        super(type2);
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myCachedName = null;
    }

    @Override
    @NotNull
    public final PsiIdentifier getNameIdentifier() {
        PsiElement element = this.findChildByRoleAsPsiElement(9);
        assert (element instanceof PsiIdentifier) : this.getText();
        PsiIdentifier psiIdentifier = (PsiIdentifier)element;
        if (psiIdentifier == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl", "getNameIdentifier"));
        }
        return psiIdentifier;
    }

    @Override
    @NotNull
    public final String getName() {
        String cachedName = this.myCachedName;
        if (cachedName == null) {
            this.myCachedName = cachedName = this.getNameIdentifier().getText();
        }
        String string = cachedName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl", "getName"));
        }
        return string;
    }

    @Override
    public void setInitializer(PsiExpression initializer2) throws IncorrectOperationException {
        JavaSharedImplUtil.setInitializer(this, initializer2);
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl", "setName"));
        }
        PsiImplUtil.setName(this.getNameIdentifier(), name);
        return this;
    }

    @Override
    @NotNull
    public final PsiType getType() {
        PsiType psiType = JavaSharedImplUtil.getType(this.getTypeElement(), this.getNameIdentifier());
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl", "getType"));
        }
        return psiType;
    }

    @Override
    @NotNull
    public PsiTypeElement getTypeElement() {
        PsiTypeElement typeElement = PsiTreeUtil.getChildOfType(this, PsiTypeElement.class);
        if (typeElement != null) {
            PsiTypeElement psiTypeElement = typeElement;
            if (psiTypeElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl", "getTypeElement"));
            }
            return psiTypeElement;
        }
        PsiElement parent2 = this.getParent();
        assert (parent2 != null) : "no parent; " + this + "; [" + this.getText() + "]";
        PsiLocalVariable localVariable = PsiTreeUtil.getChildOfType(parent2, PsiLocalVariable.class);
        assert (localVariable != null) : "no local variable in " + Arrays.toString(parent2.getChildren());
        typeElement = PsiTreeUtil.getChildOfType(localVariable, PsiTypeElement.class);
        assert (typeElement != null) : "no type element in " + Arrays.toString(localVariable.getChildren());
        PsiTypeElement psiTypeElement = typeElement;
        if (psiTypeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl", "getTypeElement"));
        }
        return psiTypeElement;
    }

    @Override
    public PsiModifierList getModifierList() {
        CompositeElement parent2 = this.getTreeParent();
        if (parent2 == null) {
            return null;
        }
        CompositeElement first = (CompositeElement)parent2.findChildByType(LOCAL_VARIABLE);
        return first != null ? (PsiModifierList)first.findChildByRoleAsPsiElement(8) : null;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl", "hasModifierProperty"));
        }
        PsiModifierList modifierList = this.getModifierList();
        return modifierList != null && modifierList.hasModifierProperty(name);
    }

    @Override
    public PsiExpression getInitializer() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(21);
    }

    @Override
    public boolean hasInitializer() {
        return this.getInitializer() != null;
    }

    @Override
    public Object computeConstantValue() {
        return this.computeConstantValue(new THashSet<PsiVariable>());
    }

    @Override
    public Object computeConstantValue(Set<PsiVariable> visitedVars) {
        if (!this.hasModifierProperty("final")) {
            return null;
        }
        PsiType type2 = this.getType();
        if (!(type2 instanceof PsiPrimitiveType) && !type2.equalsToText("java.lang.String")) {
            return null;
        }
        PsiExpression initializer2 = this.getInitializer();
        if (initializer2 == null) {
            return null;
        }
        return PsiConstantEvaluationHelperImpl.computeCastTo(initializer2, this.getType(), visitedVars);
    }

    @Override
    public int getTextOffset() {
        return this.getNameIdentifier().getTextOffset();
    }

    @Override
    public void normalizeDeclaration() throws IncorrectOperationException {
        PsiElement[] variables;
        CheckUtil.checkWritable(this);
        CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
        CompositeElement statement2 = this.getTreeParent();
        PsiElement psiElement = SourceTreeToPsiMap.treeElementToPsi(statement2);
        PsiElement[] psiElementArray = variables = psiElement instanceof PsiDeclarationStatement ? ((PsiDeclarationStatement)psiElement).getDeclaredElements() : PsiElement.EMPTY_ARRAY;
        if (variables.length > 1) {
            PsiModifierList modifierList = this.getModifierList();
            PsiTypeElement typeElement = this.getTypeElement();
            assert (modifierList != null) : this.getText();
            CompositeElement last = statement2;
            for (int i = 1; i < variables.length; ++i) {
                ASTNode typeCopy = typeElement.copy().getNode();
                ASTNode modifierListCopy = modifierList.copy().getNode();
                CompositeElement variable = (CompositeElement)SourceTreeToPsiMap.psiToTreeNotNull(variables[i]);
                ASTNode comma = PsiImplUtil.skipWhitespaceAndCommentsBack(variable.getTreePrev());
                if (comma != null && comma.getElementType() == JavaTokenType.COMMA) {
                    CodeEditUtil.removeChildren(statement2, comma, variable.getTreePrev());
                }
                CodeEditUtil.removeChild(statement2, variable);
                CharTable charTableByTree = SharedImplUtil.findCharTableByTree(statement2);
                CompositeElement statement1 = Factory.createCompositeElement(DECLARATION_STATEMENT, charTableByTree, this.getManager());
                statement1.addChild(variable, null);
                LeafElement space = Factory.createSingleLeafElement(TokenType.WHITE_SPACE, " ", 0, 1, treeCharTab, this.getManager());
                variable.addChild(space, variable.getFirstChildNode());
                variable.addChild(typeCopy, variable.getFirstChildNode());
                if (modifierListCopy.getTextLength() > 0) {
                    space = Factory.createSingleLeafElement(TokenType.WHITE_SPACE, " ", 0, 1, treeCharTab, this.getManager());
                    variable.addChild(space, variable.getFirstChildNode());
                }
                variable.addChild(modifierListCopy, variable.getFirstChildNode());
                LeafElement semicolon = Factory.createSingleLeafElement(JavaTokenType.SEMICOLON, ";", 0, 1, treeCharTab, this.getManager());
                SourceTreeToPsiMap.psiToTreeNotNull(variables[i - 1]).addChild(semicolon, null);
                CodeEditUtil.addChild(statement2.getTreeParent(), statement1, last.getTreeNext());
                last = statement1;
            }
        }
        JavaSharedImplUtil.normalizeBrackets(this);
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        ASTNode eq;
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl", "deleteChildInternal"));
        }
        if (this.getChildRole(child) == 21 && (eq = this.findChildByRole(20)) != null) {
            this.deleteChildInternal(eq);
        }
        super.deleteChildInternal(child);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 8: {
                return this.findChildByType(MODIFIER_LIST);
            }
            case 10: {
                return this.findChildByType(TYPE);
            }
            case 9: {
                return this.findChildByType(JavaTokenType.IDENTIFIER);
            }
            case 20: {
                return this.findChildByType(JavaTokenType.EQ);
            }
            case 21: {
                return this.findChildByType(ElementType.EXPRESSION_BIT_SET);
            }
            case 22: 
        }
        return TreeUtil.findChildBackward(this, JavaTokenType.SEMICOLON);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == MODIFIER_LIST) {
            return 8;
        }
        if (i == TYPE) {
            return this.getChildRole(child, 10);
        }
        if (i == JavaTokenType.IDENTIFIER) {
            return this.getChildRole(child, 9);
        }
        if (i == JavaTokenType.EQ) {
            return this.getChildRole(child, 20);
        }
        if (i == JavaTokenType.SEMICOLON) {
            return this.getChildRole(child, 22);
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 21;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitLocalVariable(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl", "processDeclarations"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl", "processDeclarations"));
        }
        if (lastParent == null) {
            return true;
        }
        if (lastParent.getContext() instanceof JavaDummyHolder) {
            return processor.execute(this, state2);
        }
        if (lastParent.getParent() != this) {
            return true;
        }
        ASTNode lastParentTree = SourceTreeToPsiMap.psiElementToTree(lastParent);
        return this.getChildRole(lastParentTree) != 21 || processor.execute(this, state2);
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public String toString() {
        return "PsiLocalVariable:" + this.getName();
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        PsiElement parentElement = this.getParent();
        if (parentElement instanceof PsiDeclarationStatement) {
            LocalSearchScope localSearchScope = new LocalSearchScope(parentElement.getParent());
            if (localSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl", "getUseScope"));
            }
            return localSearchScope;
        }
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementUseScope(this);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl", "getUseScope"));
        }
        return globalSearchScope;
    }

    @Override
    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(PlatformIcons.VARIABLE_ICON, this, false);
        return ElementPresentationUtil.addVisibilityIcon(this, flags, baseIcon);
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }
}

