/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PathUtilRt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathUtil {
    private PathUtil() {
    }

    @Nullable
    public static String getLocalPath(@Nullable VirtualFile file) {
        if (file == null || !file.isValid()) {
            return null;
        }
        if (file.getFileSystem().getProtocol().equals("jar") && file.getParent() != null) {
            return null;
        }
        return PathUtil.getLocalPath(file.getPath());
    }

    @NotNull
    public static String getLocalPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/PathUtil", "getLocalPath"));
        }
        String string = FileUtil.toSystemDependentName(StringUtil.trimEnd(path, "!/"));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtil", "getLocalPath"));
        }
        return string;
    }

    @NotNull
    public static String toPresentableUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/PathUtil", "toPresentableUrl"));
        }
        String string = PathUtil.getLocalPath(VirtualFileManager.extractPath(url));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtil", "toPresentableUrl"));
        }
        return string;
    }

    @NotNull
    public static String getFileName(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/PathUtil", "getFileName"));
        }
        String string = PathUtilRt.getFileName(path);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtil", "getFileName"));
        }
        return string;
    }
}

