/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.Bits;
import com.intellij.util.io.IOStatistics;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.InlineKeyDescriptor;
import com.intellij.util.io.IntToIntBtree;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.io.ResizeableMappedFile;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentBTreeEnumerator<Data>
extends PersistentEnumeratorBase<Data> {
    public static final int PAGE_SIZE = SystemProperties.getIntProperty("idea.btree.page.size", 32768);
    private int myLogicalFileLength;
    private int myDataPageStart;
    private int myFirstPageStart;
    private int myDataPageOffset;
    private int myDuplicatedValuesPageStart;
    private int myDuplicatedValuesPageOffset;
    private int myValuesCount;
    private int myCollisions;
    private int myExistingKeysEnumerated;
    private IntToIntBtree myBTree;
    private final boolean myInlineKeysNoMapping;
    private boolean myExternalKeysNoMapping;
    static final int VERSION;
    private final int[] myResultBuf;

    public PersistentBTreeEnumerator(@NotNull File file, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize, @Nullable PagedFileStorage.StorageLockContext lockContext) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/io/PersistentBTreeEnumerator", "<init>"));
        }
        if (dataDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataDescriptor", "com/intellij/util/io/PersistentBTreeEnumerator", "<init>"));
        }
        this(file, dataDescriptor, initialSize, lockContext, 0);
    }

    public PersistentBTreeEnumerator(@NotNull File file, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize, @Nullable PagedFileStorage.StorageLockContext lockContext, int version) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/io/PersistentBTreeEnumerator", "<init>"));
        }
        if (dataDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataDescriptor", "com/intellij/util/io/PersistentBTreeEnumerator", "<init>"));
        }
        super(file, new ResizeableMappedFile(file, initialSize, lockContext, 0x100000, true, IOUtil.ourByteBuffersUseNativeByteOrder), dataDescriptor, initialSize, new PersistentEnumeratorBase.Version(VERSION + version), new RecordBufferHandler(), false);
        this.myResultBuf = new int[1];
        this.myInlineKeysNoMapping = this.myDataDescriptor instanceof InlineKeyDescriptor && !this.wantKeyMapping();
        boolean bl = this.myExternalKeysNoMapping = !(this.myDataDescriptor instanceof InlineKeyDescriptor) && !this.wantKeyMapping();
        if (this.myBTree == null) {
            try {
                this.lockStorage();
                this.storeVars(false);
                this.initBtree(false);
                this.storeBTreeVars(false);
            }
            catch (IOException e) {
                try {
                    this.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw e;
            }
            catch (Throwable e) {
                LOG.info(e);
                try {
                    this.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new PersistentEnumeratorBase.CorruptedException(file);
            }
            finally {
                this.unlockStorage();
            }
        }
    }

    @NotNull
    private File indexFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/io/PersistentBTreeEnumerator", "indexFile"));
        }
        File file2 = new File(file.getPath() + "_i");
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/PersistentBTreeEnumerator", "indexFile"));
        }
        return file2;
    }

    protected boolean wantKeyMapping() {
        return false;
    }

    private void initBtree(boolean initial) throws IOException {
        this.myBTree = new IntToIntBtree(PAGE_SIZE, this.indexFile(this.myFile), this.myStorage.getPagedFileStorage().getStorageLockContext(), initial);
    }

    private void storeVars(boolean toDisk) {
        this.myLogicalFileLength = this.store(20, this.myLogicalFileLength, toDisk);
        this.myDataPageStart = this.store(24, this.myDataPageStart, toDisk);
        this.myDataPageOffset = this.store(28, this.myDataPageOffset, toDisk);
        this.myFirstPageStart = this.store(32, this.myFirstPageStart, toDisk);
        this.myDuplicatedValuesPageStart = this.store(36, this.myDuplicatedValuesPageStart, toDisk);
        this.myDuplicatedValuesPageOffset = this.store(40, this.myDuplicatedValuesPageOffset, toDisk);
        this.myValuesCount = this.store(44, this.myValuesCount, toDisk);
        this.myCollisions = this.store(48, this.myCollisions, toDisk);
        this.myExistingKeysEnumerated = this.store(52, this.myExistingKeysEnumerated, toDisk);
        this.storeBTreeVars(toDisk);
    }

    private void storeBTreeVars(boolean toDisk) {
        IntToIntBtree tree = this.myBTree;
        if (tree != null) {
            int BTREE_DATA_START = 56;
            tree.persistVars(new IntToIntBtree.BtreeDataStorage(){

                @Override
                public int persistInt(int offset2, int value, boolean toDisk) {
                    return PersistentBTreeEnumerator.this.store(56 + offset2, value, toDisk);
                }
            }, toDisk);
        }
    }

    private int store(int offset2, int value, boolean toDisk) {
        assert (offset2 + 4 < PAGE_SIZE);
        if (toDisk) {
            if (this.myFirstPageStart == -1 || this.myStorage.getInt(offset2) != value) {
                this.myStorage.putInt(offset2, value);
            }
        } else {
            value = this.myStorage.getInt(offset2);
        }
        return value;
    }

    @Override
    protected void setupEmptyFile() throws IOException {
        this.myLogicalFileLength = PAGE_SIZE;
        this.myDataPageStart = -1;
        this.myFirstPageStart = -1;
        this.myDuplicatedValuesPageStart = -1;
        this.initBtree(true);
        this.storeVars(true);
    }

    @Override
    protected void doClose() throws IOException {
        try {
            super.doClose();
        }
        finally {
            IntToIntBtree tree = this.myBTree;
            if (tree != null) {
                tree.doClose();
            }
        }
    }

    private int allocPage() {
        int pageStart = this.myLogicalFileLength;
        this.myLogicalFileLength += PAGE_SIZE;
        return pageStart;
    }

    @Override
    public boolean processAllDataObject(final @NotNull Processor<Data> processor, final @Nullable PersistentEnumeratorBase.DataFilter filter2) throws IOException {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/io/PersistentBTreeEnumerator", "processAllDataObject"));
        }
        if (this.myInlineKeysNoMapping) {
            return this.traverseAllRecords(new PersistentEnumeratorBase.RecordsProcessor(){

                @Override
                public boolean process(int record2) throws IOException {
                    if (filter2 == null || filter2.accept(record2)) {
                        Object data2 = ((InlineKeyDescriptor)PersistentBTreeEnumerator.this.myDataDescriptor).fromInt(this.getCurrentKey());
                        return processor.process(data2);
                    }
                    return true;
                }
            });
        }
        return super.processAllDataObject(processor, filter2);
    }

    @Override
    public boolean traverseAllRecords(final @NotNull PersistentEnumeratorBase.RecordsProcessor p) throws IOException {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/util/io/PersistentBTreeEnumerator", "traverseAllRecords"));
        }
        try {
            this.lockStorage();
            boolean bl = this.myBTree.processMappings(new IntToIntBtree.KeyValueProcessor(){

                @Override
                public boolean process(int key, int value) throws IOException {
                    p.setCurrentKey(key);
                    if (value > 0) {
                        if (!p.process(value)) {
                            return false;
                        }
                    } else {
                        if (PersistentBTreeEnumerator.this.myInlineKeysNoMapping) {
                            return p.process(value);
                        }
                        int rec = -value;
                        while (rec != 0) {
                            int id = PersistentBTreeEnumerator.this.myStorage.getInt(rec);
                            if (!p.process(id)) {
                                return false;
                            }
                            rec = PersistentBTreeEnumerator.this.myStorage.getInt(rec + 4);
                        }
                    }
                    return true;
                }
            });
            return bl;
        }
        catch (IllegalStateException e) {
            PersistentEnumeratorBase.CorruptedException corruptedException = new PersistentEnumeratorBase.CorruptedException(this.myFile);
            corruptedException.initCause(e);
            throw corruptedException;
        }
        finally {
            this.unlockStorage();
        }
    }

    protected int addrToIndex(int addr) {
        assert (this.myExternalKeysNoMapping);
        return addr + 1;
    }

    @Override
    protected int indexToAddr(int idx) {
        if (this.myExternalKeysNoMapping) {
            IntToIntBtree.myAssert(idx > 0);
            return idx - 1;
        }
        int anInt = this.myStorage.getInt(idx);
        return anInt;
    }

    @Override
    protected int setupValueId(int hashCode2, int dataOff) {
        if (this.myExternalKeysNoMapping) {
            return this.addrToIndex(dataOff);
        }
        PersistentEnumeratorBase.RecordBufferHandler<PersistentEnumeratorBase> recordHandler = this.getRecordHandler();
        byte[] buf = recordHandler.getRecordBuffer(this);
        int pos = recordHandler.recordWriteOffset(this, buf);
        this.myStorage.ensureSize(pos + buf.length);
        if (!this.myInlineKeysNoMapping) {
            this.myStorage.putInt(pos, dataOff);
        }
        return pos;
    }

    @Override
    public void setRecordHandler(@NotNull PersistentEnumeratorBase.RecordBufferHandler<PersistentEnumeratorBase> recordHandler) {
        if (recordHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recordHandler", "com/intellij/util/io/PersistentBTreeEnumerator", "setRecordHandler"));
        }
        this.myExternalKeysNoMapping = false;
        super.setRecordHandler(recordHandler);
    }

    @Override
    public Data getValue(int keyId, int processingKey) throws IOException {
        if (this.myInlineKeysNoMapping) {
            return (Data)((InlineKeyDescriptor)this.myDataDescriptor).fromInt(processingKey);
        }
        return super.getValue(keyId, processingKey);
    }

    public long getNonnegativeValue(Data key) throws IOException {
        assert (this.myInlineKeysNoMapping);
        try {
            this.lockStorage();
            boolean hasMapping = this.myBTree.get(((InlineKeyDescriptor)this.myDataDescriptor).toInt(key), this.myResultBuf);
            if (!hasMapping) {
                long l = 0L;
                return l;
            }
            long l = this.keyIdToNonnegattiveOffset(this.myResultBuf[0]);
            return l;
        }
        catch (IllegalStateException e) {
            PersistentEnumeratorBase.CorruptedException exception = new PersistentEnumeratorBase.CorruptedException(this.myFile);
            exception.initCause(e);
            throw exception;
        }
        finally {
            this.unlockStorage();
        }
    }

    public long keyIdToNonnegattiveOffset(int value) {
        if (value >= 0) {
            return value;
        }
        return this.myStorage.getLong(-value);
    }

    public void putNonnegativeValue(Data key, long value) throws IOException {
        assert (value >= 0L);
        assert (this.myInlineKeysNoMapping);
        try {
            this.lockStorage();
            int intKey = ((InlineKeyDescriptor)this.myDataDescriptor).toInt(key);
            this.markDirty(true);
            if (value < Integer.MAX_VALUE) {
                this.myBTree.put(intKey, (int)value);
            } else {
                boolean hasMapping = this.myBTree.get(intKey, this.myResultBuf);
                if (hasMapping && this.myResultBuf[0] < 0) {
                    this.myStorage.putLong(-this.myResultBuf[0], value);
                    return;
                }
                int pos = this.nextLongValueRecord();
                this.myStorage.putLong(pos, value);
                this.myBTree.put(intKey, -pos);
            }
        }
        catch (IllegalStateException e) {
            PersistentEnumeratorBase.CorruptedException exception = new PersistentEnumeratorBase.CorruptedException(this.myFile);
            exception.initCause(e);
            throw exception;
        }
        finally {
            this.unlockStorage();
        }
    }

    private int nextLongValueRecord() {
        assert (this.myInlineKeysNoMapping);
        if (this.myDuplicatedValuesPageStart == -1 || this.myDuplicatedValuesPageOffset == this.myBTree.pageSize) {
            this.myDuplicatedValuesPageStart = this.allocPage();
            this.myDuplicatedValuesPageOffset = 0;
        }
        int duplicatedValueOff = this.myDuplicatedValuesPageOffset;
        this.myDuplicatedValuesPageOffset += 8;
        return this.myDuplicatedValuesPageStart + duplicatedValueOff;
    }

    @Override
    protected synchronized int enumerateImpl(Data value, boolean onlyCheckForExisting, boolean saveNewValue) throws IOException {
        try {
            int n;
            this.lockStorage();
            int valueHC = this.myDataDescriptor.getHashCode(value);
            boolean hasMapping = this.myBTree.get(valueHC, this.myResultBuf);
            if (!hasMapping && onlyCheckForExisting) {
                int n2 = 0;
                return n2;
            }
            int indexNodeValueAddress = hasMapping ? this.myResultBuf[0] : 0;
            int collisionAddress = 0;
            boolean hasExistingData = false;
            if (!this.myInlineKeysNoMapping) {
                int address;
                collisionAddress = 0;
                if (indexNodeValueAddress > 0) {
                    if (this.isKeyAtIndex(value, indexNodeValueAddress)) {
                        if (!saveNewValue) {
                            ++this.myExistingKeysEnumerated;
                            int n3 = indexNodeValueAddress;
                            return n3;
                        }
                        hasExistingData = true;
                    }
                    collisionAddress = indexNodeValueAddress;
                } else if (indexNodeValueAddress < 0) {
                    collisionAddress = -indexNodeValueAddress;
                    while (true) {
                        if (this.isKeyAtIndex(value, address = this.myStorage.getInt(collisionAddress))) {
                            if (!saveNewValue) {
                                n = address;
                                return n;
                            }
                            hasExistingData = true;
                            break;
                        }
                        int newCollisionAddress = this.myStorage.getInt(collisionAddress + 4);
                        if (newCollisionAddress == 0) break;
                        collisionAddress = newCollisionAddress;
                    }
                }
                if (onlyCheckForExisting) {
                    address = 0;
                    return address;
                }
            } else if (hasMapping) {
                if (!saveNewValue) {
                    int address = indexNodeValueAddress;
                    return address;
                }
                hasExistingData = true;
            }
            int newValueId = this.writeData(value, valueHC);
            ++this.myValuesCount;
            if (IOStatistics.DEBUG && (this.myValuesCount & 0xFFFF) == 0) {
                IOStatistics.dump("Index " + this.myFile + ", values " + this.myValuesCount + ", existing keys enumerated:" + this.myExistingKeysEnumerated + ", storage size:" + this.myStorage.length());
                this.myBTree.dumpStatistics();
            }
            if (collisionAddress != 0) {
                if (hasExistingData) {
                    if (indexNodeValueAddress > 0) {
                        this.myBTree.put(valueHC, newValueId);
                    } else {
                        this.myStorage.putInt(collisionAddress, newValueId);
                    }
                } else {
                    int duplicatedValueOff;
                    if (indexNodeValueAddress > 0) {
                        duplicatedValueOff = this.nextDuplicatedValueRecord();
                        this.myBTree.put(valueHC, -duplicatedValueOff);
                        this.myStorage.putInt(duplicatedValueOff, indexNodeValueAddress);
                        collisionAddress = duplicatedValueOff;
                        ++this.myCollisions;
                    }
                    ++this.myCollisions;
                    duplicatedValueOff = this.nextDuplicatedValueRecord();
                    this.myStorage.putInt(collisionAddress + 4, duplicatedValueOff);
                    this.myStorage.putInt(duplicatedValueOff, newValueId);
                    this.myStorage.putInt(duplicatedValueOff + 4, 0);
                }
            } else {
                this.myBTree.put(valueHC, newValueId);
            }
            n = newValueId;
            return n;
        }
        catch (IllegalStateException e) {
            PersistentEnumeratorBase.CorruptedException exception = new PersistentEnumeratorBase.CorruptedException(this.myFile);
            exception.initCause(e);
            throw exception;
        }
        finally {
            this.unlockStorage();
        }
    }

    @Override
    boolean canReEnumerate() {
        return true;
    }

    @Override
    public Data valueOf(int idx) throws IOException {
        if (this.myInlineKeysNoMapping) assert (false) : "No valueOf for inline keys with no mapping option";
        return super.valueOf(idx);
    }

    private int nextDuplicatedValueRecord() {
        assert (!this.myInlineKeysNoMapping);
        if (this.myDuplicatedValuesPageStart == -1 || this.myDuplicatedValuesPageOffset == this.myBTree.pageSize) {
            this.myDuplicatedValuesPageStart = this.allocPage();
            this.myDuplicatedValuesPageOffset = 0;
        }
        int duplicatedValueOff = this.myDuplicatedValuesPageOffset;
        this.myDuplicatedValuesPageOffset += 8;
        return this.myDuplicatedValuesPageStart + duplicatedValueOff;
    }

    @Override
    protected void doFlush() throws IOException {
        this.myBTree.doFlush();
        this.storeVars(true);
        super.doFlush();
    }

    static {
        assert (0x100000 % PAGE_SIZE == 0) : "Page size should be divisor of 1048576";
        VERSION = 7 + IntToIntBtree.version() + PAGE_SIZE;
    }

    private static class RecordBufferHandler
    extends PersistentEnumeratorBase.RecordBufferHandler<PersistentBTreeEnumerator> {
        private byte[] myBuffer;

        private RecordBufferHandler() {
        }

        @Override
        int recordWriteOffset(@NotNull PersistentBTreeEnumerator enumerator, @NotNull byte[] buf) {
            if (enumerator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumerator", "com/intellij/util/io/PersistentBTreeEnumerator$RecordBufferHandler", "recordWriteOffset"));
            }
            if (buf == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "com/intellij/util/io/PersistentBTreeEnumerator$RecordBufferHandler", "recordWriteOffset"));
            }
            if (enumerator.myFirstPageStart == -1) {
                enumerator.myFirstPageStart = (enumerator.myDataPageStart = enumerator.allocPage());
            }
            if (enumerator.myDataPageOffset + buf.length + 4 > ((PersistentBTreeEnumerator)enumerator).myBTree.pageSize) {
                assert (enumerator.myDataPageOffset + 4 <= ((PersistentBTreeEnumerator)enumerator).myBTree.pageSize);
                int prevDataPageStart = enumerator.myDataPageStart + ((PersistentBTreeEnumerator)enumerator).myBTree.pageSize - 4;
                enumerator.myDataPageStart = enumerator.allocPage();
                enumerator.myStorage.putInt(prevDataPageStart, enumerator.myDataPageStart);
                enumerator.myDataPageOffset = 0;
            }
            int recordWriteOffset = enumerator.myDataPageOffset;
            assert (recordWriteOffset + buf.length + 4 <= ((PersistentBTreeEnumerator)enumerator).myBTree.pageSize);
            PersistentBTreeEnumerator persistentBTreeEnumerator = enumerator;
            persistentBTreeEnumerator.myDataPageOffset = persistentBTreeEnumerator.myDataPageOffset + buf.length;
            return recordWriteOffset + enumerator.myDataPageStart;
        }

        @Override
        @NotNull
        byte[] getRecordBuffer(@NotNull PersistentBTreeEnumerator enumerator) {
            if (enumerator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumerator", "com/intellij/util/io/PersistentBTreeEnumerator$RecordBufferHandler", "getRecordBuffer"));
            }
            if (this.myBuffer == null) {
                this.myBuffer = new byte[enumerator.myInlineKeysNoMapping ? 0 : 4];
            }
            if (this.myBuffer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/PersistentBTreeEnumerator$RecordBufferHandler", "getRecordBuffer"));
            }
            return this.myBuffer;
        }

        @Override
        void setupRecord(@NotNull PersistentBTreeEnumerator enumerator, int hashCode2, int dataOffset, byte[] buf) {
            if (enumerator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumerator", "com/intellij/util/io/PersistentBTreeEnumerator$RecordBufferHandler", "setupRecord"));
            }
            if (!enumerator.myInlineKeysNoMapping) {
                Bits.putInt(buf, 0, dataOffset);
            }
        }
    }
}

