/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.source.HierarchicalMethodSignatureImpl;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.DeepestSuperMethodsSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiCacheKey;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.containers.hash.LinkedHashMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSuperMethodImplUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.PsiSuperMethodImplUtil");
    private static final PsiCacheKey<Map<MethodSignature, HierarchicalMethodSignature>, PsiClass> SIGNATURES_FOR_CLASS_KEY = PsiCacheKey.create("SIGNATURES_FOR_CLASS_KEY", dom -> PsiSuperMethodImplUtil.buildMethodHierarchy(dom, null, PsiSubstitutor.EMPTY, true, new THashSet<PsiClass>(), false, dom.getResolveScope()));
    private static final PsiCacheKey<FactoryMap<String, Map<MethodSignature, HierarchicalMethodSignature>>, PsiClass> SIGNATURES_BY_NAME_KEY = PsiCacheKey.create("SIGNATURES_BY_NAME_KEY", psiClass -> new ConcurrentFactoryMap<String, Map<MethodSignature, HierarchicalMethodSignature>>(){

        @Override
        @Nullable
        protected Map<MethodSignature, HierarchicalMethodSignature> create(String methodName) {
            return PsiSuperMethodImplUtil.buildMethodHierarchy(psiClass, methodName, PsiSubstitutor.EMPTY, true, new THashSet(), false, psiClass.getResolveScope());
        }
    });
    private static final Key<ParameterizedCachedValue<HierarchicalMethodSignature, PsiMethod>> HIERARCHICAL_SIGNATURE_KEY = Key.create("HierarchicalMethodSignature");
    private static final ParameterizedCachedValueProvider<HierarchicalMethodSignature, PsiMethod> HIERARCHICAL_SIGNATURE_PROVIDER = new ParameterizedCachedValueProvider<HierarchicalMethodSignature, PsiMethod>(){

        @Override
        public CachedValueProvider.Result<HierarchicalMethodSignature> compute(PsiMethod method) {
            PsiClass aClass2 = method.getContainingClass();
            HierarchicalMethodSignature result2 = null;
            if (aClass2 != null) {
                result2 = (HierarchicalMethodSignature)((Map)((FactoryMap)SIGNATURES_BY_NAME_KEY.getValue(aClass2)).get(method.getName())).get(method.getSignature(PsiSubstitutor.EMPTY));
            }
            if (result2 == null) {
                result2 = new HierarchicalMethodSignatureImpl((MethodSignatureBackedByPsiMethod)method.getSignature(PsiSubstitutor.EMPTY));
            }
            if (!(method.isPhysical() || method instanceof SyntheticElement || method instanceof LightElement)) {
                return CachedValueProvider.Result.create(result2, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT, method);
            }
            return CachedValueProvider.Result.create(result2, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
        }
    };

    private PsiSuperMethodImplUtil() {
    }

    @NotNull
    public static PsiMethod[] findSuperMethods(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethods"));
        }
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods(method, null);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public static PsiMethod[] findSuperMethods(@NotNull PsiMethod method, boolean checkAccess) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethods"));
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, checkAccess, false)) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethods"));
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethodsInternal(method, null);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public static PsiMethod[] findSuperMethods(@NotNull PsiMethod method, PsiClass parentClass) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethods"));
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, true, false)) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethods"));
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethodsInternal(method, parentClass);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    private static PsiMethod[] findSuperMethodsInternal(@NotNull PsiMethod method, PsiClass parentClass) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethodsInternal"));
        }
        List<MethodSignatureBackedByPsiMethod> outputMethods = PsiSuperMethodImplUtil.findSuperMethodSignatures(method, parentClass, false);
        PsiMethod[] psiMethodArray = MethodSignatureUtil.convertMethodSignaturesToMethods(outputMethods);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethodsInternal"));
        }
        return psiMethodArray;
    }

    @NotNull
    public static List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(@NotNull PsiMethod method, boolean checkAccess) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethodSignaturesIncludingStatic"));
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, checkAccess, true)) {
            List<MethodSignatureBackedByPsiMethod> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethodSignaturesIncludingStatic"));
            }
            return list2;
        }
        List<MethodSignatureBackedByPsiMethod> list3 = PsiSuperMethodImplUtil.findSuperMethodSignatures(method, null, true);
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethodSignaturesIncludingStatic"));
        }
        return list3;
    }

    @NotNull
    private static List<MethodSignatureBackedByPsiMethod> findSuperMethodSignatures(@NotNull PsiMethod method, PsiClass parentClass, boolean allowStaticMethod) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethodSignatures"));
        }
        ArrayList<MethodSignatureBackedByPsiMethod> arrayList = new ArrayList<MethodSignatureBackedByPsiMethod>(SuperMethodsSearch.search(method, parentClass, true, allowStaticMethod).findAll());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethodSignatures"));
        }
        return arrayList;
    }

    private static boolean canHaveSuperMethod(@NotNull PsiMethod method, boolean checkAccess, boolean allowStaticMethod) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "canHaveSuperMethod"));
        }
        if (method.isConstructor()) {
            return false;
        }
        if (!allowStaticMethod && method.hasModifierProperty("static")) {
            return false;
        }
        if (checkAccess && method.hasModifierProperty("private")) {
            return false;
        }
        PsiClass parentClass = method.getContainingClass();
        return parentClass != null && !"java.lang.Object".equals(parentClass.getQualifiedName());
    }

    @Nullable
    public static PsiMethod findDeepestSuperMethod(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findDeepestSuperMethod"));
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, true, false)) {
            return null;
        }
        return DeepestSuperMethodsSearch.search(method).findFirst();
    }

    @NotNull
    public static PsiMethod[] findDeepestSuperMethods(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findDeepestSuperMethods"));
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, true, false)) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findDeepestSuperMethods"));
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        Collection<PsiMethod> collection = DeepestSuperMethodsSearch.search(method).findAll();
        PsiMethod[] psiMethodArray = collection.toArray(new PsiMethod[collection.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findDeepestSuperMethods"));
        }
        return psiMethodArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static Map<MethodSignature, HierarchicalMethodSignature> buildMethodHierarchy(@NotNull PsiClass aClass2, @Nullable String nameHint, @NotNull PsiSubstitutor substitutor2, boolean includePrivates, @NotNull Set<PsiClass> visited2, boolean isInRawContext, GlobalSearchScope resolveScope) {
        void var13_17;
        PsiMethod psiMethod;
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "buildMethodHierarchy"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "buildMethodHierarchy"));
        }
        if (visited2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "buildMethodHierarchy"));
        }
        ProgressManager.checkCanceled();
        LinkedHashMap<MethodSignature, HierarchicalMethodSignature> result2 = new LinkedHashMap<MethodSignature, HierarchicalMethodSignature>(new EqualityPolicy<MethodSignature>(){

            @Override
            public int getHashCode(MethodSignature object) {
                return object.hashCode();
            }

            @Override
            public boolean isEqual(MethodSignature o1, MethodSignature o2) {
                if (o1.equals(o2)) {
                    PsiMethod method1 = ((MethodSignatureBackedByPsiMethod)o1).getMethod();
                    PsiType returnType1 = method1.getReturnType();
                    PsiMethod method2 = ((MethodSignatureBackedByPsiMethod)o2).getMethod();
                    PsiType returnType2 = method2.getReturnType();
                    if (method1.hasModifierProperty("static") || method2.hasModifierProperty("static")) {
                        return true;
                    }
                    if (MethodSignatureUtil.isReturnTypeSubstitutable(o1, o2, returnType1, returnType2)) {
                        return true;
                    }
                    PsiClass containingClass1 = method1.getContainingClass();
                    PsiClass containingClass2 = method2.getContainingClass();
                    if (containingClass1 != null && containingClass2 != null) {
                        return containingClass1.isAnnotationType() || containingClass2.isAnnotationType();
                    }
                }
                return false;
            }
        });
        final THashMap<MethodSignature, SmartList<PsiMethod>> sameParameterErasureMethods = new THashMap<MethodSignature, SmartList<PsiMethod>>(MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY);
        THashMap<MethodSignature, HierarchicalMethodSignatureImpl> map2 = new THashMap<MethodSignature, HierarchicalMethodSignatureImpl>(new TObjectHashingStrategy<MethodSignature>(){

            @Override
            public int computeHashCode(MethodSignature signature2) {
                return MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY.computeHashCode(signature2);
            }

            @Override
            public boolean equals(MethodSignature o1, MethodSignature o2) {
                boolean toCheckReturnType;
                if (!MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY.equals(o1, o2)) {
                    return false;
                }
                List list2 = (List)sameParameterErasureMethods.get(o1);
                boolean bl = toCheckReturnType = list2 != null && list2.size() > 1;
                if (!toCheckReturnType) {
                    return true;
                }
                PsiType returnType1 = ((MethodSignatureBackedByPsiMethod)o1).getMethod().getReturnType();
                PsiType returnType2 = ((MethodSignatureBackedByPsiMethod)o2).getMethod().getReturnType();
                if (returnType1 == null && returnType2 == null) {
                    return true;
                }
                if (returnType1 == null || returnType2 == null) {
                    return false;
                }
                PsiType erasure1 = TypeConversionUtil.erasure(o1.getSubstitutor().substitute(returnType1));
                PsiType erasure2 = TypeConversionUtil.erasure(o2.getSubstitutor().substitute(returnType2));
                return erasure1.equals(erasure2);
            }
        });
        PsiMethod[] methods2 = aClass2.getMethods();
        if ((nameHint == null || "values".equals(nameHint)) && aClass2 instanceof PsiClassImpl && (psiMethod = ((PsiClassImpl)aClass2).getValuesMethod()) != null) {
            methods2 = ArrayUtil.append(methods2, psiMethod);
        }
        PsiMethod[] psiMethodArray = methods2;
        int n = psiMethodArray.length;
        boolean bl = false;
        while (var13_17 < n) {
            PsiMethod method = psiMethodArray[var13_17];
            if (!method.isValid()) {
                throw new PsiInvalidElementAccessException((PsiElement)method, "class.valid=" + aClass2.isValid() + "; name=" + method.getName());
            }
            if (!(nameHint != null && !nameHint.equals(method.getName()) || !includePrivates && method.hasModifierProperty("private"))) {
                MethodSignatureBackedByPsiMethod signature2 = MethodSignatureBackedByPsiMethod.create(method, PsiSubstitutor.EMPTY, isInRawContext);
                HierarchicalMethodSignatureImpl newH = new HierarchicalMethodSignatureImpl(MethodSignatureBackedByPsiMethod.create(method, substitutor2, isInRawContext));
                SmartList<PsiMethod> list2 = (SmartList<PsiMethod>)sameParameterErasureMethods.get(signature2);
                if (list2 == null) {
                    list2 = new SmartList<PsiMethod>();
                    sameParameterErasureMethods.put(signature2, list2);
                }
                list2.add(method);
                LOG.assertTrue(newH.getMethod().isValid());
                result2.put(signature2, newH);
                map2.put(signature2, newH);
            }
            ++var13_17;
        }
        List<PsiClassType.ClassResolveResult> list2 = PsiClassImplUtil.getScopeCorrectedSuperTypes(aClass2, resolveScope);
        for (PsiClassType.ClassResolveResult classResolveResult : list2) {
            PsiClass superClass = classResolveResult.getElement();
            if (superClass == null || !visited2.add(superClass)) continue;
            PsiSubstitutor superSubstitutor = classResolveResult.getSubstitutor();
            PsiSubstitutor finalSubstitutor = PsiSuperMethodUtil.obtainFinalSubstitutor(superClass, superSubstitutor, substitutor2, isInRawContext);
            boolean isInRawContextSuper = (isInRawContext || PsiUtil.isRawSubstitutor(superClass, superSubstitutor)) && superClass.getTypeParameters().length != 0;
            Map<MethodSignature, HierarchicalMethodSignature> superResult = PsiSuperMethodImplUtil.buildMethodHierarchy(superClass, nameHint, finalSubstitutor, false, visited2, isInRawContextSuper, resolveScope);
            visited2.remove(superClass);
            ArrayList<Pair<MethodSignatureBackedByPsiMethod, HierarchicalMethodSignature>> flattened = new ArrayList<Pair<MethodSignatureBackedByPsiMethod, HierarchicalMethodSignature>>();
            for (Map.Entry<MethodSignature, HierarchicalMethodSignature> entry : superResult.entrySet()) {
                HierarchicalMethodSignature hms = entry.getValue();
                MethodSignatureBackedByPsiMethod signature3 = MethodSignatureBackedByPsiMethod.create(hms.getMethod(), hms.getSubstitutor(), hms.isRaw());
                PsiClass containingClass = hms.getMethod().getContainingClass();
                ArrayList<HierarchicalMethodSignature> supers = new ArrayList<HierarchicalMethodSignature>(hms.getSuperSignatures());
                for (HierarchicalMethodSignature aSuper : supers) {
                    PsiClass superContainingClass = aSuper.getMethod().getContainingClass();
                    if (containingClass == null || superContainingClass == null || containingClass.isInheritor(superContainingClass, true)) continue;
                    flattened.add(Pair.create(signature3, aSuper));
                }
                PsiSuperMethodImplUtil.putInMap(aClass2, result2, map2, hms, signature3);
            }
            for (Pair pair : flattened) {
                PsiSuperMethodImplUtil.putInMap(aClass2, result2, map2, (HierarchicalMethodSignature)pair.second, (MethodSignature)pair.first);
            }
        }
        for (Map.Entry entry : map2.entrySet()) {
            HierarchicalMethodSignatureImpl hierarchicalMethodSignature = (HierarchicalMethodSignatureImpl)entry.getValue();
            MethodSignature methodSignature = (MethodSignature)entry.getKey();
            if (result2.get(methodSignature) != null) continue;
            LOG.assertTrue(hierarchicalMethodSignature.getMethod().isValid());
            result2.put(methodSignature, hierarchicalMethodSignature);
        }
        LinkedHashMap<MethodSignature, HierarchicalMethodSignature> linkedHashMap = result2;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "buildMethodHierarchy"));
        }
        return linkedHashMap;
    }

    private static void putInMap(@NotNull PsiClass aClass2, @NotNull Map<MethodSignature, HierarchicalMethodSignature> result2, @NotNull Map<MethodSignature, HierarchicalMethodSignatureImpl> map2, @NotNull HierarchicalMethodSignature hierarchicalMethodSignature, @NotNull MethodSignature signature2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "putInMap"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "putInMap"));
        }
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "putInMap"));
        }
        if (hierarchicalMethodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchicalMethodSignature", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "putInMap"));
        }
        if (signature2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "putInMap"));
        }
        HierarchicalMethodSignatureImpl existing = map2.get(signature2);
        if (existing == null) {
            HierarchicalMethodSignatureImpl copy = PsiSuperMethodImplUtil.copy(hierarchicalMethodSignature);
            LOG.assertTrue(copy.getMethod().isValid());
            map2.put(signature2, copy);
        } else if (PsiSuperMethodImplUtil.isReturnTypeIsMoreSpecificThan(hierarchicalMethodSignature, existing) && PsiSuperMethodImplUtil.isSuperMethod(aClass2, hierarchicalMethodSignature, existing)) {
            HierarchicalMethodSignatureImpl newSuper = PsiSuperMethodImplUtil.copy(hierarchicalMethodSignature);
            PsiSuperMethodImplUtil.mergeSupers(newSuper, existing);
            LOG.assertTrue(newSuper.getMethod().isValid());
            map2.put(signature2, newSuper);
        } else if (PsiSuperMethodImplUtil.isSuperMethod(aClass2, existing, hierarchicalMethodSignature)) {
            PsiSuperMethodImplUtil.mergeSupers(existing, hierarchicalMethodSignature);
        } else if (!result2.containsKey(signature2)) {
            LOG.assertTrue(hierarchicalMethodSignature.getMethod().isValid());
            result2.put(signature2, hierarchicalMethodSignature);
        }
    }

    private static boolean isReturnTypeIsMoreSpecificThan(@NotNull HierarchicalMethodSignature thisSig, @NotNull HierarchicalMethodSignature thatSig) {
        PsiSubstitutor unifyingSubstitutor;
        if (thisSig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisSig", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "isReturnTypeIsMoreSpecificThan"));
        }
        if (thatSig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thatSig", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "isReturnTypeIsMoreSpecificThan"));
        }
        PsiType thisRet = thisSig.getSubstitutor().substitute(thisSig.getMethod().getReturnType());
        PsiType thatRet = thatSig.getSubstitutor().substitute(thatSig.getMethod().getReturnType());
        PsiSubstitutor psiSubstitutor = unifyingSubstitutor = MethodSignatureUtil.isSubsignature(thatSig, thisSig) ? MethodSignatureUtil.getSuperMethodSignatureSubstitutor(thisSig, thatSig) : null;
        if (unifyingSubstitutor != null) {
            thisRet = unifyingSubstitutor.substitute(thisRet);
            thatRet = unifyingSubstitutor.substitute(thatRet);
        }
        return thatRet != null && thisRet != null && !thatRet.equals(thisRet) && TypeConversionUtil.isAssignable(thatRet, thisRet, false);
    }

    private static void mergeSupers(@NotNull HierarchicalMethodSignatureImpl existing, @NotNull HierarchicalMethodSignature superSignature) {
        if (existing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existing", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "mergeSupers"));
        }
        if (superSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superSignature", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "mergeSupers"));
        }
        for (HierarchicalMethodSignature existingSuper : existing.getSuperSignatures()) {
            if (existingSuper.getMethod() != superSignature.getMethod()) continue;
            for (HierarchicalMethodSignature signature2 : superSignature.getSuperSignatures()) {
                PsiSuperMethodImplUtil.mergeSupers((HierarchicalMethodSignatureImpl)existingSuper, signature2);
            }
            return;
        }
        if (existing.getMethod() == superSignature.getMethod()) {
            List<HierarchicalMethodSignature> existingSupers = existing.getSuperSignatures();
            for (HierarchicalMethodSignature supers : superSignature.getSuperSignatures()) {
                if (existingSupers.contains(supers)) continue;
                existing.addSuperSignature(PsiSuperMethodImplUtil.copy(supers));
            }
        } else {
            HierarchicalMethodSignatureImpl copy = PsiSuperMethodImplUtil.copy(superSignature);
            existing.addSuperSignature(copy);
        }
    }

    private static boolean isSuperMethod(@NotNull PsiClass aClass2, @NotNull MethodSignatureBackedByPsiMethod hierarchicalMethodSignature, @NotNull MethodSignatureBackedByPsiMethod superSignatureHierarchical) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "isSuperMethod"));
        }
        if (hierarchicalMethodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchicalMethodSignature", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "isSuperMethod"));
        }
        if (superSignatureHierarchical == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superSignatureHierarchical", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "isSuperMethod"));
        }
        PsiMethod superMethod = superSignatureHierarchical.getMethod();
        PsiClass superClass = superMethod.getContainingClass();
        PsiMethod method = hierarchicalMethodSignature.getMethod();
        PsiClass containingClass = method.getContainingClass();
        if (!superMethod.isConstructor() && !aClass2.equals(superClass) && MethodSignatureUtil.isSubsignature(superSignatureHierarchical, hierarchicalMethodSignature) && superClass != null) {
            if (superClass.isInterface() || "java.lang.Object".equals(superClass.getQualifiedName())) {
                if (superMethod.hasModifierProperty("static") || superMethod.hasModifierProperty("default") && method.hasModifierProperty("static") && !InheritanceUtil.isInheritorOrSelf(containingClass, superClass, true)) {
                    return false;
                }
                if (superMethod.hasModifierProperty("default") || method.hasModifierProperty("default")) {
                    return superMethod.equals(method) || !InheritanceUtil.isInheritorOrSelf(superClass, containingClass, true);
                }
                return true;
            }
            if (containingClass != null) {
                if (containingClass.isInterface()) {
                    return false;
                }
                if (!aClass2.isInterface() && !InheritanceUtil.isInheritorOrSelf(superClass, containingClass, true)) {
                    return true;
                }
            }
        }
        return false;
    }

    @NotNull
    private static HierarchicalMethodSignatureImpl copy(@NotNull HierarchicalMethodSignature hi) {
        if (hi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hi", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "copy"));
        }
        HierarchicalMethodSignatureImpl hierarchicalMethodSignature = new HierarchicalMethodSignatureImpl(hi);
        for (HierarchicalMethodSignature his : hi.getSuperSignatures()) {
            hierarchicalMethodSignature.addSuperSignature(PsiSuperMethodImplUtil.copy(his));
        }
        HierarchicalMethodSignatureImpl hierarchicalMethodSignatureImpl = hierarchicalMethodSignature;
        if (hierarchicalMethodSignatureImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "copy"));
        }
        return hierarchicalMethodSignatureImpl;
    }

    @NotNull
    public static Collection<HierarchicalMethodSignature> getVisibleSignatures(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "getVisibleSignatures"));
        }
        Map<MethodSignature, HierarchicalMethodSignature> map2 = PsiSuperMethodImplUtil.getSignaturesMap(aClass2);
        Collection<HierarchicalMethodSignature> collection = map2.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "getVisibleSignatures"));
        }
        return collection;
    }

    @NotNull
    public static HierarchicalMethodSignature getHierarchicalMethodSignature(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "getHierarchicalMethodSignature"));
        }
        Project project = method.getProject();
        HierarchicalMethodSignature hierarchicalMethodSignature = CachedValuesManager.getManager(project).getParameterizedCachedValue(method, HIERARCHICAL_SIGNATURE_KEY, HIERARCHICAL_SIGNATURE_PROVIDER, false, method);
        if (hierarchicalMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "getHierarchicalMethodSignature"));
        }
        return hierarchicalMethodSignature;
    }

    @NotNull
    private static Map<MethodSignature, HierarchicalMethodSignature> getSignaturesMap(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "getSignaturesMap"));
        }
        Map<MethodSignature, HierarchicalMethodSignature> map2 = SIGNATURES_FOR_CLASS_KEY.getValue(aClass2);
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "getSignaturesMap"));
        }
        return map2;
    }

    public static boolean processDirectSuperMethodsSmart(@NotNull PsiMethod method, @NotNull Processor<PsiMethod> superMethodProcessor) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "processDirectSuperMethodsSmart"));
        }
        if (superMethodProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethodProcessor", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "processDirectSuperMethodsSmart"));
        }
        PsiClass aClass2 = method.getContainingClass();
        if (aClass2 == null) {
            return false;
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, true, false)) {
            return false;
        }
        Map<MethodSignature, HierarchicalMethodSignature> cachedMap = SIGNATURES_BY_NAME_KEY.getValue(aClass2).get(method.getName());
        HierarchicalMethodSignature signature2 = cachedMap.get(method.getSignature(PsiSubstitutor.EMPTY));
        if (signature2 != null) {
            List<HierarchicalMethodSignature> superSignatures = signature2.getSuperSignatures();
            for (HierarchicalMethodSignature superSignature : superSignatures) {
                if (superMethodProcessor.process(superSignature.getMethod())) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isSuperMethodSmart(@NotNull PsiMethod method, @NotNull PsiMethod superMethod) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "isSuperMethodSmart"));
        }
        if (superMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethod", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "isSuperMethodSmart"));
        }
        if (method == superMethod) {
            return false;
        }
        PsiClass aClass2 = method.getContainingClass();
        PsiClass superClass = superMethod.getContainingClass();
        if (aClass2 == null || superClass == null || superClass == aClass2) {
            return false;
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, true, false)) {
            return false;
        }
        Map<MethodSignature, HierarchicalMethodSignature> cachedMap = SIGNATURES_BY_NAME_KEY.getValue(aClass2).get(method.getName());
        HierarchicalMethodSignature signature2 = cachedMap.get(method.getSignature(PsiSubstitutor.EMPTY));
        for (PsiMethod superCandidate : MethodSignatureUtil.convertMethodSignaturesToMethods(signature2.getSuperSignatures())) {
            if (!superMethod.equals(superCandidate) && !PsiSuperMethodImplUtil.isSuperMethodSmart(superCandidate, superMethod)) continue;
            return true;
        }
        return false;
    }
}

