/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsClassModel;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SpecialFunction;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.naming.SuggestedName;
import org.jetbrains.kotlin.js.translate.context.AliasingContext;
import org.jetbrains.kotlin.js.translate.context.DeferredCallSite;
import org.jetbrains.kotlin.js.translate.context.DynamicContext;
import org.jetbrains.kotlin.js.translate.context.InlineFunctionContext;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.StaticContext;
import org.jetbrains.kotlin.js.translate.context.TemporaryConstVariable;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.UsageTracker;
import org.jetbrains.kotlin.js.translate.context.UsageTrackerKt;
import org.jetbrains.kotlin.js.translate.declaration.ClassModelGenerator;
import org.jetbrains.kotlin.js.translate.intrinsic.Intrinsics;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.serialization.js.ModuleKind;

public class TranslationContext {
    @NotNull
    private final DynamicContext dynamicContext;
    @NotNull
    private final StaticContext staticContext;
    @NotNull
    private final AliasingContext aliasingContext;
    @Nullable
    private final UsageTracker usageTracker;
    @Nullable
    private final TranslationContext parent;
    @Nullable
    private final DeclarationDescriptor declarationDescriptor;
    @Nullable
    private final ClassDescriptor classDescriptor;
    @Nullable
    private final VariableDescriptor continuationParameterDescriptor;
    @Nullable
    private InlineFunctionContext inlineFunctionContext;
    private final Map<JsExpression, TemporaryConstVariable> expressionToTempConstVariableCache;

    @NotNull
    public static TranslationContext rootContext(@NotNull StaticContext staticContext) {
        if (staticContext == null) {
            TranslationContext.$$$reportNull$$$0(0);
        }
        DynamicContext rootDynamicContext = DynamicContext.rootContext(staticContext.getFragment().getScope(), staticContext.getFragment().getInitializerBlock());
        AliasingContext rootAliasingContext = AliasingContext.getCleanContext();
        TranslationContext translationContext = new TranslationContext(null, staticContext, rootDynamicContext, rootAliasingContext, null, null);
        if (translationContext == null) {
            TranslationContext.$$$reportNull$$$0(1);
        }
        return translationContext;
    }

    private TranslationContext(@Nullable TranslationContext parent2, @NotNull StaticContext staticContext, @NotNull DynamicContext dynamicContext, @NotNull AliasingContext aliasingContext, @Nullable UsageTracker usageTracker, @Nullable DeclarationDescriptor declarationDescriptor) {
        DeclarationDescriptor parentDescriptor;
        if (staticContext == null) {
            TranslationContext.$$$reportNull$$$0(2);
        }
        if (dynamicContext == null) {
            TranslationContext.$$$reportNull$$$0(3);
        }
        if (aliasingContext == null) {
            TranslationContext.$$$reportNull$$$0(4);
        }
        this.expressionToTempConstVariableCache = new HashMap<JsExpression, TemporaryConstVariable>();
        this.parent = parent2;
        this.dynamicContext = dynamicContext;
        this.staticContext = staticContext;
        this.aliasingContext = aliasingContext;
        this.usageTracker = usageTracker;
        this.declarationDescriptor = declarationDescriptor;
        this.classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : (parent2 != null ? parent2.classDescriptor : null);
        this.continuationParameterDescriptor = this.calculateContinuationParameter();
        this.inlineFunctionContext = parent2 != null ? parent2.inlineFunctionContext : null;
        DeclarationDescriptor declarationDescriptor2 = parentDescriptor = parent2 != null ? parent2.declarationDescriptor : null;
        if (parentDescriptor != declarationDescriptor && declarationDescriptor instanceof CallableDescriptor && InlineUtil.isInline(declarationDescriptor)) {
            this.inlineFunctionContext = new InlineFunctionContext((CallableDescriptor)declarationDescriptor);
        }
    }

    private VariableDescriptor calculateContinuationParameter() {
        FunctionDescriptor function2;
        if (this.parent != null && this.parent.declarationDescriptor == this.declarationDescriptor) {
            return this.parent.continuationParameterDescriptor;
        }
        if (this.declarationDescriptor instanceof FunctionDescriptor && (function2 = (FunctionDescriptor)this.declarationDescriptor).isSuspend()) {
            ClassDescriptor continuationDescriptor = DescriptorUtilKt.findContinuationClassDescriptor(this.getCurrentModule(), NoLookupLocation.FROM_BACKEND);
            return new LocalVariableDescriptor(this.declarationDescriptor, Annotations.Companion.getEMPTY(), Name.identifier("continuation"), continuationDescriptor.getDefaultType(), SourceElement.NO_SOURCE);
        }
        return null;
    }

    @Nullable
    public UsageTracker usageTracker() {
        return this.usageTracker;
    }

    @NotNull
    public DynamicContext dynamicContext() {
        DynamicContext dynamicContext = this.dynamicContext;
        if (dynamicContext == null) {
            TranslationContext.$$$reportNull$$$0(5);
        }
        return dynamicContext;
    }

    @Nullable
    public InlineFunctionContext getInlineFunctionContext() {
        return this.inlineFunctionContext;
    }

    @NotNull
    public TranslationContext contextWithScope(@NotNull JsFunction fun) {
        if (fun == null) {
            TranslationContext.$$$reportNull$$$0(6);
        }
        TranslationContext translationContext = this.newFunctionBody(fun, this.aliasingContext, this.declarationDescriptor);
        if (translationContext == null) {
            TranslationContext.$$$reportNull$$$0(7);
        }
        return translationContext;
    }

    @NotNull
    private TranslationContext newFunctionBody(@NotNull JsFunction fun, @Nullable AliasingContext aliasingContext, DeclarationDescriptor descriptor2) {
        if (fun == null) {
            TranslationContext.$$$reportNull$$$0(8);
        }
        DynamicContext dynamicContext = DynamicContext.newContext(fun.getScope(), fun.getBody());
        if (aliasingContext == null) {
            aliasingContext = this.aliasingContext.inner();
        }
        TranslationContext translationContext = new TranslationContext(this, this.staticContext, dynamicContext, aliasingContext, this.usageTracker, descriptor2);
        if (translationContext == null) {
            TranslationContext.$$$reportNull$$$0(9);
        }
        return translationContext;
    }

    @NotNull
    public TranslationContext newFunctionBodyWithUsageTracker(@NotNull JsFunction fun, @NotNull MemberDescriptor descriptor2) {
        if (fun == null) {
            TranslationContext.$$$reportNull$$$0(10);
        }
        if (descriptor2 == null) {
            TranslationContext.$$$reportNull$$$0(11);
        }
        DynamicContext dynamicContext = DynamicContext.newContext(fun.getScope(), fun.getBody());
        UsageTracker usageTracker = new UsageTracker(this.usageTracker, descriptor2);
        TranslationContext translationContext = new TranslationContext(this, this.staticContext, dynamicContext, this.aliasingContext.inner(), usageTracker, descriptor2);
        if (translationContext == null) {
            TranslationContext.$$$reportNull$$$0(12);
        }
        return translationContext;
    }

    @NotNull
    public TranslationContext innerWithUsageTracker(@NotNull MemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            TranslationContext.$$$reportNull$$$0(13);
        }
        UsageTracker usageTracker = new UsageTracker(this.usageTracker, descriptor2);
        TranslationContext translationContext = new TranslationContext(this, this.staticContext, this.dynamicContext, this.aliasingContext.inner(), usageTracker, descriptor2);
        if (translationContext == null) {
            TranslationContext.$$$reportNull$$$0(14);
        }
        return translationContext;
    }

    @NotNull
    public TranslationContext inner(@NotNull MemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            TranslationContext.$$$reportNull$$$0(15);
        }
        TranslationContext translationContext = new TranslationContext(this, this.staticContext, this.dynamicContext, this.aliasingContext.inner(), this.usageTracker, descriptor2);
        if (translationContext == null) {
            TranslationContext.$$$reportNull$$$0(16);
        }
        return translationContext;
    }

    @NotNull
    public TranslationContext innerBlock(@NotNull JsBlock block) {
        if (block == null) {
            TranslationContext.$$$reportNull$$$0(17);
        }
        TranslationContext translationContext = new TranslationContext(this, this.staticContext, this.dynamicContext.innerBlock(block), this.aliasingContext, this.usageTracker, this.declarationDescriptor);
        if (translationContext == null) {
            TranslationContext.$$$reportNull$$$0(18);
        }
        return translationContext;
    }

    @NotNull
    public TranslationContext innerBlock() {
        TranslationContext translationContext = this.innerBlock(new JsBlock());
        if (translationContext == null) {
            TranslationContext.$$$reportNull$$$0(19);
        }
        return translationContext;
    }

    @NotNull
    public TranslationContext newDeclaration(@NotNull DeclarationDescriptor descriptor2) {
        JsBlock innerBlock;
        if (descriptor2 == null) {
            TranslationContext.$$$reportNull$$$0(20);
        }
        if ((innerBlock = this.getBlockForDescriptor(descriptor2)) == null) {
            innerBlock = this.dynamicContext.jsBlock();
        }
        DynamicContext dynamicContext = DynamicContext.newContext(this.getScopeForDescriptor(descriptor2), innerBlock);
        TranslationContext translationContext = new TranslationContext(this, this.staticContext, dynamicContext, this.aliasingContext, this.usageTracker, descriptor2);
        if (translationContext == null) {
            TranslationContext.$$$reportNull$$$0(21);
        }
        return translationContext;
    }

    @NotNull
    private TranslationContext innerWithAliasingContext(AliasingContext aliasingContext) {
        TranslationContext translationContext = new TranslationContext(this, this.staticContext, this.dynamicContext, aliasingContext, this.usageTracker, this.declarationDescriptor);
        if (translationContext == null) {
            TranslationContext.$$$reportNull$$$0(22);
        }
        return translationContext;
    }

    @NotNull
    public TranslationContext innerContextWithAliased(@NotNull DeclarationDescriptor correspondingDescriptor, @NotNull JsExpression alias) {
        if (correspondingDescriptor == null) {
            TranslationContext.$$$reportNull$$$0(23);
        }
        if (alias == null) {
            TranslationContext.$$$reportNull$$$0(24);
        }
        TranslationContext translationContext = this.innerWithAliasingContext(this.aliasingContext.inner(correspondingDescriptor, alias));
        if (translationContext == null) {
            TranslationContext.$$$reportNull$$$0(25);
        }
        return translationContext;
    }

    @NotNull
    public TranslationContext innerContextWithAliasesForExpressions(@NotNull Map<KtExpression, JsExpression> aliases) {
        if (aliases == null) {
            TranslationContext.$$$reportNull$$$0(26);
        }
        if (aliases.isEmpty()) {
            TranslationContext translationContext = this;
            if (translationContext == null) {
                TranslationContext.$$$reportNull$$$0(27);
            }
            return translationContext;
        }
        TranslationContext translationContext = this.innerWithAliasingContext(this.aliasingContext.withExpressionsAliased(aliases));
        if (translationContext == null) {
            TranslationContext.$$$reportNull$$$0(28);
        }
        return translationContext;
    }

    @NotNull
    public TranslationContext innerContextWithDescriptorsAliased(@NotNull Map<DeclarationDescriptor, JsExpression> aliases) {
        if (aliases == null) {
            TranslationContext.$$$reportNull$$$0(29);
        }
        if (aliases.isEmpty()) {
            TranslationContext translationContext = this;
            if (translationContext == null) {
                TranslationContext.$$$reportNull$$$0(30);
            }
            return translationContext;
        }
        TranslationContext translationContext = this.innerWithAliasingContext(this.aliasingContext.withDescriptorsAliased(aliases));
        if (translationContext == null) {
            TranslationContext.$$$reportNull$$$0(31);
        }
        return translationContext;
    }

    @Nullable
    private JsBlock getBlockForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            TranslationContext.$$$reportNull$$$0(32);
        }
        if (descriptor2 instanceof CallableDescriptor) {
            return this.getFunctionObject((CallableDescriptor)descriptor2).getBody();
        }
        return null;
    }

    @Nullable
    public ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    @NotNull
    public BindingContext bindingContext() {
        BindingContext bindingContext = this.staticContext.getBindingContext();
        if (bindingContext == null) {
            TranslationContext.$$$reportNull$$$0(33);
        }
        return bindingContext;
    }

    @NotNull
    public BindingTrace bindingTrace() {
        BindingTrace bindingTrace = this.staticContext.getBindingTrace();
        if (bindingTrace == null) {
            TranslationContext.$$$reportNull$$$0(34);
        }
        return bindingTrace;
    }

    @NotNull
    public JsScope getScopeForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            TranslationContext.$$$reportNull$$$0(35);
        }
        JsScope jsScope = this.staticContext.getScopeForDescriptor(descriptor2);
        if (jsScope == null) {
            TranslationContext.$$$reportNull$$$0(36);
        }
        return jsScope;
    }

    @NotNull
    public JsName getNameForElement(@NotNull PsiElement element) {
        if (element == null) {
            TranslationContext.$$$reportNull$$$0(37);
        }
        DeclarationDescriptor descriptor2 = BindingUtils.getDescriptorForElement(this.bindingContext(), element);
        JsName jsName = this.getNameForDescriptor(descriptor2);
        if (jsName == null) {
            TranslationContext.$$$reportNull$$$0(38);
        }
        return jsName;
    }

    @NotNull
    public JsName getNameForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            TranslationContext.$$$reportNull$$$0(39);
        }
        JsName jsName = this.staticContext.getNameForDescriptor(descriptor2);
        if (jsName == null) {
            TranslationContext.$$$reportNull$$$0(40);
        }
        return jsName;
    }

    @NotNull
    public JsName getInnerNameForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            TranslationContext.$$$reportNull$$$0(41);
        }
        JsName jsName = this.staticContext.getInnerNameForDescriptor(descriptor2);
        if (jsName == null) {
            TranslationContext.$$$reportNull$$$0(42);
        }
        return jsName;
    }

    @NotNull
    public JsName getInlineableInnerNameForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        JsName name;
        if (descriptor2 == null) {
            TranslationContext.$$$reportNull$$$0(43);
        }
        if (this.inlineFunctionContext == null || !this.isPublicInlineFunction() || !org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt.shouldBeExported(descriptor2, this.getConfig()) || DescriptorUtils.isAncestor(this.inlineFunctionContext.getDescriptor(), descriptor2, false)) {
            name = this.getInnerNameForDescriptor(descriptor2);
        } else {
            String tag = this.staticContext.getTag(descriptor2);
            name = this.inlineFunctionContext.getImports().computeIfAbsent(tag, t -> {
                JsNameRef importedNameRef;
                JsExpression imported;
                if (descriptor2 == null) {
                    TranslationContext.$$$reportNull$$$0(127);
                }
                if ((imported = this.createInlineLocalImportExpression(descriptor2)) instanceof JsNameRef && (importedNameRef = (JsNameRef)imported).getQualifier() == null && importedNameRef.getIdent().equals(Namer.getRootPackageName()) && (descriptor2 instanceof PackageFragmentDescriptor || descriptor2 instanceof ModuleDescriptor)) {
                    return importedNameRef.getName();
                }
                JsName result2 = JsScope.declareTemporaryName(StaticContext.getSuggestedName(descriptor2));
                if (this.isFromCurrentModule(descriptor2) && !AnnotationsUtils.isNativeObject(descriptor2)) {
                    MetadataProperties.setLocalAlias(result2, this.getInnerNameForDescriptor(descriptor2));
                }
                MetadataProperties.setDescriptor(result2, descriptor2);
                MetadataProperties.setStaticRef(result2, imported);
                MetadataProperties.setImported(result2, true);
                this.inlineFunctionContext.getImportBlock().getStatements().add(JsAstUtils.newVar(result2, imported));
                return result2;
            });
        }
        JsName jsName = name;
        if (jsName == null) {
            TranslationContext.$$$reportNull$$$0(44);
        }
        return jsName;
    }

    @NotNull
    public JsName getNameForObjectInstance(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            TranslationContext.$$$reportNull$$$0(45);
        }
        JsName jsName = this.staticContext.getNameForObjectInstance(descriptor2);
        if (jsName == null) {
            TranslationContext.$$$reportNull$$$0(46);
        }
        return jsName;
    }

    @NotNull
    public JsExpression getQualifiedReference(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            TranslationContext.$$$reportNull$$$0(47);
        }
        JsExpression result2 = this.staticContext.getQualifiedReference(descriptor2);
        if (this.isPublicInlineFunction()) {
            if (this.isFromCurrentModule(descriptor2)) {
                if (descriptor2 instanceof MemberDescriptor) {
                    this.staticContext.export((MemberDescriptor)descriptor2, true);
                }
            } else {
                JsExpression replacement;
                ModuleDescriptor module2 = DescriptorUtils.getContainingModule(descriptor2);
                if (module2 != this.staticContext.getCurrentModule() && !this.isInlineFunction(descriptor2) && (replacement = this.staticContext.exportModuleForInline(module2)) != null) {
                    result2 = TranslationContext.replaceModuleReference(result2, this.getInnerNameForDescriptor(module2), replacement);
                }
            }
        }
        JsNameRef jsNameRef = result2;
        if (jsNameRef == null) {
            TranslationContext.$$$reportNull$$$0(48);
        }
        return jsNameRef;
    }

    private boolean isInlineFunction(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            TranslationContext.$$$reportNull$$$0(49);
        }
        if (!(descriptor2 instanceof CallableDescriptor)) {
            return false;
        }
        return CallExpressionTranslator.shouldBeInlined((CallableDescriptor)descriptor2, this);
    }

    private static JsExpression replaceModuleReference(@NotNull JsExpression expression2, @NotNull JsName expectedModuleName, @NotNull JsExpression reexportExpr) {
        if (expression2 == null) {
            TranslationContext.$$$reportNull$$$0(50);
        }
        if (expectedModuleName == null) {
            TranslationContext.$$$reportNull$$$0(51);
        }
        if (reexportExpr == null) {
            TranslationContext.$$$reportNull$$$0(52);
        }
        if (expression2 instanceof JsNameRef) {
            JsNameRef nameRef = (JsNameRef)expression2;
            if (nameRef.getQualifier() == null) {
                return expectedModuleName == nameRef.getName() ? reexportExpr : expression2;
            }
            JsExpression newQualifier = TranslationContext.replaceModuleReference(nameRef.getQualifier(), expectedModuleName, reexportExpr);
            if (newQualifier == nameRef.getQualifier()) {
                return expression2;
            }
            JsNameRef result2 = nameRef.getName() != null ? new JsNameRef(nameRef.getName(), newQualifier) : new JsNameRef(nameRef.getIdent(), newQualifier);
            result2.copyMetadataFrom(nameRef);
            return result2;
        }
        return expression2;
    }

    @NotNull
    public JsExpression getInnerReference(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            TranslationContext.$$$reportNull$$$0(53);
        }
        JsNameRef jsNameRef = JsAstUtils.pureFqn(this.getInlineableInnerNameForDescriptor(descriptor2), null);
        if (jsNameRef == null) {
            TranslationContext.$$$reportNull$$$0(54);
        }
        return jsNameRef;
    }

    @NotNull
    private JsExpression createInlineLocalImportExpression(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            TranslationContext.$$$reportNull$$$0(55);
        }
        JsExpression result2 = this.getQualifiedReference(descriptor2);
        JsName name = this.getInnerNameForDescriptor(descriptor2);
        SuggestedName suggested = this.staticContext.suggestName(descriptor2);
        if (suggested != null && this.getConfig().getModuleKind() != ModuleKind.PLAIN && this.isPublicInlineFunction()) {
            String fileModuleId;
            String moduleId = AnnotationsUtils.getModuleName(suggested.getDescriptor());
            if (moduleId != null) {
                JsExpression replacement = this.staticContext.exportModuleForInline(moduleId, name);
                result2 = TranslationContext.replaceModuleReference(result2, name, replacement);
            } else if (AnnotationsUtils.isNativeObject(suggested.getDescriptor()) && DescriptorUtils.isTopLevelDeclaration(suggested.getDescriptor()) && (fileModuleId = AnnotationsUtils.getFileModuleName(this.bindingContext(), suggested.getDescriptor())) != null) {
                JsName fileModuleName = this.staticContext.getImportedModule(fileModuleId, null).getInternalName();
                JsExpression replacement = this.staticContext.exportModuleForInline(fileModuleId, fileModuleName);
                result2 = TranslationContext.replaceModuleReference(this.staticContext.getQualifiedReference(descriptor2), fileModuleName, replacement);
            }
        }
        JsExpression jsExpression = result2;
        if (jsExpression == null) {
            TranslationContext.$$$reportNull$$$0(56);
        }
        return jsExpression;
    }

    @NotNull
    public JsName getNameForBackingField(@NotNull VariableDescriptorWithAccessors property) {
        if (property == null) {
            TranslationContext.$$$reportNull$$$0(57);
        }
        JsName jsName = this.staticContext.getNameForBackingField(property);
        if (jsName == null) {
            TranslationContext.$$$reportNull$$$0(58);
        }
        return jsName;
    }

    @NotNull
    public TemporaryVariable declareTemporary(@Nullable JsExpression initExpression, @Nullable Object source) {
        TemporaryVariable temporaryVariable = this.dynamicContext.declareTemporary(initExpression, source);
        if (temporaryVariable == null) {
            TranslationContext.$$$reportNull$$$0(59);
        }
        return temporaryVariable;
    }

    @NotNull
    public JsExpression defineTemporary(@NotNull JsExpression initExpression) {
        if (initExpression == null) {
            TranslationContext.$$$reportNull$$$0(60);
        }
        TemporaryVariable var = this.dynamicContext.declareTemporary(initExpression, initExpression.getSource());
        this.addStatementToCurrentBlock(var.assignmentStatement());
        JsNameRef jsNameRef = var.reference();
        if (jsNameRef == null) {
            TranslationContext.$$$reportNull$$$0(61);
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression cacheExpressionIfNeeded(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            TranslationContext.$$$reportNull$$$0(62);
        }
        JsExpression jsExpression = TranslationUtils.isCacheNeeded(expression2) ? this.defineTemporary(expression2) : expression2;
        if (jsExpression == null) {
            TranslationContext.$$$reportNull$$$0(63);
        }
        return jsExpression;
    }

    @NotNull
    public TemporaryConstVariable getOrDeclareTemporaryConstVariable(@NotNull JsExpression expression2) {
        TemporaryConstVariable tempVar;
        if (expression2 == null) {
            TranslationContext.$$$reportNull$$$0(64);
        }
        if ((tempVar = this.expressionToTempConstVariableCache.get(expression2)) == null) {
            TemporaryVariable tmpVar = this.declareTemporary(expression2, expression2.getSource());
            tempVar = new TemporaryConstVariable(tmpVar.name(), tmpVar.assignmentExpression());
            this.expressionToTempConstVariableCache.put(expression2, tempVar);
            this.expressionToTempConstVariableCache.put(tmpVar.assignmentExpression(), tempVar);
        }
        TemporaryConstVariable temporaryConstVariable = tempVar;
        if (temporaryConstVariable == null) {
            TranslationContext.$$$reportNull$$$0(65);
        }
        return temporaryConstVariable;
    }

    public void associateExpressionToLazyValue(JsExpression expression2, TemporaryConstVariable temporaryConstVariable) {
        assert (expression2 == temporaryConstVariable.assignmentExpression());
        this.expressionToTempConstVariableCache.put(expression2, temporaryConstVariable);
    }

    @NotNull
    public Namer namer() {
        Namer namer = this.staticContext.getNamer();
        if (namer == null) {
            TranslationContext.$$$reportNull$$$0(66);
        }
        return namer;
    }

    @NotNull
    public Intrinsics intrinsics() {
        Intrinsics intrinsics = this.staticContext.getIntrinsics();
        if (intrinsics == null) {
            TranslationContext.$$$reportNull$$$0(67);
        }
        return intrinsics;
    }

    @NotNull
    public JsProgram program() {
        JsProgram jsProgram = this.staticContext.getProgram();
        if (jsProgram == null) {
            TranslationContext.$$$reportNull$$$0(68);
        }
        return jsProgram;
    }

    @NotNull
    public JsConfig getConfig() {
        JsConfig jsConfig = this.staticContext.getConfig();
        if (jsConfig == null) {
            TranslationContext.$$$reportNull$$$0(69);
        }
        return jsConfig;
    }

    @NotNull
    public JsScope scope() {
        JsScope jsScope = this.dynamicContext.getScope();
        if (jsScope == null) {
            TranslationContext.$$$reportNull$$$0(70);
        }
        return jsScope;
    }

    @NotNull
    public AliasingContext aliasingContext() {
        AliasingContext aliasingContext = this.aliasingContext;
        if (aliasingContext == null) {
            TranslationContext.$$$reportNull$$$0(71);
        }
        return aliasingContext;
    }

    @NotNull
    public JsFunction getFunctionObject(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            TranslationContext.$$$reportNull$$$0(72);
        }
        JsFunction jsFunction = this.staticContext.getFunctionWithScope(descriptor2);
        if (jsFunction == null) {
            TranslationContext.$$$reportNull$$$0(73);
        }
        return jsFunction;
    }

    public void addStatementToCurrentBlock(@NotNull JsStatement statement2) {
        if (statement2 == null) {
            TranslationContext.$$$reportNull$$$0(74);
        }
        this.dynamicContext.jsBlock().getStatements().add(statement2);
    }

    public void addStatementsToCurrentBlock(@NotNull Collection<JsStatement> statements) {
        if (statements == null) {
            TranslationContext.$$$reportNull$$$0(75);
        }
        this.dynamicContext.jsBlock().getStatements().addAll(statements);
    }

    public void addStatementsToCurrentBlockFrom(@NotNull TranslationContext context) {
        if (context == null) {
            TranslationContext.$$$reportNull$$$0(76);
        }
        this.addStatementsToCurrentBlockFrom(context.dynamicContext().jsBlock());
    }

    public void addStatementsToCurrentBlockFrom(@NotNull JsBlock block) {
        if (block == null) {
            TranslationContext.$$$reportNull$$$0(77);
        }
        this.dynamicContext.jsBlock().getStatements().addAll(block.getStatements());
    }

    public boolean currentBlockIsEmpty() {
        return this.dynamicContext.jsBlock().isEmpty();
    }

    public void moveVarsFrom(@NotNull TranslationContext context) {
        if (context == null) {
            TranslationContext.$$$reportNull$$$0(78);
        }
        this.dynamicContext.moveVarsFrom(context.dynamicContext());
    }

    @NotNull
    public JsBlock getCurrentBlock() {
        JsBlock jsBlock = this.dynamicContext.jsBlock();
        if (jsBlock == null) {
            TranslationContext.$$$reportNull$$$0(79);
        }
        return jsBlock;
    }

    @Nullable
    public JsExpression getAliasForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        JsExpression nameRef;
        if (descriptor2 == null) {
            TranslationContext.$$$reportNull$$$0(80);
        }
        if ((nameRef = this.captureIfNeedAndGetCapturedName(descriptor2)) != null) {
            return nameRef;
        }
        JsExpression alias = this.aliasingContext.getAliasForDescriptor(descriptor2);
        return alias != null ? alias.deepCopy() : null;
    }

    @NotNull
    public JsExpression getDispatchReceiver(@NotNull ReceiverParameterDescriptor descriptor2) {
        JsExpression alias;
        if (descriptor2 == null) {
            TranslationContext.$$$reportNull$$$0(81);
        }
        if ((alias = this.getAliasForDescriptor(descriptor2)) != null) {
            JsExpression jsExpression = alias;
            if (jsExpression == null) {
                TranslationContext.$$$reportNull$$$0(82);
            }
            return jsExpression;
        }
        if (org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt.isCoroutineLambda(descriptor2.getContainingDeclaration())) {
            JsNameRef result2 = new JsNameRef("$$controller$$", JsAstUtils.stateMachineReceiver());
            MetadataProperties.setCoroutineController(result2, true);
            JsNameRef jsNameRef = result2;
            if (jsNameRef == null) {
                TranslationContext.$$$reportNull$$$0(83);
            }
            return jsNameRef;
        }
        if (DescriptorUtils.isObject(descriptor2.getContainingDeclaration())) {
            if (this.isConstructorOrDirectScope(descriptor2.getContainingDeclaration())) {
                JsThisRef jsThisRef = new JsThisRef();
                if (jsThisRef == null) {
                    TranslationContext.$$$reportNull$$$0(84);
                }
                return jsThisRef;
            }
            ClassDescriptor objectDescriptor = (ClassDescriptor)descriptor2.getContainingDeclaration();
            JsExpression jsExpression = ReferenceTranslator.translateAsValueReference(objectDescriptor, this);
            if (jsExpression == null) {
                TranslationContext.$$$reportNull$$$0(85);
            }
            return jsExpression;
        }
        if (descriptor2.getValue() instanceof ExtensionReceiver) {
            JsThisRef jsThisRef = new JsThisRef();
            if (jsThisRef == null) {
                TranslationContext.$$$reportNull$$$0(86);
            }
            return jsThisRef;
        }
        ClassifierDescriptor classifier2 = descriptor2.getValue().getType().getConstructor().getDeclarationDescriptor();
        assert (classifier2 instanceof ClassDescriptor);
        ClassDescriptor cls = (ClassDescriptor)classifier2;
        assert (this.classDescriptor != null) : "Can't get ReceiverParameterDescriptor in top level";
        JsExpression receiver = this.getAliasForDescriptor(this.classDescriptor.getThisAsReceiverParameter());
        if (receiver == null) {
            receiver = new JsThisRef();
        }
        JsExpression jsExpression = this.getDispatchReceiverPath(cls, receiver);
        if (jsExpression == null) {
            TranslationContext.$$$reportNull$$$0(87);
        }
        return jsExpression;
    }

    private boolean isConstructorOrDirectScope(DeclarationDescriptor descriptor2) {
        return descriptor2 == DescriptorUtils.getParentOfType(this.declarationDescriptor, ClassDescriptor.class, false);
    }

    @NotNull
    private JsExpression getDispatchReceiverPath(@Nullable ClassDescriptor cls, JsExpression thisExpression) {
        JsExpression alias;
        if (cls != null && (alias = this.getAliasForDescriptor(cls)) != null) {
            JsExpression jsExpression = alias;
            if (jsExpression == null) {
                TranslationContext.$$$reportNull$$$0(88);
            }
            return jsExpression;
        }
        if (this.classDescriptor == cls || this.parent == null) {
            JsExpression jsExpression = thisExpression;
            if (jsExpression == null) {
                TranslationContext.$$$reportNull$$$0(89);
            }
            return jsExpression;
        }
        if (this.classDescriptor != this.parent.classDescriptor) {
            JsNameRef jsNameRef = new JsNameRef("$outer", this.parent.getDispatchReceiverPath(cls, thisExpression));
            if (jsNameRef == null) {
                TranslationContext.$$$reportNull$$$0(90);
            }
            return jsNameRef;
        }
        JsExpression jsExpression = this.parent.getDispatchReceiverPath(cls, thisExpression);
        if (jsExpression == null) {
            TranslationContext.$$$reportNull$$$0(91);
        }
        return jsExpression;
    }

    @Nullable
    private JsExpression captureIfNeedAndGetCapturedName(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            TranslationContext.$$$reportNull$$$0(92);
        }
        if (this.usageTracker != null) {
            this.usageTracker.used(descriptor2);
            JsName name = UsageTrackerKt.getNameForCapturedDescriptor(this.usageTracker, descriptor2);
            if (name != null) {
                return this.getCapturedReference(name);
            }
        }
        return null;
    }

    @Nullable
    public JsExpression captureTypeIfNeedAndGetCapturedName(@NotNull TypeParameterDescriptor descriptor2) {
        if (descriptor2 == null) {
            TranslationContext.$$$reportNull$$$0(93);
        }
        if (this.usageTracker == null) {
            return null;
        }
        this.usageTracker.used(descriptor2);
        JsName name = this.usageTracker.getCapturedTypes().get(descriptor2);
        return name != null ? this.getCapturedReference(name) : null;
    }

    @NotNull
    public JsName getCapturedTypeName(@NotNull TypeParameterDescriptor descriptor2) {
        JsName result2;
        if (descriptor2 == null) {
            TranslationContext.$$$reportNull$$$0(94);
        }
        JsName jsName = result2 = this.usageTracker != null ? this.usageTracker.getCapturedTypes().get(descriptor2) : null;
        if (result2 == null) {
            result2 = this.getNameForDescriptor(descriptor2);
        }
        JsName jsName2 = result2;
        if (jsName2 == null) {
            TranslationContext.$$$reportNull$$$0(95);
        }
        return jsName2;
    }

    @NotNull
    private JsExpression getCapturedReference(@NotNull JsName name) {
        JsExpression result2;
        if (name == null) {
            TranslationContext.$$$reportNull$$$0(96);
        }
        if (this.shouldCaptureViaThis()) {
            result2 = new JsThisRef();
            int depth = this.getOuterLocalClassDepth();
            for (int i = 0; i < depth; ++i) {
                result2 = new JsNameRef("$outer", result2);
            }
            result2 = new JsNameRef(name, result2);
        } else {
            result2 = name.makeRef();
        }
        JsExpression jsExpression = result2;
        if (jsExpression == null) {
            TranslationContext.$$$reportNull$$$0(97);
        }
        return jsExpression;
    }

    private int getOuterLocalClassDepth() {
        if (this.usageTracker == null) {
            return 0;
        }
        MemberDescriptor capturingDescriptor = this.usageTracker.getContainingDescriptor();
        if (!(capturingDescriptor instanceof ClassDescriptor)) {
            return 0;
        }
        ClassDescriptor capturingClassDescriptor = (ClassDescriptor)capturingDescriptor;
        ClassDescriptor currentDescriptor = this.classDescriptor;
        if (currentDescriptor == null) {
            return 0;
        }
        int depth = 0;
        while (currentDescriptor != capturingClassDescriptor) {
            DeclarationDescriptor container2 = currentDescriptor.getContainingDeclaration();
            if (!(container2 instanceof ClassDescriptor)) {
                return 0;
            }
            currentDescriptor = (ClassDescriptor)container2;
            ++depth;
        }
        return depth;
    }

    private boolean shouldCaptureViaThis() {
        if (this.declarationDescriptor == null) {
            return false;
        }
        if (DescriptorUtils.isDescriptorWithLocalVisibility(this.declarationDescriptor)) {
            return false;
        }
        return !(this.declarationDescriptor instanceof ConstructorDescriptor) || !DescriptorUtils.isDescriptorWithLocalVisibility(this.declarationDescriptor.getContainingDeclaration());
    }

    @Nullable
    public DeclarationDescriptor getDeclarationDescriptor() {
        return this.declarationDescriptor;
    }

    public void putClassOrConstructorClosure(@NotNull MemberDescriptor descriptor2, @NotNull List<DeclarationDescriptor> closure) {
        if (descriptor2 == null) {
            TranslationContext.$$$reportNull$$$0(98);
        }
        if (closure == null) {
            TranslationContext.$$$reportNull$$$0(99);
        }
        this.staticContext.putClassOrConstructorClosure(descriptor2, closure);
    }

    @Nullable
    public List<DeclarationDescriptor> getClassOrConstructorClosure(@NotNull MemberDescriptor classOrConstructor) {
        if (classOrConstructor == null) {
            TranslationContext.$$$reportNull$$$0(100);
        }
        if (classOrConstructor instanceof TypeAliasConstructorDescriptor) {
            ClassConstructorDescriptor constructorDescriptor = ((TypeAliasConstructorDescriptor)classOrConstructor).getUnderlyingConstructorDescriptor();
            return this.getClassOrConstructorClosure(constructorDescriptor);
        }
        List<DeclarationDescriptor> result2 = this.staticContext.getClassOrConstructorClosure(classOrConstructor);
        if (result2 == null && classOrConstructor instanceof ConstructorDescriptor && ((ConstructorDescriptor)classOrConstructor).isPrimary()) {
            result2 = this.staticContext.getClassOrConstructorClosure((ClassDescriptor)classOrConstructor.getContainingDeclaration());
        }
        return result2;
    }

    @NotNull
    public JsExpression getArgumentForClosureConstructor(@NotNull DeclarationDescriptor descriptor2) {
        JsExpression alias;
        if (descriptor2 == null) {
            TranslationContext.$$$reportNull$$$0(101);
        }
        if ((alias = this.getAliasForDescriptor(descriptor2)) != null) {
            JsExpression jsExpression = alias;
            if (jsExpression == null) {
                TranslationContext.$$$reportNull$$$0(102);
            }
            return jsExpression;
        }
        if (descriptor2 instanceof ReceiverParameterDescriptor) {
            JsExpression jsExpression = this.getDispatchReceiver((ReceiverParameterDescriptor)descriptor2);
            if (jsExpression == null) {
                TranslationContext.$$$reportNull$$$0(103);
            }
            return jsExpression;
        }
        if (org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt.isCoroutineLambda(descriptor2)) {
            JsThisRef jsThisRef = new JsThisRef();
            if (jsThisRef == null) {
                TranslationContext.$$$reportNull$$$0(104);
            }
            return jsThisRef;
        }
        JsNameRef jsNameRef = this.getNameForDescriptor(descriptor2).makeRef();
        if (jsNameRef == null) {
            TranslationContext.$$$reportNull$$$0(105);
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression getTypeArgumentForClosureConstructor(@NotNull TypeParameterDescriptor descriptor2) {
        JsName name;
        if (descriptor2 == null) {
            TranslationContext.$$$reportNull$$$0(106);
        }
        JsNameRef captured2 = null;
        if (this.usageTracker != null && (name = this.usageTracker.getCapturedTypes().get(descriptor2)) != null) {
            captured2 = name.makeRef();
        }
        JsNameRef jsNameRef = captured2 != null ? captured2 : this.getNameForDescriptor(descriptor2).makeRef();
        if (jsNameRef == null) {
            TranslationContext.$$$reportNull$$$0(107);
        }
        return jsNameRef;
    }

    @Nullable
    public JsName getOuterClassReference(ClassDescriptor descriptor2) {
        DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
        if (!(container2 instanceof ClassDescriptor) || !descriptor2.isInner()) {
            return null;
        }
        return this.staticContext.getScopeForDescriptor(descriptor2).declareName("$outer");
    }

    public void startDeclaration() {
        ClassDescriptor classDescriptor = this.classDescriptor;
        if (classDescriptor != null && !(classDescriptor.getContainingDeclaration() instanceof ClassOrPackageFragmentDescriptor)) {
            this.staticContext.getDeferredCallSites().put(classDescriptor, new ArrayList());
        }
    }

    @NotNull
    public List<DeferredCallSite> endDeclaration() {
        List<DeferredCallSite> result2 = null;
        if (this.classDescriptor != null) {
            result2 = this.staticContext.getDeferredCallSites().remove(this.classDescriptor);
        }
        if (result2 == null) {
            result2 = Collections.emptyList();
        }
        List<DeferredCallSite> list2 = result2;
        if (list2 == null) {
            TranslationContext.$$$reportNull$$$0(108);
        }
        return list2;
    }

    public boolean shouldBeDeferred(@NotNull ClassConstructorDescriptor constructor) {
        if (constructor == null) {
            TranslationContext.$$$reportNull$$$0(109);
        }
        ClassDescriptor classDescriptor = constructor.getContainingDeclaration();
        return this.staticContext.getDeferredCallSites().containsKey(classDescriptor);
    }

    public void deferConstructorCall(@NotNull ClassConstructorDescriptor constructor, @NotNull List<JsExpression> invocationArgs) {
        if (constructor == null) {
            TranslationContext.$$$reportNull$$$0(110);
        }
        if (invocationArgs == null) {
            TranslationContext.$$$reportNull$$$0(111);
        }
        ClassDescriptor classDescriptor = constructor.getContainingDeclaration();
        List<DeferredCallSite> callSites = this.staticContext.getDeferredCallSites().get(classDescriptor);
        if (callSites == null) {
            throw new IllegalStateException("This method should be call only when `shouldBeDeferred` method reports true for given constructor: " + constructor);
        }
        callSites.add(new DeferredCallSite(constructor, invocationArgs, this));
    }

    public void addInlineCall(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            TranslationContext.$$$reportNull$$$0(112);
        }
        this.staticContext.addInlineCall(descriptor2);
    }

    public void addDeclarationStatement(@NotNull JsStatement statement2) {
        if (statement2 == null) {
            TranslationContext.$$$reportNull$$$0(113);
        }
        if (this.inlineFunctionContext != null) {
            this.inlineFunctionContext.getDeclarationsBlock().getStatements().add(statement2);
        } else {
            this.staticContext.getDeclarationStatements().add(statement2);
        }
    }

    public void addTopLevelStatement(@NotNull JsStatement statement2) {
        if (statement2 == null) {
            TranslationContext.$$$reportNull$$$0(114);
        }
        this.staticContext.getTopLevelStatements().add(statement2);
    }

    @NotNull
    public JsFunction createRootScopedFunction(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            TranslationContext.$$$reportNull$$$0(115);
        }
        JsFunction jsFunction = this.createRootScopedFunction(descriptor2.toString());
        if (jsFunction == null) {
            TranslationContext.$$$reportNull$$$0(116);
        }
        return jsFunction;
    }

    @NotNull
    public JsFunction createRootScopedFunction(@NotNull String description) {
        if (description == null) {
            TranslationContext.$$$reportNull$$$0(117);
        }
        JsFunction jsFunction = new JsFunction(this.staticContext.getFragment().getScope(), new JsBlock(), description);
        if (jsFunction == null) {
            TranslationContext.$$$reportNull$$$0(118);
        }
        return jsFunction;
    }

    public void addClass(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            TranslationContext.$$$reportNull$$$0(119);
        }
        if (this.inlineFunctionContext != null) {
            JsClassModel classModel = new ClassModelGenerator(this).generateClassModel(classDescriptor);
            List<JsStatement> targetStatements = this.inlineFunctionContext.getPrototypeBlock().getStatements();
            JsName superName = classModel.getSuperName();
            if (superName != null) {
                targetStatements.addAll(UtilsKt.createPrototypeStatements(superName, classModel.getName()));
            }
            targetStatements.addAll(classModel.getPostDeclarationBlock().getStatements());
        } else {
            this.staticContext.addClass(classDescriptor);
        }
    }

    public void export(@NotNull MemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            TranslationContext.$$$reportNull$$$0(120);
        }
        this.staticContext.export(descriptor2, false);
    }

    public boolean isFromCurrentModule(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            TranslationContext.$$$reportNull$$$0(121);
        }
        return this.staticContext.getCurrentModule() == DescriptorUtilsKt.getModule(descriptor2);
    }

    public boolean isPublicInlineFunction() {
        if (this.inlineFunctionContext == null) {
            return false;
        }
        return org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt.shouldBeExported(this.inlineFunctionContext.getDescriptor(), this.getConfig());
    }

    @Nullable
    public VariableDescriptor getContinuationParameterDescriptor() {
        return this.continuationParameterDescriptor;
    }

    @NotNull
    public ModuleDescriptor getCurrentModule() {
        ModuleDescriptor moduleDescriptor = this.staticContext.getCurrentModule();
        if (moduleDescriptor == null) {
            TranslationContext.$$$reportNull$$$0(122);
        }
        return moduleDescriptor;
    }

    @Nullable
    public TranslationContext getParent() {
        return this.parent;
    }

    @NotNull
    public JsName getNameForSpecialFunction(@NotNull SpecialFunction function2) {
        if (function2 == null) {
            TranslationContext.$$$reportNull$$$0(123);
        }
        if (this.inlineFunctionContext == null || !this.isPublicInlineFunction()) {
            JsName jsName = this.staticContext.getNameForSpecialFunction(function2);
            if (jsName == null) {
                TranslationContext.$$$reportNull$$$0(124);
            }
            return jsName;
        }
        String tag = TranslationUtils.getTagForSpecialFunction(function2);
        JsName jsName = this.inlineFunctionContext.getImports().computeIfAbsent(tag, t -> {
            if (function2 == null) {
                TranslationContext.$$$reportNull$$$0(126);
            }
            JsExpression imported = Namer.createSpecialFunction(function2);
            JsName result2 = JsScope.declareTemporaryName(function2.getSuggestedName());
            MetadataProperties.setImported(result2, true);
            MetadataProperties.setSpecialFunction(result2, function2);
            this.inlineFunctionContext.getImportBlock().getStatements().add(JsAstUtils.newVar(result2, imported));
            return result2;
        });
        if (jsName == null) {
            TranslationContext.$$$reportNull$$$0(125);
        }
        return jsName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 79: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 95: 
            case 97: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 116: 
            case 118: 
            case 122: 
            case 124: 
            case 125: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 79: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 95: 
            case 97: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 116: 
            case 118: 
            case 122: 
            case 124: 
            case 125: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticContext";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 79: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 95: 
            case 97: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 116: 
            case 118: 
            case 122: 
            case 124: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/context/TranslationContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aliasingContext";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 20: 
            case 32: 
            case 35: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 53: 
            case 55: 
            case 72: 
            case 80: 
            case 81: 
            case 92: 
            case 93: 
            case 94: 
            case 98: 
            case 101: 
            case 106: 
            case 112: 
            case 115: 
            case 120: 
            case 121: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 17: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "correspondingDescriptor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aliases";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 50: 
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedModuleName";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reexportExpr";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initExpression";
                break;
            }
            case 74: 
            case 113: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 76: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classOrConstructor";
                break;
            }
            case 109: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invocationArgs";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 123: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/context/TranslationContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "rootContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "dynamicContext";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "contextWithScope";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "newFunctionBody";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "newFunctionBodyWithUsageTracker";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "innerWithUsageTracker";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "inner";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "innerBlock";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "newDeclaration";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "innerWithAliasingContext";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "innerContextWithAliased";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "innerContextWithAliasesForExpressions";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "innerContextWithDescriptorsAliased";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "bindingContext";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "bindingTrace";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeForDescriptor";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameForElement";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameForDescriptor";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerNameForDescriptor";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlineableInnerNameForDescriptor";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameForObjectInstance";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedReference";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerReference";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "createInlineLocalImportExpression";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameForBackingField";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "declareTemporary";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "defineTemporary";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "cacheExpressionIfNeeded";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrDeclareTemporaryConstVariable";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "namer";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "intrinsics";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "program";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfig";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "scope";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "aliasingContext";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionObject";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentBlock";
                break;
            }
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getDispatchReceiver";
                break;
            }
            case 88: 
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "getDispatchReceiverPath";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapturedTypeName";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapturedReference";
                break;
            }
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentForClosureConstructor";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArgumentForClosureConstructor";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "endDeclaration";
                break;
            }
            case 116: 
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "createRootScopedFunction";
                break;
            }
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentModule";
                break;
            }
            case 124: 
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameForSpecialFunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "rootContext";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 79: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 95: 
            case 97: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 116: 
            case 118: 
            case 122: 
            case 124: 
            case 125: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "contextWithScope";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "newFunctionBody";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "newFunctionBodyWithUsageTracker";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "innerWithUsageTracker";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "inner";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "innerBlock";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "newDeclaration";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "innerContextWithAliased";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "innerContextWithAliasesForExpressions";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "innerContextWithDescriptorsAliased";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getBlockForDescriptor";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getScopeForDescriptor";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getNameForElement";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getNameForDescriptor";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getInnerNameForDescriptor";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getInlineableInnerNameForDescriptor";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getNameForObjectInstance";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedReference";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isInlineFunction";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "replaceModuleReference";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getInnerReference";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "createInlineLocalImportExpression";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getNameForBackingField";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "defineTemporary";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "cacheExpressionIfNeeded";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getOrDeclareTemporaryConstVariable";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionObject";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "addStatementToCurrentBlock";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "addStatementsToCurrentBlock";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "addStatementsToCurrentBlockFrom";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "moveVarsFrom";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getAliasForDescriptor";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getDispatchReceiver";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "captureIfNeedAndGetCapturedName";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "captureTypeIfNeedAndGetCapturedName";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "getCapturedTypeName";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "getCapturedReference";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "putClassOrConstructorClosure";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "getClassOrConstructorClosure";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentForClosureConstructor";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "getTypeArgumentForClosureConstructor";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "shouldBeDeferred";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "deferConstructorCall";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "addInlineCall";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "addDeclarationStatement";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "addTopLevelStatement";
                break;
            }
            case 115: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "createRootScopedFunction";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "addClass";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "export";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "isFromCurrentModule";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "getNameForSpecialFunction";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getNameForSpecialFunction$1";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getInlineableInnerNameForDescriptor$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 79: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 95: 
            case 97: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 116: 
            case 118: 
            case 122: 
            case 124: 
            case 125: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

