/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentPassedTwice;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCall;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.MixingNamedAndPositionArguments;
import org.jetbrains.kotlin.resolve.calls.model.NameForAmbiguousParameter;
import org.jetbrains.kotlin.resolve.calls.model.NameNotFound;
import org.jetbrains.kotlin.resolve.calls.model.NamedArgumentNotAllowed;
import org.jetbrains.kotlin.resolve.calls.model.NamedArgumentReference;
import org.jetbrains.kotlin.resolve.calls.model.NoValueForParameter;
import org.jetbrains.kotlin.resolve.calls.model.NonVarargSpread;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.TooManyArguments;
import org.jetbrains.kotlin.resolve.calls.model.VarargArgumentOutsideParentheses;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/ArgumentsToParametersMapper;", "", "()V", "EmptyArgumentMapping", "Lorg/jetbrains/kotlin/resolve/calls/components/ArgumentsToParametersMapper$ArgumentMapping;", "getEmptyArgumentMapping", "()Lorg/jetbrains/kotlin/resolve/calls/components/ArgumentsToParametersMapper$ArgumentMapping;", "mapArguments", "argumentsInParenthesis", "", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "externalArgument", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "call", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCall;", "ArgumentMapping", "CallArgumentProcessor", "kotlin-compiler"})
public final class ArgumentsToParametersMapper {
    @NotNull
    private final ArgumentMapping EmptyArgumentMapping = new ArgumentMapping(MapsKt.emptyMap(), CollectionsKt.emptyList());

    @NotNull
    public final ArgumentMapping getEmptyArgumentMapping() {
        return this.EmptyArgumentMapping;
    }

    @NotNull
    public final ArgumentMapping mapArguments(@NotNull KotlinCall call2, @NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(call2, "call");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        return this.mapArguments(call2.getArgumentsInParenthesis(), call2.getExternalArgument(), descriptor2);
    }

    @NotNull
    public final ArgumentMapping mapArguments(@NotNull List<? extends KotlinCallArgument> argumentsInParenthesis, @Nullable KotlinCallArgument externalArgument, @NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(argumentsInParenthesis, "argumentsInParenthesis");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (argumentsInParenthesis.isEmpty() && externalArgument == null && descriptor2.getValueParameters().isEmpty()) {
            return this.EmptyArgumentMapping;
        }
        CallArgumentProcessor processor = new CallArgumentProcessor(descriptor2);
        processor.processArgumentsInParenthesis(argumentsInParenthesis);
        if (externalArgument != null) {
            processor.processExternalArgument(externalArgument);
        }
        processor.processDefaultsAndRunChecks();
        return new ArgumentMapping(processor.getResult(), processor.getDiagnostics());
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J/\u0010\u0010\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/ArgumentsToParametersMapper$ArgumentMapping;", "", "parameterToCallArgumentMap", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCallArgument;", "diagnostics", "", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallDiagnostic;", "(Ljava/util/Map;Ljava/util/List;)V", "getDiagnostics", "()Ljava/util/List;", "getParameterToCallArgumentMap", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin-compiler"})
    public static final class ArgumentMapping {
        @NotNull
        private final Map<ValueParameterDescriptor, ResolvedCallArgument> parameterToCallArgumentMap;
        @NotNull
        private final List<KotlinCallDiagnostic> diagnostics;

        @NotNull
        public final Map<ValueParameterDescriptor, ResolvedCallArgument> getParameterToCallArgumentMap() {
            return this.parameterToCallArgumentMap;
        }

        @NotNull
        public final List<KotlinCallDiagnostic> getDiagnostics() {
            return this.diagnostics;
        }

        public ArgumentMapping(@NotNull Map<ValueParameterDescriptor, ? extends ResolvedCallArgument> parameterToCallArgumentMap, @NotNull List<? extends KotlinCallDiagnostic> diagnostics) {
            Intrinsics.checkParameterIsNotNull(parameterToCallArgumentMap, "parameterToCallArgumentMap");
            Intrinsics.checkParameterIsNotNull(diagnostics, "diagnostics");
            this.parameterToCallArgumentMap = parameterToCallArgumentMap;
            this.diagnostics = diagnostics;
        }

        @NotNull
        public final Map<ValueParameterDescriptor, ResolvedCallArgument> component1() {
            return this.parameterToCallArgumentMap;
        }

        @NotNull
        public final List<KotlinCallDiagnostic> component2() {
            return this.diagnostics;
        }

        @NotNull
        public final ArgumentMapping copy(@NotNull Map<ValueParameterDescriptor, ? extends ResolvedCallArgument> parameterToCallArgumentMap, @NotNull List<? extends KotlinCallDiagnostic> diagnostics) {
            Intrinsics.checkParameterIsNotNull(parameterToCallArgumentMap, "parameterToCallArgumentMap");
            Intrinsics.checkParameterIsNotNull(diagnostics, "diagnostics");
            return new ArgumentMapping(parameterToCallArgumentMap, diagnostics);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ArgumentMapping copy$default(ArgumentMapping argumentMapping, Map map2, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                map2 = argumentMapping.parameterToCallArgumentMap;
            }
            if ((n & 2) != 0) {
                list2 = argumentMapping.diagnostics;
            }
            return argumentMapping.copy(map2, list2);
        }

        public String toString() {
            return "ArgumentMapping(parameterToCallArgumentMap=" + this.parameterToCallArgumentMap + ", diagnostics=" + this.diagnostics + ")";
        }

        public int hashCode() {
            Map<ValueParameterDescriptor, ResolvedCallArgument> map2 = this.parameterToCallArgumentMap;
            List<KotlinCallDiagnostic> list2 = this.diagnostics;
            return (map2 != null ? ((Object)map2).hashCode() : 0) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ArgumentMapping)) break block3;
                    ArgumentMapping argumentMapping = (ArgumentMapping)object;
                    if (!Intrinsics.areEqual(this.parameterToCallArgumentMap, argumentMapping.parameterToCallArgumentMap) || !Intrinsics.areEqual(this.diagnostics, argumentMapping.diagnostics)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u00010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000bH\u0002J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001cH\u0002J\b\u0010\"\u001a\u00020\u001eH\u0002J\u001a\u0010#\u001a\u0004\u0018\u00010\u000f2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u000eH\u0002J\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011J\u0012\u0010&\u001a\u0004\u0018\u00010\u000f2\u0006\u0010$\u001a\u00020\u000eH\u0002J\u0014\u0010'\u001a\u00020\u001e2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0011J\u0006\u0010)\u001a\u00020\u001eJ\u000e\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020\u001cJ\u0018\u0010,\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u000eH\u0002J\u0010\u0010-\u001a\u00020.2\u0006\u0010!\u001a\u00020\u001cH\u0002J\u000e\u0010/\u001a\u0004\u0018\u00010\u000f*\u00020\u000fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/ArgumentsToParametersMapper$CallArgumentProcessor;", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;)V", "currentParameterIndex", "", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "diagnostics", "", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallDiagnostic;", "nameToParameter", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "parameters", "", "getParameters", "()Ljava/util/List;", "result", "", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCallArgument;", "getResult", "()Ljava/util/Map;", "state", "Lorg/jetbrains/kotlin/resolve/calls/components/ArgumentsToParametersMapper$CallArgumentProcessor$State;", "varargArguments", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "addDiagnostic", "", "diagnostic", "addVarargArgument", "argument", "completeVarargPositionArguments", "findParameterByName", "name", "getDiagnostics", "getParameterByName", "processArgumentsInParenthesis", "arguments", "processDefaultsAndRunChecks", "processExternalArgument", "externalArgument", "processNamedArgument", "processPositionArgument", "", "getOverriddenParameterWithOtherName", "State", "kotlin-compiler"})
    private static final class CallArgumentProcessor {
        @NotNull
        private final Map<ValueParameterDescriptor, ResolvedCallArgument> result;
        private State state;
        private List<KotlinCallDiagnostic> diagnostics;
        private Map<Name, ? extends ValueParameterDescriptor> nameToParameter;
        private List<KotlinCallArgument> varargArguments;
        private int currentParameterIndex;
        @NotNull
        private final CallableDescriptor descriptor;

        @NotNull
        public final Map<ValueParameterDescriptor, ResolvedCallArgument> getResult() {
            return this.result;
        }

        private final List<ValueParameterDescriptor> getParameters() {
            List<ValueParameterDescriptor> list2 = this.descriptor.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, "descriptor.valueParameters");
            return list2;
        }

        private final void addDiagnostic(KotlinCallDiagnostic diagnostic) {
            if (this.diagnostics == null) {
                this.diagnostics = new ArrayList();
            }
            List<KotlinCallDiagnostic> list2 = this.diagnostics;
            if (list2 == null) {
                Intrinsics.throwNpe();
            }
            list2.add(diagnostic);
        }

        @NotNull
        public final List<KotlinCallDiagnostic> getDiagnostics() {
            List<KotlinCallDiagnostic> list2 = this.diagnostics;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            return list2;
        }

        /*
         * WARNING - void declaration
         */
        private final ValueParameterDescriptor getParameterByName(Name name) {
            if (this.nameToParameter == null) {
                Map map2;
                void $receiver$iv$iv;
                void $receiver$iv;
                Iterable iterable = this.getParameters();
                CallArgumentProcessor callArgumentProcessor = this;
                int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10)), 16);
                void var4_5 = $receiver$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                for (Object element$iv$iv : $receiver$iv$iv) {
                    void it;
                    ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)element$iv$iv;
                    map2 = destination$iv$iv;
                    Name name2 = it.getName();
                    map2.put(name2, element$iv$iv);
                }
                callArgumentProcessor.nameToParameter = map2 = destination$iv$iv;
            }
            Map<Name, ? extends ValueParameterDescriptor> map3 = this.nameToParameter;
            if (map3 == null) {
                Intrinsics.throwNpe();
            }
            return map3.get(name);
        }

        private final void addVarargArgument(KotlinCallArgument argument) {
            if (this.varargArguments == null) {
                this.varargArguments = new ArrayList();
            }
            List<KotlinCallArgument> list2 = this.varargArguments;
            if (list2 == null) {
                Intrinsics.throwNpe();
            }
            list2.add(argument);
        }

        private final void completeVarargPositionArguments() {
            boolean bl = Intrinsics.areEqual((Object)this.state, (Object)State.VARARG_POSITION);
            if (_Assertions.ENABLED && !bl) {
                String string = "Incorrect state: " + (Object)((Object)this.state);
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            ValueParameterDescriptor parameter = this.getParameters().get(this.currentParameterIndex);
            ValueParameterDescriptor valueParameterDescriptor = parameter.getOriginal();
            List<KotlinCallArgument> list2 = this.varargArguments;
            if (list2 == null) {
                Intrinsics.throwNpe();
            }
            this.result.put(valueParameterDescriptor, new ResolvedCallArgument.VarargArgument(list2));
        }

        private final boolean processPositionArgument(KotlinCallArgument argument) {
            if (Intrinsics.areEqual((Object)this.state, (Object)State.NAMED_ARGUMENT)) {
                this.addDiagnostic(new MixingNamedAndPositionArguments(argument));
                return false;
            }
            ValueParameterDescriptor parameter = CollectionsKt.getOrNull(this.getParameters(), this.currentParameterIndex);
            if (parameter == null) {
                this.addDiagnostic(new TooManyArguments(argument, this.descriptor));
                return false;
            }
            if (!ArgumentsUtilsKt.isVararg(parameter)) {
                int n = this.currentParameterIndex;
                this.currentParameterIndex = n + 1;
                this.result.put(parameter.getOriginal(), new ResolvedCallArgument.SimpleArgument(argument));
                return false;
            }
            this.addVarargArgument(argument);
            return true;
        }

        private final void processNamedArgument(KotlinCallArgument argument, Name name) {
            if (!this.descriptor.hasStableParameterNames()) {
                this.addDiagnostic(new NamedArgumentNotAllowed(argument, this.descriptor));
            }
            ValueParameterDescriptor valueParameterDescriptor = this.findParameterByName(argument, name);
            if (valueParameterDescriptor == null) {
                return;
            }
            ValueParameterDescriptor parameter = valueParameterDescriptor;
            this.addDiagnostic(new NamedArgumentReference(argument, parameter));
            ResolvedCallArgument resolvedCallArgument = this.result.get(parameter.getOriginal());
            if (resolvedCallArgument != null) {
                ResolvedCallArgument resolvedCallArgument2;
                ResolvedCallArgument it = resolvedCallArgument2 = resolvedCallArgument;
                this.addDiagnostic(new ArgumentPassedTwice(argument, parameter, it));
                return;
            }
            Map<ValueParameterDescriptor, ResolvedCallArgument> map2 = this.result;
            ValueParameterDescriptor valueParameterDescriptor2 = parameter.getOriginal();
            ResolvedCallArgument.SimpleArgument simpleArgument = new ResolvedCallArgument.SimpleArgument(argument);
            map2.put(valueParameterDescriptor2, simpleArgument);
        }

        private final ValueParameterDescriptor getOverriddenParameterWithOtherName(@NotNull ValueParameterDescriptor $receiver) {
            Object v0;
            block1: {
                Iterable $receiver$iv = $receiver.getOverriddenDescriptors();
                for (Object element$iv : $receiver$iv) {
                    ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                    if (!(it.getContainingDeclaration().hasStableParameterNames() && Intrinsics.areEqual(it.getName(), $receiver.getName()) ^ true)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        private final ValueParameterDescriptor findParameterByName(KotlinCallArgument argument, Name name) {
            ValueParameterDescriptor parameter = this.getParameterByName(name);
            if (this.descriptor instanceof CallableMemberDescriptor && Intrinsics.areEqual((Object)((CallableMemberDescriptor)this.descriptor).getKind(), (Object)CallableMemberDescriptor.Kind.FAKE_OVERRIDE)) {
                if (parameter == null) {
                    for (ValueParameterDescriptor valueParameter : ((CallableMemberDescriptor)this.descriptor).getValueParameters()) {
                        ValueParameterDescriptor matchedParameter;
                        Object v0;
                        block7: {
                            Iterable $receiver$iv = valueParameter.getOverriddenDescriptors();
                            for (Object element$iv : $receiver$iv) {
                                ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                                if (!(it.getContainingDeclaration().hasStableParameterNames() && Intrinsics.areEqual(it.getName(), name))) continue;
                                v0 = element$iv;
                                break block7;
                            }
                            v0 = null;
                        }
                        if ((matchedParameter = (ValueParameterDescriptor)v0) == null) continue;
                        ValueParameterDescriptor valueParameterDescriptor = valueParameter;
                        Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "valueParameter");
                        this.addDiagnostic(new NamedArgumentReference(argument, valueParameterDescriptor));
                        this.addDiagnostic(new NameForAmbiguousParameter(argument, valueParameter, matchedParameter));
                        return valueParameter;
                    }
                } else {
                    ValueParameterDescriptor valueParameterDescriptor = this.getOverriddenParameterWithOtherName(parameter);
                    if (valueParameterDescriptor != null) {
                        ValueParameterDescriptor valueParameterDescriptor2;
                        ValueParameterDescriptor it = valueParameterDescriptor2 = valueParameterDescriptor;
                        this.addDiagnostic(new NameForAmbiguousParameter(argument, parameter, it));
                    }
                }
            }
            if (parameter == null) {
                this.addDiagnostic(new NameNotFound(argument, this.descriptor));
            }
            return parameter;
        }

        public final void processArgumentsInParenthesis(@NotNull List<? extends KotlinCallArgument> arguments2) {
            Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
            for (KotlinCallArgument kotlinCallArgument : arguments2) {
                Name argumentName = kotlinCallArgument.getArgumentName();
                if (argumentName == null) {
                    if (!this.processPositionArgument(kotlinCallArgument)) continue;
                    this.state = State.VARARG_POSITION;
                    continue;
                }
                if (Intrinsics.areEqual((Object)this.state, (Object)State.VARARG_POSITION)) {
                    this.completeVarargPositionArguments();
                }
                this.state = State.POSITION_ARGUMENTS;
                this.processNamedArgument(kotlinCallArgument, argumentName);
            }
            if (Intrinsics.areEqual((Object)this.state, (Object)State.VARARG_POSITION)) {
                this.completeVarargPositionArguments();
            }
        }

        public final void processExternalArgument(@NotNull KotlinCallArgument externalArgument) {
            Intrinsics.checkParameterIsNotNull(externalArgument, "externalArgument");
            ValueParameterDescriptor lastParameter = CollectionsKt.lastOrNull(this.getParameters());
            if (lastParameter == null) {
                this.addDiagnostic(new TooManyArguments(externalArgument, this.descriptor));
                return;
            }
            if (ArgumentsUtilsKt.isVararg(lastParameter)) {
                this.addDiagnostic(new VarargArgumentOutsideParentheses(externalArgument, lastParameter));
                return;
            }
            ResolvedCallArgument previousOccurrence = this.result.get(lastParameter.getOriginal());
            if (previousOccurrence != null) {
                this.addDiagnostic(new TooManyArguments(externalArgument, this.descriptor));
                return;
            }
            Map<ValueParameterDescriptor, ResolvedCallArgument> map2 = this.result;
            ValueParameterDescriptor valueParameterDescriptor = lastParameter.getOriginal();
            ResolvedCallArgument.SimpleArgument simpleArgument = new ResolvedCallArgument.SimpleArgument(externalArgument);
            map2.put(valueParameterDescriptor, simpleArgument);
        }

        public final void processDefaultsAndRunChecks() {
            Object object;
            Map<ValueParameterDescriptor, ResolvedCallArgument> map2 = this.result;
            for (Map.Entry<ValueParameterDescriptor, ResolvedCallArgument> entry : map2.entrySet()) {
                object = entry;
                ValueParameterDescriptor parameter = object.getKey();
                object = entry;
                ResolvedCallArgument resolvedArgument = object.getValue();
                if (ArgumentsUtilsKt.isVararg(parameter)) continue;
                if (!(resolvedArgument instanceof ResolvedCallArgument.SimpleArgument)) {
                    object = "Incorrect resolved argument for parameter " + parameter + " :" + resolvedArgument;
                    throw (Throwable)new IllegalStateException(object.toString());
                }
                if (!((ResolvedCallArgument.SimpleArgument)resolvedArgument).getCallArgument().isSpread()) continue;
                this.addDiagnostic(new NonVarargSpread(((ResolvedCallArgument.SimpleArgument)resolvedArgument).getCallArgument(), parameter));
            }
            for (ValueParameterDescriptor parameter : this.getParameters()) {
                ValueParameterDescriptor valueParameterDescriptor;
                if (this.result.containsKey(parameter.getOriginal())) continue;
                if (DescriptorUtilsKt.hasDefaultValue(parameter)) {
                    map2 = this.result;
                    valueParameterDescriptor = parameter.getOriginal();
                    object = ResolvedCallArgument.DefaultArgument.INSTANCE;
                    map2.put(valueParameterDescriptor, (ResolvedCallArgument)object);
                    continue;
                }
                if (ArgumentsUtilsKt.isVararg(parameter)) {
                    map2 = this.result;
                    valueParameterDescriptor = parameter.getOriginal();
                    object = new ResolvedCallArgument.VarargArgument(CollectionsKt.emptyList());
                    map2.put(valueParameterDescriptor, (ResolvedCallArgument)object);
                    continue;
                }
                this.addDiagnostic(new NoValueForParameter(parameter, this.descriptor));
            }
        }

        @NotNull
        public final CallableDescriptor getDescriptor() {
            return this.descriptor;
        }

        public CallArgumentProcessor(@NotNull CallableDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            this.descriptor = descriptor2;
            this.result = new LinkedHashMap();
            this.state = State.POSITION_ARGUMENTS;
        }

        @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/ArgumentsToParametersMapper$CallArgumentProcessor$State;", "", "(Ljava/lang/String;I)V", "POSITION_ARGUMENTS", "VARARG_POSITION", "NAMED_ARGUMENT", "kotlin-compiler"})
        private static final class State
        extends Enum<State> {
            public static final /* enum */ State POSITION_ARGUMENTS;
            public static final /* enum */ State VARARG_POSITION;
            public static final /* enum */ State NAMED_ARGUMENT;
            private static final /* synthetic */ State[] $VALUES;

            static {
                State[] stateArray = new State[3];
                State[] stateArray2 = stateArray;
                stateArray[0] = POSITION_ARGUMENTS = new State();
                stateArray[1] = VARARG_POSITION = new State();
                stateArray[2] = NAMED_ARGUMENT = new State();
                $VALUES = stateArray;
            }

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String string) {
                return Enum.valueOf(State.class, string);
            }
        }
    }
}

