/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.functions.FunctionClassDescriptor;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.TypeSubstitutor;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0001\u001a\u0018\u0010\u0014\u001a\u00020\n*\u00020\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0001\u001a#\u0010\u0015\u001a\u00020\u000f*\u00020\u000f2\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0016\"\u00020\n\u00a2\u0006\u0002\u0010\u0017\u001a\u001e\u0010\u0015\u001a\u00020\u000f*\u00020\u000f2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\n0\u0019\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u001b\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\"\u0015\u0010\b\u001a\u00020\t*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u000b\"\u0015\u0010\f\u001a\u00020\t*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"allParameters", "", "Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getAllParameters", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;)Ljava/util/List;", "explicitParameters", "getExplicitParameters", "isFunctionOrKFunctionType", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/types/KotlinType;)Z", "isSuspend", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;)Z", "getFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "name", "", "types", "replace", "substitute", "", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;[Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "typeArguments", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "backend-common"})
public final class DescriptorUtilsKt {
    public static final boolean isSuspend(@NotNull CallableDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver instanceof FunctionDescriptor && ((FunctionDescriptor)$receiver).isSuspend();
    }

    @NotNull
    public static final List<ParameterDescriptor> getAllParameters(@NotNull CallableDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver instanceof ConstructorDescriptor ? CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)((ConstructorDescriptor)$receiver).getConstructedClass().getThisAsReceiverParameter()), (Iterable)DescriptorUtilsKt.getExplicitParameters($receiver)) : DescriptorUtilsKt.getExplicitParameters($receiver);
    }

    @NotNull
    public static final List<ParameterDescriptor> getExplicitParameters(@NotNull CallableDescriptor $receiver) {
        ReceiverParameterDescriptor it;
        ReceiverParameterDescriptor receiverParameterDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ArrayList<ReceiverParameterDescriptor> result2 = new ArrayList<ReceiverParameterDescriptor>($receiver.getValueParameters().size() + 2);
        ReceiverParameterDescriptor receiverParameterDescriptor2 = $receiver.getDispatchReceiverParameter();
        if (receiverParameterDescriptor2 != null) {
            it = receiverParameterDescriptor = receiverParameterDescriptor2;
            result2.add(it);
        }
        ReceiverParameterDescriptor receiverParameterDescriptor3 = $receiver.getExtensionReceiverParameter();
        if (receiverParameterDescriptor3 != null) {
            it = receiverParameterDescriptor = receiverParameterDescriptor3;
            result2.add(it);
        }
        result2.addAll((Collection)$receiver.getValueParameters());
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KotlinType replace(@NotNull KotlinType $receiver, @NotNull List<? extends KotlinType> types) {
        Collection<TypeProjectionImpl> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(types, (String)"types");
        Iterable iterable = types;
        KotlinType kotlinType = $receiver;
        void var3_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void p1;
            KotlinType kotlinType2 = (KotlinType)item$iv$iv;
            collection = destination$iv$iv;
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl((KotlinType)p1);
            collection.add(typeProjectionImpl);
        }
        collection = (List)destination$iv$iv;
        return TypeSubstitutionKt.replace$default(kotlinType, (List)collection, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FunctionDescriptor substitute(@NotNull FunctionDescriptor $receiver, KotlinType ... types) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)types, (String)"types");
        Iterable $receiver$iv = CollectionsKt.withIndex((Iterable)$receiver.getTypeParameters());
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        Iterable iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            IndexedValue it;
            IndexedValue indexedValue = (IndexedValue)element$iv$iv;
            Map map2 = destination$iv$iv;
            TypeConstructor typeConstructor2 = ((TypeParameterDescriptor)it.getValue()).getTypeConstructor();
            it = (IndexedValue)element$iv$iv;
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(types[it.getIndex()]);
            map2.put(typeConstructor2, typeProjectionImpl);
        }
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(destination$iv$iv);
        FunctionDescriptor functionDescriptor = $receiver.substitute(typeSubstitutor2);
        if (functionDescriptor == null) {
            Intrinsics.throwNpe();
        }
        return functionDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FunctionDescriptor substitute(@NotNull FunctionDescriptor $receiver, @NotNull Map<TypeParameterDescriptor, ? extends KotlinType> typeArguments2) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(typeArguments2, (String)"typeArguments");
        Iterable $receiver$iv = $receiver.getTypeParameters();
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        Iterable iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            TypeParameterDescriptor it;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)element$iv$iv;
            Map map2 = destination$iv$iv;
            TypeConstructor typeConstructor2 = it.getTypeConstructor();
            it = (TypeParameterDescriptor)element$iv$iv;
            KotlinType kotlinType = typeArguments2.get(it);
            if (kotlinType == null) {
                Intrinsics.throwNpe();
            }
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(kotlinType);
            map2.put(typeConstructor2, typeProjectionImpl);
        }
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(destination$iv$iv);
        FunctionDescriptor functionDescriptor = $receiver.substitute(typeSubstitutor2);
        if (functionDescriptor == null) {
            Intrinsics.throwNpe();
        }
        return functionDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FunctionDescriptor getFunction(@NotNull ClassDescriptor $receiver, @NotNull String name, @NotNull List<? extends KotlinType> types) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(types, (String)"types");
        Iterable iterable = CollectionsKt.withIndex((Iterable)$receiver.getDeclaredTypeParameters());
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        void var6_5 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            IndexedValue it;
            IndexedValue indexedValue = (IndexedValue)element$iv$iv;
            Map map2 = destination$iv$iv;
            TypeConstructor typeConstructor2 = ((TypeParameterDescriptor)it.getValue()).getTypeConstructor();
            it = (IndexedValue)element$iv$iv;
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(types.get(it.getIndex()));
            map2.put(typeConstructor2, typeProjectionImpl);
        }
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(destination$iv$iv);
        MemberScope memberScope2 = $receiver.getUnsubstitutedMemberScope();
        Name name2 = Name.identifier(name);
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(name)");
        FunctionDescriptor functionDescriptor = ((SimpleFunctionDescriptor)CollectionsKt.single((Iterable)memberScope2.getContributedFunctions(name2, NoLookupLocation.FROM_BACKEND))).substitute(typeSubstitutor2);
        if (functionDescriptor == null) {
            Intrinsics.throwNpe();
        }
        return functionDescriptor;
    }

    public static final boolean isFunctionOrKFunctionType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        FunctionClassDescriptor.Kind kind = classifierDescriptor != null ? FunctionTypesKt.getFunctionalClassKind(classifierDescriptor) : null;
        return Intrinsics.areEqual((Object)((Object)kind), (Object)((Object)FunctionClassDescriptor.Kind.Function)) || Intrinsics.areEqual((Object)((Object)kind), (Object)((Object)FunctionClassDescriptor.Kind.KFunction));
    }
}

