/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.config;

import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;

public class CompilerConfiguration {
    public static CompilerConfiguration EMPTY = new CompilerConfiguration();
    private final Map<Key, Object> map = new HashMap<Key, Object>();
    private boolean readOnly = false;

    @Nullable
    public <T> T get(@NotNull CompilerConfigurationKey<T> key) {
        Object data = this.map.get(key.ideaKey);
        return (T)(data == null ? null : CompilerConfiguration.unmodifiable(data));
    }

    @NotNull
    public <T> T get(@NotNull CompilerConfigurationKey<T> key, @NotNull T defaultValue) {
        T data = this.get(key);
        return data == null ? defaultValue : data;
    }

    @NotNull
    public <T> T getNotNull(@NotNull CompilerConfigurationKey<T> key) {
        T data = this.get(key);
        assert (data != null) : "No value for configuration key: " + key;
        return data;
    }

    public boolean getBoolean(@NotNull CompilerConfigurationKey<Boolean> key) {
        return this.get(key, false);
    }

    @NotNull
    public <T> List<T> getList(@NotNull CompilerConfigurationKey<List<T>> key) {
        List<T> data = this.get(key);
        return data == null ? Collections.emptyList() : data;
    }

    @NotNull
    public <K, V> Map<K, V> getMap(@NotNull CompilerConfigurationKey<Map<K, V>> key) {
        Map<K, V> data = this.get(key);
        return data == null ? Collections.emptyMap() : data;
    }

    public <T> void put(@NotNull CompilerConfigurationKey<T> key, @NotNull T value) {
        this.checkReadOnly();
        this.map.put(key.ideaKey, value);
    }

    public <T> void add(@NotNull CompilerConfigurationKey<List<T>> key, @NotNull T value) {
        this.checkReadOnly();
        Key ideaKey = key.ideaKey;
        this.map.computeIfAbsent(ideaKey, k -> new ArrayList());
        List list2 = (List)this.map.get(ideaKey);
        list2.add(value);
    }

    public <K, V> void put(@NotNull CompilerConfigurationKey<Map<K, V>> configurationKey, @NotNull K key, @NotNull V value) {
        this.checkReadOnly();
        Key ideaKey = configurationKey.ideaKey;
        this.map.computeIfAbsent(ideaKey, k -> new HashMap());
        Map data = (Map)this.map.get(ideaKey);
        data.put(key, value);
    }

    public <T> void addAll(@NotNull CompilerConfigurationKey<List<T>> key, @NotNull Collection<T> values) {
        this.checkReadOnly();
        CompilerConfiguration.checkForNullElements(values);
        Key ideaKey = key.ideaKey;
        this.map.computeIfAbsent(ideaKey, k -> new ArrayList());
        List list2 = (List)this.map.get(ideaKey);
        list2.addAll(values);
    }

    public CompilerConfiguration copy() {
        CompilerConfiguration copy = new CompilerConfiguration();
        copy.map.putAll(this.map);
        return copy;
    }

    private void checkReadOnly() {
        if (this.readOnly) {
            throw new IllegalStateException("CompilerConfiguration is read-only");
        }
    }

    public void setReadOnly(boolean readOnly) {
        if (readOnly != this.readOnly) {
            this.readOnly = readOnly;
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    @NotNull
    private static <T> T unmodifiable(@NotNull T object) {
        if (object instanceof List) {
            return (T)Collections.unmodifiableList((List)object);
        }
        if (object instanceof Map) {
            return (T)Collections.unmodifiableMap((Map)object);
        }
        if (object instanceof Collection) {
            return (T)Collections.unmodifiableCollection((Collection)object);
        }
        return object;
    }

    public String toString() {
        return this.map.toString();
    }

    private static <T> void checkForNullElements(Collection<T> values) {
        int index2 = 0;
        for (T value : values) {
            if (value == null) {
                throw new IllegalArgumentException("Element " + index2 + " is null, while null values in compiler configuration are not allowed");
            }
            ++index2;
        }
    }

    static {
        EMPTY.setReadOnly(true);
    }
}

