/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.psiUtil;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.psiUtil.PsiChildRange;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=2, d1={"\u0000\u009c\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u001a\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0016H\u0002\u001a\u0016\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\"2\u0006\u0010#\u001a\u00020!\u001a/\u0010$\u001a\u00020%\"\n\b\u0000\u0010&\u0018\u0001*\u00020\u0002*\u00020\u00022\u0014\b\n\u0010'\u001a\u000e\u0012\u0004\u0012\u0002H&\u0012\u0004\u0012\u00020%0(H\u0086\b\u001aE\u0010$\u001a\u00020%\"\n\b\u0000\u0010&\u0018\u0001*\u00020\u0002*\u00020\u00022\u0014\b\u0004\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020%0(2\u0014\b\n\u0010'\u001a\u000e\u0012\u0004\u0012\u0002H&\u0012\u0004\u0012\u00020%0(H\u0086\b\u001a\u0012\u0010*\u001a\u00020%*\u00020\u00022\u0006\u0010+\u001a\u00020\u0002\u001a5\u0010,\u001a\b\u0012\u0004\u0012\u0002H&0-\"\n\b\u0000\u0010&\u0018\u0001*\u00020\u0002*\u00020\u00022\u0014\b\n\u0010'\u001a\u000e\u0012\u0004\u0012\u0002H&\u0012\u0004\u0012\u00020%0(H\u0086\b\u001aK\u0010,\u001a\b\u0012\u0004\u0012\u0002H&0-\"\n\b\u0000\u0010&\u0018\u0001*\u00020\u0002*\u00020\u00022\u0014\b\u0004\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020%0(2\u0014\b\n\u0010'\u001a\u000e\u0012\u0004\u0012\u0002H&\u0012\u0004\u0012\u00020%0(H\u0086\b\u001a\u0015\u0010.\u001a\u00020%*\u00020/2\u0006\u0010+\u001a\u00020\u0002H\u0086\u0002\u001a\u0012\u00100\u001a\u00020%*\u00020\u00162\u0006\u00101\u001a\u00020\u0006\u001a\u001f\u00102\u001a\b\u0012\u0004\u0012\u0002H403\"\b\b\u0000\u00104*\u00020\u0002*\u0002H4\u00a2\u0006\u0002\u00105\u001a\u0018\u00106\u001a\b\u0012\u0004\u0012\u00020\u00020-*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0016\u001a6\u00107\u001a\u0004\u0018\u0001H&\"\n\b\u0000\u0010&\u0018\u0001*\u00020\u0002*\u00020\u00022\u0014\b\n\u0010'\u001a\u000e\u0012\u0004\u0012\u0002H&\u0012\u0004\u0012\u00020%0(H\u0086\b\u00a2\u0006\u0002\u00108\u001aL\u00107\u001a\u0004\u0018\u0001H&\"\n\b\u0000\u0010&\u0018\u0001*\u00020\u0002*\u00020\u00022\u0014\b\u0004\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020%0(2\u0014\b\n\u0010'\u001a\u000e\u0012\u0004\u0012\u0002H&\u0012\u0004\u0012\u00020%0(H\u0086\b\u00a2\u0006\u0002\u00109\u001a/\u0010:\u001a\u00020;\"\n\b\u0000\u0010&\u0018\u0001*\u00020\u0002*\u00020\u00022\u0014\b\b\u0010<\u001a\u000e\u0012\u0004\u0012\u0002H&\u0012\u0004\u0012\u00020;0(H\u0086\b\u001aE\u0010:\u001a\u00020;\"\n\b\u0000\u0010&\u0018\u0001*\u00020\u0002*\u00020\u00022\u0014\b\u0004\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020%0(2\u0014\b\b\u0010<\u001a\u000e\u0012\u0004\u0012\u0002H&\u0012\u0004\u0012\u00020;0(H\u0086\b\u001a \u0010=\u001a\u0004\u0018\u0001H&\"\n\b\u0000\u0010&\u0018\u0001*\u00020\u0002*\u00020\u0002H\u0086\b\u00a2\u0006\u0002\u0010>\u001a$\u0010?\u001a\b\u0012\u0004\u0012\u0002H&0@\"\n\b\u0000\u0010&\u0018\u0001*\u00020\u0002*\u00020\u0002H\u0086\b\u00a2\u0006\u0002\u0010A\u001a\n\u0010B\u001a\u00020C*\u00020\u0002\u001a>\u0010D\u001a\u0004\u0018\u0001H&\"\b\b\u0000\u0010&*\u00020\u0002*\u0002H&2\u0006\u0010+\u001a\u00020\u00022\u0019\u0010E\u001a\u0015\u0012\u0004\u0012\u0002H&\u0012\u0006\u0012\u0004\u0018\u00010\u00020(\u00a2\u0006\u0002\bF\u00a2\u0006\u0002\u0010G\u001aD\u0010H\u001a\u0004\u0018\u0001H&\"\b\b\u0000\u0010&*\u00020\u0002*\u0002H&2\u0006\u0010+\u001a\u00020\u00022\u001f\u0010I\u001a\u001b\u0012\u0004\u0012\u0002H&\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020J0(\u00a2\u0006\u0002\bF\u00a2\u0006\u0002\u0010G\u001a \u0010K\u001a\u0004\u0018\u0001H&\"\n\b\u0000\u0010&\u0018\u0001*\u00020\u0002*\u00020\u0002H\u0086\b\u00a2\u0006\u0002\u0010>\u001a\u0016\u0010L\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\b\b\u0002\u0010M\u001a\u00020%\u001a\u0016\u0010N\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\b\b\u0002\u0010M\u001a\u00020%\u001a \u0010O\u001a\u0004\u0018\u0001H&\"\n\b\u0000\u0010&\u0018\u0001*\u00020\u0002*\u00020\u0002H\u0086\b\u00a2\u0006\u0002\u0010>\u001a)\u0010O\u001a\u0004\u0018\u0001H&\"\b\b\u0000\u0010&*\u00020\u0002*\u00020\u00022\f\u0010P\u001a\b\u0012\u0004\u0012\u0002H&0Q\u00a2\u0006\u0002\u0010R\u001a\u0017\u0010S\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010T\u001a\u00020\u0002H\u0086\u0010\u001a(\u0010U\u001a\u0004\u0018\u0001H&\"\n\b\u0000\u0010&\u0018\u0001*\u00020\u0002*\u00020\u00022\u0006\u0010V\u001a\u00020%H\u0086\b\u00a2\u0006\u0002\u0010W\u001aG\u0010X\u001a\u0004\u0018\u0001H&\"\n\b\u0000\u0010&\u0018\u0001*\u00020\u0002*\u00020\u00022\b\b\u0002\u0010V\u001a\u00020%2\u001b\b\b\u0010E\u001a\u0015\u0012\u0004\u0012\u0002H&\u0012\u0006\u0012\u0004\u0018\u00010\u00020(\u00a2\u0006\u0002\bFH\u0086\b\u00a2\u0006\u0002\u0010Y\u001aM\u0010Z\u001a\u0004\u0018\u0001H&\"\n\b\u0000\u0010&\u0018\u0001*\u00020\u0002*\u00020\u00022\b\b\u0002\u0010V\u001a\u00020%2!\b\b\u0010I\u001a\u001b\u0012\u0004\u0012\u0002H&\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020J0(\u00a2\u0006\u0002\bFH\u0086\b\u00a2\u0006\u0002\u0010Y\u001aY\u0010[\u001a\u0004\u0018\u0001H&\"\b\b\u0000\u0010&*\u00020\u0002*\u00020\u00022\b\b\u0002\u0010V\u001a\u00020%2\u001e\u0010\\\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H&0Q0@\"\b\u0012\u0004\u0012\u0002H&0Q2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u0002H&\u0012\u0004\u0012\u00020%0(\u00a2\u0006\u0002\u0010]\u001a\u0016\u0010^\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\b\b\u0002\u0010M\u001a\u00020%\u001a\u0012\u0010_\u001a\u00020\u0006*\u00020\u00022\u0006\u0010`\u001a\u00020\u0002\u001a \u0010a\u001a\u0004\u0018\u0001H&\"\n\b\u0000\u0010&\u0018\u0001*\u00020\u0002*\u00020\u0002H\u0086\b\u00a2\u0006\u0002\u0010>\u001a\n\u0010b\u001a\u00020C*\u00020\u0001\u001a\n\u0010c\u001a\u00020C*\u00020\u0002\u001a \u0010d\u001a\u0004\u0018\u0001H&\"\n\b\u0000\u0010&\u0018\u0001*\u00020\u0002*\u00020\u0002H\u0086\b\u00a2\u0006\u0002\u0010>\u001a\n\u0010e\u001a\u00020%*\u00020f\u001a\n\u0010e\u001a\u00020%*\u00020g\u001a\n\u0010h\u001a\u00020%*\u00020f\u001a\n\u0010h\u001a\u00020%*\u00020g\u001a\u001e\u0010i\u001a\u00020%*\u0004\u0018\u00010\u00022\u0006\u0010+\u001a\u00020\u00022\b\b\u0002\u0010V\u001a\u00020%\u001a\u0018\u0010j\u001a\u00020%*\u00020\u00022\f\u0010k\u001a\b\u0012\u0004\u0012\u00020\u00020J\u001a \u0010l\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0012\u0010m\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020%0(\u001a\u0016\u0010l\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\b\b\u0002\u0010n\u001a\u00020%\u001a \u0010o\u001a\u0004\u0018\u0001H&\"\n\b\u0000\u0010&\u0018\u0001*\u00020\u0002*\u0002H&H\u0086\b\u00a2\u0006\u0002\u0010>\u001a \u0010p\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0012\u0010m\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020%0(\u001a\u0016\u0010p\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\b\b\u0002\u0010n\u001a\u00020%\u001a \u0010q\u001a\u0004\u0018\u0001H&\"\n\b\u0000\u0010&\u0018\u0001*\u00020\u0002*\u0002H&H\u0086\b\u00a2\u0006\u0002\u0010>\u001a$\u0010r\u001a\b\u0012\u0004\u0012\u00020\u00020\n*\u00020\u00022\b\b\u0002\u0010s\u001a\u00020%2\b\b\u0002\u0010M\u001a\u00020%\u001a\n\u0010t\u001a\u00020\u0001*\u00020\u0001\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u001b\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u001b\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\"\u001b\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\f\"\u001b\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\f\"\u0015\u0010\u0013\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\b\"\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\"\u0015\u0010\u0019\u001a\u00020\u0016*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006u"}, d2={"allChildren", "Lorg/jetbrains/kotlin/psi/psiUtil/PsiChildRange;", "Lcom/intellij/psi/PsiElement;", "getAllChildren", "(Lcom/intellij/psi/PsiElement;)Lorg/jetbrains/kotlin/psi/psiUtil/PsiChildRange;", "endOffset", "", "getEndOffset", "(Lcom/intellij/psi/PsiElement;)I", "nextLeafs", "Lkotlin/sequences/Sequence;", "getNextLeafs", "(Lcom/intellij/psi/PsiElement;)Lkotlin/sequences/Sequence;", "parents", "getParents", "parentsWithSelf", "getParentsWithSelf", "prevLeafs", "getPrevLeafs", "startOffset", "getStartOffset", "textRange", "Lcom/intellij/openapi/util/TextRange;", "getTextRange", "(Lorg/jetbrains/kotlin/psi/psiUtil/PsiChildRange;)Lcom/intellij/openapi/util/TextRange;", "textRangeWithoutComments", "getTextRangeWithoutComments", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/openapi/util/TextRange;", "findFirstLeafWhollyInRange", "file", "Lcom/intellij/psi/PsiFile;", "range", "replaceFileAnnotationList", "Lorg/jetbrains/kotlin/psi/KtFileAnnotationList;", "Lorg/jetbrains/kotlin/psi/KtFile;", "annotationList", "anyDescendantOfType", "", "T", "predicate", "Lkotlin/Function1;", "canGoInside", "before", "element", "collectDescendantsOfType", "", "contains", "Lcom/intellij/psi/search/SearchScope;", "containsInside", "offset", "createSmartPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "E", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/SmartPsiElementPointer;", "elementsInRange", "findDescendantOfType", "(Lcom/intellij/psi/PsiElement;Lkotlin/jvm/functions/Function1;)Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Lcom/intellij/psi/PsiElement;", "forEachDescendantOfType", "", "action", "getChildOfType", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "getChildrenOfType", "", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiElement;", "getElementTextWithContext", "", "getIfChildIsInBranch", "branch", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Lkotlin/jvm/functions/Function1;)Lcom/intellij/psi/PsiElement;", "getIfChildIsInBranches", "branches", "", "getLastParentOfTypeInRow", "getNextSiblingIgnoringWhitespace", "withItself", "getNextSiblingIgnoringWhitespaceAndComments", "getNonStrictParentOfType", "parentClass", "Ljava/lang/Class;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/Class;)Lcom/intellij/psi/PsiElement;", "getOutermostParentContainedIn", "container", "getParentOfType", "strict", "(Lcom/intellij/psi/PsiElement;Z)Lcom/intellij/psi/PsiElement;", "getParentOfTypeAndBranch", "(Lcom/intellij/psi/PsiElement;ZLkotlin/jvm/functions/Function1;)Lcom/intellij/psi/PsiElement;", "getParentOfTypeAndBranches", "getParentOfTypesAndPredicate", "parentClasses", "(Lcom/intellij/psi/PsiElement;Z[Ljava/lang/Class;Lkotlin/jvm/functions/Function1;)Lcom/intellij/psi/PsiElement;", "getPrevSiblingIgnoringWhitespaceAndComments", "getStartOffsetIn", "ancestor", "getStrictParentOfType", "getText", "getTextWithLocation", "getTopmostParentOfType", "hasActualModifier", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "hasExpectModifier", "isAncestor", "isInsideOf", "elements", "nextLeaf", "filter", "skipEmptyElements", "nextSiblingOfSameType", "prevLeaf", "prevSiblingOfSameType", "siblings", "forward", "trimWhiteSpaces", "frontend"})
public final class PsiUtilsKt {
    @NotNull
    public static final PsiChildRange getAllChildren(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PsiElement first = $receiver.getFirstChild();
        return first != null ? new PsiChildRange(first, $receiver.getLastChild()) : PsiChildRange.Companion.getEMPTY();
    }

    @NotNull
    public static final Sequence<PsiElement> siblings(@NotNull PsiElement $receiver, boolean forward, boolean withItself) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return (Sequence)new Sequence<PsiElement>($receiver, forward, withItself){
            final /* synthetic */ PsiElement receiver$0;
            final /* synthetic */ boolean $forward;
            final /* synthetic */ boolean $withItself;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public Iterator<PsiElement> iterator() {
                void next;
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                objectRef.element = this.receiver$0;
                return new Iterator<PsiElement>(this, (Ref.ObjectRef)next){
                    final /* synthetic */ siblings.1 this$0;
                    final /* synthetic */ Ref.ObjectRef $next;

                    public boolean hasNext() {
                        return (PsiElement)this.$next.element != null;
                    }

                    @NotNull
                    public PsiElement next() {
                        PsiElement psiElement = (PsiElement)this.$next.element;
                        if (psiElement == null) {
                            throw (Throwable)new NoSuchElementException();
                        }
                        PsiElement result2 = psiElement;
                        this.$next.element = this.this$0.$forward ? result2.getNextSibling() : result2.getPrevSibling();
                        return result2;
                    }
                    {
                        this.this$0 = $outer;
                        this.$next = $captured_local_variable$1;
                        if (!this.this$0.$withItself) {
                            this.next();
                        }
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
            {
                this.receiver$0 = $receiver;
                this.$forward = $captured_local_variable$1;
                this.$withItself = $captured_local_variable$2;
            }
        };
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Sequence siblings$default(PsiElement psiElement, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return PsiUtilsKt.siblings(psiElement, bl, bl2);
    }

    @NotNull
    public static final Sequence<PsiElement> getParentsWithSelf(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return SequencesKt.generateSequence((Object)$receiver, (Function1)parentsWithSelf.1.INSTANCE);
    }

    @NotNull
    public static final Sequence<PsiElement> getParents(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return SequencesKt.drop(PsiUtilsKt.getParentsWithSelf($receiver), (int)1);
    }

    @Nullable
    public static final PsiElement prevLeaf(@NotNull PsiElement $receiver, boolean skipEmptyElements) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return PsiTreeUtil.prevLeaf($receiver, skipEmptyElements);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ PsiElement prevLeaf$default(PsiElement psiElement, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return PsiUtilsKt.prevLeaf(psiElement, bl);
    }

    @Nullable
    public static final PsiElement nextLeaf(@NotNull PsiElement $receiver, boolean skipEmptyElements) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return PsiTreeUtil.nextLeaf($receiver, skipEmptyElements);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ PsiElement nextLeaf$default(PsiElement psiElement, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return PsiUtilsKt.nextLeaf(psiElement, bl);
    }

    @NotNull
    public static final Sequence<PsiElement> getPrevLeafs(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return SequencesKt.generateSequence((Function0)((Function0)new Function0<PsiElement>($receiver){
            final /* synthetic */ PsiElement receiver$0;

            @Nullable
            public final PsiElement invoke() {
                return PsiUtilsKt.prevLeaf$default(this.receiver$0, false, 1, null);
            }
            {
                this.receiver$0 = psiElement;
                super(0);
            }
        }), (Function1)prevLeafs.2.INSTANCE);
    }

    @NotNull
    public static final Sequence<PsiElement> getNextLeafs(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return SequencesKt.generateSequence((Function0)((Function0)new Function0<PsiElement>($receiver){
            final /* synthetic */ PsiElement receiver$0;

            @Nullable
            public final PsiElement invoke() {
                return PsiUtilsKt.nextLeaf$default(this.receiver$0, false, 1, null);
            }
            {
                this.receiver$0 = psiElement;
                super(0);
            }
        }), (Function1)nextLeafs.2.INSTANCE);
    }

    @Nullable
    public static final PsiElement prevLeaf(@NotNull PsiElement $receiver, @NotNull Function1<? super PsiElement, Boolean> filter2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(filter2, (String)"filter");
        PsiElement leaf = PsiUtilsKt.prevLeaf$default($receiver, false, 1, null);
        while (leaf != null && !((Boolean)filter2.invoke((Object)leaf)).booleanValue()) {
            leaf = PsiUtilsKt.prevLeaf$default(leaf, false, 1, null);
        }
        return leaf;
    }

    @Nullable
    public static final PsiElement nextLeaf(@NotNull PsiElement $receiver, @NotNull Function1<? super PsiElement, Boolean> filter2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(filter2, (String)"filter");
        PsiElement leaf = PsiUtilsKt.nextLeaf$default($receiver, false, 1, null);
        while (leaf != null && !((Boolean)filter2.invoke((Object)leaf)).booleanValue()) {
            leaf = PsiUtilsKt.nextLeaf$default(leaf, false, 1, null);
        }
        return leaf;
    }

    @Nullable
    public static final <T extends PsiElement> T getParentOfTypesAndPredicate(@NotNull PsiElement $receiver, boolean strict, @NotNull Class<T>[] parentClasses, @NotNull Function1<? super T, Boolean> predicate) {
        PsiElement element;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(parentClasses, (String)"parentClasses");
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        PsiElement psiElement = element = strict ? $receiver.getParent() : $receiver;
        while (element != null) {
            block10: {
                block9: {
                    boolean bl;
                    block8: {
                        Object[] objectArray = parentClasses;
                        if (objectArray.length == 0) break block9;
                        Object[] $receiver$iv = parentClasses;
                        for (int i = 0; i < $receiver$iv.length; ++i) {
                            Object element$iv = $receiver$iv[i];
                            Class parentClass = (Class)element$iv;
                            if (!parentClass.isInstance(element)) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                    if (!bl) break block10;
                }
                PsiElement psiElement2 = element;
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type T");
                }
                if (((Boolean)predicate.invoke((Object)psiElement2)).booleanValue()) {
                    return (T)element;
                }
            }
            if (element instanceof PsiFile) {
                return null;
            }
            element = element.getParent();
        }
        return null;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ PsiElement getParentOfTypesAndPredicate$default(PsiElement psiElement, boolean bl, Class[] classArray, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return PsiUtilsKt.getParentOfTypesAndPredicate(psiElement, bl, classArray, function1);
    }

    @Nullable
    public static final <T extends PsiElement> T getNonStrictParentOfType(@NotNull PsiElement $receiver, @NotNull Class<T> parentClass) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(parentClass, (String)"parentClass");
        return PsiTreeUtil.getParentOfType($receiver, parentClass, false);
    }

    @Nullable
    public static final PsiElement getNextSiblingIgnoringWhitespaceAndComments(@NotNull PsiElement $receiver, boolean withItself) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return (PsiElement)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)PsiUtilsKt.siblings$default($receiver, false, withItself, 1, null), (Function1)getNextSiblingIgnoringWhitespaceAndComments.1.INSTANCE));
    }

    @Nullable
    public static /* bridge */ /* synthetic */ PsiElement getNextSiblingIgnoringWhitespaceAndComments$default(PsiElement psiElement, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments(psiElement, bl);
    }

    @Nullable
    public static final PsiElement getNextSiblingIgnoringWhitespace(@NotNull PsiElement $receiver, boolean withItself) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return (PsiElement)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)PsiUtilsKt.siblings$default($receiver, false, withItself, 1, null), (Function1)getNextSiblingIgnoringWhitespace.1.INSTANCE));
    }

    @Nullable
    public static /* bridge */ /* synthetic */ PsiElement getNextSiblingIgnoringWhitespace$default(PsiElement psiElement, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return PsiUtilsKt.getNextSiblingIgnoringWhitespace(psiElement, bl);
    }

    @Nullable
    public static final PsiElement getPrevSiblingIgnoringWhitespaceAndComments(@NotNull PsiElement $receiver, boolean withItself) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        boolean bl = false;
        boolean bl2 = withItself;
        return (PsiElement)SequencesKt.firstOrNull((Sequence)SequencesKt.filter(PsiUtilsKt.siblings($receiver, bl, bl2), (Function1)getPrevSiblingIgnoringWhitespaceAndComments.1.INSTANCE));
    }

    @Nullable
    public static /* bridge */ /* synthetic */ PsiElement getPrevSiblingIgnoringWhitespaceAndComments$default(PsiElement psiElement, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments(psiElement, bl);
    }

    public static final boolean isAncestor(@Nullable PsiElement $receiver, @NotNull PsiElement element, boolean strict) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return PsiTreeUtil.isAncestor($receiver, element, strict);
    }

    public static /* bridge */ /* synthetic */ boolean isAncestor$default(PsiElement psiElement, PsiElement psiElement2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return PsiUtilsKt.isAncestor(psiElement, psiElement2, bl);
    }

    @Nullable
    public static final <T extends PsiElement> T getIfChildIsInBranch(@NotNull T $receiver, @NotNull PsiElement element, @NotNull Function1<? super T, ? extends PsiElement> branch) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull(branch, (String)"branch");
        return (T)(PsiUtilsKt.isAncestor$default((PsiElement)branch.invoke($receiver), element, false, 2, null) ? $receiver : null);
    }

    @Nullable
    public static final <T extends PsiElement> T getIfChildIsInBranches(@NotNull T $receiver, @NotNull PsiElement element, @NotNull Function1<? super T, ? extends Iterable<? extends PsiElement>> branches) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull(branches, (String)"branches");
            Iterable $receiver$iv = (Iterable)branches.invoke($receiver);
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    if (!PsiUtilsKt.isAncestor$default(it, element, false, 2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return (T)(bl ? $receiver : null);
    }

    @Nullable
    public static final PsiElement getOutermostParentContainedIn(@NotNull PsiElement $receiver, @NotNull PsiElement container2) {
        PsiElement psiElement;
        block1: {
            PsiElement parent2;
            do {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull((Object)container2, (String)"container");
                parent2 = $receiver.getParent();
                if (!Intrinsics.areEqual((Object)parent2, (Object)container2)) continue;
                psiElement = $receiver;
                break block1;
            } while (parent2 != null);
            psiElement = null;
        }
        return psiElement;
    }

    public static final boolean isInsideOf(@NotNull PsiElement $receiver, @NotNull Iterable<? extends PsiElement> elements) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            Iterable<? extends PsiElement> $receiver$iv = elements;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (PsiElement psiElement : $receiver$iv) {
                    PsiElement it = psiElement;
                    if (!PsiUtilsKt.isAncestor$default(it, $receiver, false, 2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public static final PsiChildRange trimWhiteSpaces(@NotNull PsiChildRange $receiver) {
        Object v3;
        PsiElement psiElement;
        block5: {
            PsiElement psiElement2;
            PsiElement it;
            Sequence $receiver$iv;
            block4: {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                if ($receiver.getFirst() == null) {
                    return $receiver;
                }
                $receiver$iv = PsiUtilsKt.siblings$default($receiver.getFirst(), false, false, 3, null);
                for (Object element$iv : $receiver$iv) {
                    it = (PsiElement)element$iv;
                    if (!(!(it instanceof PsiWhiteSpace))) continue;
                    psiElement2 = (PsiElement)element$iv;
                    break block4;
                }
                psiElement2 = null;
            }
            psiElement = psiElement2;
            PsiElement psiElement3 = psiElement;
            PsiElement psiElement4 = $receiver.getLast();
            if (psiElement4 == null) {
                Intrinsics.throwNpe();
            }
            $receiver$iv = PsiUtilsKt.siblings$default(psiElement4, false, false, 2, null);
            psiElement = psiElement3;
            for (Object element$iv : $receiver$iv) {
                it = (PsiElement)element$iv;
                if (!(!(it instanceof PsiWhiteSpace))) continue;
                v3 = element$iv;
                break block5;
            }
            v3 = null;
        }
        Object var10_6 = v3;
        PsiElement psiElement5 = var10_6;
        PsiElement psiElement6 = psiElement;
        return new PsiChildRange(psiElement6, psiElement5);
    }

    public static final int getStartOffset(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getTextRange().getStartOffset();
    }

    public static final int getEndOffset(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getTextRange().getEndOffset();
    }

    public static final int getStartOffsetIn(@NotNull PsiElement $receiver, @NotNull PsiElement ancestor) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)ancestor, (String)"ancestor");
        int offset2 = 0;
        PsiElement parent2 = $receiver;
        while (Intrinsics.areEqual((Object)parent2, (Object)ancestor) ^ true) {
            offset2 += parent2.getStartOffsetInParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)parent2.getParent(), (String)"parent.parent");
        }
        return offset2;
    }

    public static final boolean containsInside(@NotNull TextRange $receiver, int offset2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getStartOffset() < offset2 && offset2 < $receiver.getEndOffset();
    }

    @Nullable
    public static final TextRange getTextRange(@NotNull PsiChildRange $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver.isEmpty()) {
            return null;
        }
        PsiElement psiElement = $receiver.getFirst();
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        int n = PsiUtilsKt.getStartOffset(psiElement);
        PsiElement psiElement2 = $receiver.getLast();
        if (psiElement2 == null) {
            Intrinsics.throwNpe();
        }
        return new TextRange(n, PsiUtilsKt.getEndOffset(psiElement2));
    }

    @NotNull
    public static final String getText(@NotNull PsiChildRange $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver.isEmpty()) {
            return "";
        }
        return SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)$receiver, (Function1)getText.1.INSTANCE), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PsiElement> elementsInRange(@NotNull PsiFile $receiver, @NotNull TextRange range) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        int offset2 = range.getStartOffset();
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        while (offset2 < range.getEndOffset()) {
            Object element$iv2;
            block3: {
                void $receiver$iv;
                PsiElement leaf;
                TextRange currentRange = new TextRange(offset2, range.getEndOffset());
                if (PsiUtilsKt.findFirstLeafWhollyInRange($receiver, currentRange) == null) {
                    break;
                }
                Sequence<PsiElement> sequence2 = PsiUtilsKt.getParentsWithSelf(leaf);
                for (Object element$iv2 : $receiver$iv) {
                    PsiElement it = (PsiElement)element$iv2;
                    PsiElement parent2 = it.getParent();
                    boolean bl = it instanceof PsiFile || !currentRange.contains(parent2.getTextRange());
                    if (!bl) continue;
                    break block3;
                }
                throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            PsiElement element = (PsiElement)element$iv2;
            result2.add(element);
            offset2 = PsiUtilsKt.getEndOffset(element);
        }
        return result2;
    }

    private static final PsiElement findFirstLeafWhollyInRange(PsiFile file, TextRange range) {
        boolean bl;
        PsiElement psiElement = file.findElementAt(range.getStartOffset());
        if (psiElement == null) {
            return null;
        }
        PsiElement element = psiElement;
        TextRange elementRange = element.getTextRange();
        if (elementRange.getStartOffset() < range.getStartOffset()) {
            PsiElement psiElement2 = PsiUtilsKt.nextLeaf(element, true);
            if (psiElement2 == null) {
                return null;
            }
            element = psiElement2;
            elementRange = element.getTextRange();
        }
        boolean bl2 = bl = elementRange.getStartOffset() >= range.getStartOffset();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return elementRange.getEndOffset() <= range.getEndOffset() ? element : null;
    }

    @NotNull
    public static final TextRange getTextRangeWithoutComments(@NotNull PsiElement $receiver) {
        Object object;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Object[] $receiver$iv = $receiver.getChildren();
            for (int i = 0; i < $receiver$iv.length; ++i) {
                Object element$iv = $receiver$iv[i];
                PsiElement it = (PsiElement)element$iv;
                if (!(!(it instanceof PsiWhiteSpace) && !(it instanceof PsiComment))) continue;
                object = element$iv;
                break block2;
            }
            object = null;
        }
        PsiElement psiElement = (PsiElement)object;
        if (psiElement == null) {
            TextRange textRange = $receiver.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"textRange");
            return textRange;
        }
        PsiElement firstNonCommentChild = psiElement;
        return new TextRange(PsiUtilsKt.getStartOffset(firstNonCommentChild), PsiUtilsKt.getEndOffset($receiver));
    }

    @NotNull
    public static final String getElementTextWithContext(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (!$receiver.isValid()) {
            return "<invalid element " + $receiver + '>';
        }
        if ($receiver instanceof PsiFile) {
            String string = ((PsiFile)$receiver).getContainingFile().getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"containingFile.text");
            return string;
        }
        PsiElement psiElement = PsiTreeUtil.findFirstParent($receiver, getElementTextWithContext.topLevelElement.1.INSTANCE);
        if (psiElement == null) {
            throw (Throwable)((Object)new AssertionError((Object)"For non-file element we should always be able to find parent in file children"));
        }
        PsiElement topLevelElement2 = psiElement;
        int startContextOffset = PsiUtilsKt.getStartOffset(topLevelElement2);
        int elementContextOffset = $receiver.getTextRange().getStartOffset();
        int inFileParentOffset = elementContextOffset - startContextOffset;
        boolean isInjected = $receiver.getContainingFile() instanceof VirtualFileWindow;
        String string = new StringBuilder(topLevelElement2.getText()).insert(inFileParentOffset, "<caret>").insert(0, "File name: " + $receiver.getContainingFile().getName() + " Physical: " + $receiver.getContainingFile().isPhysical() + " Injected: " + isInjected + '\n').toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder(topLevelEl\u2026)\n            .toString()");
        return string;
    }

    @NotNull
    public static final String getTextWithLocation(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return '\'' + $receiver.getText() + "' at " + DiagnosticUtils.atLocation($receiver);
    }

    @NotNull
    public static final KtFileAnnotationList replaceFileAnnotationList(@NotNull KtFile file, @NotNull KtFileAnnotationList annotationList) {
        PsiElement beforeAnchor;
        PsiElement psiElement;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)annotationList, (String)"annotationList");
        if (file.getFileAnnotationList() != null) {
            KtFileAnnotationList ktFileAnnotationList = file.getFileAnnotationList();
            if (ktFileAnnotationList == null) {
                Intrinsics.throwNpe();
            }
            PsiElement psiElement2 = ktFileAnnotationList.replace(annotationList);
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFileAnnotationList");
            }
            return (KtFileAnnotationList)psiElement2;
        }
        KtPackageDirective ktPackageDirective = file.getPackageDirective();
        if ((ktPackageDirective != null ? ktPackageDirective.getPackageKeyword() : null) != null) {
            KtPackageDirective ktPackageDirective2 = file.getPackageDirective();
            if (ktPackageDirective2 == null) {
                Intrinsics.throwNpe();
            }
            psiElement = ktPackageDirective2;
        } else if (file.getImportList() != null) {
            KtImportList ktImportList = file.getImportList();
            if (ktImportList == null) {
                Intrinsics.throwNpe();
            }
            psiElement = ktImportList;
        } else {
            psiElement = beforeAnchor = CollectionsKt.firstOrNull(file.getDeclarations()) != null ? (PsiElement)CollectionsKt.first(file.getDeclarations()) : null;
        }
        if (beforeAnchor != null) {
            PsiElement psiElement3 = file.addBefore(annotationList, beforeAnchor);
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFileAnnotationList");
            }
            return (KtFileAnnotationList)psiElement3;
        }
        if (file.getLastChild() == null) {
            PsiElement psiElement4 = file.add(annotationList);
            if (psiElement4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFileAnnotationList");
            }
            return (KtFileAnnotationList)psiElement4;
        }
        PsiElement psiElement5 = file.addAfter(annotationList, file.getLastChild());
        if (psiElement5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFileAnnotationList");
        }
        return (KtFileAnnotationList)psiElement5;
    }

    public static final boolean contains(@NotNull SearchScope $receiver, @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return PsiSearchScopeUtil.isInScope($receiver, element);
    }

    @NotNull
    public static final <E extends PsiElement> SmartPsiElementPointer<E> createSmartPointer(@NotNull E $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        SmartPsiElementPointer<E> smartPsiElementPointer = SmartPointerManager.getInstance($receiver.getProject()).createSmartPsiElementPointer($receiver);
        Intrinsics.checkExpressionValueIsNotNull(smartPsiElementPointer, (String)"SmartPointerManager.getI\u2026rtPsiElementPointer(this)");
        return smartPsiElementPointer;
    }

    public static final boolean before(@NotNull PsiElement $receiver, @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return $receiver.getTextRange().getEndOffset() <= element.getTextRange().getStartOffset();
    }

    public static final boolean hasExpectModifier(@NotNull KtModifierListOwner $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.hasModifier(KtTokens.HEADER_KEYWORD) || $receiver.hasModifier(KtTokens.EXPECT_KEYWORD);
    }

    public static final boolean hasExpectModifier(@NotNull KtModifierList $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.hasModifier(KtTokens.HEADER_KEYWORD) || $receiver.hasModifier(KtTokens.EXPECT_KEYWORD);
    }

    public static final boolean hasActualModifier(@NotNull KtModifierListOwner $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.hasModifier(KtTokens.IMPL_KEYWORD) || $receiver.hasModifier(KtTokens.ACTUAL_KEYWORD);
    }

    public static final boolean hasActualModifier(@NotNull KtModifierList $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.hasModifier(KtTokens.IMPL_KEYWORD) || $receiver.hasModifier(KtTokens.ACTUAL_KEYWORD);
    }
}

