/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.load.java.structure.reflect.ReflectClassUtilKt;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.reflect.ReflectAnnotationSource;
import org.jetbrains.kotlin.load.kotlin.reflect.ReflectKotlinClassKt;
import org.jetbrains.kotlin.load.kotlin.reflect.SignatureSerializer;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001c\u0010\t\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\f\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\r\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0001H\u0002J$\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J\u001a\u0010\u0018\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/reflect/ReflectClassStructure;", "", "()V", "loadClassAnnotations", "", "klass", "Ljava/lang/Class;", "visitor", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass$AnnotationVisitor;", "loadConstructorAnnotations", "memberVisitor", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass$MemberVisitor;", "loadFieldAnnotations", "loadMethodAnnotations", "processAnnotation", "annotation", "", "processAnnotationArgumentValue", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass$AnnotationArgumentVisitor;", "name", "Lorg/jetbrains/kotlin/name/Name;", "value", "processAnnotationArguments", "annotationType", "visitMembers", "core"})
final class ReflectClassStructure {
    public static final ReflectClassStructure INSTANCE;

    public final void loadClassAnnotations(@NotNull Class<?> klass2, @NotNull KotlinJvmBinaryClass.AnnotationVisitor visitor2) {
        Intrinsics.checkParameterIsNotNull(klass2, (String)"klass");
        Intrinsics.checkParameterIsNotNull((Object)visitor2, (String)"visitor");
        Annotation[] annotationArray = klass2.getDeclaredAnnotations();
        for (int i = 0; i < annotationArray.length; ++i) {
            Annotation annotation2;
            Annotation annotation3 = annotation2 = annotationArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)annotation3, (String)"annotation");
            this.processAnnotation(visitor2, annotation3);
        }
        visitor2.visitEnd();
    }

    public final void visitMembers(@NotNull Class<?> klass2, @NotNull KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Intrinsics.checkParameterIsNotNull(klass2, (String)"klass");
        Intrinsics.checkParameterIsNotNull((Object)memberVisitor, (String)"memberVisitor");
        this.loadMethodAnnotations(klass2, memberVisitor);
        this.loadConstructorAnnotations(klass2, memberVisitor);
        this.loadFieldAnnotations(klass2, memberVisitor);
    }

    private final void loadMethodAnnotations(Class<?> klass2, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Method[] methodArray = klass2.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            KotlinJvmBinaryClass.MethodAnnotationVisitor visitor2;
            Method method = methodArray[i];
            Name name = Name.identifier(method.getName());
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.identifier(method.name)");
            Method method2 = method;
            Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"method");
            if (memberVisitor.visitMethod(name, SignatureSerializer.INSTANCE.methodDesc(method2)) == null) {
                continue;
            }
            Annotation[] annotationArray = method.getDeclaredAnnotations();
            for (int j = 0; j < annotationArray.length; ++j) {
                Annotation annotation2 = annotationArray[j];
                KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor = visitor2;
                Annotation annotation3 = annotation2;
                Intrinsics.checkExpressionValueIsNotNull((Object)annotation3, (String)"annotation");
                this.processAnnotation(annotationVisitor, annotation3);
            }
            for (IndexedValue indexedValue : ArraysKt.withIndex((Object[])((Object[])method.getParameterAnnotations()))) {
                int parameterIndex = indexedValue.component1();
                Annotation[] annotations2 = (Annotation[])indexedValue.component2();
                for (int j = 0; j < annotations2.length; ++j) {
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor;
                    Annotation annotation4 = annotations2[j];
                    Class annotationType = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation4));
                    ClassId classId = ReflectClassUtilKt.getClassId(annotationType);
                    Annotation annotation5 = annotation4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)annotation5, (String)"annotation");
                    if (visitor2.visitParameterAnnotation(parameterIndex, classId, new ReflectAnnotationSource(annotation5)) == null) continue;
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor it = annotationArgumentVisitor;
                    INSTANCE.processAnnotationArguments(it, annotation4, annotationType);
                }
            }
            visitor2.visitEnd();
        }
    }

    private final void loadConstructorAnnotations(Class<?> klass2, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Constructor<?>[] constructorArray = klass2.getDeclaredConstructors();
        for (int i = 0; i < constructorArray.length; ++i) {
            KotlinJvmBinaryClass.MethodAnnotationVisitor visitor2;
            Constructor<?> constructor = constructorArray[i];
            Name name = Name.special("<init>");
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.special(\"<init>\")");
            Constructor<?> constructor2 = constructor;
            Intrinsics.checkExpressionValueIsNotNull(constructor2, (String)"constructor");
            if (memberVisitor.visitMethod(name, SignatureSerializer.INSTANCE.constructorDesc(constructor2)) == null) {
                continue;
            }
            Object[] objectArray3 = constructor.getDeclaredAnnotations();
            for (int j = 0; j < objectArray3.length; ++j) {
                Annotation annotation2 = objectArray3[j];
                KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor = visitor2;
                Annotation annotation3 = annotation2;
                Intrinsics.checkExpressionValueIsNotNull((Object)annotation3, (String)"annotation");
                this.processAnnotation(annotationVisitor, annotation3);
            }
            Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
            Object[] objectArray2 = (Object[])parameterAnnotations;
            objectArray3 = objectArray2;
            if (!(objectArray3.length == 0)) {
                int shift = ((Object[])constructor.getParameterTypes()).length - ((Object[])parameterAnnotations).length;
                for (Object[] objectArray3 : ArraysKt.withIndex((Object[])((Object[])parameterAnnotations))) {
                    int parameterIndex = objectArray3.component1();
                    Annotation[] annotations2 = (Annotation[])objectArray3.component2();
                    for (int j = 0; j < annotations2.length; ++j) {
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor;
                        Annotation annotation4 = annotations2[j];
                        Class annotationType = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation4));
                        ClassId classId = ReflectClassUtilKt.getClassId(annotationType);
                        Annotation annotation5 = annotation4;
                        Intrinsics.checkExpressionValueIsNotNull((Object)annotation5, (String)"annotation");
                        if (visitor2.visitParameterAnnotation(parameterIndex + shift, classId, new ReflectAnnotationSource(annotation5)) == null) continue;
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor it = annotationArgumentVisitor;
                        INSTANCE.processAnnotationArguments(it, annotation4, annotationType);
                    }
                }
            }
            visitor2.visitEnd();
        }
    }

    private final void loadFieldAnnotations(Class<?> klass2, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Field[] fieldArray = klass2.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            KotlinJvmBinaryClass.AnnotationVisitor visitor2;
            Field field = fieldArray[i];
            Name name = Name.identifier(field.getName());
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.identifier(field.name)");
            Field field2 = field;
            Intrinsics.checkExpressionValueIsNotNull((Object)field2, (String)"field");
            if (memberVisitor.visitField(name, SignatureSerializer.INSTANCE.fieldDesc(field2), null) == null) {
                continue;
            }
            Annotation[] annotationArray = field.getDeclaredAnnotations();
            for (int j = 0; j < annotationArray.length; ++j) {
                Annotation annotation2;
                Annotation annotation3 = annotation2 = annotationArray[j];
                Intrinsics.checkExpressionValueIsNotNull((Object)annotation3, (String)"annotation");
                this.processAnnotation(visitor2, annotation3);
            }
            visitor2.visitEnd();
        }
    }

    private final void processAnnotation(KotlinJvmBinaryClass.AnnotationVisitor visitor2, Annotation annotation2) {
        block0: {
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor;
            Class annotationType = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation2));
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor2 = visitor2.visitAnnotation(ReflectClassUtilKt.getClassId(annotationType), new ReflectAnnotationSource(annotation2));
            if (annotationArgumentVisitor2 == null) break block0;
            KotlinJvmBinaryClass.AnnotationArgumentVisitor it = annotationArgumentVisitor = annotationArgumentVisitor2;
            INSTANCE.processAnnotationArguments(it, annotation2, annotationType);
        }
    }

    private final void processAnnotationArguments(KotlinJvmBinaryClass.AnnotationArgumentVisitor visitor2, Annotation annotation2, Class<?> annotationType) {
        Method[] methodArray = annotationType.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Object object;
            Method method;
            block3: {
                method = methodArray[i];
                try {
                    if (method.invoke((Object)annotation2, new Object[0]) != null) break block3;
                    Intrinsics.throwNpe();
                }
                catch (IllegalAccessException e) {
                    continue;
                }
            }
            Object value = object;
            Name name = Name.identifier(method.getName());
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.identifier(method.name)");
            this.processAnnotationArgumentValue(visitor2, name, value);
        }
        visitor2.visitEnd();
    }

    private final void processAnnotationArgumentValue(KotlinJvmBinaryClass.AnnotationArgumentVisitor visitor2, Name name, Object value) {
        Class<?> clazz = value.getClass();
        if (ReflectKotlinClassKt.access$getTYPES_ELIGIBLE_FOR_SIMPLE_VISIT$p().contains(clazz)) {
            visitor2.visit(name, value);
        } else if (ReflectClassUtilKt.isEnumClassOrSpecializedEnumEntryClass(clazz)) {
            ClassId classId = ReflectClassUtilKt.getClassId(clazz.isEnum() ? clazz : clazz.getEnclosingClass());
            Object object = value;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Enum<*>");
            }
            Name name2 = Name.identifier(((Enum)object).name());
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier((value as Enum<*>).name)");
            visitor2.visitEnum(name, classId, name2);
        } else if (Annotation.class.isAssignableFrom(clazz)) {
            Class annotationClass = (Class)ArraysKt.single((Object[])clazz.getInterfaces());
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = visitor2.visitAnnotation(name, ReflectClassUtilKt.getClassId(annotationClass));
            if (annotationArgumentVisitor == null) {
                return;
            }
            KotlinJvmBinaryClass.AnnotationArgumentVisitor v = annotationArgumentVisitor;
            Object object = value;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Annotation");
            }
            Annotation annotation2 = (Annotation)object;
            Class clazz2 = annotationClass;
            Intrinsics.checkExpressionValueIsNotNull((Object)clazz2, (String)"annotationClass");
            this.processAnnotationArguments(v, annotation2, clazz2);
        } else if (clazz.isArray()) {
            KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor annotationArrayArgumentVisitor = visitor2.visitArray(name);
            if (annotationArrayArgumentVisitor == null) {
                return;
            }
            KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor v = annotationArrayArgumentVisitor;
            Class<?> componentType = clazz.getComponentType();
            if (componentType.isEnum()) {
                ClassId enumClassId = ReflectClassUtilKt.getClassId(componentType);
                Object object = value;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<*>");
                }
                Object[] objectArray = (Object[])object;
                for (int i = 0; i < objectArray.length; ++i) {
                    Object element;
                    Object object2 = element = objectArray[i];
                    if (object2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Enum<*>");
                    }
                    Name name3 = Name.identifier(((Enum)object2).name());
                    Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"Name.identifier((element as Enum<*>).name)");
                    v.visitEnum(enumClassId, name3);
                }
            } else {
                Object object = value;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<*>");
                }
                Object[] objectArray = (Object[])object;
                for (int i = 0; i < objectArray.length; ++i) {
                    Object element = objectArray[i];
                    v.visit(element);
                }
            }
            v.visitEnd();
        } else {
            throw (Throwable)new UnsupportedOperationException("Unsupported annotation argument value (" + clazz + "): " + value);
        }
    }

    private ReflectClassStructure() {
        INSTANCE = this;
    }

    static {
        new ReflectClassStructure();
    }
}

