/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.util.Getter;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubTree;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.Reference;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FileTrees {
    private final Reference<StubTree> myStub;
    private final Getter<FileElement> myTreeElementPointer;
    final boolean astLoaded;
    final boolean useStrongRefs;

    private FileTrees(@Nullable Reference<StubTree> stub, @Nullable Getter<FileElement> ast, boolean astLoaded, boolean useStrongRefs) {
        this.myStub = stub;
        this.myTreeElementPointer = ast;
        this.astLoaded = astLoaded;
        this.useStrongRefs = useStrongRefs;
    }

    @Nullable
    StubTree derefStub() {
        return SoftReference.dereference(this.myStub);
    }

    @Nullable
    FileElement derefTreeElement() {
        return SoftReference.deref(this.myTreeElementPointer);
    }

    FileTrees switchToStrongRefs() {
        return new FileTrees(this.myStub, this.myTreeElementPointer, this.astLoaded, true);
    }

    FileTrees clearStub(@NotNull String reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/source/FileTrees", "clearStub"));
        }
        StubTree stubHolder = this.derefStub();
        if (stubHolder != null) {
            ((PsiFileStubImpl)stubHolder.getRoot()).clearPsi(reason);
        }
        return new FileTrees(null, this.myTreeElementPointer, this.astLoaded, this.useStrongRefs);
    }

    FileTrees withAst(@NotNull Getter<FileElement> ast) {
        if (ast == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ast", "com/intellij/psi/impl/source/FileTrees", "withAst"));
        }
        return new FileTrees(this.myStub, ast, true, this.useStrongRefs);
    }

    FileTrees withExclusiveStub(@NotNull StubTree stub, Set<PsiFileImpl> allRoots) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/source/FileTrees", "withExclusiveStub"));
        }
        if (this.derefTreeElement() != null || this.useStrongRefs) {
            throw new RuntimeException(this.toString() + "; roots=" + allRoots + "; root trees=" + ContainerUtil.map(allRoots, PsiFileImpl::getFileTrees));
        }
        return new FileTrees(new SoftReference<StubTree>(stub), null, false, false);
    }

    FileTrees withGreenStub(@NotNull StubTree stub, @NotNull PsiFileImpl file) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/source/FileTrees", "withGreenStub"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/FileTrees", "withGreenStub"));
        }
        if (this.derefTreeElement() == null || !this.astLoaded) {
            throw new RuntimeException("No AST in file " + file + " of " + file.getClass() + "; " + this);
        }
        return new FileTrees(new SoftReference<StubTree>(stub), this.myTreeElementPointer, true, this.useStrongRefs);
    }

    static FileTrees noStub(@Nullable FileElement ast, @NotNull PsiFileImpl file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/FileTrees", "noStub"));
        }
        return new FileTrees(null, ast, ast != null, file instanceof DummyHolder);
    }

    public String toString() {
        return "FileTrees{stub=" + (this.myStub == null ? "noRef" : this.derefStub()) + ", AST=" + (this.myTreeElementPointer == null ? "noRef" : this.derefTreeElement()) + ", astLoaded=" + this.astLoaded + ", useStrongRefs=" + this.useStrongRefs + '}';
    }
}

