/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.ClassFileUtilsKt;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.MultifileClassCodegen;
import org.jetbrains.kotlin.codegen.PackageCodegen;
import org.jetbrains.kotlin.codegen.PackagePartRegistry;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.load.kotlin.ModuleMapping;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.load.kotlin.PackageParts;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationConfiguration;
import org.jetbrains.kotlin.serialization.jvm.JvmPackageTable;
import org.jetbrains.org.objectweb.asm.Type;

public class ClassFileFactory
implements OutputFileCollection {
    private final GenerationState state;
    private final ClassBuilderFactory builderFactory;
    private final Map<String, OutAndSourceFileList> generators = new LinkedHashMap<String, OutAndSourceFileList>();
    private boolean isDone = false;
    private final Set<File> packagePartSourceFiles = new HashSet<File>();
    private final Map<String, PackageParts> partsGroupedByPackage = new LinkedHashMap<String, PackageParts>();

    public ClassFileFactory(@NotNull GenerationState state2, @NotNull ClassBuilderFactory builderFactory) {
        this.state = state2;
        this.builderFactory = builderFactory;
    }

    public GenerationState getGenerationState() {
        return this.state;
    }

    @NotNull
    public ClassBuilder newVisitor(@NotNull JvmDeclarationOrigin origin, @NotNull Type asmType, @NotNull PsiFile sourceFile) {
        return this.newVisitor(origin, asmType, Collections.singletonList(sourceFile));
    }

    @NotNull
    public ClassBuilder newVisitor(@NotNull JvmDeclarationOrigin origin, @NotNull Type asmType, @NotNull Collection<? extends PsiFile> sourceFiles2) {
        ClassBuilder answer = this.builderFactory.newClassBuilder(origin);
        this.generators.put(asmType.getInternalName() + ".class", new ClassBuilderAndSourceFileList(answer, ClassFileFactory.toIoFilesIgnoringNonPhysical(sourceFiles2)));
        return answer;
    }

    public void done() {
        if (!this.isDone) {
            this.isDone = true;
            this.writeModuleMappings();
        }
    }

    public void releaseGeneratedOutput() {
        this.generators.clear();
    }

    private void writeModuleMappings() {
        final JvmPackageTable.PackageTable.Builder builder = JvmPackageTable.PackageTable.newBuilder();
        String outputFilePath = JvmCodegenUtil.getMappingFileName(this.state.getModuleName());
        for (PackageParts part : ClassFileUtilsKt.addCompiledPartsAndSort(this.partsGroupedByPackage.values(), this.state)) {
            part.addTo(builder);
        }
        if (builder.getPackagePartsCount() == 0) {
            return;
        }
        this.generators.put(outputFilePath, new OutAndSourceFileList(CollectionsKt.toList(this.packagePartSourceFiles)){

            @Override
            public byte[] asBytes(ClassBuilderFactory factory2) {
                return ClassFileUtilsKt.serializeToByteArray(builder);
            }

            @Override
            public String asText(ClassBuilderFactory factory2) {
                try {
                    return new String(this.asBytes(factory2), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    @NotNull
    public List<OutputFile> asList() {
        this.done();
        return this.getCurrentOutput();
    }

    @NotNull
    public List<OutputFile> getCurrentOutput() {
        return CollectionsKt.map(this.generators.keySet(), x$0 -> new OutputClassFile((String)x$0));
    }

    @Override
    @Nullable
    public OutputFile get(@NotNull String relativePath) {
        return this.generators.containsKey(relativePath) ? new OutputClassFile(relativePath) : null;
    }

    @NotNull
    public String createText() {
        StringBuilder answer = new StringBuilder();
        block8: for (OutputFile file : this.asList()) {
            File relativePath = new File(file.getRelativePath());
            answer.append("@").append(relativePath).append('\n');
            switch (FilesKt.getExtension((File)relativePath)) {
                case "class": {
                    answer.append(file.asText());
                    break;
                }
                case "kotlin_module": {
                    ModuleMapping mapping2 = ModuleMapping.Companion.create(file.asByteArray(), relativePath.getPath(), DeserializationConfiguration.Default.INSTANCE);
                    for (Map.Entry<String, PackageParts> entry : mapping2.getPackageFqName2Parts().entrySet()) {
                        FqName packageFqName = new FqName(entry.getKey());
                        PackageParts packageParts = entry.getValue();
                        answer.append("<package ").append(packageFqName).append(": ").append(packageParts.getParts()).append(">\n");
                    }
                    continue block8;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown OutputFile: " + file);
                }
            }
        }
        return answer.toString();
    }

    @NotNull
    public Map<String, String> createTextForEachFile() {
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        for (OutputFile file : this.asList()) {
            answer.put(file.getRelativePath(), file.asText());
        }
        return answer;
    }

    @NotNull
    public PackageCodegen forPackage(@NotNull FqName fqName2, @NotNull Collection<KtFile> files2) {
        assert (!this.isDone) : "Already done!";
        this.registerPackagePartSourceFiles(files2);
        return this.state.getCodegenFactory().createPackageCodegen(this.state, files2, fqName2, this.buildNewPackagePartRegistry(fqName2));
    }

    @NotNull
    public MultifileClassCodegen forMultifileClass(@NotNull FqName facadeFqName, @NotNull Collection<KtFile> files2) {
        assert (!this.isDone) : "Already done!";
        this.registerPackagePartSourceFiles(files2);
        return this.state.getCodegenFactory().createMultifileClassCodegen(this.state, files2, facadeFqName, this.buildNewPackagePartRegistry(facadeFqName.parent()));
    }

    private PackagePartRegistry buildNewPackagePartRegistry(@NotNull FqName packageFqName) {
        String packageFqNameAsString = packageFqName.asString();
        return (partInternalName, facadeInternalName) -> {
            PackageParts packageParts = this.partsGroupedByPackage.computeIfAbsent(packageFqNameAsString, PackageParts::new);
            packageParts.addPart(partInternalName, facadeInternalName);
        };
    }

    private void registerPackagePartSourceFiles(Collection<KtFile> files2) {
        this.packagePartSourceFiles.addAll(ClassFileFactory.toIoFilesIgnoringNonPhysical(PackagePartClassUtils.getFilesWithCallables(files2)));
    }

    @NotNull
    private static List<File> toIoFilesIgnoringNonPhysical(@NotNull Collection<? extends PsiFile> psiFiles) {
        ArrayList<File> result2 = new ArrayList<File>(psiFiles.size());
        for (PsiFile psiFile : psiFiles) {
            VirtualFile virtualFile2 = psiFile.getVirtualFile();
            if (virtualFile2 == null) continue;
            result2.add(new File(virtualFile2.getPath()));
        }
        return result2;
    }

    public void removeClasses(Set<String> classNamesToRemove) {
        for (String classInternalName : classNamesToRemove) {
            this.generators.remove(classInternalName + ".class");
        }
    }

    public List<KtFile> getInputFiles() {
        return this.state.getFiles();
    }

    private static abstract class OutAndSourceFileList {
        protected final List<File> sourceFiles;

        private OutAndSourceFileList(List<File> sourceFiles2) {
            this.sourceFiles = sourceFiles2;
        }

        public abstract byte[] asBytes(ClassBuilderFactory var1);

        public abstract String asText(ClassBuilderFactory var1);
    }

    private static final class ClassBuilderAndSourceFileList
    extends OutAndSourceFileList {
        private final ClassBuilder classBuilder;

        private ClassBuilderAndSourceFileList(ClassBuilder classBuilder2, List<File> sourceFiles2) {
            super(sourceFiles2);
            this.classBuilder = classBuilder2;
        }

        @Override
        public byte[] asBytes(ClassBuilderFactory factory2) {
            return factory2.asBytes(this.classBuilder);
        }

        @Override
        public String asText(ClassBuilderFactory factory2) {
            return factory2.asText(this.classBuilder);
        }
    }

    private class OutputClassFile
    implements OutputFile {
        private final String relativeClassFilePath;

        public OutputClassFile(String relativeClassFilePath) {
            this.relativeClassFilePath = relativeClassFilePath;
        }

        @Override
        @NotNull
        public String getRelativePath() {
            return this.relativeClassFilePath;
        }

        @Override
        @NotNull
        public List<File> getSourceFiles() {
            OutAndSourceFileList pair = (OutAndSourceFileList)ClassFileFactory.this.generators.get(this.relativeClassFilePath);
            if (pair == null) {
                throw new IllegalStateException("No record for binary file " + this.relativeClassFilePath);
            }
            return pair.sourceFiles;
        }

        @Override
        @NotNull
        public byte[] asByteArray() {
            try {
                return ((OutAndSourceFileList)ClassFileFactory.this.generators.get(this.relativeClassFilePath)).asBytes(ClassFileFactory.this.builderFactory);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Error generating class file " + this.toString() + ": " + e.getMessage(), e);
            }
        }

        @Override
        @NotNull
        public String asText() {
            try {
                return ((OutAndSourceFileList)ClassFileFactory.this.generators.get(this.relativeClassFilePath)).asText(ClassFileFactory.this.builderFactory);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Error generating class file " + this.toString() + ": " + e.getMessage(), e);
            }
        }

        @NotNull
        public String toString() {
            return this.getRelativePath() + " (compiled from " + this.getSourceFiles() + ")";
        }
    }
}

