/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.facade;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.SourceLocationConsumer;
import org.jetbrains.kotlin.js.backend.ast.JsLocation;
import org.jetbrains.kotlin.js.backend.ast.JsLocationWithSource;
import org.jetbrains.kotlin.js.sourceMap.SourceFilePathResolver;
import org.jetbrains.kotlin.js.sourceMap.SourceMapMappingConsumer;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;

public class SourceMapBuilderConsumer
implements SourceLocationConsumer {
    @NotNull
    private final SourceMapMappingConsumer mappingConsumer;
    @NotNull
    private final SourceFilePathResolver pathResolver;
    private final boolean provideCurrentModuleContent;
    private final boolean provideExternalModuleContent;
    @NotNull
    private final List<Object> sourceStack = new ArrayList<Object>();

    public SourceMapBuilderConsumer(@NotNull SourceMapMappingConsumer mappingConsumer, @NotNull SourceFilePathResolver pathResolver, boolean provideCurrentModuleContent, boolean provideExternalModuleContent) {
        this.mappingConsumer = mappingConsumer;
        this.pathResolver = pathResolver;
        this.provideCurrentModuleContent = provideCurrentModuleContent;
        this.provideExternalModuleContent = provideExternalModuleContent;
    }

    @Override
    public void newLine() {
        this.mappingConsumer.newLine();
    }

    @Override
    public void pushSourceInfo(@Nullable Object info) {
        this.sourceStack.add(info);
        this.addMapping(info);
    }

    @Override
    public void popSourceInfo() {
        this.sourceStack.remove(this.sourceStack.size() - 1);
        Object sourceInfo = !this.sourceStack.isEmpty() ? this.sourceStack.get(this.sourceStack.size() - 1) : null;
        this.addMapping(sourceInfo);
    }

    private void addMapping(@Nullable Object sourceInfo) {
        if (sourceInfo == null) {
            this.mappingConsumer.addEmptyMapping();
        }
        if (sourceInfo instanceof PsiElement) {
            PsiElement element = (PsiElement)sourceInfo;
            try {
                JsLocation location2 = PsiUtils.extractLocationFromPsi(element, this.pathResolver);
                PsiFile psiFile = element.getContainingFile();
                File file = new File(psiFile.getViewProvider().getVirtualFile().getPath());
                Supplier<Reader> contentSupplier = this.provideCurrentModuleContent ? () -> {
                    try {
                        return new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8"));
                    }
                    catch (IOException e) {
                        return null;
                    }
                } : () -> null;
                this.mappingConsumer.addMapping(location2.getFile(), null, contentSupplier, location2.getStartLine(), location2.getStartChar());
            }
            catch (IOException e) {
                throw new RuntimeException("IO error occurred generating source maps", e);
            }
        } else if (sourceInfo instanceof JsLocationWithSource) {
            JsLocationWithSource location3 = (JsLocationWithSource)sourceInfo;
            Supplier<Reader> contentSupplier = this.provideExternalModuleContent ? () -> location3.getSourceProvider().invoke() : () -> null;
            this.mappingConsumer.addMapping(location3.getFile(), location3.getIdentityObject(), contentSupplier, location3.getStartLine(), location3.getStartChar());
        }
    }
}

