/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.SourceManager;
import org.jetbrains.kotlin.ir.SourceRangeInfo;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u0005J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u0006J\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\bJ\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0006R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/psi2ir/PsiSourceManager;", "Lorg/jetbrains/kotlin/ir/SourceManager;", "()V", "fileEntriesByIrFile", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Lorg/jetbrains/kotlin/psi2ir/PsiSourceManager$PsiFileEntry;", "fileEntriesByKtFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "ktFileByFileEntry", "createFileEntry", "ktFile", "getFileEntry", "Lorg/jetbrains/kotlin/ir/SourceManager$FileEntry;", "irFile", "getKtFile", "fileEntry", "getOrCreateFileEntry", "putFileEntry", "", "PsiFileEntry", "ir.psi2ir"})
public final class PsiSourceManager
implements SourceManager {
    private final HashMap<KtFile, PsiFileEntry> fileEntriesByKtFile = new HashMap();
    private final HashMap<IrFile, PsiFileEntry> fileEntriesByIrFile = new HashMap();
    private final HashMap<PsiFileEntry, KtFile> ktFileByFileEntry = new HashMap();

    private final PsiFileEntry createFileEntry(KtFile ktFile) {
        Object object = this.fileEntriesByKtFile;
        Object object2 = object;
        if (object2.containsKey(ktFile)) {
            object = "PsiFileEntry is already created for " + ktFile;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        PsiFileEntry newEntry = new PsiFileEntry(ktFile);
        object2 = this.fileEntriesByKtFile;
        Object object3 = newEntry;
        object2.put(ktFile, object3);
        object2 = this.ktFileByFileEntry;
        object3 = ktFile;
        object2.put(newEntry, object3);
        return newEntry;
    }

    public final void putFileEntry(@NotNull IrFile irFile, @NotNull PsiFileEntry fileEntry) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        Intrinsics.checkParameterIsNotNull((Object)fileEntry, (String)"fileEntry");
        Map map2 = this.fileEntriesByIrFile;
        PsiFileEntry psiFileEntry = fileEntry;
        map2.put(irFile, psiFileEntry);
    }

    @NotNull
    public final PsiFileEntry getOrCreateFileEntry(@NotNull KtFile ktFile) {
        Intrinsics.checkParameterIsNotNull((Object)ktFile, (String)"ktFile");
        Map map2 = this.fileEntriesByKtFile;
        Object object = map2.get(ktFile);
        if (object == null) {
            object = this.createFileEntry(ktFile);
        }
        return (PsiFileEntry)object;
    }

    @Nullable
    public final KtFile getKtFile(@NotNull PsiFileEntry fileEntry) {
        Intrinsics.checkParameterIsNotNull((Object)fileEntry, (String)"fileEntry");
        return this.ktFileByFileEntry.get(fileEntry);
    }

    @Nullable
    public final KtFile getKtFile(@NotNull IrFile irFile) {
        KtFile ktFile;
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        SourceManager.FileEntry fileEntry = irFile.getFileEntry();
        if (!(fileEntry instanceof PsiFileEntry)) {
            fileEntry = null;
        }
        PsiFileEntry psiFileEntry = (PsiFileEntry)fileEntry;
        if (psiFileEntry != null) {
            PsiFileEntry psiFileEntry2;
            PsiFileEntry it = psiFileEntry2 = psiFileEntry;
            ktFile = this.ktFileByFileEntry.get(it);
        } else {
            ktFile = null;
        }
        return ktFile;
    }

    @Override
    @NotNull
    public SourceManager.FileEntry getFileEntry(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        PsiFileEntry psiFileEntry = this.fileEntriesByIrFile.get(irFile);
        if (psiFileEntry == null) {
            Intrinsics.throwNpe();
        }
        return psiFileEntry;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0016J\b\u0010\u0013\u001a\u00020\fH\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0016J\b\u0010\u0018\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/psi2ir/PsiSourceManager$PsiFileEntry;", "Lorg/jetbrains/kotlin/ir/SourceManager$FileEntry;", "psiFile", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiFile;)V", "lineStartOffsets", "", "maxOffset", "", "getMaxOffset", "()I", "name", "", "getName", "()Ljava/lang/String;", "psiFileName", "getColumnNumber", "offset", "getLineNumber", "getRecognizableName", "getSourceRangeInfo", "Lorg/jetbrains/kotlin/ir/SourceRangeInfo;", "beginOffset", "endOffset", "toString", "ir.psi2ir"})
    public static final class PsiFileEntry
    implements SourceManager.FileEntry {
        private final String psiFileName;
        private final int maxOffset;
        private final int[] lineStartOffsets;

        @Override
        public int getMaxOffset() {
            return this.maxOffset;
        }

        @Override
        public int getLineNumber(int offset2) {
            if (offset2 < 0) {
                return -1;
            }
            int index2 = ArraysKt.binarySearch$default((int[])this.lineStartOffsets, (int)offset2, (int)0, (int)0, (int)6, null);
            return index2 >= 0 ? index2 : -index2 - 2;
        }

        @Override
        public int getColumnNumber(int offset2) {
            if (offset2 < 0) {
                return -1;
            }
            int lineNumber = this.getLineNumber(offset2);
            return offset2 - this.lineStartOffsets[lineNumber];
        }

        @Override
        @NotNull
        public SourceRangeInfo getSourceRangeInfo(int beginOffset, int endOffset) {
            return new SourceRangeInfo(this.getRecognizableName(), beginOffset, this.getLineNumber(beginOffset), this.getColumnNumber(beginOffset), endOffset, this.getLineNumber(endOffset), this.getColumnNumber(endOffset));
        }

        private final String getRecognizableName() {
            String string = this.psiFileName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"psiFileName");
            return string;
        }

        @Override
        @NotNull
        public String getName() {
            return this.getRecognizableName();
        }

        @NotNull
        public String toString() {
            return this.getRecognizableName();
        }

        /*
         * WARNING - void declaration
         */
        public PsiFileEntry(@NotNull PsiFile psiFile) {
            Collection<Integer> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Document document;
            Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
            Object object = psiFile.getVirtualFile();
            if (object == null || (object = ((VirtualFile)object).getPath()) == null) {
                object = psiFile.getName();
            }
            this.psiFileName = object;
            FileViewProvider fileViewProvider = psiFile.getViewProvider();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileViewProvider, (String)"psiFile.viewProvider");
            Document document2 = fileViewProvider.getDocument();
            if (document2 == null) {
                throw (Throwable)((Object)new AssertionError((Object)("No document for " + psiFile)));
            }
            Document document3 = document = document2;
            Intrinsics.checkExpressionValueIsNotNull((Object)document3, (String)"document");
            this.maxOffset = document3.getTextLength();
            int n = 0;
            Iterable iterable = (Iterable)new IntRange(n, document.getLineCount() - 1);
            PsiFileEntry psiFileEntry = this;
            void var4_6 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            Iterator iterator2 = $receiver$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv;
                int n2 = item$iv$iv = ((IntIterator)iterator2).nextInt();
                collection = destination$iv$iv;
                Integer n3 = document.getLineStartOffset((int)it);
                collection.add(n3);
            }
            collection = (List)destination$iv$iv;
            psiFileEntry.lineStartOffsets = CollectionsKt.toIntArray((Collection)collection);
        }
    }
}

