/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.resolve.DeprecationResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.components.KotlinResolutionStatelessCallbacks;
import org.jetbrains.kotlin.resolve.calls.model.CallableReferenceKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCall;
import org.jetbrains.kotlin.resolve.calls.model.KotlinResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.tower.CallableReferenceKotlinCallArgumentImpl;
import org.jetbrains.kotlin.resolve.calls.tower.ImplicitScopeTower;
import org.jetbrains.kotlin.resolve.calls.tower.NewCallArgumentsKt;
import org.jetbrains.kotlin.resolve.calls.tower.PSIKotlinCallForInvoke;
import org.jetbrains.kotlin.resolve.calls.tower.PSIKotlinCallImpl;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\fH\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\fH\u0016J\u0012\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/tower/KotlinResolutionStatelessCallbacksImpl;", "Lorg/jetbrains/kotlin/resolve/calls/components/KotlinResolutionStatelessCallbacks;", "deprecationResolver", "Lorg/jetbrains/kotlin/resolve/DeprecationResolver;", "(Lorg/jetbrains/kotlin/resolve/DeprecationResolver;)V", "getScopeTowerForCallableReferenceArgument", "Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/CallableReferenceKotlinCallArgument;", "getVariableCandidateIfInvoke", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinResolutionCandidate;", "functionCall", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCall;", "isDescriptorFromSource", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "isHiddenInResolution", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "kotlinCall", "isInfixCall", "isOperatorCall", "isSuperExpression", "receiver", "Lorg/jetbrains/kotlin/resolve/calls/model/SimpleKotlinCallArgument;", "isSuperOrDelegatingConstructorCall", "frontend"})
public final class KotlinResolutionStatelessCallbacksImpl
implements KotlinResolutionStatelessCallbacks {
    private final DeprecationResolver deprecationResolver;

    @Override
    public boolean isDescriptorFromSource(@NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        return DescriptorToSourceUtils.descriptorToDeclaration(descriptor2) != null;
    }

    @Override
    public boolean isInfixCall(@NotNull KotlinCall kotlinCall) {
        Intrinsics.checkParameterIsNotNull((Object)kotlinCall, (String)"kotlinCall");
        return kotlinCall instanceof PSIKotlinCallImpl && CallResolverUtilKt.isInfixCall(((PSIKotlinCallImpl)kotlinCall).getPsiCall());
    }

    @Override
    public boolean isOperatorCall(@NotNull KotlinCall kotlinCall) {
        Intrinsics.checkParameterIsNotNull((Object)kotlinCall, (String)"kotlinCall");
        return kotlinCall instanceof PSIKotlinCallForInvoke || kotlinCall instanceof PSIKotlinCallImpl && CallResolverUtilKt.isConventionCall(((PSIKotlinCallImpl)kotlinCall).getPsiCall());
    }

    @Override
    public boolean isSuperOrDelegatingConstructorCall(@NotNull KotlinCall kotlinCall) {
        Intrinsics.checkParameterIsNotNull((Object)kotlinCall, (String)"kotlinCall");
        return kotlinCall instanceof PSIKotlinCallImpl && CallResolverUtilKt.isSuperOrDelegatingConstructorCall(((PSIKotlinCallImpl)kotlinCall).getPsiCall());
    }

    @Override
    public boolean isHiddenInResolution(@NotNull DeclarationDescriptor descriptor2, @NotNull KotlinCall kotlinCall) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)kotlinCall, (String)"kotlinCall");
        return this.deprecationResolver.isHiddenInResolution(descriptor2, this.isSuperOrDelegatingConstructorCall(kotlinCall));
    }

    @Override
    public boolean isSuperExpression(@Nullable SimpleKotlinCallArgument receiver) {
        SimpleKotlinCallArgument simpleKotlinCallArgument = receiver;
        return (simpleKotlinCallArgument != null ? NewCallArgumentsKt.getPsiExpression(simpleKotlinCallArgument) : null) instanceof KtSuperExpression;
    }

    @Override
    @NotNull
    public ImplicitScopeTower getScopeTowerForCallableReferenceArgument(@NotNull CallableReferenceKotlinCallArgument argument) {
        Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
        return ((CallableReferenceKotlinCallArgumentImpl)argument).getScopeTowerForResolution();
    }

    @Override
    @Nullable
    public KotlinResolutionCandidate getVariableCandidateIfInvoke(@NotNull KotlinCall functionCall) {
        Intrinsics.checkParameterIsNotNull((Object)functionCall, (String)"functionCall");
        KotlinCall $receiver$iv = functionCall;
        KotlinCall kotlinCall = $receiver$iv;
        if (!(kotlinCall instanceof PSIKotlinCallForInvoke)) {
            kotlinCall = null;
        }
        PSIKotlinCallForInvoke pSIKotlinCallForInvoke = (PSIKotlinCallForInvoke)kotlinCall;
        return pSIKotlinCallForInvoke != null ? pSIKotlinCallForInvoke.getVariableCall() : null;
    }

    public KotlinResolutionStatelessCallbacksImpl(@NotNull DeprecationResolver deprecationResolver) {
        Intrinsics.checkParameterIsNotNull((Object)deprecationResolver, (String)"deprecationResolver");
        this.deprecationResolver = deprecationResolver;
    }
}

