/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.script;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.KotlinScriptDefinitionFromAnnotatedTemplate;
import org.jetbrains.kotlin.script.ScriptTemplateProviderExtensionPointKt;
import org.jetbrains.kotlin.script.ScriptTemplatesProvider;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a.\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u001a6\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\u001a\b\u0002\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "createClassLoader", "Ljava/lang/ClassLoader;", "provider", "Lorg/jetbrains/kotlin/script/ScriptTemplatesProvider;", "makeScriptDefsFromTemplatesProviderExtensions", "", "Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "project", "Lcom/intellij/openapi/project/Project;", "errorsHandler", "Lkotlin/Function2;", "", "", "makeScriptDefsFromTemplatesProviders", "providers", "", "frontend.script"})
public final class ScriptTemplateProviderExtensionPointKt {
    private static final Logger LOG = Logger.getInstance("ScriptTemplatesProviders");

    @NotNull
    public static final List<KotlinScriptDefinition> makeScriptDefsFromTemplatesProviderExtensions(@NotNull Project project, @NotNull Function2<? super ScriptTemplatesProvider, ? super Throwable, Unit> errorsHandler) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(errorsHandler, (String)"errorsHandler");
        ExtensionPoint<ScriptTemplatesProvider> extensionPoint = Extensions.getArea(project).getExtensionPoint(ScriptTemplatesProvider.Companion.getEP_NAME());
        Intrinsics.checkExpressionValueIsNotNull(extensionPoint, (String)"Extensions.getArea(proje\u2026emplatesProvider.EP_NAME)");
        Object[] objectArray = extensionPoint.getExtensions();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"Extensions.getArea(proje\u2026vider.EP_NAME).extensions");
        return ScriptTemplateProviderExtensionPointKt.makeScriptDefsFromTemplatesProviders(ArraysKt.asIterable((Object[])objectArray), errorsHandler);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KotlinScriptDefinition> makeScriptDefsFromTemplatesProviders(@NotNull Iterable<? extends ScriptTemplatesProvider> providers, @NotNull Function2<? super ScriptTemplatesProvider, ? super Throwable, Unit> errorsHandler) {
        void $receiver$iv$iv;
        Iterable<? extends ScriptTemplatesProvider> $receiver$iv;
        Intrinsics.checkParameterIsNotNull(providers, (String)"providers");
        Intrinsics.checkParameterIsNotNull(errorsHandler, (String)"errorsHandler");
        Iterable<? extends ScriptTemplatesProvider> iterable = $receiver$iv = providers;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            List list2;
            ScriptTemplatesProvider provider = (ScriptTemplatesProvider)element$iv$iv;
            try {
                void $receiver$iv$iv2;
                Iterable<String> $receiver$iv2;
                ClassLoader loader = ScriptTemplateProviderExtensionPointKt.createClassLoader(provider);
                Iterable<String> iterable2 = $receiver$iv2 = provider.getTemplateClassNames();
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv2) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    Class<?> clazz = loader.loadClass((String)it);
                    Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"loader.loadClass(it)");
                    KotlinScriptDefinitionFromAnnotatedTemplate kotlinScriptDefinitionFromAnnotatedTemplate = new KotlinScriptDefinitionFromAnnotatedTemplate((KClass<? extends Object>)JvmClassMappingKt.getKotlinClass(clazz), provider.getResolver(), provider.getFilePattern(), provider.getEnvironment(), provider.getTemplateClasspath());
                    collection.add(kotlinScriptDefinitionFromAnnotatedTemplate);
                }
                list2 = (List)destination$iv$iv2;
            }
            catch (Throwable ex) {
                LOG.info("Templates provider " + provider.getId() + " is invalid: " + ex.getMessage());
                errorsHandler.invoke((Object)provider, (Object)ex);
                list2 = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ List makeScriptDefsFromTemplatesProviders$default(Iterable iterable, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            function2 = makeScriptDefsFromTemplatesProviders.1.INSTANCE;
        }
        return ScriptTemplateProviderExtensionPointKt.makeScriptDefsFromTemplatesProviders(iterable, (Function2<? super ScriptTemplatesProvider, ? super Throwable, Unit>)function2);
    }

    /*
     * WARNING - void declaration
     */
    private static final ClassLoader createClassLoader(ScriptTemplatesProvider provider) {
        ClassLoader classLoader;
        List classpath = CollectionsKt.plus((Collection)provider.getTemplateClasspath(), (Iterable)provider.getAdditionalResolverClasspath());
        StringBuilder stringBuilder = new StringBuilder().append("[kts] loading script definitions ").append(provider.getTemplateClassNames()).append(" using cp: ");
        Iterable iterable = classpath;
        String string = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File.pathSeparator");
        LOG.info(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null)).toString());
        ClassLoader baseLoader = ScriptTemplatesProvider.class.getClassLoader();
        if (classpath.isEmpty()) {
            ClassLoader classLoader2 = baseLoader;
            classLoader = classLoader2;
            Intrinsics.checkExpressionValueIsNotNull((Object)classLoader2, (String)"baseLoader");
        } else {
            Collection<URL> collection;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable2 = $receiver$iv = (Iterable)classpath;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                collection = destination$iv$iv;
                URL uRL = it.toURI().toURL();
                collection.add(uRL);
            }
            collection = (List)destination$iv$iv;
            $receiver$iv = collection;
            Iterable thisCollection$iv = $receiver$iv;
            URL[] uRLArray = thisCollection$iv.toArray(new URL[thisCollection$iv.size()]);
            if (uRLArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            ClassLoader classLoader3 = baseLoader;
            URL[] uRLArray2 = uRLArray;
            classLoader = new URLClassLoader(uRLArray2, classLoader3);
        }
        return classLoader;
    }
}

