/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiParserFacadeImpl
implements PsiParserFacade {
    protected final PsiManagerEx myManager;

    public PsiParserFacadeImpl(PsiManagerEx manager) {
        this.myManager = manager;
    }

    @Override
    @NotNull
    public PsiElement createWhiteSpaceFromText(@NotNull @NonNls String text2) throws IncorrectOperationException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiParserFacadeImpl", "createWhiteSpaceFromText"));
        }
        FileElement holderElement = DummyHolderFactory.createHolder(this.myManager, null).getTreeElement();
        LeafElement newElement = ASTFactory.leaf(TokenType.WHITE_SPACE, holderElement.getCharTable().intern(text2));
        holderElement.rawAddChildren(newElement);
        GeneratedMarkerVisitor.markGenerated(newElement.getPsi());
        PsiElement psiElement = newElement.getPsi();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiParserFacadeImpl", "createWhiteSpaceFromText"));
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiComment createLineCommentFromText(@NotNull LanguageFileType fileType, @NotNull String text2) throws IncorrectOperationException {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/psi/impl/PsiParserFacadeImpl", "createLineCommentFromText"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiParserFacadeImpl", "createLineCommentFromText"));
        }
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(fileType.getLanguage());
        assert (commenter != null);
        String prefix = commenter.getLineCommentPrefix();
        if (prefix == null) {
            throw new IncorrectOperationException("No line comment prefix defined for language " + fileType.getLanguage().getID());
        }
        PsiFile aFile = this.createDummyFile(prefix + text2, fileType);
        PsiComment psiComment = this.findPsiCommentChild(aFile);
        if (psiComment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiParserFacadeImpl", "createLineCommentFromText"));
        }
        return psiComment;
    }

    @Override
    @NotNull
    public PsiComment createBlockCommentFromText(@NotNull Language language, @NotNull String text2) throws IncorrectOperationException {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/impl/PsiParserFacadeImpl", "createBlockCommentFromText"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiParserFacadeImpl", "createBlockCommentFromText"));
        }
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        assert (commenter != null) : language;
        String blockCommentPrefix = commenter.getBlockCommentPrefix();
        String blockCommentSuffix = commenter.getBlockCommentSuffix();
        PsiFile aFile = PsiFileFactory.getInstance(this.myManager.getProject()).createFileFromText("_Dummy_", language, (CharSequence)(blockCommentPrefix + text2 + blockCommentSuffix));
        PsiComment psiComment = this.findPsiCommentChild(aFile);
        if (psiComment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiParserFacadeImpl", "createBlockCommentFromText"));
        }
        return psiComment;
    }

    @Override
    @NotNull
    public PsiComment createLineOrBlockCommentFromText(@NotNull Language lang, @NotNull String text2) throws IncorrectOperationException {
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/intellij/psi/impl/PsiParserFacadeImpl", "createLineOrBlockCommentFromText"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiParserFacadeImpl", "createLineOrBlockCommentFromText"));
        }
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(lang);
        assert (commenter != null) : lang;
        String prefix = commenter.getLineCommentPrefix();
        String blockCommentPrefix = commenter.getBlockCommentPrefix();
        String blockCommentSuffix = commenter.getBlockCommentSuffix();
        assert (prefix != null || blockCommentPrefix != null && blockCommentSuffix != null);
        PsiFile aFile = PsiFileFactory.getInstance(this.myManager.getProject()).createFileFromText("_Dummy_", lang, (CharSequence)(prefix != null ? prefix + text2 : blockCommentPrefix + text2 + blockCommentSuffix));
        PsiComment psiComment = this.findPsiCommentChild(aFile);
        if (psiComment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiParserFacadeImpl", "createLineOrBlockCommentFromText"));
        }
        return psiComment;
    }

    private PsiComment findPsiCommentChild(PsiFile aFile) {
        PsiElement[] children2;
        for (PsiElement aChildren : children2 = aFile.getChildren()) {
            if (!(aChildren instanceof PsiComment)) continue;
            PsiComment comment = (PsiComment)aChildren;
            DummyHolderFactory.createHolder((PsiManager)this.myManager, (TreeElement)SourceTreeToPsiMap.psiElementToTree(comment), null);
            return comment;
        }
        throw new IncorrectOperationException("Incorrect comment \"" + aFile.getText() + "\".");
    }

    protected PsiFile createDummyFile(String text2, LanguageFileType fileType) {
        String ext = fileType.getDefaultExtension();
        String fileName = "_Dummy_." + ext;
        return PsiFileFactory.getInstance(this.myManager.getProject()).createFileFromText(fileType, fileName, (CharSequence)text2, 0, text2.length());
    }
}

