/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CustomExceptionHandler;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionUtil {
    @NotNull
    public static List<PsiClassType> getThrownExceptions(@NotNull PsiElement[] elements) {
        if (elements == null) {
            ExceptionUtil.$$$reportNull$$$0(0);
        }
        ArrayList<PsiClassType> array = ContainerUtil.newArrayList();
        for (PsiElement element : elements) {
            List<PsiClassType> exceptions = ExceptionUtil.getThrownExceptions(element);
            ExceptionUtil.addExceptions(array, exceptions);
        }
        ArrayList<PsiClassType> arrayList = array;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiClassType> getThrownExceptions(final @NotNull PsiElement element) {
        if (element == null) {
            ExceptionUtil.$$$reportNull$$$0(7);
        }
        final ArrayList<PsiClassType> result2 = new ArrayList<PsiClassType>();
        element.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitAnonymousClass(PsiAnonymousClass aClass2) {
                PsiExpressionList argumentList2 = aClass2.getArgumentList();
                if (argumentList2 != null) {
                    super.visitExpressionList(argumentList2);
                }
                super.visitAnonymousClass(aClass2);
            }

            @Override
            public void visitClass(PsiClass aClass2) {
            }

            @Override
            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                PsiReferenceExpression methodRef = expression2.getMethodExpression();
                JavaResolveResult resolveResult = methodRef.advancedResolve(false);
                PsiMethod method = (PsiMethod)resolveResult.getElement();
                if (method != null) {
                    ExceptionUtil.addExceptions(result2, ExceptionUtil.getExceptionsByMethod(method, resolveResult.getSubstitutor(), element));
                }
                super.visitMethodCallExpression(expression2);
            }

            @Override
            public void visitNewExpression(PsiNewExpression expression2) {
                JavaResolveResult resolveResult = expression2.resolveMethodGenerics();
                PsiMethod method = (PsiMethod)resolveResult.getElement();
                if (method != null) {
                    ExceptionUtil.addExceptions(result2, ExceptionUtil.getExceptionsByMethod(method, resolveResult.getSubstitutor(), element));
                }
                super.visitNewExpression(expression2);
            }

            @Override
            public void visitThrowStatement(PsiThrowStatement statement2) {
                PsiExpression expr = statement2.getException();
                if (expr != null) {
                    ExceptionUtil.addExceptions(result2, StreamEx.of(ExceptionUtil.getPreciseThrowTypes(expr)).select(PsiClassType.class).toList());
                }
                super.visitThrowStatement(statement2);
            }

            @Override
            public void visitLambdaExpression(PsiLambdaExpression expression2) {
            }

            @Override
            public void visitResourceList(PsiResourceList resourceList) {
                for (PsiResourceListElement listElement : resourceList) {
                    ExceptionUtil.addExceptions(result2, ExceptionUtil.getCloserExceptions(listElement));
                }
                super.visitResourceList(resourceList);
            }

            @Override
            public void visitTryStatement(PsiTryStatement statement2) {
                ExceptionUtil.addExceptions(result2, ExceptionUtil.getTryExceptions(statement2));
            }
        });
        ArrayList<PsiClassType> arrayList = result2;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiClassType> getTryExceptions(@NotNull PsiTryStatement tryStatement) {
        PsiCodeBlock tryBlock;
        if (tryStatement == null) {
            ExceptionUtil.$$$reportNull$$$0(9);
        }
        ArrayList<PsiClassType> array = ContainerUtil.newArrayList();
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList != null) {
            for (PsiResourceListElement psiResourceListElement : resourceList) {
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledCloserExceptions(psiResourceListElement, resourceList));
            }
        }
        if ((tryBlock = tryStatement.getTryBlock()) != null) {
            ExceptionUtil.addExceptions(array, ExceptionUtil.getThrownExceptions(tryBlock));
        }
        for (PsiParameter psiParameter : tryStatement.getCatchBlockParameters()) {
            PsiType exception = psiParameter.getType();
            for (int j = array.size() - 1; j >= 0; --j) {
                PsiClassType exception1 = (PsiClassType)array.get(j);
                if (!exception.isAssignableFrom(exception1)) continue;
                array.remove(exception1);
            }
        }
        for (PsiCodeBlock psiCodeBlock : tryStatement.getCatchBlocks()) {
            ExceptionUtil.addExceptions(array, ExceptionUtil.getThrownExceptions(psiCodeBlock));
        }
        PsiCodeBlock psiCodeBlock = tryStatement.getFinallyBlock();
        if (psiCodeBlock != null) {
            try {
                ControlFlow flow = ControlFlowFactory.getInstance(psiCodeBlock.getProject()).getControlFlow(psiCodeBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
                int completionReasons = ControlFlowUtil.getCompletionReasons(flow, 0, flow.getSize());
                List<PsiClassType> list2 = ExceptionUtil.getThrownExceptions(psiCodeBlock);
                if (!BitUtil.isSet(completionReasons, 1)) {
                    array = ContainerUtil.newArrayList(list2);
                } else {
                    ExceptionUtil.addExceptions(array, list2);
                }
            }
            catch (AnalysisCanceledException analysisCanceledException) {
                // empty catch block
            }
        }
        ArrayList<PsiClassType> arrayList = array;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiClassType> getExceptionsByMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor2, @NotNull PsiElement place) {
        PsiClassType[] referenceTypes;
        if (method == null) {
            ExceptionUtil.$$$reportNull$$$0(14);
        }
        if (substitutor2 == null) {
            ExceptionUtil.$$$reportNull$$$0(15);
        }
        if (place == null) {
            ExceptionUtil.$$$reportNull$$$0(16);
        }
        if ((referenceTypes = method.getThrowsList().getReferencedTypes()).length == 0) {
            List<PsiClassType> list2 = Collections.emptyList();
            if (list2 == null) {
                ExceptionUtil.$$$reportNull$$$0(17);
            }
            return list2;
        }
        GlobalSearchScope scope = place.getResolveScope();
        ArrayList<PsiClassType> result2 = ContainerUtil.newArrayList();
        for (PsiType type2 : referenceTypes) {
            if (!((type2 = PsiClassImplUtil.correctType(substitutor2.substitute(type2), scope)) instanceof PsiClassType)) continue;
            result2.add((PsiClassType)type2);
        }
        ArrayList<PsiClassType> arrayList = result2;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    private static void addExceptions(@NotNull List<PsiClassType> array, @NotNull Collection<PsiClassType> exceptions) {
        if (array == null) {
            ExceptionUtil.$$$reportNull$$$0(19);
        }
        if (exceptions == null) {
            ExceptionUtil.$$$reportNull$$$0(20);
        }
        for (PsiClassType exception : exceptions) {
            ExceptionUtil.addException(array, exception);
        }
    }

    private static void addException(@NotNull List<PsiClassType> array, @Nullable PsiClassType exception) {
        if (array == null) {
            ExceptionUtil.$$$reportNull$$$0(21);
        }
        if (exception == null) {
            return;
        }
        for (int i = array.size() - 1; i >= 0; --i) {
            PsiClassType exception1 = array.get(i);
            if (exception1.isAssignableFrom(exception)) {
                return;
            }
            if (!exception.isAssignableFrom(exception1)) continue;
            array.remove(i);
        }
        array.add(exception);
    }

    @NotNull
    public static Collection<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement) {
        if (element == null) {
            ExceptionUtil.$$$reportNull$$$0(22);
        }
        Collection<PsiClassType> collection = ExceptionUtil.collectUnhandledExceptions(element, topElement, true);
        if (collection == null) {
            ExceptionUtil.$$$reportNull$$$0(23);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement, boolean includeSelfCalls) {
        Set<PsiClassType> set;
        if (element == null) {
            ExceptionUtil.$$$reportNull$$$0(24);
        }
        Collection<Object> collection = (set = ExceptionUtil.collectUnhandledExceptions(element, topElement, null, includeSelfCalls)) == null ? Collections.emptyList() : set;
        if (collection == null) {
            ExceptionUtil.$$$reportNull$$$0(25);
        }
        return collection;
    }

    @Nullable
    private static Set<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement, @Nullable Set<PsiClassType> foundExceptions, boolean includeSelfCalls) {
        if (element == null) {
            ExceptionUtil.$$$reportNull$$$0(26);
        }
        Collection<PsiClassType> unhandledExceptions = null;
        if (element instanceof PsiCallExpression) {
            PsiCallExpression expression2 = (PsiCallExpression)element;
            unhandledExceptions = ExceptionUtil.getUnhandledExceptions(expression2, topElement, includeSelfCalls);
        } else {
            List<PsiClassType> unhandled;
            if (element instanceof PsiMethodReferenceExpression) {
                PsiExpression qualifierExpression = ((PsiMethodReferenceExpression)element).getQualifierExpression();
                return qualifierExpression != null ? ExceptionUtil.collectUnhandledExceptions(qualifierExpression, topElement, null, false) : null;
            }
            if (element instanceof PsiLambdaExpression) {
                return null;
            }
            if (element instanceof PsiThrowStatement) {
                PsiThrowStatement statement2 = (PsiThrowStatement)element;
                unhandledExceptions = ExceptionUtil.getUnhandledExceptions(statement2, topElement);
            } else if (element instanceof PsiCodeBlock && element.getParent() instanceof PsiMethod && ((PsiMethod)element.getParent()).isConstructor() && !ExceptionUtil.firstStatementIsConstructorCall((PsiCodeBlock)element)) {
                PsiMethod constructor = (PsiMethod)element.getParent();
                PsiClass aClass2 = constructor.getContainingClass();
                PsiClass superClass = aClass2 == null ? null : aClass2.getSuperClass();
                PsiMethod[] superConstructors = superClass == null ? PsiMethod.EMPTY_ARRAY : superClass.getConstructors();
                HashSet<PsiClassType> unhandled2 = new HashSet<PsiClassType>();
                for (PsiMethod superConstructor : superConstructors) {
                    PsiClassType[] exceptionTypes;
                    if (superConstructor.hasModifierProperty("private") || superConstructor.getParameterList().getParametersCount() != 0) continue;
                    for (PsiClassType exceptionType : exceptionTypes = superConstructor.getThrowsList().getReferencedTypes()) {
                        if (ExceptionUtil.isUncheckedException(exceptionType) || ExceptionUtil.isHandled(element, exceptionType, topElement)) continue;
                        unhandled2.add(exceptionType);
                    }
                    break;
                }
                if (aClass2 != null) {
                    PsiClassInitializer[] initializers = aClass2.getInitializers();
                    THashSet<PsiClassType> thrownByInitializer = new THashSet<PsiClassType>();
                    for (PsiClassInitializer initializer2 : initializers) {
                        if (initializer2.hasModifierProperty("static")) continue;
                        thrownByInitializer.clear();
                        ExceptionUtil.collectUnhandledExceptions(initializer2.getBody(), initializer2, thrownByInitializer, includeSelfCalls);
                        for (PsiClassType thrown : thrownByInitializer) {
                            if (ExceptionUtil.isHandled(constructor.getBody(), thrown, topElement)) continue;
                            unhandled2.add(thrown);
                        }
                    }
                }
                unhandledExceptions = unhandled2;
            } else if (element instanceof PsiResourceListElement && !(unhandled = ExceptionUtil.getUnhandledCloserExceptions((PsiResourceListElement)element, topElement)).isEmpty()) {
                unhandledExceptions = ContainerUtil.newArrayList(unhandled);
            }
        }
        if (unhandledExceptions != null) {
            if (foundExceptions == null) {
                foundExceptions = new THashSet<PsiClassType>();
            }
            foundExceptions.addAll(unhandledExceptions);
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            Set<PsiClassType> foundInChild = ExceptionUtil.collectUnhandledExceptions(child, topElement, foundExceptions, includeSelfCalls);
            if (foundExceptions == null) {
                foundExceptions = foundInChild;
                continue;
            }
            if (foundInChild == null) continue;
            foundExceptions.addAll(foundInChild);
        }
        return foundExceptions;
    }

    @NotNull
    private static Collection<PsiClassType> getUnhandledExceptions(@NotNull PsiMethodReferenceExpression methodReferenceExpression, PsiElement topElement) {
        JavaResolveResult resolveResult;
        PsiElement resolve2;
        if (methodReferenceExpression == null) {
            ExceptionUtil.$$$reportNull$$$0(27);
        }
        if ((resolve2 = (resolveResult = methodReferenceExpression.advancedResolve(false)).getElement()) instanceof PsiMethod) {
            PsiElement referenceNameElement = methodReferenceExpression.getReferenceNameElement();
            List<PsiClassType> list2 = ExceptionUtil.getUnhandledExceptions((PsiMethod)resolve2, referenceNameElement, topElement, resolveResult.getSubstitutor());
            if (list2 == null) {
                ExceptionUtil.$$$reportNull$$$0(28);
            }
            return list2;
        }
        List<PsiClassType> list3 = Collections.emptyList();
        if (list3 == null) {
            ExceptionUtil.$$$reportNull$$$0(29);
        }
        return list3;
    }

    private static boolean firstStatementIsConstructorCall(@NotNull PsiCodeBlock constructorBody) {
        PsiStatement[] statements;
        if (constructorBody == null) {
            ExceptionUtil.$$$reportNull$$$0(30);
        }
        if ((statements = constructorBody.getStatements()).length == 0) {
            return false;
        }
        if (!(statements[0] instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpression expression2 = ((PsiExpressionStatement)statements[0]).getExpression();
        if (!(expression2 instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethod method = (PsiMethod)((PsiMethodCallExpression)expression2).getMethodExpression().resolve();
        return method != null && method.isConstructor();
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(final @NotNull PsiElement[] elements) {
        if (elements == null) {
            ExceptionUtil.$$$reportNull$$$0(31);
        }
        final ArrayList<PsiClassType> array = ContainerUtil.newArrayList();
        JavaRecursiveElementWalkingVisitor visitor2 = new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitEnumConstant(PsiEnumConstant enumConstant) {
                PsiMethod method = enumConstant.resolveMethod();
                if (method != null) {
                    ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledExceptions(method, (PsiElement)enumConstant, null, PsiSubstitutor.EMPTY));
                }
                this.visitElement(enumConstant);
            }

            @Override
            public void visitCallExpression(@NotNull PsiCallExpression expression2) {
                if (expression2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledExceptions(expression2, null));
                this.visitElement(expression2);
            }

            @Override
            public void visitThrowStatement(@NotNull PsiThrowStatement statement2) {
                if (statement2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledExceptions(statement2, null));
                this.visitElement(statement2);
            }

            @Override
            public void visitLambdaExpression(PsiLambdaExpression expression2) {
                if (ArrayUtil.find(elements, expression2) >= 0) {
                    this.visitElement(expression2);
                }
            }

            @Override
            public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression2) {
                if (expression2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (ArrayUtil.find(elements, expression2) >= 0) {
                    ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledExceptions(expression2, null));
                    this.visitElement(expression2);
                }
            }

            @Override
            public void visitResourceVariable(@NotNull PsiResourceVariable resource) {
                if (resource == null) {
                    2.$$$reportNull$$$0(3);
                }
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledCloserExceptions(resource, null));
                this.visitElement(resource);
            }

            @Override
            public void visitResourceExpression(@NotNull PsiResourceExpression resource) {
                if (resource == null) {
                    2.$$$reportNull$$$0(4);
                }
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledCloserExceptions(resource, null));
                this.visitElement(resource);
            }

            @Override
            public void visitClass(PsiClass aClass2) {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "resource";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/ExceptionUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCallExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitThrowStatement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodReferenceExpression";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitResourceVariable";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitResourceExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        for (PsiElement element : elements) {
            element.accept(visitor2);
        }
        ArrayList<PsiClassType> arrayList = array;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(32);
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiCallExpression methodCall, @Nullable PsiElement topElement) {
        if (methodCall == null) {
            ExceptionUtil.$$$reportNull$$$0(35);
        }
        List<PsiClassType> list2 = ExceptionUtil.getUnhandledExceptions(methodCall, topElement, true);
        if (list2 == null) {
            ExceptionUtil.$$$reportNull$$$0(36);
        }
        return list2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiCallExpression methodCall, @Nullable PsiElement topElement, boolean includeSelfCalls) {
        block19: {
            block20: {
                if (methodCall == null) {
                    ExceptionUtil.$$$reportNull$$$0(37);
                }
                if (MethodCandidateInfo.isOverloadCheck()) {
                    v0 = Collections.emptyList();
                    if (v0 == null) {
                        ExceptionUtil.$$$reportNull$$$0(38);
                    }
                    return v0;
                }
                properties = MethodCandidateInfo.getCurrentMethod(methodCall.getArgumentList());
                result = properties != null ? properties.getInfo() : PsiDiamondType.getDiamondsAwareResolveResult(methodCall);
                element = result.getElement();
                v1 = method = element instanceof PsiMethod != false ? (PsiMethod)element : null;
                if (method == null) {
                    v2 = Collections.emptyList();
                    if (v2 == null) {
                        ExceptionUtil.$$$reportNull$$$0(39);
                    }
                    return v2;
                }
                containingMethod = PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiMethod.class);
                if (!includeSelfCalls && method == containingMethod) {
                    v3 = Collections.emptyList();
                    if (v3 == null) {
                        ExceptionUtil.$$$reportNull$$$0(40);
                    }
                    return v3;
                }
                if (properties != null) {
                    PsiUtilCore.ensureValid(method);
                }
                if ((thrownExceptions = method.getThrowsList().getReferencedTypes()).length == 0) {
                    v4 = Collections.emptyList();
                    if (v4 == null) {
                        ExceptionUtil.$$$reportNull$$$0(41);
                    }
                    return v4;
                }
                substitutor = result.getSubstitutor();
                if (ExceptionUtil.isArrayClone(method, methodCall) || !(methodCall instanceof PsiMethodCallExpression)) break block19;
                containingFile = (containingMethod == null ? methodCall : containingMethod).getContainingFile();
                processor = new MethodResolverProcessor((PsiMethodCallExpression)methodCall, containingFile);
                try {
                    PsiScopesUtil.setupAndRunProcessor(processor, methodCall, false);
                    candidates = ContainerUtil.mapNotNull(processor.getResults(), (Function<CandidateInfo, Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getUnhandledExceptions$0(com.intellij.psi.PsiMethod com.intellij.psi.infos.CandidateInfo ), (Lcom/intellij/psi/infos/CandidateInfo;)Lcom/intellij/openapi/util/Pair;)((PsiMethod)method));
                    if (candidates.isEmpty()) break block19;
                    scope = methodCall.getResolveScope();
                    ex = ExceptionUtil.collectSubstituted(substitutor, thrownExceptions, scope);
lbl40:
                    // 2 sources

                    for (Pair pair : candidates) {
                        exceptions = ((PsiMethod)pair.first).getThrowsList().getReferencedTypes();
                        if (exceptions.length == 0) {
                            v5 = ExceptionUtil.getUnhandledExceptions(methodCall, topElement, PsiSubstitutor.EMPTY, PsiClassType.EMPTY_ARRAY);
                            break block20;
                        }
                        ** GOTO lbl-1000
                    }
                    ** GOTO lbl58
                }
                catch (MethodProcessorSetupFailedException ignore) {
                    v6 = Collections.emptyList();
                    if (v6 == null) {
                        ExceptionUtil.$$$reportNull$$$0(44);
                    }
                    return v6;
                }
            }
            if (v5 == null) {
                ExceptionUtil.$$$reportNull$$$0(42);
            }
            return v5;
lbl-1000:
            // 1 sources

            {
                ExceptionUtil.retainExceptions(ex, ExceptionUtil.collectSubstituted((PsiSubstitutor)pair.second, exceptions, scope));
                ** GOTO lbl40
lbl58:
                // 1 sources

                v7 = ExceptionUtil.getUnhandledExceptions(methodCall, topElement, PsiSubstitutor.EMPTY, ex.toArray(new PsiClassType[ex.size()]));
            }
            if (v7 == null) {
                ExceptionUtil.$$$reportNull$$$0(43);
            }
            return v7;
        }
        v8 = ExceptionUtil.getUnhandledExceptions(method, (PsiElement)methodCall, topElement, substitutor);
        if (v8 == null) {
            ExceptionUtil.$$$reportNull$$$0(45);
        }
        return v8;
    }

    public static void retainExceptions(List<PsiClassType> ex, List<PsiClassType> thrownEx) {
        ArrayList<PsiClassType> replacement = new ArrayList<PsiClassType>();
        Iterator<PsiClassType> iterator2 = ex.iterator();
        while (iterator2.hasNext()) {
            PsiClassType classType = iterator2.next();
            boolean found = false;
            for (PsiClassType psiClassType : thrownEx) {
                if (psiClassType.isAssignableFrom(classType)) {
                    found = true;
                    break;
                }
                if (!classType.isAssignableFrom(psiClassType) || ExceptionUtil.isUncheckedException(classType) != ExceptionUtil.isUncheckedException(psiClassType)) continue;
                replacement.add(psiClassType);
            }
            if (found) continue;
            iterator2.remove();
        }
        ex.removeAll(replacement);
        ex.addAll(replacement);
    }

    public static List<PsiClassType> collectSubstituted(PsiSubstitutor substitutor2, PsiClassType[] thrownExceptions, GlobalSearchScope scope) {
        ArrayList<PsiClassType> ex = new ArrayList<PsiClassType>();
        for (PsiClassType thrownException : thrownExceptions) {
            PsiCapturedWildcardType capturedWildcardType;
            PsiType upperBound;
            PsiType psiType = PsiClassImplUtil.correctType(substitutor2.substitute(thrownException), scope);
            if (psiType instanceof PsiClassType) {
                ex.add((PsiClassType)psiType);
                continue;
            }
            if (!(psiType instanceof PsiCapturedWildcardType) || !((upperBound = (capturedWildcardType = (PsiCapturedWildcardType)psiType).getUpperBound()) instanceof PsiClassType)) continue;
            ex.add((PsiClassType)upperBound);
        }
        return ex;
    }

    @NotNull
    public static List<PsiClassType> getCloserExceptions(@NotNull PsiResourceListElement resource) {
        List<PsiClassType> ex;
        if (resource == null) {
            ExceptionUtil.$$$reportNull$$$0(46);
        }
        List<PsiClassType> list2 = (ex = ExceptionUtil.getExceptionsFromClose(resource)) != null ? ex : Collections.emptyList();
        if (list2 == null) {
            ExceptionUtil.$$$reportNull$$$0(47);
        }
        return list2;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledCloserExceptions(@NotNull PsiResourceListElement resource, @Nullable PsiElement topElement) {
        if (resource == null) {
            ExceptionUtil.$$$reportNull$$$0(48);
        }
        PsiType type2 = resource.getType();
        List<PsiClassType> list2 = ExceptionUtil.getUnhandledCloserExceptions(resource, topElement, type2);
        if (list2 == null) {
            ExceptionUtil.$$$reportNull$$$0(49);
        }
        return list2;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledCloserExceptions(PsiElement place, @Nullable PsiElement topElement, PsiType type2) {
        List<PsiClassType> ex = type2 instanceof PsiClassType ? ExceptionUtil.getExceptionsFromClose(type2, place.getResolveScope()) : null;
        List<PsiClassType> list2 = ex != null ? ExceptionUtil.getUnhandledExceptions(place, topElement, PsiSubstitutor.EMPTY, ex.toArray(new PsiClassType[ex.size()])) : Collections.emptyList();
        if (list2 == null) {
            ExceptionUtil.$$$reportNull$$$0(50);
        }
        return list2;
    }

    private static List<PsiClassType> getExceptionsFromClose(PsiResourceListElement resource) {
        PsiType type2 = resource.getType();
        return type2 instanceof PsiClassType ? ExceptionUtil.getExceptionsFromClose(type2, resource.getResolveScope()) : null;
    }

    private static List<PsiClassType> getExceptionsFromClose(PsiType type2, GlobalSearchScope scope) {
        PsiClassType.ClassResolveResult resourceType = PsiUtil.resolveGenericsClassInType(type2);
        PsiClass resourceClass = resourceType.getElement();
        if (resourceClass == null) {
            return null;
        }
        PsiMethod[] methods2 = PsiUtil.getResourceCloserMethodsForType((PsiClassType)type2);
        if (methods2 != null) {
            List<PsiClassType> ex = null;
            for (PsiMethod method : methods2) {
                PsiSubstitutor substitutor2;
                PsiClass closerClass = method.getContainingClass();
                if (closerClass == null || (substitutor2 = TypeConversionUtil.getClassSubstitutor(closerClass, resourceClass, resourceType.getSubstitutor())) == null) continue;
                PsiClassType[] exceptionTypes = method.getThrowsList().getReferencedTypes();
                if (exceptionTypes.length == 0) {
                    return Collections.emptyList();
                }
                if (ex == null) {
                    ex = ExceptionUtil.collectSubstituted(substitutor2, exceptionTypes, scope);
                    continue;
                }
                ExceptionUtil.retainExceptions(ex, ExceptionUtil.collectSubstituted(substitutor2, exceptionTypes, scope));
            }
            return ex;
        }
        return null;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiThrowStatement throwStatement, @Nullable PsiElement topElement) {
        if (throwStatement == null) {
            ExceptionUtil.$$$reportNull$$$0(51);
        }
        SmartList<PsiClassType> unhandled = new SmartList<PsiClassType>();
        for (PsiType type2 : ExceptionUtil.getPreciseThrowTypes(throwStatement.getException())) {
            List<PsiType> types = type2 instanceof PsiDisjunctionType ? ((PsiDisjunctionType)type2).getDisjunctions() : Collections.singletonList(type2);
            for (PsiType subType : types) {
                PsiClassType classType;
                if (!(subType instanceof PsiClassType) || ExceptionUtil.isUncheckedException(classType = (PsiClassType)subType) || ExceptionUtil.isHandled(throwStatement, classType, topElement)) continue;
                unhandled.add(classType);
            }
        }
        SmartList<PsiClassType> smartList = unhandled;
        if (smartList == null) {
            ExceptionUtil.$$$reportNull$$$0(52);
        }
        return smartList;
    }

    @NotNull
    private static List<PsiType> getPreciseThrowTypes(@Nullable PsiExpression expression2) {
        PsiType type2;
        PsiElement target;
        if ((expression2 = PsiUtil.skipParenthesizedExprDown(expression2)) instanceof PsiReferenceExpression && (target = ((PsiReferenceExpression)expression2).resolve()) != null && PsiUtil.isCatchParameter(target)) {
            List<PsiType> list2 = ((PsiCatchSection)target.getParent()).getPreciseCatchTypes();
            if (list2 == null) {
                ExceptionUtil.$$$reportNull$$$0(53);
            }
            return list2;
        }
        if (expression2 != null && (type2 = expression2.getType()) != null) {
            List<PsiType> list3 = Collections.singletonList(type2);
            if (list3 == null) {
                ExceptionUtil.$$$reportNull$$$0(54);
            }
            return list3;
        }
        List<PsiType> list4 = Collections.emptyList();
        if (list4 == null) {
            ExceptionUtil.$$$reportNull$$$0(55);
        }
        return list4;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiMethod method, PsiElement element, PsiElement topElement, @NotNull PsiSubstitutor substitutor2) {
        if (method == null) {
            ExceptionUtil.$$$reportNull$$$0(56);
        }
        if (substitutor2 == null) {
            ExceptionUtil.$$$reportNull$$$0(57);
        }
        if (ExceptionUtil.isArrayClone(method, element)) {
            List<PsiClassType> list2 = Collections.emptyList();
            if (list2 == null) {
                ExceptionUtil.$$$reportNull$$$0(58);
            }
            return list2;
        }
        PsiClassType[] referencedTypes = method.getThrowsList().getReferencedTypes();
        List<PsiClassType> list3 = ExceptionUtil.getUnhandledExceptions(element, topElement, substitutor2, referencedTypes);
        if (list3 == null) {
            ExceptionUtil.$$$reportNull$$$0(59);
        }
        return list3;
    }

    private static List<PsiClassType> getUnhandledExceptions(PsiElement element, PsiElement topElement, PsiSubstitutor substitutor2, PsiClassType[] referencedTypes) {
        if (referencedTypes.length > 0) {
            ArrayList<PsiClassType> result2 = ContainerUtil.newArrayList();
            for (PsiClassType referencedType : referencedTypes) {
                PsiType type2 = PsiClassImplUtil.correctType(GenericsUtil.eliminateWildcards(substitutor2.substitute(referencedType), false), element.getResolveScope());
                if (!(type2 instanceof PsiClassType)) continue;
                PsiClassType classType = (PsiClassType)type2;
                PsiClass exceptionClass = ((PsiClassType)type2).resolve();
                if (exceptionClass == null || ExceptionUtil.isUncheckedException(classType) || ExceptionUtil.isHandled(element, classType, topElement)) continue;
                result2.add((PsiClassType)type2);
            }
            return result2;
        }
        return Collections.emptyList();
    }

    private static boolean isArrayClone(@NotNull PsiMethod method, PsiElement element) {
        if (method == null) {
            ExceptionUtil.$$$reportNull$$$0(60);
        }
        if (!method.getName().equals("clone")) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null || !"java.lang.Object".equals(containingClass.getQualifiedName())) {
            return false;
        }
        if (element instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression methodCallExpression = (PsiMethodReferenceExpression)element;
            PsiExpression qualifierExpression = methodCallExpression.getQualifierExpression();
            return qualifierExpression != null && qualifierExpression.getType() instanceof PsiArrayType;
        }
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
        PsiExpression qualifierExpression = methodCallExpression.getMethodExpression().getQualifierExpression();
        return qualifierExpression != null && qualifierExpression.getType() instanceof PsiArrayType;
    }

    public static boolean isUncheckedException(@NotNull PsiClassType type2) {
        if (type2 == null) {
            ExceptionUtil.$$$reportNull$$$0(61);
        }
        return InheritanceUtil.isInheritor(type2, "java.lang.RuntimeException") || InheritanceUtil.isInheritor(type2, "java.lang.Error");
    }

    public static boolean isUncheckedExceptionOrSuperclass(@NotNull PsiClassType type2) {
        if (type2 == null) {
            ExceptionUtil.$$$reportNull$$$0(63);
        }
        return ExceptionUtil.isGeneralExceptionType(type2) || ExceptionUtil.isUncheckedException(type2);
    }

    public static boolean isGeneralExceptionType(@NotNull PsiType type2) {
        String canonicalText;
        if (type2 == null) {
            ExceptionUtil.$$$reportNull$$$0(64);
        }
        return "java.lang.Throwable".equals(canonicalText = type2.getCanonicalText()) || "java.lang.Exception".equals(canonicalText);
    }

    private static boolean isHandled(@Nullable PsiElement element, @NotNull PsiClassType exceptionType, PsiElement topElement) {
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(67);
        }
        if (element == null || element.getParent() == topElement || element.getParent() == null) {
            return false;
        }
        PsiElement parent2 = element.getParent();
        if (parent2 instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent2;
            return ExceptionUtil.isHandledByMethodThrowsClause(method, exceptionType);
        }
        if (parent2 instanceof PsiClass) {
            return parent2 instanceof PsiAnonymousClass && ExceptionUtil.isHandled(parent2, exceptionType, topElement);
        }
        if (parent2 instanceof PsiLambdaExpression || parent2 instanceof PsiMethodReferenceExpression && element == ((PsiMethodReferenceExpression)parent2).getReferenceNameElement()) {
            PsiType interfaceType = ((PsiFunctionalExpression)parent2).getFunctionalInterfaceType();
            return ExceptionUtil.isDeclaredBySAMMethod(exceptionType, interfaceType);
        }
        if (parent2 instanceof PsiClassInitializer) {
            if (((PsiClassInitializer)parent2).hasModifierProperty("static")) {
                return false;
            }
            if (!(parent2.getParent() instanceof PsiAnonymousClass)) {
                PsiClass aClass2 = ((PsiClassInitializer)parent2).getContainingClass();
                return ExceptionUtil.areAllConstructorsThrow(aClass2, exceptionType);
            }
        } else if (parent2 instanceof PsiTryStatement) {
            PsiTryStatement tryStatement = (PsiTryStatement)parent2;
            if (tryStatement.getTryBlock() == element && ExceptionUtil.isCaught(tryStatement, exceptionType)) {
                return true;
            }
            if (tryStatement.getResourceList() == element && ExceptionUtil.isCaught(tryStatement, exceptionType)) {
                return true;
            }
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (element instanceof PsiCatchSection && finallyBlock != null && ExceptionUtil.blockCompletesAbruptly(finallyBlock)) {
                return true;
            }
        } else {
            if (parent2 instanceof JavaCodeFragment) {
                JavaCodeFragment codeFragment = (JavaCodeFragment)parent2;
                JavaCodeFragment.ExceptionHandler exceptionHandler = codeFragment.getExceptionHandler();
                return exceptionHandler != null && exceptionHandler.isHandledException(exceptionType);
            }
            if (PsiImplUtil.isInServerPage(parent2) && parent2 instanceof PsiFile) {
                return true;
            }
            if (parent2 instanceof PsiFile) {
                return false;
            }
            if (parent2 instanceof PsiField && ((PsiField)parent2).getInitializer() == element) {
                PsiClass aClass3 = ((PsiField)parent2).getContainingClass();
                if (aClass3 != null && !(aClass3 instanceof PsiAnonymousClass) && !((PsiField)parent2).hasModifierProperty("static")) {
                    return ExceptionUtil.areAllConstructorsThrow(aClass3, exceptionType);
                }
            } else {
                for (CustomExceptionHandler exceptionHandler : Extensions.getExtensions(CustomExceptionHandler.KEY)) {
                    if (!exceptionHandler.isHandled(element, exceptionType, topElement)) continue;
                    return true;
                }
            }
        }
        return ExceptionUtil.isHandled(parent2, exceptionType, topElement);
    }

    private static boolean isDeclaredBySAMMethod(@NotNull PsiClassType exceptionType, @Nullable PsiType interfaceType) {
        PsiClassType.ClassResolveResult resolveResult;
        PsiMethod interfaceMethod;
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(68);
        }
        if (interfaceType != null && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult = PsiUtil.resolveGenericsClassInType(interfaceType))) != null) {
            return ExceptionUtil.isHandledByMethodThrowsClause(interfaceMethod, exceptionType, LambdaUtil.getSubstitutor(interfaceMethod, resolveResult));
        }
        return true;
    }

    private static boolean areAllConstructorsThrow(@Nullable PsiClass aClass2, @NotNull PsiClassType exceptionType) {
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(69);
        }
        if (aClass2 == null) {
            return false;
        }
        PsiMethod[] constructors2 = aClass2.getConstructors();
        boolean thrown = constructors2.length != 0;
        for (PsiMethod constructor : constructors2) {
            if (ExceptionUtil.isHandledByMethodThrowsClause(constructor, exceptionType)) continue;
            thrown = false;
            break;
        }
        return thrown;
    }

    private static boolean isCaught(@NotNull PsiTryStatement tryStatement, @NotNull PsiClassType exceptionType) {
        PsiParameter[] catchBlockParameters;
        PsiCodeBlock finallyBlock;
        if (tryStatement == null) {
            ExceptionUtil.$$$reportNull$$$0(70);
        }
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(71);
        }
        if ((finallyBlock = tryStatement.getFinallyBlock()) != null && ExceptionUtil.blockCompletesAbruptly(finallyBlock)) {
            return true;
        }
        for (PsiParameter parameter : catchBlockParameters = tryStatement.getCatchBlockParameters()) {
            PsiType paramType = parameter.getType();
            if (!paramType.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }

    private static boolean blockCompletesAbruptly(@NotNull PsiCodeBlock finallyBlock) {
        if (finallyBlock == null) {
            ExceptionUtil.$$$reportNull$$$0(72);
        }
        try {
            ControlFlow flow = ControlFlowFactory.getInstance(finallyBlock.getProject()).getControlFlow(finallyBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
            int completionReasons = ControlFlowUtil.getCompletionReasons(flow, 0, flow.getSize());
            if (!BitUtil.isSet(completionReasons, 1)) {
                return true;
            }
        }
        catch (AnalysisCanceledException e) {
            return true;
        }
        return false;
    }

    private static boolean isHandledByMethodThrowsClause(@NotNull PsiMethod method, @NotNull PsiClassType exceptionType) {
        if (method == null) {
            ExceptionUtil.$$$reportNull$$$0(73);
        }
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(74);
        }
        return ExceptionUtil.isHandledByMethodThrowsClause(method, exceptionType, PsiSubstitutor.EMPTY);
    }

    private static boolean isHandledByMethodThrowsClause(@NotNull PsiMethod method, @NotNull PsiClassType exceptionType, PsiSubstitutor substitutor2) {
        if (method == null) {
            ExceptionUtil.$$$reportNull$$$0(75);
        }
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(76);
        }
        PsiClassType[] referencedTypes = method.getThrowsList().getReferencedTypes();
        return ExceptionUtil.isHandledBy(exceptionType, referencedTypes, substitutor2);
    }

    public static boolean isHandledBy(@NotNull PsiClassType exceptionType, @NotNull PsiClassType[] referencedTypes, PsiSubstitutor substitutor2) {
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(79);
        }
        if (referencedTypes == null) {
            ExceptionUtil.$$$reportNull$$$0(80);
        }
        for (PsiClassType classType : referencedTypes) {
            PsiType psiType = substitutor2.substitute(classType);
            if (psiType == null || !psiType.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ Pair lambda$getUnhandledExceptions$0(PsiMethod method, CandidateInfo info) {
        PsiElement element1 = info.getElement();
        if (info instanceof MethodCandidateInfo && element1 != method && MethodSignatureUtil.areSignaturesEqual(method, (PsiMethod)element1) && !MethodSignatureUtil.isSuperMethod((PsiMethod)element1, method) && (!((MethodCandidateInfo)info).isToInferApplicability() || ((MethodCandidateInfo)info).isApplicable())) {
            return Pair.create((PsiMethod)element1, ((MethodCandidateInfo)info).getSubstitutor(false));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 58: 
            case 59: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 58: 
            case 59: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 58: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/ExceptionUtil";
                break;
            }
            case 5: 
            case 20: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 7: 
            case 11: 
            case 22: 
            case 24: 
            case 26: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tryStatement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 14: 
            case 56: 
            case 60: 
            case 73: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 15: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReferenceExpression";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorBody";
                break;
            }
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwStatement";
                break;
            }
            case 61: 
            case 63: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 74: 
            case 76: 
            case 77: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionType";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwPlace";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finallyBlock";
                break;
            }
            case 78: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/ExceptionUtil";
                break;
            }
            case 1: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrownExceptions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrownCheckedExceptions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOutUncheckedExceptions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTryExceptions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionsByMethodAndChildren";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionsByMethod";
                break;
            }
            case 23: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUnhandledExceptions";
                break;
            }
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 52: 
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnhandledExceptions";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getCloserExceptions";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnhandledCloserExceptions";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreciseThrowTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getThrownExceptions";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 58: 
            case 59: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getThrownCheckedExceptions";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "filterOutUncheckedExceptions";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTryExceptions";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getExceptionsByMethodAndChildren";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getExceptionsByMethod";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addExceptions";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addException";
                break;
            }
            case 22: 
            case 24: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "collectUnhandledExceptions";
                break;
            }
            case 27: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 51: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getUnhandledExceptions";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "firstStatementIsConstructorCall";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getCloserExceptions";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getUnhandledCloserExceptions";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "isArrayClone";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "isUncheckedException";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "isUncheckedExceptionOrSuperclass";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "isGeneralExceptionType";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isHandled";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "isDeclaredBySAMMethod";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "areAllConstructorsThrow";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "isCaught";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "blockCompletesAbruptly";
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "isHandledByMethodThrowsClause";
                break;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "isHandledBy";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "sortExceptionsByHierarchy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 58: 
            case 59: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

