/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.util.io.DataOutputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.load.kotlin.JvmMetadataVersion;
import org.jetbrains.kotlin.load.kotlin.ModuleMapping;
import org.jetbrains.kotlin.load.kotlin.PackageParts;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCache;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.jvm.JvmModuleProtoBuf;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003*\b\u0012\u0004\u0012\u00020\b0\u0001\u001a\u0010\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0003*\u00020\n\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\r\u00a8\u0006\u000e"}, d2={"addCompiledParts", "", "Lorg/jetbrains/kotlin/load/kotlin/PackageParts;", "", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "addCompiledPartsAndSort", "filterClassFiles", "Lorg/jetbrains/kotlin/backend/common/output/OutputFile;", "getClassFiles", "Lorg/jetbrains/kotlin/codegen/ClassFileFactory;", "serializeToByteArray", "", "Lorg/jetbrains/kotlin/serialization/jvm/JvmModuleProtoBuf$Module;", "backend"})
public final class ClassFileUtilsKt {
    @NotNull
    public static final Iterable<OutputFile> getClassFiles(@NotNull ClassFileFactory $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        List<OutputFile> list2 = $receiver.asList();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"asList()");
        return ClassFileUtilsKt.filterClassFiles(list2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Iterable<OutputFile> filterClassFiles(@NotNull List<? extends OutputFile> $receiver) {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Iterable iterable = $receiver$iv = (Iterable)$receiver;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            OutputFile it = (OutputFile)element$iv$iv;
            if (!StringsKt.endsWith$default((String)it.getRelativePath(), (String)".class", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)var3_3;
    }

    @NotNull
    public static final List<PackageParts> addCompiledPartsAndSort(@NotNull Iterable<PackageParts> $receiver, @NotNull GenerationState state2) {
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)state2, (String)"state");
        Iterable iterable = $receiver$iv = (Iterable)ClassFileUtilsKt.addCompiledParts($receiver, state2);
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                PackageParts it = (PackageParts)a;
                Comparable comparable = (Comparable)((Object)it.getPackageFqName());
                it = (PackageParts)b;
                Comparable comparable2 = comparable;
                String string = it.getPackageFqName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        };
        return CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<PackageParts> addCompiledParts(@NotNull Iterable<PackageParts> $receiver, GenerationState state2) {
        Object $receiver$iv$iv;
        IncrementalCache incrementalCache = state2.getIncrementalCacheForThisTarget();
        if (incrementalCache == null) {
            return CollectionsKt.toList($receiver);
        }
        IncrementalCache incrementalCache2 = incrementalCache;
        byte[] byArray = incrementalCache2.getModuleMappingData();
        if (byArray == null) {
            return CollectionsKt.toList($receiver);
        }
        byte[] moduleMappingData = byArray;
        ModuleMapping mapping2 = ModuleMapping.Companion.create(moduleMappingData, "<incremental>", state2.getDeserializationConfiguration());
        Object $receiver$iv = incrementalCache2.getObsoletePackageParts();
        Object object = $receiver$iv.iterator();
        while (object.hasNext()) {
            String qualifier;
            Object element$iv = object.next();
            String internalName = (String)element$iv;
            JvmClassName jvmClassName = JvmClassName.byInternalName(internalName);
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"JvmClassName.byInternalName(internalName)");
            String string = qualifier = jvmClassName.getPackageFqName().asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"qualifier");
            PackageParts packageParts = mapping2.findPackageParts(string);
            if (packageParts == null) continue;
            packageParts.removePart(internalName);
        }
        $receiver$iv = CollectionsKt.plus($receiver, (Iterable)mapping2.getPackageFqName2Parts().values());
        object = $receiver$iv;
        Object destination$iv$iv = new LinkedHashMap();
        Object object2 = $receiver$iv$iv.iterator();
        while (object2.hasNext()) {
            Object object3;
            Object $receiver$iv$iv$iv = destination$iv$iv;
            Object element$iv$iv = object2.next();
            PackageParts it = (PackageParts)element$iv$iv;
            String key$iv$iv = it.getPackageFqName();
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object3;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList($receiver$iv.size());
        object2 = $receiver$iv$iv;
        Iterator iterator2 = object2.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $packageFqName_allOldPackageParts;
            Map.Entry item$iv$iv;
            Map.Entry $i$a$2$groupBy = item$iv$iv = iterator2.next();
            Object object4 = destination$iv$iv;
            PackageParts packageParts = $packageFqName_allOldPackageParts;
            String packageFqName = (String)packageParts.getKey();
            packageParts = $packageFqName_allOldPackageParts;
            List allOldPackageParts = (List)packageParts.getValue();
            PackageParts $receiver2 = packageParts = new PackageParts(packageFqName);
            Iterable $receiver$iv2 = allOldPackageParts;
            for (Object element$iv : $receiver$iv2) {
                PackageParts packageParts2 = (PackageParts)element$iv;
                $receiver2.plusAssign(packageParts2);
            }
            PackageParts packageParts3 = packageParts;
            object4.add(packageParts3);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final byte[] serializeToByteArray(@NotNull JvmModuleProtoBuf.Module $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ByteArrayOutputStream moduleMapping = new ByteArrayOutputStream(4096);
        DataOutputStream out = new DataOutputStream(moduleMapping);
        int[] version = JvmMetadataVersion.INSTANCE.toArray();
        out.writeInt(version.length);
        for (int number : version) {
            out.writeInt(number);
        }
        $receiver.writeTo(out);
        out.flush();
        byte[] byArray = moduleMapping.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"moduleMapping.toByteArray()");
        return byArray;
    }
}

