/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.snapshots;

import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.snapshots.FileSnapshot;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/incremental/snapshots/FileSnapshotExternalizer;", "Lcom/intellij/util/io/DataExternalizer;", "Lorg/jetbrains/kotlin/incremental/snapshots/FileSnapshot;", "()V", "read", "input", "Ljava/io/DataInput;", "save", "", "out", "Ljava/io/DataOutput;", "value", "incremental-compilation-impl"})
public final class FileSnapshotExternalizer
implements DataExternalizer<FileSnapshot> {
    public static final FileSnapshotExternalizer INSTANCE;

    @Override
    public void save(@NotNull DataOutput out, @NotNull FileSnapshot value) {
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        out.writeUTF(value.getFile().getCanonicalPath());
        out.writeLong(value.getLength());
        out.writeInt(value.getHash().length);
        out.write(value.getHash());
    }

    @Override
    @NotNull
    public FileSnapshot read(@NotNull DataInput input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        File file2 = new File(input.readUTF());
        long length = input.readLong();
        int hashSize = input.readInt();
        byte[] hash = new byte[hashSize];
        input.readFully(hash);
        return new FileSnapshot(file2, length, hash);
    }

    private FileSnapshotExternalizer() {
    }

    static {
        FileSnapshotExternalizer fileSnapshotExternalizer;
        INSTANCE = fileSnapshotExternalizer = new FileSnapshotExternalizer();
    }
}

