/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl;

import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.JavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.JavaValueParameter;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementCollectionFromPsiArrayUtil;
import org.jetbrains.kotlin.load.java.structure.impl.JavaMemberImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaTypeImpl;
import org.jetbrains.kotlin.name.Name;

public class JavaMethodImpl
extends JavaMemberImpl<PsiMethod>
implements JavaMethod {
    public JavaMethodImpl(@NotNull PsiMethod psiMethod) {
        super(psiMethod);
        assert (!psiMethod.isConstructor()) : "PsiMethod which is a constructor should be wrapped in JavaConstructorImpl: " + psiMethod.getName();
    }

    @Override
    @NotNull
    public Name getName() {
        return Name.identifier(((PsiMethod)this.getPsi()).getName());
    }

    @Override
    @NotNull
    public List<JavaTypeParameter> getTypeParameters() {
        return JavaElementCollectionFromPsiArrayUtil.typeParameters(((PsiMethod)this.getPsi()).getTypeParameters());
    }

    @Override
    @NotNull
    public List<JavaValueParameter> getValueParameters() {
        return JavaElementCollectionFromPsiArrayUtil.valueParameters(((PsiMethod)this.getPsi()).getParameterList().getParameters());
    }

    @Override
    public boolean getHasAnnotationParameterDefaultValue() {
        PsiMethod psiMethod = (PsiMethod)this.getPsi();
        return psiMethod instanceof PsiAnnotationMethod && ((PsiAnnotationMethod)psiMethod).getDefaultValue() != null;
    }

    @Override
    @NotNull
    public JavaType getReturnType() {
        PsiType psiType = ((PsiMethod)this.getPsi()).getReturnType();
        assert (psiType != null) : "Method is not a constructor and has no return type: " + this.getName();
        return JavaTypeImpl.create(psiType);
    }
}

