/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.impl.IrErrorDeclarationImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrPropertyImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrTypeAliasImpl;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.KotlinUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.AnonymousInitializerGenerator;
import org.jetbrains.kotlin.psi2ir.generators.ClassGenerator;
import org.jetbrains.kotlin.psi2ir.generators.DeclarationGeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.FunctionGenerator;
import org.jetbrains.kotlin.psi2ir.generators.Generator;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorContext;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.PropertyGenerator;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010)\u001a\u00020\b2\u0006\u0010\t\u001a\u00020*J\u001c\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020100R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/DeclarationGenerator;", "Lorg/jetbrains/kotlin/psi2ir/generators/Generator;", "context", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "(Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;)V", "getContext", "()Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "generateClassMemberDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "ktDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "generateClassOrObjectDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "ktClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "generateEnumEntryDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "ktEnumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "generateFakeOverrideDeclaration", "memberDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "ktElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "generateFakeOverrideFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "generateFakeOverrideProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "generateInitializerBody", "Lorg/jetbrains/kotlin/ir/expressions/IrExpressionBody;", "scopeOwnerSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "ktBody", "Lorg/jetbrains/kotlin/psi/KtExpression;", "generateMemberDeclaration", "generateTypeAliasDeclaration", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "generateTypeParameterDeclarations", "", "irTypeParametersOwner", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParametersContainer;", "from", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "ir.psi2ir"})
public final class DeclarationGenerator
implements Generator {
    @NotNull
    private final GeneratorContext context;

    @NotNull
    public final IrDeclaration generateMemberDeclaration(@NotNull KtDeclaration ktDeclaration) {
        IrDeclaration irDeclaration;
        Intrinsics.checkParameterIsNotNull((Object)ktDeclaration, (String)"ktDeclaration");
        KtDeclaration ktDeclaration2 = ktDeclaration;
        if (ktDeclaration2 instanceof KtNamedFunction) {
            irDeclaration = new FunctionGenerator(this).generateFunctionDeclaration((KtNamedFunction)ktDeclaration);
        } else if (ktDeclaration2 instanceof KtProperty) {
            irDeclaration = new PropertyGenerator(this).generatePropertyDeclaration((KtProperty)ktDeclaration);
        } else if (ktDeclaration2 instanceof KtClassOrObject) {
            irDeclaration = this.generateClassOrObjectDeclaration((KtClassOrObject)ktDeclaration);
        } else if (ktDeclaration2 instanceof KtTypeAlias) {
            irDeclaration = this.generateTypeAliasDeclaration((KtTypeAlias)ktDeclaration);
        } else {
            int n = PsiUtilsKt.getStartOffset(ktDeclaration);
            int n2 = PsiUtilsKt.getEndOffset(ktDeclaration);
            ReadOnlySlice<PsiElement, DeclarationDescriptor> readOnlySlice = BindingContext.DECLARATION_TO_DESCRIPTOR;
            Intrinsics.checkExpressionValueIsNotNull(readOnlySlice, (String)"BindingContext.DECLARATION_TO_DESCRIPTOR");
            DeclarationDescriptor declarationDescriptor = GeneratorKt.getOrFail(this, readOnlySlice, ktDeclaration);
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"getOrFail(BindingContext\u2026ESCRIPTOR, ktDeclaration)");
            irDeclaration = new IrErrorDeclarationImpl(n, n2, declarationDescriptor);
        }
        return irDeclaration;
    }

    @NotNull
    public final IrDeclaration generateClassMemberDeclaration(@NotNull KtDeclaration ktDeclaration, @NotNull ClassDescriptor classDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)ktDeclaration, (String)"ktDeclaration");
        Intrinsics.checkParameterIsNotNull((Object)classDescriptor, (String)"classDescriptor");
        KtDeclaration ktDeclaration2 = ktDeclaration;
        return ktDeclaration2 instanceof KtAnonymousInitializer ? new AnonymousInitializerGenerator(this).generateAnonymousInitializerDeclaration((KtAnonymousInitializer)ktDeclaration, classDescriptor) : (ktDeclaration2 instanceof KtSecondaryConstructor ? (IrDeclaration)new FunctionGenerator(this).generateSecondaryConstructor((KtSecondaryConstructor)ktDeclaration) : (ktDeclaration2 instanceof KtEnumEntry ? (IrDeclaration)this.generateEnumEntryDeclaration((KtEnumEntry)ktDeclaration) : this.generateMemberDeclaration(ktDeclaration)));
    }

    private final IrEnumEntry generateEnumEntryDeclaration(KtEnumEntry ktEnumEntry) {
        return new ClassGenerator(this).generateEnumEntry(ktEnumEntry);
    }

    @NotNull
    public final IrClass generateClassOrObjectDeclaration(@NotNull KtClassOrObject ktClassOrObject) {
        Intrinsics.checkParameterIsNotNull((Object)ktClassOrObject, (String)"ktClassOrObject");
        return new ClassGenerator(this).generateClass(ktClassOrObject);
    }

    @NotNull
    public final IrDeclaration generateTypeAliasDeclaration(@NotNull KtTypeAlias ktDeclaration) {
        Intrinsics.checkParameterIsNotNull((Object)ktDeclaration, (String)"ktDeclaration");
        int n = PsiUtilsKt.getStartOffset(ktDeclaration);
        int n2 = PsiUtilsKt.getEndOffset(ktDeclaration);
        IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.DEFINED.INSTANCE;
        WritableSlice<PsiElement, TypeAliasDescriptor> writableSlice = BindingContext.TYPE_ALIAS;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice, (String)"BindingContext.TYPE_ALIAS");
        Object v = GeneratorKt.getOrFail(this, writableSlice, ktDeclaration);
        Intrinsics.checkExpressionValueIsNotNull(v, (String)"getOrFail(BindingContext\u2026YPE_ALIAS, ktDeclaration)");
        return new IrTypeAliasImpl(n, n2, irDeclarationOrigin, (TypeAliasDescriptor)v);
    }

    /*
     * WARNING - void declaration
     */
    public final void generateTypeParameterDeclarations(@NotNull IrTypeParametersContainer irTypeParametersOwner, @NotNull List<? extends TypeParameterDescriptor> from) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)irTypeParametersOwner, (String)"irTypeParametersOwner");
        Intrinsics.checkParameterIsNotNull(from, (String)"from");
        Iterable iterable = from;
        Collection destination$iv = irTypeParametersOwner.getTypeParameters();
        for (Object item$iv : $receiver$iv) {
            void typeParameterDescriptor;
            TypeParameterDescriptor typeParameterDescriptor2 = (TypeParameterDescriptor)item$iv;
            Collection collection = destination$iv;
            PsiElement ktTypeParameterDeclaration = DescriptorToSourceUtils.getSourceFromDescriptor((DeclarationDescriptor)typeParameterDescriptor);
            int startOffset = KotlinUtilsKt.getStartOffsetOrUndefined(ktTypeParameterDeclaration);
            int endOffset = KotlinUtilsKt.getEndOffsetOrUndefined(ktTypeParameterDeclaration);
            IrTypeParameter irTypeParameter = this.getContext().getSymbolTable().declareTypeParameter(startOffset, endOffset, IrDeclarationOrigin.DEFINED.INSTANCE, (TypeParameterDescriptor)typeParameterDescriptor);
            collection.add(irTypeParameter);
        }
    }

    @NotNull
    public final IrExpressionBody generateInitializerBody(@NotNull IrSymbol scopeOwnerSymbol, @NotNull KtExpression ktBody) {
        Intrinsics.checkParameterIsNotNull((Object)scopeOwnerSymbol, (String)"scopeOwnerSymbol");
        Intrinsics.checkParameterIsNotNull((Object)ktBody, (String)"ktBody");
        return DeclarationGeneratorKt.createBodyGenerator(this, scopeOwnerSymbol).generateExpressionBody(ktBody);
    }

    @NotNull
    public final IrDeclaration generateFakeOverrideDeclaration(@NotNull CallableMemberDescriptor memberDescriptor, @NotNull KtElement ktElement) {
        IrDeclaration irDeclaration;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)memberDescriptor, (String)"memberDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)ktElement, (String)"ktElement");
        boolean bl2 = bl = memberDescriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE;
        if (_Assertions.ENABLED && !bl) {
            String string = "Fake override expected: " + memberDescriptor;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        CallableMemberDescriptor callableMemberDescriptor = memberDescriptor;
        if (callableMemberDescriptor instanceof FunctionDescriptor) {
            irDeclaration = this.generateFakeOverrideFunction((FunctionDescriptor)memberDescriptor, ktElement);
        } else if (callableMemberDescriptor instanceof PropertyDescriptor) {
            irDeclaration = this.generateFakeOverrideProperty((PropertyDescriptor)memberDescriptor, ktElement);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected member descriptor: " + memberDescriptor)));
        }
        return irDeclaration;
    }

    private final IrProperty generateFakeOverrideProperty(PropertyDescriptor propertyDescriptor, KtElement ktElement) {
        IrFunction irFunction;
        IrFunction irFunction2;
        IrFunction irFunction3;
        PropertyAccessorDescriptor it;
        int n;
        int n2;
        IrDeclarationOrigin irDeclarationOrigin;
        boolean bl;
        PropertyDescriptor propertyDescriptor2;
        IrField irField;
        PropertyAccessorDescriptor propertyAccessorDescriptor;
        int n3 = KotlinUtilsKt.getStartOffsetOrUndefined(ktElement);
        int n4 = KotlinUtilsKt.getEndOffsetOrUndefined(ktElement);
        IrDeclarationOrigin irDeclarationOrigin2 = IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE;
        boolean bl2 = false;
        PropertyDescriptor propertyDescriptor3 = propertyDescriptor;
        IrField irField2 = propertyDescriptor.getGetter() == null ? this.getContext().getSymbolTable().declareField(KotlinUtilsKt.getStartOffsetOrUndefined(ktElement), KotlinUtilsKt.getEndOffsetOrUndefined(ktElement), IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE, propertyDescriptor) : null;
        PropertyGetterDescriptor propertyGetterDescriptor = propertyDescriptor.getGetter();
        if (propertyGetterDescriptor != null) {
            propertyAccessorDescriptor = propertyGetterDescriptor;
            irField = irField2;
            propertyDescriptor2 = propertyDescriptor3;
            bl = bl2;
            irDeclarationOrigin = irDeclarationOrigin2;
            n2 = n4;
            n = n3;
            PropertyAccessorDescriptor propertyAccessorDescriptor2 = it = propertyAccessorDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)propertyAccessorDescriptor2, (String)"it");
            irFunction3 = this.generateFakeOverrideFunction(propertyAccessorDescriptor2, ktElement);
            n3 = n;
            n4 = n2;
            irDeclarationOrigin2 = irDeclarationOrigin;
            bl2 = bl;
            propertyDescriptor3 = propertyDescriptor2;
            irField2 = irField;
            irFunction2 = irFunction3;
        } else {
            irFunction2 = null;
        }
        PropertySetterDescriptor propertySetterDescriptor = propertyDescriptor.getSetter();
        if (propertySetterDescriptor != null) {
            propertyAccessorDescriptor = propertySetterDescriptor;
            irFunction3 = irFunction2;
            irField = irField2;
            propertyDescriptor2 = propertyDescriptor3;
            bl = bl2;
            irDeclarationOrigin = irDeclarationOrigin2;
            n2 = n4;
            n = n3;
            PropertyAccessorDescriptor propertyAccessorDescriptor3 = it = propertyAccessorDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)propertyAccessorDescriptor3, (String)"it");
            IrFunction irFunction4 = this.generateFakeOverrideFunction(propertyAccessorDescriptor3, ktElement);
            n3 = n;
            n4 = n2;
            irDeclarationOrigin2 = irDeclarationOrigin;
            bl2 = bl;
            propertyDescriptor3 = propertyDescriptor2;
            irField2 = irField;
            irFunction2 = irFunction3;
            irFunction = irFunction4;
        } else {
            irFunction = null;
        }
        IrFunction irFunction5 = irFunction;
        IrFunction irFunction6 = irFunction2;
        IrField irField3 = irField2;
        PropertyDescriptor propertyDescriptor4 = propertyDescriptor3;
        boolean bl3 = bl2;
        IrDeclarationOrigin irDeclarationOrigin3 = irDeclarationOrigin2;
        int n5 = n4;
        int n6 = n3;
        return new IrPropertyImpl(n6, n5, irDeclarationOrigin3, bl3, propertyDescriptor4, irField3, irFunction6, irFunction5);
    }

    private final IrFunction generateFakeOverrideFunction(FunctionDescriptor functionDescriptor, KtElement ktElement) {
        return new FunctionGenerator(this).generateFakeOverrideFunction(functionDescriptor, ktElement);
    }

    @Override
    @NotNull
    public GeneratorContext getContext() {
        return this.context;
    }

    public DeclarationGenerator(@NotNull GeneratorContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }
}

