/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.modules;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.modules.JavaModuleGraph;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModule;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModuleResolver;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\u0010\tJ&\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u0015\u0010\u0014\u001a\u00020\u0015*\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u000eH\u0082\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/modules/CliJavaModuleResolver;", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleResolver;", "moduleGraph", "Lorg/jetbrains/kotlin/cli/jvm/modules/JavaModuleGraph;", "userModules", "", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule;", "systemModules", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule$Explicit;", "(Lorg/jetbrains/kotlin/cli/jvm/modules/JavaModuleGraph;Ljava/util/List;Ljava/util/List;)V", "sourceModule", "checkAccessibility", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleResolver$AccessError;", "fileFromOurModule", "Lcom/intellij/openapi/vfs/VirtualFile;", "referencedFile", "referencedPackage", "Lorg/jetbrains/kotlin/name/FqName;", "findJavaModule", "file", "contains", "", "cli"})
public final class CliJavaModuleResolver
implements JavaModuleResolver {
    private final JavaModule sourceModule;
    private final JavaModuleGraph moduleGraph;
    private final List<JavaModule> userModules;
    private final List<JavaModule.Explicit> systemModules;

    private final JavaModule findJavaModule(VirtualFile file2) {
        JavaModule javaModule;
        VirtualFileSystem virtualFileSystem = file2.getFileSystem();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileSystem, (String)"file.fileSystem");
        if (Intrinsics.areEqual((Object)virtualFileSystem.getProtocol(), (Object)"jrt")) {
            Object v1;
            block7: {
                Iterable $receiver$iv = this.systemModules;
                for (Object element$iv : $receiver$iv) {
                    JavaModule.Explicit module2 = (JavaModule.Explicit)element$iv;
                    if (!this.contains(module2, file2)) continue;
                    v1 = element$iv;
                    break block7;
                }
                v1 = null;
            }
            return v1;
        }
        FileType fileType = file2.getFileType();
        if (Intrinsics.areEqual((Object)fileType, (Object)KotlinFileType.INSTANCE) || Intrinsics.areEqual((Object)fileType, (Object)JavaFileType.INSTANCE)) {
            javaModule = this.sourceModule;
        } else if (Intrinsics.areEqual((Object)fileType, (Object)JavaClassFileType.INSTANCE)) {
            Object v3;
            block8: {
                Iterable $receiver$iv = this.userModules;
                for (Object element$iv : $receiver$iv) {
                    JavaModule module3 = (JavaModule)element$iv;
                    if (!this.contains(module3, file2)) continue;
                    v3 = element$iv;
                    break block8;
                }
                v3 = null;
            }
            javaModule = v3;
        } else {
            javaModule = null;
        }
        return javaModule;
    }

    private final boolean contains(@NotNull JavaModule $receiver, VirtualFile file2) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Iterable $receiver$iv = $receiver.getModuleRoots();
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    JavaModule.Root $root_isBinary = (JavaModule.Root)element$iv;
                    VirtualFile root2 = $root_isBinary.component1();
                    boolean isBinary = $root_isBinary.component2();
                    if (!(isBinary && VfsUtilCore.isAncestor(root2, file2, false))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @Nullable
    public JavaModuleResolver.AccessError checkAccessibility(@Nullable VirtualFile fileFromOurModule, @NotNull VirtualFile referencedFile, @Nullable FqName referencedPackage) {
        JavaModule javaModule;
        Intrinsics.checkParameterIsNotNull((Object)referencedFile, (String)"referencedFile");
        VirtualFile virtualFile2 = fileFromOurModule;
        if (virtualFile2 != null) {
            VirtualFile virtualFile3 = virtualFile2;
            CliJavaModuleResolver cliJavaModuleResolver = this;
            VirtualFile p1 = virtualFile3;
            javaModule = cliJavaModuleResolver.findJavaModule(p1);
        } else {
            javaModule = null;
        }
        JavaModule ourModule = javaModule;
        JavaModule theirModule = this.findJavaModule(referencedFile);
        JavaModule javaModule2 = ourModule;
        JavaModule javaModule3 = theirModule;
        if (Intrinsics.areEqual((Object)(javaModule2 != null ? javaModule2.getName() : null), (Object)(javaModule3 != null ? javaModule3.getName() : null))) {
            return null;
        }
        if (theirModule == null) {
            return JavaModuleResolver.AccessError.ModuleDoesNotReadUnnamedModule.INSTANCE;
        }
        if (ourModule != null && !this.moduleGraph.reads(ourModule.getName(), theirModule.getName())) {
            return new JavaModuleResolver.AccessError.ModuleDoesNotReadModule(theirModule.getName());
        }
        FqName fqName2 = referencedPackage;
        if (fqName2 == null) {
            return null;
        }
        FqName fqName3 = fqName2;
        if (!(theirModule.exports(fqName3) || ourModule != null && theirModule.exportsTo(fqName3, ourModule.getName()))) {
            return new JavaModuleResolver.AccessError.ModuleDoesNotExportPackage(theirModule.getName());
        }
        return null;
    }

    public CliJavaModuleResolver(@NotNull JavaModuleGraph moduleGraph, @NotNull List<? extends JavaModule> userModules, @NotNull List<JavaModule.Explicit> systemModules2) {
        Object v2;
        block5: {
            int n;
            Intrinsics.checkParameterIsNotNull((Object)moduleGraph, (String)"moduleGraph");
            Intrinsics.checkParameterIsNotNull(userModules, (String)"userModules");
            Intrinsics.checkParameterIsNotNull(systemModules2, (String)"systemModules");
            this.moduleGraph = moduleGraph;
            this.userModules = userModules;
            this.systemModules = systemModules2;
            Iterable $receiver$iv = this.userModules;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $receiver$iv) {
                    Object receiver = element$iv;
                    if (!((JavaModule)receiver).isSourceModule()) continue;
                    ++count$iv;
                }
                n = count$iv;
            }
            boolean bl = $receiver$iv = n <= 1;
            if (_Assertions.ENABLED && !$receiver$iv) {
                String string = "Modules computed by ClasspathRootsResolver cannot have more than one source module: " + this.userModules;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            $receiver$iv = this.userModules;
            CliJavaModuleResolver cliJavaModuleResolver = this;
            for (Object element$iv : $receiver$iv) {
                Object receiver = element$iv;
                if (!((JavaModule)receiver).isSourceModule()) continue;
                v2 = element$iv;
                break block5;
            }
            v2 = null;
        }
        Object var11_13 = v2;
        cliJavaModuleResolver.sourceModule = var11_13;
    }
}

