/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.Queue;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Substitutable;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtInitializerList;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.AnalyzerExtensions;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.BodyResolveCache;
import org.jetbrains.kotlin.resolve.ControlFlowAnalyzer;
import org.jetbrains.kotlin.resolve.DeclarationsChecker;
import org.jetbrains.kotlin.resolve.DelegatedPropertyResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.ObservableBindingTrace;
import org.jetbrains.kotlin.resolve.OverloadChecker;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeImpl;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.scopes.ScopeUtils;
import org.jetbrains.kotlin.resolve.scopes.TraceBasedLocalRedeclarationChecker;
import org.jetbrains.kotlin.types.DeferredType;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.PreliminaryDeclarationVisitor;
import org.jetbrains.kotlin.types.expressions.ValueParameterResolver;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.util.Box;
import org.jetbrains.kotlin.util.ReenteringLazyValueComputationException;

public class BodyResolver {
    @NotNull
    private final Project project;
    @NotNull
    private final AnnotationChecker annotationChecker;
    @NotNull
    private final ExpressionTypingServices expressionTypingServices;
    @NotNull
    private final CallResolver callResolver;
    @NotNull
    private final ObservableBindingTrace trace;
    @NotNull
    private final ControlFlowAnalyzer controlFlowAnalyzer;
    @NotNull
    private final DeclarationsChecker declarationsChecker;
    @NotNull
    private final AnnotationResolver annotationResolver;
    @NotNull
    private final DelegatedPropertyResolver delegatedPropertyResolver;
    @NotNull
    private final AnalyzerExtensions analyzerExtensions;
    @NotNull
    private final ValueParameterResolver valueParameterResolver;
    @NotNull
    private final BodyResolveCache bodyResolveCache;
    @NotNull
    private final KotlinBuiltIns builtIns;
    @NotNull
    private final OverloadChecker overloadChecker;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;

    public BodyResolver(@NotNull Project project, @NotNull AnnotationResolver annotationResolver, @NotNull BodyResolveCache bodyResolveCache, @NotNull CallResolver callResolver, @NotNull ControlFlowAnalyzer controlFlowAnalyzer, @NotNull DeclarationsChecker declarationsChecker, @NotNull DelegatedPropertyResolver delegatedPropertyResolver, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull AnalyzerExtensions analyzerExtensions, @NotNull BindingTrace trace, @NotNull ValueParameterResolver valueParameterResolver, @NotNull AnnotationChecker annotationChecker, @NotNull KotlinBuiltIns builtIns, @NotNull OverloadChecker overloadChecker, @NotNull LanguageVersionSettings languageVersionSettings) {
        this.project = project;
        this.annotationResolver = annotationResolver;
        this.bodyResolveCache = bodyResolveCache;
        this.callResolver = callResolver;
        this.controlFlowAnalyzer = controlFlowAnalyzer;
        this.declarationsChecker = declarationsChecker;
        this.delegatedPropertyResolver = delegatedPropertyResolver;
        this.expressionTypingServices = expressionTypingServices;
        this.analyzerExtensions = analyzerExtensions;
        this.annotationChecker = annotationChecker;
        this.overloadChecker = overloadChecker;
        this.trace = new ObservableBindingTrace(trace);
        this.valueParameterResolver = valueParameterResolver;
        this.builtIns = builtIns;
        this.languageVersionSettings = languageVersionSettings;
    }

    private void resolveBehaviorDeclarationBodies(@NotNull BodiesResolveContext c) {
        this.resolveSuperTypeEntryLists(c);
        this.resolvePropertyDeclarationBodies(c);
        this.resolveAnonymousInitializers(c);
        this.resolvePrimaryConstructorParameters(c);
        this.resolveSecondaryConstructors(c);
        this.resolveFunctionBodies(c);
        if (!c.getTopDownAnalysisMode().isLocalDeclarations()) {
            this.computeDeferredTypes();
        }
    }

    private void resolveSecondaryConstructors(@NotNull BodiesResolveContext c) {
        for (Map.Entry<KtSecondaryConstructor, ClassConstructorDescriptor> entry : c.getSecondaryConstructors().entrySet()) {
            LexicalScope declaringScope = c.getDeclaringScope(entry.getKey());
            assert (declaringScope != null) : "Declaring scope should be registered before body resolve";
            this.resolveSecondaryConstructorBody(c.getOuterDataFlowInfo(), this.trace, entry.getKey(), entry.getValue(), declaringScope);
        }
        if (c.getSecondaryConstructors().isEmpty()) {
            return;
        }
        HashSet<ConstructorDescriptor> visitedConstructors = Sets.newHashSet();
        for (Map.Entry<KtSecondaryConstructor, ClassConstructorDescriptor> entry : c.getSecondaryConstructors().entrySet()) {
            this.checkCyclicConstructorDelegationCall(entry.getValue(), visitedConstructors);
        }
    }

    public void resolveSecondaryConstructorBody(@NotNull DataFlowInfo outerDataFlowInfo, @NotNull BindingTrace trace, @NotNull KtSecondaryConstructor constructor, @NotNull ClassConstructorDescriptor descriptor2, @NotNull LexicalScope declaringScope) {
        ForceResolveUtil.forceResolveAllContents(descriptor2.getAnnotations());
        this.resolveFunctionBody(outerDataFlowInfo, trace, constructor, descriptor2, declaringScope, (Function1<LexicalScope, DataFlowInfo>)((Function1)headerInnerScope -> this.resolveSecondaryConstructorDelegationCall(outerDataFlowInfo, trace, (LexicalScope)headerInnerScope, constructor, descriptor2)), (Function1<LexicalScope, LexicalScope>)((Function1)scope -> new LexicalScopeImpl((HierarchicalScope)scope, descriptor2, scope.isOwnerDescriptorAccessibleByLabel(), scope.getImplicitReceiver(), LexicalScopeKind.CONSTRUCTOR_HEADER)));
    }

    @Nullable
    private DataFlowInfo resolveSecondaryConstructorDelegationCall(@NotNull DataFlowInfo outerDataFlowInfo, @NotNull BindingTrace trace, @NotNull LexicalScope scope, @NotNull KtSecondaryConstructor constructor, @NotNull ClassConstructorDescriptor descriptor2) {
        if (descriptor2.isExpect() || DescriptorUtilsKt.isEffectivelyExternal(descriptor2)) {
            return DataFlowInfo.Companion.getEMPTY();
        }
        OverloadResolutionResults<ConstructorDescriptor> results = this.callResolver.resolveConstructorDelegationCall(trace, scope, outerDataFlowInfo, descriptor2, constructor.getDelegationCall());
        if (results != null && results.isSingleResult()) {
            ResolvedCall<ConstructorDescriptor> resolvedCall2 = results.getResultingCall();
            BodyResolver.recordConstructorDelegationCall(trace, descriptor2, resolvedCall2);
            return resolvedCall2.getDataFlowInfoForArguments().getResultInfo();
        }
        return null;
    }

    private void checkCyclicConstructorDelegationCall(@NotNull ConstructorDescriptor constructorDescriptor, @NotNull Set<ConstructorDescriptor> visitedConstructors) {
        if (visitedConstructors.contains(constructorDescriptor)) {
            return;
        }
        HashSet<ConstructorDescriptor> visitedInCurrentChain = Sets.newHashSet();
        ConstructorDescriptor currentConstructorDescriptor = constructorDescriptor;
        while (true) {
            visitedInCurrentChain.add(currentConstructorDescriptor);
            ConstructorDescriptor delegatedConstructorDescriptor = this.getDelegatedConstructor(currentConstructorDescriptor);
            if (delegatedConstructorDescriptor == null || !constructorDescriptor.getContainingDeclaration().equals(delegatedConstructorDescriptor.getContainingDeclaration()) || delegatedConstructorDescriptor.isPrimary() || visitedConstructors.contains(delegatedConstructorDescriptor)) break;
            if (visitedInCurrentChain.contains(delegatedConstructorDescriptor)) {
                this.reportEachConstructorOnCycle(delegatedConstructorDescriptor);
                break;
            }
            currentConstructorDescriptor = delegatedConstructorDescriptor;
        }
        visitedConstructors.addAll(visitedInCurrentChain);
    }

    private void reportEachConstructorOnCycle(@NotNull ConstructorDescriptor startConstructor) {
        ConstructorDescriptor currentConstructor = startConstructor;
        do {
            PsiElement constructorToReport;
            if ((constructorToReport = DescriptorToSourceUtils.descriptorToDeclaration(currentConstructor)) != null) {
                KtConstructorDelegationCall call2 = ((KtSecondaryConstructor)constructorToReport).getDelegationCall();
                assert (call2.getCalleeExpression() != null) : "Callee expression of delegation call should not be null on cycle as there should be explicit 'this' calls";
                this.trace.report(Errors.CYCLIC_CONSTRUCTOR_DELEGATION_CALL.on(call2.getCalleeExpression()));
            }
            currentConstructor = this.getDelegatedConstructor(currentConstructor);
            assert (currentConstructor != null) : "Delegated constructor should not be null in cycle";
        } while (startConstructor != currentConstructor);
    }

    @Nullable
    private ConstructorDescriptor getDelegatedConstructor(@NotNull ConstructorDescriptor constructor) {
        ResolvedCall<ConstructorDescriptor> call2 = this.trace.get(BindingContext.CONSTRUCTOR_RESOLVED_DELEGATION_CALL, constructor);
        return call2 == null || !call2.getStatus().isSuccess() ? null : call2.getResultingDescriptor().getOriginal();
    }

    public void resolveBodies(@NotNull BodiesResolveContext c) {
        this.resolveBehaviorDeclarationBodies(c);
        this.controlFlowAnalyzer.process(c);
        this.declarationsChecker.process(c);
        this.analyzerExtensions.process(c);
    }

    private void resolveSuperTypeEntryLists(@NotNull BodiesResolveContext c) {
        for (Map.Entry<KtClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getDeclaredClasses().entrySet()) {
            KtClassOrObject classOrObject = entry.getKey();
            ClassDescriptorWithResolutionScopes descriptor2 = entry.getValue();
            this.resolveSuperTypeEntryList(c.getOuterDataFlowInfo(), classOrObject, descriptor2, descriptor2.getUnsubstitutedPrimaryConstructor(), descriptor2.getScopeForConstructorHeaderResolution(), descriptor2.getScopeForMemberDeclarationResolution());
        }
    }

    public void resolveSuperTypeEntryList(final @NotNull DataFlowInfo outerDataFlowInfo, @NotNull KtClassOrObject ktClass, final @NotNull ClassDescriptor descriptor2, final @Nullable ConstructorDescriptor primaryConstructor2, @NotNull LexicalScope scopeForConstructorResolution, final @NotNull LexicalScope scopeForMemberResolution) {
        LexicalScope scopeForConstructor;
        LexicalScope lexicalScope = scopeForConstructor = primaryConstructor2 == null ? null : FunctionDescriptorUtil.getFunctionInnerScope(scopeForConstructorResolution, primaryConstructor2, this.trace, this.overloadChecker);
        if (primaryConstructor2 == null) {
            this.checkRedeclarationsInClassHeaderWithoutPrimaryConstructor(descriptor2, scopeForConstructorResolution);
        }
        final ExpressionTypingServices typeInferrer = this.expressionTypingServices;
        final LinkedHashMap<KtTypeReference, KotlinType> supertypes2 = Maps.newLinkedHashMap();
        final ResolvedCall[] primaryConstructorDelegationCall = new ResolvedCall[1];
        KtVisitorVoid visitor2 = new KtVisitorVoid(){

            private void recordSupertype(KtTypeReference typeReference, KotlinType supertype) {
                if (supertype == null) {
                    return;
                }
                supertypes2.put(typeReference, supertype);
            }

            @Override
            public void visitDelegatedSuperTypeEntry(@NotNull KtDelegatedSuperTypeEntry specifier) {
                KtExpression delegateExpression;
                ClassDescriptor classDescriptor;
                ClassifierDescriptor declarationDescriptor;
                if (descriptor2.getKind() == ClassKind.INTERFACE) {
                    BodyResolver.this.trace.report(Errors.DELEGATION_IN_INTERFACE.on(specifier));
                }
                KotlinType supertype = BodyResolver.this.trace.getBindingContext().get(BindingContext.TYPE, specifier.getTypeReference());
                this.recordSupertype(specifier.getTypeReference(), supertype);
                if (supertype != null && (declarationDescriptor = supertype.getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor && (classDescriptor = (ClassDescriptor)declarationDescriptor).getKind() != ClassKind.INTERFACE) {
                    BodyResolver.this.trace.report(Errors.DELEGATION_NOT_TO_INTERFACE.on(specifier.getTypeReference()));
                }
                if ((delegateExpression = specifier.getDelegateExpression()) != null) {
                    LexicalScope scope = scopeForConstructor == null ? scopeForMemberResolution : scopeForConstructor;
                    KotlinType expectedType2 = supertype != null ? supertype : TypeUtils.NO_EXPECTED_TYPE;
                    typeInferrer.getType(scope, delegateExpression, expectedType2, outerDataFlowInfo, BodyResolver.this.trace);
                }
                if (descriptor2.isExpect()) {
                    BodyResolver.this.trace.report(Errors.IMPLEMENTATION_BY_DELEGATION_IN_EXPECT_CLASS.on(specifier));
                } else if (primaryConstructor2 == null) {
                    BodyResolver.this.trace.report(Errors.UNSUPPORTED.on(specifier, "Delegation without primary constructor is not supported"));
                }
            }

            @Override
            public void visitSuperTypeCallEntry(@NotNull KtSuperTypeCallEntry call2) {
                KtTypeReference typeReference;
                ASTDelegatePsiElement elementToMark;
                KtValueArgumentList valueArgumentList = call2.getValueArgumentList();
                ASTDelegatePsiElement aSTDelegatePsiElement = elementToMark = valueArgumentList == null ? call2 : valueArgumentList;
                if (descriptor2.getKind() == ClassKind.INTERFACE) {
                    BodyResolver.this.trace.report(Errors.SUPERTYPE_INITIALIZED_IN_INTERFACE.on(elementToMark));
                }
                if (descriptor2.isExpect()) {
                    BodyResolver.this.trace.report(Errors.SUPERTYPE_INITIALIZED_IN_EXPECTED_CLASS.on(elementToMark));
                }
                if ((typeReference = call2.getTypeReference()) == null) {
                    return;
                }
                if (primaryConstructor2 == null) {
                    if (descriptor2.getKind() != ClassKind.INTERFACE) {
                        BodyResolver.this.trace.report(Errors.SUPERTYPE_INITIALIZED_WITHOUT_PRIMARY_CONSTRUCTOR.on(call2));
                    }
                    this.recordSupertype(typeReference, BodyResolver.this.trace.getBindingContext().get(BindingContext.TYPE, typeReference));
                    return;
                }
                OverloadResolutionResults<FunctionDescriptor> results = BodyResolver.this.callResolver.resolveFunctionCall(BodyResolver.this.trace, scopeForConstructor, CallMaker.makeConstructorCallWithoutTypeArguments(call2), TypeUtils.NO_EXPECTED_TYPE, outerDataFlowInfo, false);
                if (results.isSingleResult()) {
                    KotlinType supertype = results.getResultingDescriptor().getReturnType();
                    this.recordSupertype(typeReference, supertype);
                    ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(supertype);
                    if (classDescriptor != null) {
                        primaryConstructorDelegationCall[0] = primaryConstructorDelegationCall[0] == null ? results.getResultingCall() : null;
                    }
                    BodyResolver.this.trace.record(BindingContext.PROCESSED, call2.getCalleeExpression(), true);
                    BodyResolver.this.trace.record(BindingContext.EXPRESSION_TYPE_INFO, call2.getCalleeExpression(), TypeInfoFactoryKt.noTypeInfo(results.getResultingCall().getDataFlowInfoForArguments().getResultInfo()));
                } else {
                    this.recordSupertype(typeReference, BodyResolver.this.trace.getBindingContext().get(BindingContext.TYPE, typeReference));
                }
            }

            @Override
            public void visitSuperTypeEntry(@NotNull KtSuperTypeEntry specifier) {
                KtTypeReference typeReference = specifier.getTypeReference();
                KotlinType supertype = BodyResolver.this.trace.getBindingContext().get(BindingContext.TYPE, typeReference);
                this.recordSupertype(typeReference, supertype);
                if (supertype == null) {
                    return;
                }
                ClassDescriptor superClass = TypeUtils.getClassDescriptor(supertype);
                if (superClass == null) {
                    return;
                }
                if (superClass.getKind().isSingleton()) {
                    return;
                }
                if (!(descriptor2.getKind() == ClassKind.INTERFACE || descriptor2.getUnsubstitutedPrimaryConstructor() == null || superClass.getKind() == ClassKind.INTERFACE || superClass.getConstructors().isEmpty() || descriptor2.isExpect() || DescriptorUtilsKt.isEffectivelyExternal(descriptor2) || ErrorUtils.isError(superClass))) {
                    BodyResolver.this.trace.report(Errors.SUPERTYPE_NOT_INITIALIZED.on(specifier));
                }
            }

            @Override
            public void visitKtElement(@NotNull KtElement element) {
                throw new UnsupportedOperationException(element.getText() + " : " + element);
            }
        };
        if (ktClass instanceof KtEnumEntry && DescriptorUtils.isEnumEntry(descriptor2) && ktClass.getSuperTypeListEntries().isEmpty()) {
            assert (scopeForConstructor != null) : "Scope for enum class constructor should be non-null: " + descriptor2;
            this.resolveConstructorCallForEnumEntryWithoutInitializer((KtEnumEntry)ktClass, descriptor2, scopeForConstructor, outerDataFlowInfo, primaryConstructorDelegationCall);
        }
        for (KtSuperTypeListEntry delegationSpecifier : ktClass.getSuperTypeListEntries()) {
            delegationSpecifier.accept(visitor2);
        }
        if (DescriptorUtils.isAnnotationClass(descriptor2) && ktClass.getSuperTypeList() != null) {
            this.trace.report(Errors.SUPERTYPES_FOR_ANNOTATION_CLASS.on(ktClass.getSuperTypeList()));
        }
        if (primaryConstructorDelegationCall[0] != null && primaryConstructor2 != null) {
            BodyResolver.recordConstructorDelegationCall(this.trace, primaryConstructor2, primaryConstructorDelegationCall[0]);
        }
        this.checkSupertypeList(descriptor2, supertypes2, ktClass);
    }

    private void checkRedeclarationsInClassHeaderWithoutPrimaryConstructor(final @NotNull ClassDescriptor descriptor2, @NotNull LexicalScope scopeForConstructorResolution) {
        new LexicalScopeImpl(scopeForConstructorResolution, descriptor2, true, null, LexicalScopeKind.CLASS_HEADER, new TraceBasedLocalRedeclarationChecker(this.trace, this.overloadChecker), (Function1<? super LexicalScopeImpl.InitializeHandler, Unit>)new Function1<LexicalScopeImpl.InitializeHandler, Unit>(){

            public Unit invoke(LexicalScopeImpl.InitializeHandler handler2) {
                for (TypeParameterDescriptor typeParameter : descriptor2.getDeclaredTypeParameters()) {
                    handler2.addClassifierDescriptor(typeParameter);
                }
                return Unit.INSTANCE;
            }
        });
    }

    private void resolveConstructorCallForEnumEntryWithoutInitializer(@NotNull KtEnumEntry ktEnumEntry, @NotNull ClassDescriptor enumEntryDescriptor, @NotNull LexicalScope scopeForConstructor, @NotNull DataFlowInfo outerDataFlowInfo, @NotNull ResolvedCall<?>[] primaryConstructorDelegationCall) {
        assert (enumEntryDescriptor.getKind() == ClassKind.ENUM_ENTRY) : "Enum entry expected: " + enumEntryDescriptor;
        ClassDescriptor enumClassDescriptor = (ClassDescriptor)enumEntryDescriptor.getContainingDeclaration();
        if (enumClassDescriptor.getKind() != ClassKind.ENUM_CLASS) {
            return;
        }
        if (enumClassDescriptor.isExpect()) {
            return;
        }
        List<ClassConstructorDescriptor> applicableConstructors = BodyResolver.getConstructorForEmptyArgumentsList(enumClassDescriptor);
        if (applicableConstructors.size() != 1) {
            this.trace.report(Errors.ENUM_ENTRY_SHOULD_BE_INITIALIZED.on(ktEnumEntry));
            return;
        }
        KtInitializerList ktInitializerList = new KtPsiFactory(this.project, false).createEnumEntryInitializerList();
        KtSuperTypeCallEntry ktCallEntry = (KtSuperTypeCallEntry)ktInitializerList.getInitializers().get(0);
        Call call2 = CallMaker.makeConstructorCallWithoutTypeArguments(ktCallEntry);
        this.trace.record(BindingContext.TYPE, ktCallEntry.getTypeReference(), enumClassDescriptor.getDefaultType());
        this.trace.record(BindingContext.CALL, ktEnumEntry, call2);
        OverloadResolutionResults<FunctionDescriptor> results = this.callResolver.resolveFunctionCall(this.trace, scopeForConstructor, call2, TypeUtils.NO_EXPECTED_TYPE, outerDataFlowInfo, false);
        if (primaryConstructorDelegationCall[0] == null) {
            primaryConstructorDelegationCall[0] = results.getResultingCall();
        }
    }

    @NotNull
    private static List<ClassConstructorDescriptor> getConstructorForEmptyArgumentsList(@NotNull ClassDescriptor descriptor2) {
        return CollectionsKt.filter(descriptor2.getConstructors(), constructor -> CollectionsKt.all(constructor.getValueParameters(), parameter -> parameter.declaresDefaultValue() || parameter.getVarargElementType() != null));
    }

    @NotNull
    private Set<TypeConstructor> getAllowedFinalSupertypes(@NotNull ClassDescriptor descriptor2, @NotNull Map<KtTypeReference, KotlinType> supertypes2, @NotNull KtClassOrObject ktClassOrObject) {
        Set<TypeConstructor> parentEnumOrSealed = Collections.emptySet();
        if (ktClassOrObject instanceof KtEnumEntry) {
            parentEnumOrSealed = Collections.singleton(((ClassDescriptor)descriptor2.getContainingDeclaration()).getTypeConstructor());
        } else if (this.languageVersionSettings.supportsFeature(LanguageFeature.TopLevelSealedInheritance) && DescriptorUtils.isTopLevelDeclaration(descriptor2)) {
            for (KotlinType supertype : supertypes2.values()) {
                ClassifierDescriptor classifierDescriptor = supertype.getConstructor().getDeclarationDescriptor();
                if (!DescriptorUtils.isSealedClass(classifierDescriptor) || !DescriptorUtils.isTopLevelDeclaration(classifierDescriptor)) continue;
                parentEnumOrSealed = Collections.singleton(classifierDescriptor.getTypeConstructor());
            }
        } else {
            ClassDescriptor currentDescriptor = descriptor2;
            while (currentDescriptor.getContainingDeclaration() instanceof ClassDescriptor) {
                if (!DescriptorUtils.isSealedClass(currentDescriptor = (ClassDescriptor)currentDescriptor.getContainingDeclaration())) continue;
                if (parentEnumOrSealed.isEmpty()) {
                    parentEnumOrSealed = new HashSet();
                }
                parentEnumOrSealed.add(currentDescriptor.getTypeConstructor());
            }
        }
        return parentEnumOrSealed;
    }

    private static void recordConstructorDelegationCall(@NotNull BindingTrace trace, @NotNull ConstructorDescriptor constructor, @NotNull ResolvedCall<?> call2) {
        trace.record(BindingContext.CONSTRUCTOR_RESOLVED_DELEGATION_CALL, constructor, call2);
    }

    private void checkSupertypeList(@NotNull ClassDescriptor supertypeOwner, @NotNull Map<KtTypeReference, KotlinType> supertypes2, @NotNull KtClassOrObject ktClassOrObject) {
        Set<TypeConstructor> allowedFinalSupertypes = this.getAllowedFinalSupertypes(supertypeOwner, supertypes2, ktClassOrObject);
        HashSet<TypeConstructor> typeConstructors = Sets.newHashSet();
        boolean classAppeared = false;
        for (Map.Entry<KtTypeReference, KotlinType> entry : supertypes2.entrySet()) {
            KtTypeReference typeReference = entry.getKey();
            KotlinType supertype = entry.getValue();
            KtTypeElement typeElement = typeReference.getTypeElement();
            if (typeElement instanceof KtFunctionType) {
                for (KtParameter parameter : ((KtFunctionType)typeElement).getParameters()) {
                    PsiElement nameIdentifier = parameter.getNameIdentifier();
                    if (nameIdentifier == null) continue;
                    this.trace.report(Errors.UNSUPPORTED.on(nameIdentifier, "named parameter in function type in supertype position"));
                }
            }
            boolean addSupertype = true;
            ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(supertype);
            if (classDescriptor != null) {
                if (ErrorUtils.isError(classDescriptor)) continue;
                if (FunctionTypesKt.isExtensionFunctionType(supertype)) {
                    this.trace.report(Errors.SUPERTYPE_IS_EXTENSION_FUNCTION_TYPE.on(typeReference));
                } else if (FunctionTypesKt.isSuspendFunctionType(supertype)) {
                    this.trace.report(Errors.SUPERTYPE_IS_SUSPEND_FUNCTION_TYPE.on(typeReference));
                }
                if (classDescriptor.getKind() != ClassKind.INTERFACE) {
                    if (supertypeOwner.getKind() == ClassKind.ENUM_CLASS) {
                        this.trace.report(Errors.CLASS_IN_SUPERTYPE_FOR_ENUM.on(typeReference));
                        addSupertype = false;
                    } else if (supertypeOwner.getKind() == ClassKind.INTERFACE && !classAppeared && !DynamicTypesKt.isDynamic(supertype)) {
                        this.trace.report(Errors.INTERFACE_WITH_SUPERCLASS.on(typeReference));
                        addSupertype = false;
                    } else if (ktClassOrObject.hasModifier(KtTokens.DATA_KEYWORD) && !this.languageVersionSettings.supportsFeature(LanguageFeature.DataClassInheritance)) {
                        this.trace.report(Errors.DATA_CLASS_CANNOT_HAVE_CLASS_SUPERTYPES.on(typeReference));
                        addSupertype = false;
                    } else if (DescriptorUtils.isSubclass(classDescriptor, this.builtIns.getThrowable())) {
                        if (!supertypeOwner.getDeclaredTypeParameters().isEmpty()) {
                            this.trace.report(Errors.GENERIC_THROWABLE_SUBCLASS.on(ktClassOrObject.getTypeParameterList()));
                            addSupertype = false;
                        } else if (!supertypeOwner.getTypeConstructor().getParameters().isEmpty()) {
                            if (this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitInnerClassesOfGenericClassExtendingThrowable)) {
                                this.trace.report(Errors.INNER_CLASS_OF_GENERIC_THROWABLE_SUBCLASS.on(ktClassOrObject));
                                addSupertype = false;
                            } else {
                                this.trace.report(Errors.INNER_CLASS_OF_GENERIC_THROWABLE_SUBCLASS_WARNING.on(ktClassOrObject));
                            }
                        }
                    }
                    if (classAppeared) {
                        this.trace.report(Errors.MANY_CLASSES_IN_SUPERTYPE_LIST.on(typeReference));
                    } else {
                        classAppeared = true;
                    }
                }
            } else {
                this.trace.report(Errors.SUPERTYPE_NOT_A_CLASS_OR_INTERFACE.on(typeReference));
            }
            TypeConstructor constructor = supertype.getConstructor();
            if (addSupertype && !typeConstructors.add(constructor)) {
                this.trace.report(Errors.SUPERTYPE_APPEARS_TWICE.on(typeReference));
            }
            if (classDescriptor == null) {
                return;
            }
            if (classDescriptor.getKind().isSingleton()) {
                if (DescriptorUtils.isEnumEntry(classDescriptor)) continue;
                this.trace.report(Errors.SINGLETON_IN_SUPERTYPE.on(typeReference));
                continue;
            }
            if (allowedFinalSupertypes.contains(constructor)) continue;
            if (DescriptorUtils.isSealedClass(classDescriptor)) {
                DeclarationDescriptor containingDescriptor;
                for (containingDescriptor = supertypeOwner.getContainingDeclaration(); containingDescriptor != null && containingDescriptor != classDescriptor; containingDescriptor = containingDescriptor.getContainingDeclaration()) {
                }
                if (containingDescriptor == null) {
                    this.trace.report(Errors.SEALED_SUPERTYPE.on(typeReference));
                    continue;
                }
                this.trace.report(Errors.SEALED_SUPERTYPE_IN_LOCAL_CLASS.on(typeReference));
                continue;
            }
            if (ModalityKt.isFinalOrEnum(classDescriptor)) {
                this.trace.report(Errors.FINAL_SUPERTYPE.on(typeReference));
                continue;
            }
            if (!KotlinBuiltIns.isEnum(classDescriptor)) continue;
            this.trace.report(Errors.CLASS_CANNOT_BE_EXTENDED_DIRECTLY.on(typeReference, classDescriptor));
        }
    }

    private void resolveAnonymousInitializers(@NotNull BodiesResolveContext c) {
        for (Map.Entry<KtAnonymousInitializer, ClassDescriptorWithResolutionScopes> entry : c.getAnonymousInitializers().entrySet()) {
            KtAnonymousInitializer initializer2 = entry.getKey();
            ClassDescriptorWithResolutionScopes descriptor2 = entry.getValue();
            this.resolveAnonymousInitializer(c.getOuterDataFlowInfo(), initializer2, descriptor2);
        }
    }

    public void resolveAnonymousInitializer(@NotNull DataFlowInfo outerDataFlowInfo, @NotNull KtAnonymousInitializer anonymousInitializer, @NotNull ClassDescriptorWithResolutionScopes classDescriptor) {
        LexicalScope scopeForInitializers = classDescriptor.getScopeForInitializerResolution();
        KtExpression body = anonymousInitializer.getBody();
        if (body != null) {
            PreliminaryDeclarationVisitor.Companion.createForDeclaration((KtDeclaration)anonymousInitializer.getParent().getParent(), this.trace, this.languageVersionSettings);
            this.expressionTypingServices.getTypeInfo(scopeForInitializers, body, TypeUtils.NO_EXPECTED_TYPE, outerDataFlowInfo, this.trace, true);
        }
        this.processModifiersOnInitializer(anonymousInitializer, scopeForInitializers);
        if (classDescriptor.getConstructors().isEmpty()) {
            this.trace.report(Errors.ANONYMOUS_INITIALIZER_IN_INTERFACE.on(anonymousInitializer));
        }
        if (classDescriptor.isExpect()) {
            this.trace.report(Errors.EXPECTED_DECLARATION_WITH_BODY.on(anonymousInitializer));
        }
    }

    private void processModifiersOnInitializer(@NotNull KtModifierListOwner owner, @NotNull LexicalScope scope) {
        this.annotationChecker.check(owner, this.trace, null);
        ModifierCheckerCore.INSTANCE.check(owner, this.trace, null, this.languageVersionSettings);
        KtModifierList modifierList = owner.getModifierList();
        if (modifierList == null) {
            return;
        }
        this.annotationResolver.resolveAnnotationsWithArguments(scope, modifierList, (BindingTrace)this.trace);
    }

    private void resolvePrimaryConstructorParameters(@NotNull BodiesResolveContext c) {
        for (Map.Entry<KtClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getDeclaredClasses().entrySet()) {
            KtClassOrObject klass2 = entry.getKey();
            ClassDescriptorWithResolutionScopes classDescriptor = entry.getValue();
            ClassConstructorDescriptor unsubstitutedPrimaryConstructor = classDescriptor.getUnsubstitutedPrimaryConstructor();
            if (unsubstitutedPrimaryConstructor == null) continue;
            ForceResolveUtil.forceResolveAllContents(unsubstitutedPrimaryConstructor.getAnnotations());
            LexicalScope parameterScope = BodyResolver.getPrimaryConstructorParametersScope(classDescriptor.getScopeForConstructorHeaderResolution(), unsubstitutedPrimaryConstructor);
            this.valueParameterResolver.resolveValueParameters(klass2.getPrimaryConstructorParameters(), unsubstitutedPrimaryConstructor.getValueParameters(), parameterScope, c.getOuterDataFlowInfo(), this.trace);
            this.resolveConstructorPropertyDescriptors(klass2);
        }
    }

    private void resolveConstructorPropertyDescriptors(KtClassOrObject ktClassOrObject) {
        for (KtParameter parameter : ktClassOrObject.getPrimaryConstructorParameters()) {
            PropertyDescriptor descriptor2 = this.trace.getBindingContext().get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter);
            if (descriptor2 == null) continue;
            ForceResolveUtil.forceResolveAllContents(descriptor2.getAnnotations());
        }
    }

    private static LexicalScope getPrimaryConstructorParametersScope(LexicalScope originalScope, ConstructorDescriptor unsubstitutedPrimaryConstructor) {
        return new LexicalScopeImpl(originalScope, unsubstitutedPrimaryConstructor, false, null, LexicalScopeKind.DEFAULT_VALUE, LocalRedeclarationChecker.DO_NOTHING.INSTANCE, (Function1<? super LexicalScopeImpl.InitializeHandler, Unit>)((Function1)handler2 -> {
            for (ValueParameterDescriptor valueParameter : unsubstitutedPrimaryConstructor.getValueParameters()) {
                handler2.addVariableDescriptor(valueParameter);
            }
            return Unit.INSTANCE;
        }));
    }

    public void resolveProperty(@NotNull BodiesResolveContext c, @NotNull KtProperty property, @NotNull PropertyDescriptor propertyDescriptor) {
        KtExpression delegateExpression;
        BodyResolver.computeDeferredType(propertyDescriptor.getReturnType());
        PreliminaryDeclarationVisitor.Companion.createForDeclaration(property, this.trace, this.languageVersionSettings);
        KtExpression initializer2 = property.getInitializer();
        LexicalScope propertyHeaderScope = ScopeUtils.makeScopeForPropertyHeader(BodyResolver.getScopeForProperty(c, property), propertyDescriptor);
        if (initializer2 != null) {
            this.resolvePropertyInitializer(c.getOuterDataFlowInfo(), property, propertyDescriptor, initializer2, propertyHeaderScope);
        }
        if ((delegateExpression = property.getDelegateExpression()) != null) {
            assert (initializer2 == null) : "Initializer should be null for delegated property : " + property.getText();
            this.resolvePropertyDelegate(c.getOuterDataFlowInfo(), property, propertyDescriptor, delegateExpression, propertyHeaderScope);
        }
        this.resolvePropertyAccessors(c, property, propertyDescriptor);
    }

    private void resolvePropertyDeclarationBodies(@NotNull BodiesResolveContext c) {
        HashSet<KtProperty> processed = Sets.newHashSet();
        for (Map.Entry<KtClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getDeclaredClasses().entrySet()) {
            if (!(entry.getKey() instanceof KtClass)) continue;
            KtClass ktClass = (KtClass)entry.getKey();
            ClassDescriptorWithResolutionScopes classDescriptor = entry.getValue();
            for (KtProperty property : ktClass.getProperties()) {
                PropertyDescriptor propertyDescriptor = c.getProperties().get(property);
                assert (propertyDescriptor != null);
                this.resolveProperty(c, property, propertyDescriptor);
                processed.add(property);
            }
        }
        for (Map.Entry<KtTypeParameterListOwnerStub, Substitutable<ClassifierDescriptorWithTypeParameters>> entry : c.getProperties().entrySet()) {
            KtProperty property = (KtProperty)entry.getKey();
            if (processed.contains(property)) continue;
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)entry.getValue();
            this.resolveProperty(c, property, propertyDescriptor);
        }
    }

    private static LexicalScope makeScopeForPropertyAccessor(@NotNull BodiesResolveContext c, @NotNull KtPropertyAccessor accessor, @NotNull PropertyDescriptor descriptor2) {
        LexicalScope accessorDeclaringScope = c.getDeclaringScope(accessor);
        assert (accessorDeclaringScope != null) : "Scope for accessor " + accessor.getText() + " should exists";
        LexicalScope headerScope = ScopeUtils.makeScopeForPropertyHeader(accessorDeclaringScope, descriptor2);
        return new LexicalScopeImpl(headerScope, descriptor2, true, descriptor2.getExtensionReceiverParameter(), LexicalScopeKind.PROPERTY_ACCESSOR_BODY);
    }

    private void resolvePropertyAccessors(@NotNull BodiesResolveContext c, @NotNull KtProperty property, @NotNull PropertyDescriptor propertyDescriptor) {
        ObservableBindingTrace fieldAccessTrackingTrace = this.createFieldTrackingTrace(propertyDescriptor);
        KtPropertyAccessor getter2 = property.getGetter();
        PropertyGetterDescriptor getterDescriptor = propertyDescriptor.getGetter();
        if (getter2 != null && getterDescriptor != null) {
            LexicalScope accessorScope = BodyResolver.makeScopeForPropertyAccessor(c, getter2, propertyDescriptor);
            ForceResolveUtil.forceResolveAllContents(getterDescriptor.getAnnotations());
            this.resolveFunctionBody(c.getOuterDataFlowInfo(), fieldAccessTrackingTrace, getter2, getterDescriptor, accessorScope);
        }
        KtPropertyAccessor setter2 = property.getSetter();
        PropertySetterDescriptor setterDescriptor = propertyDescriptor.getSetter();
        if (setter2 != null && setterDescriptor != null) {
            LexicalScope accessorScope = BodyResolver.makeScopeForPropertyAccessor(c, setter2, propertyDescriptor);
            ForceResolveUtil.forceResolveAllContents(setterDescriptor.getAnnotations());
            this.resolveFunctionBody(c.getOuterDataFlowInfo(), fieldAccessTrackingTrace, setter2, setterDescriptor, accessorScope);
        }
    }

    private ObservableBindingTrace createFieldTrackingTrace(PropertyDescriptor propertyDescriptor) {
        return new ObservableBindingTrace(this.trace).addHandler(BindingContext.REFERENCE_TARGET, (slice, expression2, descriptor2) -> {
            if (expression2 instanceof KtSimpleNameExpression && descriptor2 instanceof SyntheticFieldDescriptor) {
                this.trace.record(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor);
            }
        });
    }

    private void resolvePropertyDelegate(@NotNull DataFlowInfo outerDataFlowInfo, @NotNull KtProperty property, @NotNull PropertyDescriptor propertyDescriptor, @NotNull KtExpression delegateExpression, @NotNull LexicalScope propertyHeaderScope) {
        this.delegatedPropertyResolver.resolvePropertyDelegate(outerDataFlowInfo, property, propertyDescriptor, delegateExpression, propertyHeaderScope, this.trace);
    }

    private void resolvePropertyInitializer(@NotNull DataFlowInfo outerDataFlowInfo, @NotNull KtProperty property, @NotNull PropertyDescriptor propertyDescriptor, @NotNull KtExpression initializer2, @NotNull LexicalScope propertyHeader) {
        KotlinType expectedTypeForInitializer;
        LexicalScope propertyDeclarationInnerScope = ScopeUtils.makeScopeForPropertyInitializer(propertyHeader, propertyDescriptor);
        KotlinType kotlinType = expectedTypeForInitializer = property.getTypeReference() != null ? propertyDescriptor.getType() : TypeUtils.NO_EXPECTED_TYPE;
        if (propertyDescriptor.getCompileTimeInitializer() == null) {
            this.expressionTypingServices.getType(propertyDeclarationInnerScope, initializer2, expectedTypeForInitializer, outerDataFlowInfo, this.trace);
        }
    }

    @NotNull
    private static LexicalScope getScopeForProperty(@NotNull BodiesResolveContext c, @NotNull KtProperty property) {
        LexicalScope scope = c.getDeclaringScope(property);
        assert (scope != null) : "Scope for property " + property.getText() + " should exists";
        return scope;
    }

    private void resolveFunctionBodies(@NotNull BodiesResolveContext c) {
        for (Map.Entry<KtNamedFunction, SimpleFunctionDescriptor> entry : c.getFunctions().entrySet()) {
            KtNamedFunction declaration = entry.getKey();
            LexicalScope scope = c.getDeclaringScope(declaration);
            assert (scope != null) : "Scope is null: " + PsiUtilsKt.getElementTextWithContext(declaration);
            if (!c.getTopDownAnalysisMode().isLocalDeclarations() && !(this.bodyResolveCache instanceof BodyResolveCache.ThrowException) && this.expressionTypingServices.getStatementFilter() != StatementFilter.NONE) {
                this.bodyResolveCache.resolveFunctionBody(declaration).addOwnDataTo(this.trace, true);
                continue;
            }
            this.resolveFunctionBody(c.getOuterDataFlowInfo(), this.trace, declaration, entry.getValue(), scope);
        }
    }

    public void resolveFunctionBody(@NotNull DataFlowInfo outerDataFlowInfo, @NotNull BindingTrace trace, @NotNull KtDeclarationWithBody function2, @NotNull FunctionDescriptor functionDescriptor, @NotNull LexicalScope declaringScope) {
        BodyResolver.computeDeferredType(functionDescriptor.getReturnType());
        this.resolveFunctionBody(outerDataFlowInfo, trace, function2, functionDescriptor, declaringScope, null, null);
        assert (functionDescriptor.getReturnType() != null);
    }

    private void resolveFunctionBody(@NotNull DataFlowInfo outerDataFlowInfo, @NotNull BindingTrace trace, @NotNull KtDeclarationWithBody function2, @NotNull FunctionDescriptor functionDescriptor, @NotNull LexicalScope scope, @Nullable Function1<LexicalScope, DataFlowInfo> beforeBlockBody, @Nullable Function1<LexicalScope, LexicalScope> headerScopeFactory) {
        PreliminaryDeclarationVisitor.Companion.createForDeclaration(function2, trace, this.languageVersionSettings);
        LexicalScope innerScope = FunctionDescriptorUtil.getFunctionInnerScope(scope, functionDescriptor, trace, this.overloadChecker);
        List<KtParameter> valueParameters = function2.getValueParameters();
        List<ValueParameterDescriptor> valueParameterDescriptors = functionDescriptor.getValueParameters();
        LexicalScope headerScope = headerScopeFactory != null ? (LexicalScope)headerScopeFactory.invoke((Object)innerScope) : innerScope;
        this.valueParameterResolver.resolveValueParameters(valueParameters, valueParameterDescriptors, headerScope, outerDataFlowInfo, trace);
        if (functionDescriptor instanceof PropertyAccessorDescriptor && functionDescriptor.getExtensionReceiverParameter() == null) {
            PropertyAccessorDescriptor accessorDescriptor = (PropertyAccessorDescriptor)functionDescriptor;
            KtProperty property = (KtProperty)function2.getParent();
            SyntheticFieldDescriptor fieldDescriptor = new SyntheticFieldDescriptor(accessorDescriptor, property);
            innerScope = new LexicalScopeImpl(innerScope, functionDescriptor, true, null, LexicalScopeKind.PROPERTY_ACCESSOR_BODY, LocalRedeclarationChecker.DO_NOTHING.INSTANCE, (Function1<? super LexicalScopeImpl.InitializeHandler, Unit>)((Function1)handler2 -> {
                handler2.addVariableDescriptor(fieldDescriptor);
                return Unit.INSTANCE;
            }));
            for (KtParameter parameter : function2.getValueParameters()) {
                if (!SyntheticFieldDescriptor.NAME.equals(parameter.getNameAsName())) continue;
                trace.report(Errors.ACCESSOR_PARAMETER_NAME_SHADOWING.on(parameter));
            }
        }
        DataFlowInfo dataFlowInfo = null;
        if (beforeBlockBody != null) {
            dataFlowInfo = (DataFlowInfo)beforeBlockBody.invoke((Object)headerScope);
        }
        if (function2.hasBody()) {
            this.expressionTypingServices.checkFunctionReturnType(innerScope, function2, functionDescriptor, dataFlowInfo != null ? dataFlowInfo : outerDataFlowInfo, null, trace);
        }
        assert (functionDescriptor.getReturnType() != null);
    }

    public void resolveConstructorParameterDefaultValues(@NotNull DataFlowInfo outerDataFlowInfo, @NotNull BindingTrace trace, @NotNull KtPrimaryConstructor constructor, @NotNull ConstructorDescriptor constructorDescriptor, @NotNull LexicalScope declaringScope) {
        List<KtParameter> valueParameters = constructor.getValueParameters();
        List<ValueParameterDescriptor> valueParameterDescriptors = constructorDescriptor.getValueParameters();
        LexicalScope scope = BodyResolver.getPrimaryConstructorParametersScope(declaringScope, constructorDescriptor);
        this.valueParameterResolver.resolveValueParameters(valueParameters, valueParameterDescriptors, scope, outerDataFlowInfo, trace);
    }

    private static void computeDeferredType(KotlinType type2) {
        DeferredType deferredType;
        if (type2 instanceof DeferredType && !(deferredType = (DeferredType)type2).isComputed()) {
            deferredType.getDelegate();
        }
    }

    private void computeDeferredTypes() {
        Collection<Box<DeferredType>> deferredTypes = this.trace.getKeys(BindingContext.DEFERRED_TYPE);
        if (deferredTypes.isEmpty()) {
            return;
        }
        Queue<DeferredType> queue = new Queue<DeferredType>(deferredTypes.size() + 1);
        this.trace.addHandler(BindingContext.DEFERRED_TYPE, (deferredTypeKeyDeferredTypeWritableSlice, key, value) -> queue.addLast((DeferredType)key.getData()));
        for (Box<DeferredType> deferredType : deferredTypes) {
            queue.addLast(deferredType.getData());
        }
        while (!queue.isEmpty()) {
            DeferredType deferredType = (DeferredType)queue.pullFirst();
            if (deferredType.isComputed()) continue;
            try {
                deferredType.getDelegate();
            }
            catch (ReenteringLazyValueComputationException reenteringLazyValueComputationException) {}
        }
    }
}

