/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.InnerClassConsumer;
import org.jetbrains.kotlin.codegen.annotation.WrappedAnnotated;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationWithTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CharValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public abstract class AnnotationCodegen {
    public static final List<JvmFlagAnnotation> FIELD_FLAGS = Arrays.asList(new JvmFlagAnnotation("kotlin.jvm.Volatile", 64), new JvmFlagAnnotation("kotlin.jvm.Transient", 128));
    public static final List<JvmFlagAnnotation> METHOD_FLAGS = Arrays.asList(new JvmFlagAnnotation("kotlin.jvm.Strictfp", 2048), new JvmFlagAnnotation("kotlin.jvm.Synchronized", 32));
    private static final AnnotationVisitor NO_ANNOTATION_VISITOR = new AnnotationVisitor(327680){

        @Override
        public AnnotationVisitor visitAnnotation(String name, @NotNull String desc) {
            return AnnotationCodegen.safe(super.visitAnnotation(name, desc));
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            return AnnotationCodegen.safe(super.visitArray(name));
        }
    };
    private final InnerClassConsumer innerClassConsumer;
    private final KotlinTypeMapper typeMapper;
    private static final Map<KotlinTarget, ElementType> annotationTargetMap = new EnumMap<KotlinTarget, ElementType>(KotlinTarget.class);
    private static final Map<KotlinRetention, RetentionPolicy> annotationRetentionMap;

    private AnnotationCodegen(@NotNull InnerClassConsumer innerClassConsumer, @NotNull KotlinTypeMapper mapper) {
        this.innerClassConsumer = innerClassConsumer;
        this.typeMapper = mapper;
    }

    public void genAnnotations(@Nullable Annotated annotated, @Nullable Type returnType) {
        this.genAnnotations(annotated, returnType, null);
    }

    public void genAnnotations(@Nullable Annotated annotated, @Nullable Type returnType, @Nullable AnnotationUseSiteTarget allowedTarget) {
        if (annotated == null) {
            return;
        }
        HashSet<String> annotationDescriptorsAlreadyPresent = new HashSet<String>();
        Annotations annotations2 = annotated.getAnnotations();
        for (AnnotationWithTarget annotationWithTarget : annotations2.getAllAnnotations()) {
            ClassDescriptor classDescriptor;
            AnnotationDescriptor annotation2 = annotationWithTarget.getAnnotation();
            AnnotationUseSiteTarget annotationTarget = annotationWithTarget.getTarget();
            if (allowedTarget == null && annotationTarget != null || allowedTarget != null && annotationTarget != null && allowedTarget != annotationTarget) continue;
            Set<KotlinTarget> applicableTargets = AnnotationChecker.applicableTargetSet(annotation2);
            if (annotated instanceof AnonymousFunctionDescriptor && !applicableTargets.contains((Object)KotlinTarget.FUNCTION) && !applicableTargets.contains((Object)KotlinTarget.PROPERTY_GETTER) && !applicableTargets.contains((Object)KotlinTarget.PROPERTY_SETTER)) {
                assert (applicableTargets.contains((Object)KotlinTarget.EXPRESSION)) : "Inconsistent target list for lambda annotation: " + applicableTargets + " on " + annotated;
                continue;
            }
            if (annotated instanceof ClassDescriptor && !applicableTargets.contains((Object)KotlinTarget.CLASS) && !applicableTargets.contains((Object)KotlinTarget.ANNOTATION_CLASS) && (classDescriptor = (ClassDescriptor)annotated).getVisibility() == Visibilities.LOCAL) {
                assert (applicableTargets.contains((Object)KotlinTarget.EXPRESSION)) : "Inconsistent target list for object literal annotation: " + applicableTargets + " on " + annotated;
                continue;
            }
            String descriptor2 = this.genAnnotation(annotation2);
            if (descriptor2 == null) continue;
            annotationDescriptorsAlreadyPresent.add(descriptor2);
        }
        this.generateAdditionalAnnotations(annotated, returnType, annotationDescriptorsAlreadyPresent);
    }

    private void generateAdditionalAnnotations(@NotNull Annotated annotated, @Nullable Type returnType, @NotNull Set<String> annotationDescriptorsAlreadyPresent) {
        ClassDescriptor classDescriptor;
        Annotated unwrapped = annotated;
        if (annotated instanceof WrappedAnnotated) {
            unwrapped = ((WrappedAnnotated)annotated).getOriginalAnnotated();
        }
        if (unwrapped instanceof CallableDescriptor) {
            CallableDescriptor descriptor2 = (CallableDescriptor)unwrapped;
            if (AnnotationCodegen.isInvisibleFromTheOutside(descriptor2)) {
                return;
            }
            if (descriptor2 instanceof ValueParameterDescriptor && AnnotationCodegen.isInvisibleFromTheOutside(descriptor2.getContainingDeclaration())) {
                return;
            }
            if (returnType != null && !AsmUtil.isPrimitive(returnType)) {
                this.generateNullabilityAnnotation(descriptor2.getReturnType(), annotationDescriptorsAlreadyPresent);
            }
        }
        if (unwrapped instanceof ClassDescriptor && (classDescriptor = (ClassDescriptor)unwrapped).getKind() == ClassKind.ANNOTATION_CLASS) {
            this.generateDocumentedAnnotation(classDescriptor, annotationDescriptorsAlreadyPresent);
            this.generateRetentionAnnotation(classDescriptor, annotationDescriptorsAlreadyPresent);
            this.generateTargetAnnotation(classDescriptor, annotationDescriptorsAlreadyPresent);
        }
    }

    private static boolean isInvisibleFromTheOutside(@Nullable DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof CallableMemberDescriptor && KotlinTypeMapper.isAccessor((CallableMemberDescriptor)descriptor2)) {
            return false;
        }
        if (descriptor2 instanceof MemberDescriptor) {
            return AsmUtil.getVisibilityAccessFlag((MemberDescriptor)descriptor2) == 2;
        }
        return false;
    }

    private void generateNullabilityAnnotation(@Nullable KotlinType type2, @NotNull Set<String> annotationDescriptorsAlreadyPresent) {
        FlexibleType flexibleType;
        if (type2 == null) {
            return;
        }
        if (AnnotationCodegen.isBareTypeParameterWithNullableUpperBound(type2)) {
            return;
        }
        if (FlexibleTypesKt.isFlexible(type2) && !TypeUtils.isNullableType((flexibleType = FlexibleTypesKt.asFlexibleType(type2)).getLowerBound()) && TypeUtils.isNullableType(flexibleType.getUpperBound())) {
            AnnotationDescriptor notNull = type2.getAnnotations().findAnnotation(JvmAnnotationNames.JETBRAINS_NOT_NULL_ANNOTATION);
            if (notNull != null) {
                this.generateAnnotationIfNotPresent(annotationDescriptorsAlreadyPresent, NotNull.class);
            }
            return;
        }
        boolean isNullableType = TypeUtils.isNullableType(type2);
        Class annotationClass = isNullableType ? Nullable.class : NotNull.class;
        this.generateAnnotationIfNotPresent(annotationDescriptorsAlreadyPresent, annotationClass);
    }

    private void generateTargetAnnotation(@NotNull ClassDescriptor classDescriptor, @NotNull Set<String> annotationDescriptorsAlreadyPresent) {
        Set<ElementType> javaTargets;
        String descriptor2 = Type.getType(Target.class).getDescriptor();
        if (!annotationDescriptorsAlreadyPresent.add(descriptor2)) {
            return;
        }
        Set<KotlinTarget> targets = AnnotationChecker.Companion.applicableTargetSet(classDescriptor);
        if (targets == null) {
            javaTargets = AnnotationCodegen.getJavaTargetList(classDescriptor);
            if (javaTargets == null) {
                return;
            }
        } else {
            javaTargets = EnumSet.noneOf(ElementType.class);
            for (KotlinTarget target : targets) {
                if (annotationTargetMap.get((Object)target) == null) continue;
                javaTargets.add(annotationTargetMap.get((Object)target));
            }
        }
        AnnotationVisitor visitor2 = this.visitAnnotation(descriptor2, true);
        AnnotationVisitor arrayVisitor = visitor2.visitArray("value");
        for (ElementType javaTarget : javaTargets) {
            arrayVisitor.visitEnum(null, Type.getType(ElementType.class).getDescriptor(), javaTarget.name());
        }
        arrayVisitor.visitEnd();
        visitor2.visitEnd();
    }

    private void generateRetentionAnnotation(@NotNull ClassDescriptor classDescriptor, @NotNull Set<String> annotationDescriptorsAlreadyPresent) {
        RetentionPolicy policy = AnnotationCodegen.getRetentionPolicy(classDescriptor);
        String descriptor2 = Type.getType(Retention.class).getDescriptor();
        if (!annotationDescriptorsAlreadyPresent.add(descriptor2)) {
            return;
        }
        AnnotationVisitor visitor2 = this.visitAnnotation(descriptor2, true);
        visitor2.visitEnum("value", Type.getType(RetentionPolicy.class).getDescriptor(), policy.name());
        visitor2.visitEnd();
    }

    private void generateDocumentedAnnotation(@NotNull ClassDescriptor classDescriptor, @NotNull Set<String> annotationDescriptorsAlreadyPresent) {
        boolean documented = DescriptorUtilsKt.isDocumentedAnnotation(classDescriptor);
        if (!documented) {
            return;
        }
        String descriptor2 = Type.getType(Documented.class).getDescriptor();
        if (!annotationDescriptorsAlreadyPresent.add(descriptor2)) {
            return;
        }
        AnnotationVisitor visitor2 = this.visitAnnotation(descriptor2, true);
        visitor2.visitEnd();
    }

    private void generateAnnotationIfNotPresent(Set<String> annotationDescriptorsAlreadyPresent, Class<?> annotationClass) {
        String descriptor2 = Type.getType(annotationClass).getDescriptor();
        if (!annotationDescriptorsAlreadyPresent.contains(descriptor2)) {
            this.visitAnnotation(descriptor2, false).visitEnd();
        }
    }

    private static boolean isBareTypeParameterWithNullableUpperBound(@NotNull KotlinType type2) {
        ClassifierDescriptor classifier2 = type2.getConstructor().getDeclarationDescriptor();
        return !type2.isMarkedNullable() && classifier2 instanceof TypeParameterDescriptor && TypeUtils.hasNullableSuperType(type2);
    }

    public void generateAnnotationDefaultValue(@NotNull ConstantValue<?> value, @NotNull KotlinType expectedType) {
        AnnotationVisitor visitor2 = this.visitAnnotation(null, false);
        this.genCompileTimeValue(null, value, visitor2);
        visitor2.visitEnd();
    }

    @Nullable
    private String genAnnotation(@NotNull AnnotationDescriptor annotationDescriptor) {
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getAnnotationClass(annotationDescriptor);
        assert (classDescriptor != null) : "Annotation descriptor has no class: " + annotationDescriptor;
        RetentionPolicy rp = AnnotationCodegen.getRetentionPolicy(classDescriptor);
        if (rp == RetentionPolicy.SOURCE && !this.typeMapper.getClassBuilderMode().generateSourceRetentionAnnotations) {
            return null;
        }
        if (classDescriptor.isExpect()) {
            return null;
        }
        this.innerClassConsumer.addInnerClassInfoFromAnnotation(classDescriptor);
        String asmTypeDescriptor = this.typeMapper.mapType(annotationDescriptor.getType()).getDescriptor();
        AnnotationVisitor annotationVisitor = this.visitAnnotation(asmTypeDescriptor, rp == RetentionPolicy.RUNTIME);
        this.genAnnotationArguments(annotationDescriptor, annotationVisitor);
        annotationVisitor.visitEnd();
        return asmTypeDescriptor;
    }

    private void genAnnotationArguments(AnnotationDescriptor annotationDescriptor, AnnotationVisitor annotationVisitor) {
        for (Map.Entry<Name, ConstantValue<?>> entry : annotationDescriptor.getAllValueArguments().entrySet()) {
            this.genCompileTimeValue(entry.getKey().asString(), entry.getValue(), annotationVisitor);
        }
    }

    private void genCompileTimeValue(final @Nullable String name, @NotNull ConstantValue<?> value, final @NotNull AnnotationVisitor annotationVisitor) {
        AnnotationArgumentVisitor<Void, Void> argumentVisitor = new AnnotationArgumentVisitor<Void, Void>(){

            @Override
            public Void visitLongValue(@NotNull LongValue value, Void data) {
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitIntValue(IntValue value, Void data) {
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitShortValue(ShortValue value, Void data) {
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitByteValue(ByteValue value, Void data) {
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitDoubleValue(DoubleValue value, Void data) {
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitFloatValue(FloatValue value, Void data) {
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitBooleanValue(BooleanValue value, Void data) {
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitCharValue(CharValue value, Void data) {
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitStringValue(StringValue value, Void data) {
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitEnumValue(EnumValue value, Void data) {
                String enumClassInternalName = AsmUtil.asmTypeByClassId(value.getEnumClassId()).getDescriptor();
                String enumEntryName = value.getEnumEntryName().asString();
                annotationVisitor.visitEnum(name, enumClassInternalName, enumEntryName);
                return null;
            }

            @Override
            public Void visitArrayValue(ArrayValue value, Void data) {
                AnnotationVisitor visitor2 = annotationVisitor.visitArray(name);
                for (ConstantValue argument : (List)value.getValue()) {
                    AnnotationCodegen.this.genCompileTimeValue(null, argument, visitor2);
                }
                visitor2.visitEnd();
                return null;
            }

            @Override
            public Void visitAnnotationValue(AnnotationValue value, Void data) {
                String internalAnnName = AnnotationCodegen.this.typeMapper.mapType(((AnnotationDescriptor)value.getValue()).getType()).getDescriptor();
                AnnotationVisitor visitor2 = annotationVisitor.visitAnnotation(name, internalAnnName);
                AnnotationCodegen.this.genAnnotationArguments((AnnotationDescriptor)value.getValue(), visitor2);
                visitor2.visitEnd();
                return null;
            }

            @Override
            public Void visitKClassValue(KClassValue value, Void data) {
                annotationVisitor.visit(name, AnnotationCodegen.this.typeMapper.mapType(value.getValue()));
                return null;
            }

            private Void visitSimpleValue(ConstantValue<?> value) {
                annotationVisitor.visit(name, value.getValue());
                return null;
            }

            @Override
            public Void visitErrorValue(ErrorValue value, Void data) {
                return this.visitUnsupportedValue(value);
            }

            @Override
            public Void visitNullValue(NullValue value, Void data) {
                return this.visitUnsupportedValue(value);
            }

            private Void visitUnsupportedValue(ConstantValue<?> value) {
                ClassBuilderMode mode = AnnotationCodegen.this.typeMapper.getClassBuilderMode();
                if (mode.generateBodies) {
                    throw new IllegalStateException("Don't know how to compile annotation value " + value);
                }
                return null;
            }
        };
        value.accept(argumentVisitor, null);
    }

    @Nullable
    private static Set<ElementType> getJavaTargetList(ClassDescriptor descriptor2) {
        ConstantValue<?> compileTimeConstant;
        Collection<ConstantValue<?>> valueArguments;
        AnnotationDescriptor targetAnnotation = descriptor2.getAnnotations().findAnnotation(new FqName(Target.class.getName()));
        if (targetAnnotation != null && !(valueArguments = targetAnnotation.getAllValueArguments().values()).isEmpty() && (compileTimeConstant = valueArguments.iterator().next()) instanceof ArrayValue) {
            List values = (List)((ArrayValue)compileTimeConstant).getValue();
            EnumSet<ElementType> result2 = EnumSet.noneOf(ElementType.class);
            for (ConstantValue value : values) {
                if (!(value instanceof EnumValue)) continue;
                FqName enumClassFqName = ((EnumValue)value).getEnumClassId().asSingleFqName();
                if (!ElementType.class.getName().equals(enumClassFqName.asString())) continue;
                result2.add(ElementType.valueOf(((EnumValue)value).getEnumEntryName().asString()));
            }
            return result2;
        }
        return null;
    }

    @NotNull
    private static RetentionPolicy getRetentionPolicy(@NotNull Annotated descriptor2) {
        ConstantValue value;
        KotlinRetention retention = DescriptorUtilsKt.getAnnotationRetention(descriptor2);
        if (retention != null) {
            return annotationRetentionMap.get((Object)retention);
        }
        AnnotationDescriptor retentionAnnotation = descriptor2.getAnnotations().findAnnotation(new FqName(Retention.class.getName()));
        if (retentionAnnotation != null && (value = (ConstantValue)CollectionsKt.firstOrNull(retentionAnnotation.getAllValueArguments().values())) instanceof EnumValue) {
            FqName enumClassFqName = ((EnumValue)value).getEnumClassId().asSingleFqName();
            if (RetentionPolicy.class.getName().equals(enumClassFqName.asString())) {
                return RetentionPolicy.valueOf(((EnumValue)value).getEnumEntryName().asString());
            }
        }
        return RetentionPolicy.RUNTIME;
    }

    @NotNull
    abstract AnnotationVisitor visitAnnotation(String var1, boolean var2);

    public static AnnotationCodegen forClass(final @NotNull ClassVisitor cv, @NotNull InnerClassConsumer innerClassConsumer, @NotNull KotlinTypeMapper mapper) {
        return new AnnotationCodegen(innerClassConsumer, mapper){

            @Override
            @NotNull
            AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                return AnnotationCodegen.safe(cv.visitAnnotation(descr, visible));
            }
        };
    }

    public static AnnotationCodegen forMethod(final @NotNull MethodVisitor mv, @NotNull InnerClassConsumer innerClassConsumer, @NotNull KotlinTypeMapper mapper) {
        return new AnnotationCodegen(innerClassConsumer, mapper){

            @Override
            @NotNull
            AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                return AnnotationCodegen.safe(mv.visitAnnotation(descr, visible));
            }
        };
    }

    public static AnnotationCodegen forField(final @NotNull FieldVisitor fv, @NotNull InnerClassConsumer innerClassConsumer, @NotNull KotlinTypeMapper mapper) {
        return new AnnotationCodegen(innerClassConsumer, mapper){

            @Override
            @NotNull
            AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                return AnnotationCodegen.safe(fv.visitAnnotation(descr, visible));
            }
        };
    }

    public static AnnotationCodegen forParameter(final int parameter, final @NotNull MethodVisitor mv, @NotNull InnerClassConsumer innerClassConsumer, @NotNull KotlinTypeMapper mapper) {
        return new AnnotationCodegen(innerClassConsumer, mapper){

            @Override
            @NotNull
            AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                return AnnotationCodegen.safe(mv.visitParameterAnnotation(parameter, descr, visible));
            }
        };
    }

    public static AnnotationCodegen forAnnotationDefaultValue(final @NotNull MethodVisitor mv, @NotNull InnerClassConsumer innerClassConsumer, @NotNull KotlinTypeMapper mapper) {
        return new AnnotationCodegen(innerClassConsumer, mapper){

            @Override
            @NotNull
            AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                return AnnotationCodegen.safe(mv.visitAnnotationDefault());
            }
        };
    }

    @NotNull
    private static AnnotationVisitor safe(@Nullable AnnotationVisitor av) {
        return av == null ? NO_ANNOTATION_VISITOR : av;
    }

    static {
        annotationTargetMap.put(KotlinTarget.CLASS, ElementType.TYPE);
        annotationTargetMap.put(KotlinTarget.ANNOTATION_CLASS, ElementType.ANNOTATION_TYPE);
        annotationTargetMap.put(KotlinTarget.CONSTRUCTOR, ElementType.CONSTRUCTOR);
        annotationTargetMap.put(KotlinTarget.LOCAL_VARIABLE, ElementType.LOCAL_VARIABLE);
        annotationTargetMap.put(KotlinTarget.FUNCTION, ElementType.METHOD);
        annotationTargetMap.put(KotlinTarget.PROPERTY_GETTER, ElementType.METHOD);
        annotationTargetMap.put(KotlinTarget.PROPERTY_SETTER, ElementType.METHOD);
        annotationTargetMap.put(KotlinTarget.FIELD, ElementType.FIELD);
        annotationTargetMap.put(KotlinTarget.VALUE_PARAMETER, ElementType.PARAMETER);
        annotationTargetMap.put(KotlinTarget.TYPE_PARAMETER, ElementType.TYPE_PARAMETER);
        annotationTargetMap.put(KotlinTarget.TYPE, ElementType.TYPE_USE);
        annotationRetentionMap = new EnumMap<KotlinRetention, RetentionPolicy>(KotlinRetention.class);
        annotationRetentionMap.put(KotlinRetention.SOURCE, RetentionPolicy.SOURCE);
        annotationRetentionMap.put(KotlinRetention.BINARY, RetentionPolicy.CLASS);
        annotationRetentionMap.put(KotlinRetention.RUNTIME, RetentionPolicy.RUNTIME);
    }

    public static final class JvmFlagAnnotation {
        private final FqName fqName;
        private final int jvmFlag;

        public JvmFlagAnnotation(@NotNull String fqName2, int jvmFlag) {
            this.fqName = new FqName(fqName2);
            this.jvmFlag = jvmFlag;
        }

        public boolean hasAnnotation(@NotNull Annotated annotated) {
            return Annotations.Companion.findAnyAnnotation(annotated.getAnnotations(), this.fqName) != null;
        }

        public int getJvmFlag() {
            return this.jvmFlag;
        }
    }
}

