/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.GeneratedFile;
import org.jetbrains.kotlin.incremental.ExpectActualTrackerImpl;
import org.jetbrains.kotlin.incremental.FilesMap;
import org.jetbrains.kotlin.incremental.ICReporter;
import org.jetbrains.kotlin.incremental.snapshots.FileSnapshotMap;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.BasicMapsOwner;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fJ\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u0014\u0010\u0016\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018J\u0014\u0010\u001a\u001a\u00020\u00122\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u001cR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/incremental/InputsCache;", "Lorg/jetbrains/kotlin/incremental/storage/BasicMapsOwner;", "workingDir", "Ljava/io/File;", "reporter", "Lorg/jetbrains/kotlin/incremental/ICReporter;", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/ICReporter;)V", "complementaryFilesMap", "Lorg/jetbrains/kotlin/incremental/FilesMap;", "sourceSnapshotMap", "Lorg/jetbrains/kotlin/incremental/snapshots/FileSnapshotMap;", "getSourceSnapshotMap$incremental_compilation_impl", "()Lorg/jetbrains/kotlin/incremental/snapshots/FileSnapshotMap;", "sourceToOutputMap", "clearComplementaryFilesMapping", "", "dirtyFiles", "registerComplementaryFiles", "", "expectActualTracker", "Lorg/jetbrains/kotlin/incremental/ExpectActualTrackerImpl;", "registerComplementaryFiles$incremental_compilation_impl", "registerOutputForSourceFiles", "generatedFiles", "", "Lorg/jetbrains/kotlin/build/GeneratedFile;", "removeOutputForSourceFiles", "sources", "", "Companion", "incremental-compilation-impl"})
public final class InputsCache
extends BasicMapsOwner {
    @NotNull
    private final FileSnapshotMap sourceSnapshotMap;
    private final FilesMap sourceToOutputMap;
    private final FilesMap complementaryFilesMap;
    private final ICReporter reporter;
    private static final String SOURCE_SNAPSHOTS = "source-snapshot";
    private static final String SOURCE_TO_OUTPUT_FILES = "source-to-output";
    private static final String COMPLEMENTARY_FILES = "complementary-files";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final FileSnapshotMap getSourceSnapshotMap$incremental_compilation_impl() {
        return this.sourceSnapshotMap;
    }

    @NotNull
    public final Collection<File> clearComplementaryFilesMapping(@NotNull Collection<? extends File> dirtyFiles) {
        Collection collection;
        Intrinsics.checkParameterIsNotNull(dirtyFiles, (String)"dirtyFiles");
        HashSet<File> complementaryFiles = new HashSet<File>();
        ArrayDeque<? extends File> filesQueue = new ArrayDeque<File>(dirtyFiles);
        while (!(collection = (Collection)filesQueue).isEmpty()) {
            File file2;
            File file3 = file2 = filesQueue.pollFirst();
            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"file");
            Iterable $receiver$iv = this.complementaryFilesMap.remove(file3);
            for (Object element$iv : $receiver$iv) {
                File it = (File)element$iv;
                if (!complementaryFiles.add(it)) continue;
                ((Collection)filesQueue).add(element$iv);
            }
        }
        complementaryFiles.removeAll(dirtyFiles);
        return complementaryFiles;
    }

    public final void registerComplementaryFiles$incremental_compilation_impl(@NotNull ExpectActualTrackerImpl expectActualTracker) {
        Object expect;
        Map.Entry<File, Set<File>> entry;
        Map.Entry<File, Set<File>> entry2;
        Intrinsics.checkParameterIsNotNull((Object)expectActualTracker, (String)"expectActualTracker");
        HashMap actualToExpect = new HashMap();
        Map<File, Set<File>> map2 = expectActualTracker.getExpectToActualMap();
        Iterator<Map.Entry<File, Set<File>>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = entry2 = iterator2.next();
            expect = entry.getKey();
            entry = entry2;
            Set<File> actuals = entry.getValue();
            Iterator<File> iterator3 = actuals.iterator();
            while (iterator3.hasNext()) {
                Object object;
                Map $receiver$iv = actualToExpect;
                File actual = iterator3.next();
                Object value$iv = $receiver$iv.get(actual);
                if (value$iv == null) {
                    Set answer$iv = new HashSet();
                    $receiver$iv.put(actual, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((Set)object).add(expect);
            }
            this.complementaryFilesMap.set((File)expect, (Collection<? extends File>)actuals);
        }
        expect = actualToExpect;
        iterator2 = expect.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = entry2 = iterator2.next();
            File actual = entry.getKey();
            entry = entry2;
            Set<File> expects = entry.getValue();
            this.complementaryFilesMap.set(actual, (Collection<? extends File>)expects);
        }
    }

    public final void removeOutputForSourceFiles(@NotNull Iterable<? extends File> sources) {
        Intrinsics.checkParameterIsNotNull(sources, (String)"sources");
        for (File file2 : sources) {
            Iterable $receiver$iv = this.sourceToOutputMap.remove(file2);
            for (Object element$iv : $receiver$iv) {
                File it = (File)element$iv;
                this.reporter.report((Function0<String>)((Function0)new Function0<String>(it, this, file2){
                    final /* synthetic */ File $it;
                    final /* synthetic */ InputsCache this$0;
                    final /* synthetic */ File $sourceFile$inlined;
                    {
                        this.$it = file2;
                        this.this$0 = inputsCache;
                        this.$sourceFile$inlined = file3;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Deleting " + this.$it + " on clearing cache for " + this.$sourceFile$inlined;
                    }
                }));
                it.delete();
            }
        }
    }

    public final void registerOutputForSourceFiles(@NotNull List<? extends GeneratedFile> generatedFiles) {
        Intrinsics.checkParameterIsNotNull(generatedFiles, (String)"generatedFiles");
        MultiMap<File, File> sourceToOutput = new MultiMap<File, File>();
        for (GeneratedFile entry : generatedFiles) {
            for (File source : entry.getSourceFiles()) {
                sourceToOutput.putValue(source, entry.getOutputFile());
            }
        }
        Iterator<Object> iterator2 = sourceToOutput.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry;
            File source;
            Map.Entry entry2 = entry = (Map.Entry)iterator2.next();
            source = (File)entry2.getKey();
            entry2 = entry;
            Collection outputs = (Collection)entry2.getValue();
            File file2 = source;
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"source");
            Collection collection = outputs;
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"outputs");
            this.sourceToOutputMap.set(file2, collection);
        }
    }

    public InputsCache(@NotNull File workingDir, @NotNull ICReporter reporter) {
        Intrinsics.checkParameterIsNotNull((Object)workingDir, (String)"workingDir");
        Intrinsics.checkParameterIsNotNull((Object)reporter, (String)"reporter");
        super(workingDir);
        this.reporter = reporter;
        this.sourceSnapshotMap = (FileSnapshotMap)this.registerMap((BasicMap)new FileSnapshotMap(this.getStorageFile(SOURCE_SNAPSHOTS)));
        this.sourceToOutputMap = (FilesMap)this.registerMap((BasicMap)new FilesMap(this.getStorageFile(SOURCE_TO_OUTPUT_FILES)));
        this.complementaryFilesMap = (FilesMap)this.registerMap((BasicMap)new FilesMap(this.getStorageFile(COMPLEMENTARY_FILES)));
    }

    static {
        SOURCE_SNAPSHOTS = SOURCE_SNAPSHOTS;
        SOURCE_TO_OUTPUT_FILES = SOURCE_TO_OUTPUT_FILES;
        COMPLEMENTARY_FILES = COMPLEMENTARY_FILES;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/incremental/InputsCache$Companion;", "", "()V", "COMPLEMENTARY_FILES", "", "SOURCE_SNAPSHOTS", "SOURCE_TO_OUTPUT_FILES", "incremental-compilation-impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

