/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.repl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.testFramework.LightVirtualFile;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.repl.IReplStageState;
import org.jetbrains.kotlin.cli.common.repl.ReplCheckAction;
import org.jetbrains.kotlin.cli.common.repl.ReplCheckResult;
import org.jetbrains.kotlin.cli.common.repl.ReplCodeLine;
import org.jetbrains.kotlin.cli.common.repl.ReplUtilKt;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.repl.GenericReplCheckerKt;
import org.jetbrains.kotlin.cli.jvm.repl.GenericReplCheckerState;
import org.jetbrains.kotlin.cli.jvm.repl.messages.ConsoleDiagnosticMessageHolder;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplChecker;", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCheckAction;", "disposable", "Lcom/intellij/openapi/Disposable;", "scriptDefinition", "Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "compilerConfiguration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "(Lcom/intellij/openapi/Disposable;Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)V", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "getEnvironment$cli", "()Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "psiFileFactory", "Lcom/intellij/psi/impl/PsiFileFactoryImpl;", "check", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCheckResult;", "state", "Lorg/jetbrains/kotlin/cli/common/repl/IReplStageState;", "codeLine", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "createDiagnosticHolder", "Lorg/jetbrains/kotlin/cli/jvm/repl/messages/ConsoleDiagnosticMessageHolder;", "cli"})
public class GenericReplChecker
implements ReplCheckAction {
    @NotNull
    private final KotlinCoreEnvironment environment;
    private final PsiFileFactoryImpl psiFileFactory;
    private final KotlinScriptDefinition scriptDefinition;
    private final CompilerConfiguration compilerConfiguration;

    @NotNull
    public final KotlinCoreEnvironment getEnvironment$cli() {
        return this.environment;
    }

    private final ConsoleDiagnosticMessageHolder createDiagnosticHolder() {
        return new ConsoleDiagnosticMessageHolder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ReplCheckResult check(@NotNull IReplStageState<?> state2, @NotNull ReplCodeLine codeLine) {
        int n;
        Intrinsics.checkParameterIsNotNull(state2, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)codeLine, (String)"codeLine");
        ReentrantReadWriteLock reentrantReadWriteLock = state2.getLock();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n3 = 0;
        int n4 = n2;
        while (n3 < n4) {
            n = n3++;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            GenericReplCheckerState checkerState = state2.asState(GenericReplCheckerState.class);
            String scriptFileName = ReplUtilKt.makeScriptBaseName(codeLine);
            LightVirtualFile lightVirtualFile = new LightVirtualFile(scriptFileName + KotlinParserDefinition.STD_SCRIPT_EXT, KotlinLanguage.INSTANCE, (CharSequence)StringUtil.convertLineSeparators(codeLine.getCode()));
            Object $receiver = lightVirtualFile;
            ((VirtualFile)$receiver).setCharset(CharsetToolkit.UTF8_CHARSET);
            LightVirtualFile virtualFile2 = lightVirtualFile;
            KtFile ktFile = (KtFile)this.psiFileFactory.trySetupPsiForFile(virtualFile2, KotlinLanguage.INSTANCE, true, false);
            if (ktFile == null) {
                $receiver = "Script file not analyzed at line " + codeLine.getNo() + ": " + codeLine.getCode();
                throw (Throwable)new IllegalStateException($receiver.toString());
            }
            KtFile psiFile = ktFile;
            ConsoleDiagnosticMessageHolder errorHolder = this.createDiagnosticHolder();
            AnalyzerWithCompilerReport.SyntaxErrorReport syntaxErrorReport = AnalyzerWithCompilerReport.Companion.reportSyntaxErrors((PsiElement)psiFile, errorHolder);
            if (!syntaxErrorReport.isHasErrors()) {
                checkerState.setLastLineState(new GenericReplCheckerState.LineState(codeLine, psiFile, errorHolder));
            }
            ReplCheckResult replCheckResult = syntaxErrorReport.isHasErrors() && syntaxErrorReport.isAllErrorsAtEof() ? (ReplCheckResult)new ReplCheckResult.Incomplete() : (syntaxErrorReport.isHasErrors() ? (ReplCheckResult)new ReplCheckResult.Error(errorHolder.renderMessage(), null, 2, null) : (ReplCheckResult)new ReplCheckResult.Ok());
            return replCheckResult;
        }
        finally {
            n = 0;
            int n5 = n2;
            while (n < n5) {
                int n6 = n++;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    public GenericReplChecker(@NotNull Disposable disposable, @NotNull KotlinScriptDefinition scriptDefinition2, @NotNull CompilerConfiguration compilerConfiguration, @NotNull MessageCollector messageCollector2) {
        KotlinCoreEnvironment kotlinCoreEnvironment;
        GenericReplChecker $receiver;
        block4: {
            Object object;
            CompilerConfigurationKey<JvmTarget> compilerConfigurationKey;
            CompilerConfiguration compilerConfiguration2;
            block6: {
                block5: {
                    CompilerConfiguration compilerConfiguration3;
                    Intrinsics.checkParameterIsNotNull((Object)disposable, (String)"disposable");
                    Intrinsics.checkParameterIsNotNull((Object)scriptDefinition2, (String)"scriptDefinition");
                    Intrinsics.checkParameterIsNotNull((Object)compilerConfiguration, (String)"compilerConfiguration");
                    Intrinsics.checkParameterIsNotNull((Object)messageCollector2, (String)"messageCollector");
                    this.scriptDefinition = scriptDefinition2;
                    this.compilerConfiguration = compilerConfiguration;
                    GenericReplChecker genericReplChecker = this;
                    GenericReplChecker genericReplChecker2 = this;
                    $receiver = genericReplChecker;
                    CompilerConfiguration $receiver2 = compilerConfiguration3 = $receiver.compilerConfiguration;
                    $receiver2.add(JVMConfigurationKeys.SCRIPT_DEFINITIONS, $receiver.scriptDefinition);
                    $receiver2.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, messageCollector2);
                    $receiver2.put(JVMConfigurationKeys.RETAIN_OUTPUT_IN_MEMORY, true);
                    if ($receiver2.get(JVMConfigurationKeys.JVM_TARGET) != null) break block4;
                    compilerConfiguration2 = $receiver2;
                    compilerConfigurationKey = JVMConfigurationKeys.JVM_TARGET;
                    object = System.getProperty("kotlin.repl.jvm.target");
                    if (object == null) break block5;
                    String string = object;
                    CompilerConfigurationKey<JvmTarget> compilerConfigurationKey2 = compilerConfigurationKey;
                    CompilerConfiguration compilerConfiguration4 = compilerConfiguration2;
                    String it = string;
                    JvmTarget jvmTarget = JvmTarget.Companion.fromString(it);
                    compilerConfiguration2 = compilerConfiguration4;
                    compilerConfigurationKey = compilerConfigurationKey2;
                    object = jvmTarget;
                    if (object != null) break block6;
                }
                object = GenericReplCheckerKt.access$getJavaVersion() >= 65544 ? JvmTarget.JVM_1_8 : JvmTarget.JVM_1_6;
            }
            compilerConfiguration2.put(compilerConfigurationKey, object);
        }
        genericReplChecker2.environment = kotlinCoreEnvironment = KotlinCoreEnvironment.Companion.createForProduction(disposable, $receiver.compilerConfiguration, EnvironmentConfigFiles.JVM_CONFIG_FILES);
        PsiFileFactory psiFileFactory2 = PsiFileFactory.getInstance(this.environment.getProject());
        if (psiFileFactory2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.impl.PsiFileFactoryImpl");
        }
        this.psiFileFactory = (PsiFileFactoryImpl)psiFileFactory2;
    }
}

