/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.IdentifierChecker;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsIdentifierChecker;", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "()V", "checkDeclaration", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "checkIdentifier", "simpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "js.frontend"})
public final class JsIdentifierChecker
implements IdentifierChecker {
    public static final JsIdentifierChecker INSTANCE;

    @Override
    public void checkIdentifier(@NotNull KtSimpleNameExpression simpleNameExpression, @NotNull DiagnosticSink diagnosticHolder) {
        boolean hasIllegalChars;
        block5: {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)simpleNameExpression, (String)"simpleNameExpression");
            Intrinsics.checkParameterIsNotNull((Object)diagnosticHolder, (String)"diagnosticHolder");
            String simpleName = simpleNameExpression.getReferencedName();
            Iterable $receiver$iv = StringsKt.split$default((CharSequence)simpleName, (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null);
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    String it = (String)element$iv;
                    if (!(Intrinsics.areEqual((Object)NameSuggestion.Companion.sanitizeName(it), (Object)it) ^ true)) continue;
                    bl = true;
                    break block5;
                }
                bl = hasIllegalChars = false;
            }
        }
        if (hasIllegalChars) {
            PsiElement psiElement = simpleNameExpression.getIdentifier();
            if (psiElement == null) {
                return;
            }
            PsiElement identifier = psiElement;
            diagnosticHolder.report(Errors.INVALID_CHARACTERS.on(identifier, "contains illegal characters"));
        }
    }

    @Override
    public void checkDeclaration(@NotNull KtDeclaration declaration, @NotNull DiagnosticSink diagnosticHolder) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticHolder, (String)"diagnosticHolder");
    }

    private JsIdentifierChecker() {
    }

    static {
        JsIdentifierChecker jsIdentifierChecker;
        INSTANCE = jsIdentifierChecker = new JsIdentifierChecker();
    }
}

