/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.index;

import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.index.JavaRoot;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\bJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00032\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R*\u0010\u0006\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00030\u0007j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0003`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/index/SingleJavaFileRootsIndex;", "", "roots", "", "Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot;", "(Ljava/util/List;)V", "classIdsInRoots", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/name/ClassId;", "Lkotlin/collections/ArrayList;", "findJavaSourceClass", "Lcom/intellij/openapi/vfs/VirtualFile;", "classId", "findJavaSourceClasses", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getClassIdsForRootAt", "index", "", "JavaSourceClassIdReader", "cli"})
public final class SingleJavaFileRootsIndex {
    private final ArrayList<List<ClassId>> classIdsInRoots;
    private final List<JavaRoot> roots;

    @Nullable
    public final VirtualFile findJavaSourceClass(@NotNull ClassId classId) {
        VirtualFile virtualFile2;
        Object v0;
        Object object;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
            object = (Iterable)CollectionsKt.getIndices((Collection)this.roots);
            Iterable iterable = object;
            for (Object t : iterable) {
                int index2 = ((Number)t).intValue();
                if (!this.getClassIdsForRootAt(index2).contains(classId)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        Integer n = v0;
        if (n != null) {
            object = n;
            int index3 = ((Number)object).intValue();
            virtualFile2 = this.roots.get(index3).getFile();
        } else {
            virtualFile2 = null;
        }
        return virtualFile2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ClassId> findJavaSourceClasses(@NotNull FqName packageFqName) {
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        Iterable iterable = (Iterable)CollectionsKt.getIndices((Collection)this.roots);
        Object object = this;
        void var4_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        Iterator iterator2 = $receiver$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            int element$iv$iv;
            int p1 = element$iv$iv = ((IntIterator)iterator2).nextInt();
            Iterable list$iv$iv = ((SingleJavaFileRootsIndex)object).getClassIdsForRootAt(p1);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        object = $receiver$iv;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ClassId root2 = (ClassId)element$iv$iv;
            if (!Intrinsics.areEqual((Object)root2.getPackageFqName(), (Object)packageFqName)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ClassId> getClassIdsForRootAt(int index2) {
        int n;
        int n2 = this.classIdsInRoots.size();
        if (n2 <= (n = index2)) {
            while (true) {
                void i;
                this.classIdsInRoots.add(new JavaSourceClassIdReader(this.roots.get((int)i).getFile()).readClassIds());
                if (i == n) break;
                ++i;
            }
        }
        List<ClassId> list2 = this.classIdsInRoots.get(index2);
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"classIdsInRoots[index]");
        return list2;
    }

    public SingleJavaFileRootsIndex(@NotNull List<JavaRoot> roots2) {
        Intrinsics.checkParameterIsNotNull(roots2, (String)"roots");
        this.roots = roots2;
        for (JavaRoot javaRoot : this.roots) {
            boolean bl;
            VirtualFile file2 = javaRoot.component1();
            boolean bl2 = bl = !file2.isDirectory();
            if (!_Assertions.ENABLED || bl) continue;
            String string = "Should not be a directory: " + file2;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.classIdsInRoots = new ArrayList(this.roots.size());
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\fH\u0002J\b\u0010\u0010\u001a\u00020\fH\u0002J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\b\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/index/SingleJavaFileRootsIndex$JavaSourceClassIdReader;", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "braceBalance", "", "lexer", "Lcom/intellij/lang/java/lexer/JavaLexer;", "advance", "", "at", "", "type", "Lcom/intellij/psi/tree/IElementType;", "atClass", "end", "readClassIds", "", "Lorg/jetbrains/kotlin/name/ClassId;", "tokenText", "", "Companion", "cli"})
    private static final class JavaSourceClassIdReader {
        private final JavaLexer lexer;
        private int braceBalance;
        private static final Set<IElementType> CLASS_KEYWORDS;
        public static final Companion Companion;

        private final boolean at(IElementType type2) {
            return Intrinsics.areEqual((Object)this.lexer.getTokenType(), (Object)type2);
        }

        private final boolean end() {
            return this.lexer.getTokenType() == null;
        }

        private final void advance() {
            IElementType iElementType = ElementType.LBRACE;
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"ElementType.LBRACE");
            if (this.at(iElementType)) {
                int n = this.braceBalance;
                this.braceBalance = n + 1;
            } else {
                IElementType iElementType2 = ElementType.RBRACE;
                Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"ElementType.RBRACE");
                if (this.at(iElementType2)) {
                    int n = this.braceBalance;
                    this.braceBalance = n + -1;
                }
            }
            this.lexer.advance();
        }

        private final String tokenText() {
            String string = this.lexer.getTokenText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"lexer.tokenText");
            return string;
        }

        private final boolean atClass() {
            return this.braceBalance == 0 && CLASS_KEYWORDS.contains(this.lexer.getTokenType());
        }

        @NotNull
        public final List<ClassId> readClassIds() {
            FqName packageFqName;
            block8: {
                packageFqName = FqName.ROOT;
                while (!this.end()) {
                    IElementType iElementType = ElementType.PACKAGE_KEYWORD;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"ElementType.PACKAGE_KEYWORD");
                    if (this.at(iElementType) || this.atClass()) break;
                    this.advance();
                }
                IElementType iElementType = ElementType.PACKAGE_KEYWORD;
                Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"ElementType.PACKAGE_KEYWORD");
                if (!this.at(iElementType)) break block8;
                StringBuilder packageName = new StringBuilder();
                while (!this.end()) {
                    block10: {
                        block9: {
                            IElementType iElementType2 = ElementType.SEMICOLON;
                            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"ElementType.SEMICOLON");
                            if (this.at(iElementType2)) break;
                            IElementType iElementType3 = ElementType.IDENTIFIER;
                            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType3, (String)"ElementType.IDENTIFIER");
                            if (this.at(iElementType3)) break block9;
                            IElementType iElementType4 = ElementType.DOT;
                            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType4, (String)"ElementType.DOT");
                            if (!this.at(iElementType4)) break block10;
                        }
                        packageName.append(this.tokenText());
                    }
                    this.advance();
                }
                packageFqName = new FqName(packageName.toString());
            }
            ArrayList<ClassId> result2 = new ArrayList<ClassId>(1);
            while (true) {
                if (!this.end() && !this.atClass()) {
                    this.advance();
                    continue;
                }
                if (this.end()) break;
                while (!this.end()) {
                    IElementType iElementType = ElementType.IDENTIFIER;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"ElementType.IDENTIFIER");
                    if (this.at(iElementType)) break;
                    this.advance();
                }
                if (this.end()) break;
                result2.add(new ClassId(packageFqName, Name.identifier(this.tokenText())));
            }
            return result2;
        }

        public JavaSourceClassIdReader(@NotNull VirtualFile file2) {
            JavaLexer javaLexer;
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            JavaLexer javaLexer2 = new JavaLexer(LanguageLevel.JDK_1_9);
            JavaSourceClassIdReader javaSourceClassIdReader = this;
            JavaLexer $receiver = javaLexer2;
            byte[] byArray = file2.contentsToByteArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"file.contentsToByteArray()");
            byte[] byArray2 = byArray;
            JavaLexer javaLexer3 = $receiver;
            String string = new String(byArray2, Charsets.UTF_8);
            javaLexer3.start(string);
            javaSourceClassIdReader.lexer = javaLexer = javaLexer2;
        }

        static {
            Companion = new Companion(null);
            CLASS_KEYWORDS = SetsKt.setOf((Object[])new IElementType[]{ElementType.CLASS_KEYWORD, ElementType.INTERFACE_KEYWORD, ElementType.ENUM_KEYWORD});
        }

        @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/index/SingleJavaFileRootsIndex$JavaSourceClassIdReader$Companion;", "", "()V", "CLASS_KEYWORDS", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "cli"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

