/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.Callable;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.JvmKotlinType;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.intrinsics.JavaClassProperty;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class CallReceiver
extends StackValue {
    private final StackValue dispatchReceiver;
    private final StackValue extensionReceiver;
    private final Type secondReceiverType;
    private final KotlinType secondReceiverKotlinType;

    private CallReceiver(@NotNull StackValue dispatchReceiver, @NotNull StackValue extensionReceiver, @NotNull Type type2, @Nullable KotlinType kotlinType, @Nullable Type secondReceiverType, @Nullable KotlinType secondReceiverKotlinType) {
        super(type2, kotlinType, dispatchReceiver.canHaveSideEffects() || extensionReceiver.canHaveSideEffects());
        this.dispatchReceiver = dispatchReceiver;
        this.extensionReceiver = extensionReceiver;
        this.secondReceiverType = secondReceiverType;
        this.secondReceiverKotlinType = secondReceiverKotlinType;
    }

    public StackValue withoutReceiverArgument() {
        return new CallReceiver(this.dispatchReceiver, CallReceiver.none(), this.type, this.kotlinType, this.secondReceiverType, this.secondReceiverKotlinType);
    }

    public static StackValue generateCallReceiver(@NotNull ResolvedCall<?> resolvedCall2, @NotNull ExpressionCodegen codegen, @Nullable Callable callableMethod, @Nullable ReceiverParameterDescriptor dispatchReceiverParameter2, @NotNull StackValue dispatchReceiver, @Nullable ReceiverParameterDescriptor extensionReceiverParameter2, @NotNull StackValue extensionReceiver) {
        JvmKotlinType jvmKotlinType;
        KotlinTypeMapper typeMapper = codegen.typeMapper;
        GenerationState state2 = codegen.getState();
        Type secondReceiverType = null;
        KotlinType secondReceiverKotlinType = null;
        if (extensionReceiverParameter2 != null) {
            jvmKotlinType = CallReceiver.calcExtensionReceiverType(resolvedCall2, extensionReceiverParameter2, typeMapper, callableMethod, state2);
            if (dispatchReceiverParameter2 != null) {
                JvmKotlinType dispatchReceiverInfo = CallReceiver.calcDispatchReceiverType(resolvedCall2, dispatchReceiverParameter2, typeMapper, callableMethod);
                secondReceiverType = dispatchReceiverInfo.getType();
                secondReceiverKotlinType = dispatchReceiverInfo.getKotlinType();
            }
        } else if (dispatchReceiverParameter2 != null) {
            jvmKotlinType = CallReceiver.calcDispatchReceiverType(resolvedCall2, dispatchReceiverParameter2, typeMapper, callableMethod);
        } else if (CallReceiver.isLocalFunCall(callableMethod)) {
            Type calleeType = callableMethod.getGenerateCalleeType();
            assert (calleeType != null) : "Could not get callee type for " + resolvedCall2;
            jvmKotlinType = new JvmKotlinType(calleeType, null);
        } else {
            jvmKotlinType = new JvmKotlinType(Type.VOID_TYPE, null);
        }
        return new CallReceiver(dispatchReceiver, extensionReceiver, jvmKotlinType.getType(), jvmKotlinType.getKotlinType(), secondReceiverType, secondReceiverKotlinType);
    }

    private static JvmKotlinType calcDispatchReceiverType(@NotNull ResolvedCall<?> resolvedCall2, @Nullable ReceiverParameterDescriptor dispatchReceiver, @NotNull KotlinTypeMapper typeMapper, @Nullable Callable callableMethod) {
        if (dispatchReceiver == null) {
            return null;
        }
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        if (CodegenUtilKt.isJvmStaticInObjectOrClassOrInterface(descriptor2)) {
            return new JvmKotlinType(Type.VOID_TYPE, null);
        }
        DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
        if (callableMethod != null) {
            if (InlineClassesUtilsKt.isInlineClass(container2)) {
                ClassDescriptor classDescriptor = (ClassDescriptor)container2;
                return new JvmKotlinType(typeMapper.mapType(classDescriptor), classDescriptor.getDefaultType());
            }
            return new JvmKotlinType(callableMethod.getDispatchReceiverType(), callableMethod.getDispatchReceiverKotlinType());
        }
        if (container2 instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)container2;
            return new JvmKotlinType(typeMapper.mapType(classDescriptor), classDescriptor.getDefaultType());
        }
        KotlinType dispatchReceiverType = dispatchReceiver.getReturnType();
        return new JvmKotlinType(typeMapper.mapType(dispatchReceiverType), dispatchReceiverType);
    }

    private static JvmKotlinType calcExtensionReceiverType(@NotNull ResolvedCall<?> resolvedCall2, @Nullable ReceiverParameterDescriptor extensionReceiver, @NotNull KotlinTypeMapper typeMapper, @Nullable Callable callableMethod, @NotNull GenerationState state2) {
        if (extensionReceiver == null) {
            return null;
        }
        Object descriptor2 = resolvedCall2.getCandidateDescriptor();
        if (descriptor2 instanceof PropertyDescriptor && state2.getIntrinsics().getIntrinsic((PropertyDescriptor)descriptor2) != JavaClassProperty.INSTANCE) {
            ReceiverParameterDescriptor receiverCandidate = descriptor2.getExtensionReceiverParameter();
            assert (receiverCandidate != null);
            return new JvmKotlinType(typeMapper.mapType(receiverCandidate.getType()), receiverCandidate.getType());
        }
        return callableMethod != null ? new JvmKotlinType(callableMethod.getExtensionReceiverType(), callableMethod.getExtensionReceiverKotlinType()) : new JvmKotlinType(typeMapper.mapType(extensionReceiver.getType()), extensionReceiver.getType());
    }

    @Override
    public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
        boolean hasExtensionReceiver;
        StackValue currentExtensionReceiver = this.extensionReceiver;
        boolean bl = hasExtensionReceiver = this.extensionReceiver != CallReceiver.none();
        if (this.extensionReceiver instanceof StackValue.SafeCall) {
            currentExtensionReceiver.put(currentExtensionReceiver.type, currentExtensionReceiver.kotlinType, v2);
            currentExtensionReceiver = StackValue.onStack(currentExtensionReceiver.type, currentExtensionReceiver.kotlinType);
        }
        Type dispatchReceiverType = CallReceiver.calcDispatchReceiver(this.secondReceiverType, hasExtensionReceiver, this.dispatchReceiver.type, type2);
        KotlinType dispatchReceiverKotlinType = CallReceiver.calcDispatchReceiver(this.secondReceiverKotlinType, hasExtensionReceiver, this.dispatchReceiver.kotlinType, kotlinType);
        this.dispatchReceiver.put(dispatchReceiverType, dispatchReceiverKotlinType, v2);
        currentExtensionReceiver.moveToTopOfStack(hasExtensionReceiver ? type2 : currentExtensionReceiver.type, hasExtensionReceiver ? kotlinType : currentExtensionReceiver.kotlinType, v2, dispatchReceiverType.getSize());
    }

    private static <T> T calcDispatchReceiver(T secondType, boolean hasExtensionReceiver, T dispatchReceiverType, T defaultType) {
        if (secondType != null) {
            return secondType;
        }
        return hasExtensionReceiver ? dispatchReceiverType : defaultType;
    }

    @Override
    public void dup(@NotNull InstructionAdapter v2, boolean withReceiver) {
        AsmUtil.dup(v2, this.extensionReceiver.type, this.dispatchReceiver.type);
    }

    @NotNull
    public StackValue getDispatchReceiver() {
        return this.dispatchReceiver;
    }

    @NotNull
    public StackValue getExtensionReceiver() {
        return this.extensionReceiver;
    }
}

