/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.psi.tree.IElementType;
import java.lang.constant.Constable;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.codegen.And;
import org.jetbrains.kotlin.codegen.ArgumentGenerator;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.BranchedValue;
import org.jetbrains.kotlin.codegen.CallBasedArgumentGenerator;
import org.jetbrains.kotlin.codegen.CallGenerator;
import org.jetbrains.kotlin.codegen.CallReceiver;
import org.jetbrains.kotlin.codegen.Callable;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.CoercionValue;
import org.jetbrains.kotlin.codegen.DefaultCallArgs;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FieldInfo;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FrameMapBase;
import org.jetbrains.kotlin.codegen.FunctionCallStackValue;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.JvmKotlinType;
import org.jetbrains.kotlin.codegen.OperationStackValue;
import org.jetbrains.kotlin.codegen.Or;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenUtilKt;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsnsKt;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ImportedFromObjectCallableDescriptor;
import org.jetbrains.kotlin.resolve.InlineClassDescriptorResolver;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public abstract class StackValue {
    public static final Local LOCAL_0 = StackValue.local(0, AsmTypes.OBJECT_TYPE);
    private static final StackValue UNIT = StackValue.operation(AsmTypes.UNIT_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)v2 -> {
        v2.visitFieldInsn(178, AsmTypes.UNIT_TYPE.getInternalName(), "INSTANCE", AsmTypes.UNIT_TYPE.getDescriptor());
        return null;
    }));
    @NotNull
    public final Type type;
    @Nullable
    public final KotlinType kotlinType;
    private final boolean canHaveSideEffects;

    protected StackValue(@NotNull Type type2) {
        this(type2, null, true);
    }

    protected StackValue(@NotNull Type type2, boolean canHaveSideEffects) {
        this(type2, null, canHaveSideEffects);
    }

    protected StackValue(@NotNull Type type2, @Nullable KotlinType kotlinType) {
        this(type2, kotlinType, true);
    }

    protected StackValue(@NotNull Type type2, @Nullable KotlinType kotlinType, boolean canHaveSideEffects) {
        this.type = type2;
        this.kotlinType = kotlinType;
        this.canHaveSideEffects = canHaveSideEffects;
    }

    public void moveToTopOfStack(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2, int depth) {
        this.put(type2, kotlinType, v2);
    }

    public void put(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
        this.put(type2, kotlinType, v2, false);
    }

    public void put(@NotNull Type type2, @NotNull InstructionAdapter v2) {
        this.put(type2, null, v2, false);
    }

    public void put(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2, boolean skipReceiver) {
        if (!skipReceiver) {
            this.putReceiver(v2, true);
        }
        this.putSelector(type2, kotlinType, v2);
    }

    public abstract void putSelector(@NotNull Type var1, @Nullable KotlinType var2, @NotNull InstructionAdapter var3);

    public boolean isNonStaticAccess(boolean isRead) {
        return false;
    }

    public void putReceiver(@NotNull InstructionAdapter v2, boolean isRead) {
    }

    public void dup(@NotNull InstructionAdapter v2, boolean withReceiver) {
        if (!Type.VOID_TYPE.equals(this.type)) {
            AsmUtil.dup(v2, this.type);
        }
    }

    public void store(@NotNull StackValue value, @NotNull InstructionAdapter v2) {
        this.store(value, v2, false);
    }

    public boolean canHaveSideEffects() {
        return this.canHaveSideEffects;
    }

    public void store(@NotNull StackValue value, @NotNull InstructionAdapter v2, boolean skipReceiver) {
        if (!skipReceiver) {
            this.putReceiver(v2, false);
        }
        value.put(value.type, value.kotlinType, v2);
        this.storeSelector(value.type, value.kotlinType, v2);
    }

    protected void storeSelector(@NotNull Type topOfStackType, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
        throw new UnsupportedOperationException("Cannot store to value " + this);
    }

    @NotNull
    public static Local local(int index2, @NotNull Type type2) {
        return new Local(index2, type2);
    }

    public static Local local(int index2, @NotNull Type type2, @Nullable KotlinType kotlinType) {
        return new Local(index2, type2, kotlinType);
    }

    @NotNull
    public static StackValue local(int index2, @NotNull Type type2, @NotNull VariableDescriptor descriptor2) {
        if (descriptor2.isLateInit()) {
            return new LateinitLocal(index2, type2, descriptor2.getType(), descriptor2.getName());
        }
        return new Local(index2, type2, descriptor2.getType());
    }

    @NotNull
    public static Delegate delegate(@NotNull Type type2, @NotNull StackValue delegateValue, @NotNull StackValue metadataValue, @NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull ExpressionCodegen codegen) {
        return new Delegate(type2, delegateValue, metadataValue, variableDescriptor, codegen);
    }

    @NotNull
    public static StackValue shared(int index2, @NotNull Type type2) {
        return new Shared(index2, type2);
    }

    @NotNull
    public static StackValue shared(int index2, @NotNull Type type2, @NotNull VariableDescriptor descriptor2) {
        return new Shared(index2, type2, descriptor2.getType(), descriptor2.isLateInit(), descriptor2.getName());
    }

    @NotNull
    public static StackValue onStack(@NotNull Type type2) {
        return StackValue.onStack(type2, null);
    }

    @NotNull
    public static StackValue onStack(@NotNull Type type2, @Nullable KotlinType kotlinType) {
        return type2 == Type.VOID_TYPE ? StackValue.none() : new OnStack(type2, kotlinType);
    }

    @NotNull
    public static StackValue integerConstant(int value, @NotNull Type type2) {
        if (type2 == Type.LONG_TYPE) {
            return StackValue.constant(value, type2);
        }
        if (type2 == Type.BYTE_TYPE || type2 == Type.SHORT_TYPE || type2 == Type.INT_TYPE) {
            return StackValue.constant(value, type2);
        }
        if (type2 == Type.CHAR_TYPE) {
            return StackValue.constant(Character.valueOf((char)value), type2);
        }
        throw new AssertionError((Object)("Unexpected integer type: " + type2));
    }

    @NotNull
    public static StackValue constant(int value) {
        return StackValue.constant(value, Type.INT_TYPE);
    }

    @NotNull
    public static StackValue constant(@Nullable Object value, @NotNull Type type2) {
        return StackValue.constant(value, type2, null);
    }

    @NotNull
    public static StackValue constant(@Nullable Object value, @NotNull Type type2, @Nullable KotlinType kotlinType) {
        if (type2 == Type.BOOLEAN_TYPE) {
            assert (value instanceof Boolean) : "Value for boolean constant should have boolean type: " + value;
            return BranchedValue.Companion.booleanConstant((Boolean)value);
        }
        return new Constant(value, type2, kotlinType);
    }

    public static StackValue createDefaultValue(@NotNull Type type2) {
        if (type2.getSort() == 10 || type2.getSort() == 9) {
            return StackValue.constant(null, type2);
        }
        return StackValue.createDefaultPrimitiveValue(type2);
    }

    private static StackValue createDefaultPrimitiveValue(@NotNull Type type2) {
        assert (1 <= type2.getSort() && type2.getSort() <= 8) : "'createDefaultPrimitiveValue' method should be called only for primitive types, but " + type2;
        Constable value = 0;
        if (type2.getSort() == 1) {
            value = Boolean.FALSE;
        } else if (type2.getSort() == 6) {
            value = new Float(0.0);
        } else if (type2.getSort() == 8) {
            value = new Double(0.0);
        } else if (type2.getSort() == 7) {
            value = new Long(0L);
        }
        return StackValue.constant(value, type2);
    }

    @NotNull
    public static StackValue cmp(@NotNull IElementType opToken, @NotNull Type type2, StackValue left, StackValue right) {
        return BranchedValue.Companion.cmp(opToken, type2, left, right);
    }

    @NotNull
    public static StackValue not(@NotNull StackValue stackValue) {
        return BranchedValue.Companion.createInvertValue(stackValue);
    }

    public static StackValue or(@NotNull StackValue left, @NotNull StackValue right) {
        return new Or(left, right);
    }

    public static StackValue and(@NotNull StackValue left, @NotNull StackValue right) {
        return new And(left, right);
    }

    public static StackValue compareIntWithZero(@NotNull StackValue argument, int operation) {
        return new BranchedValue(argument, null, Type.INT_TYPE, operation);
    }

    public static StackValue compareWithNull(@NotNull StackValue argument, int operation) {
        return new BranchedValue(argument, null, AsmTypes.OBJECT_TYPE, operation);
    }

    @NotNull
    public static StackValue arrayElement(@NotNull Type type2, @Nullable KotlinType kotlinType, StackValue array, StackValue index2) {
        return new ArrayElement(type2, kotlinType, array, index2);
    }

    @NotNull
    public static StackValue collectionElement(CollectionElementReceiver collectionElementReceiver, Type type2, KotlinType kotlinType, ResolvedCall<FunctionDescriptor> getter2, ResolvedCall<FunctionDescriptor> setter2, ExpressionCodegen codegen) {
        return new CollectionElement(collectionElementReceiver, type2, kotlinType, getter2, setter2, codegen);
    }

    public static UnderlyingValueOfInlineClass underlyingValueOfInlineClass(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull StackValue receiver) {
        return new UnderlyingValueOfInlineClass(type2, kotlinType, receiver);
    }

    @NotNull
    public static Field field(@NotNull Type type2, @NotNull Type owner, @NotNull String name, boolean isStatic, @NotNull StackValue receiver) {
        return StackValue.field(type2, null, owner, name, isStatic, receiver, null);
    }

    @NotNull
    public static Field field(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull Type owner, @NotNull String name, boolean isStatic, @NotNull StackValue receiver, @Nullable DeclarationDescriptor descriptor2) {
        return new Field(type2, kotlinType, owner, name, isStatic, receiver, descriptor2);
    }

    @NotNull
    public static Field field(@NotNull Field field, @NotNull StackValue newReceiver) {
        return StackValue.field(field.type, field.kotlinType, field.owner, field.name, field.isStaticPut, newReceiver, field.descriptor);
    }

    @NotNull
    public static Field field(@NotNull FieldInfo info, @NotNull StackValue receiver) {
        return StackValue.field(info.getFieldType(), Type.getObjectType(info.getOwnerInternalName()), info.getFieldName(), info.isStatic(), receiver);
    }

    @NotNull
    public static StackValue changeReceiverForFieldAndSharedVar(@NotNull StackValueWithSimpleReceiver stackValue, @Nullable StackValue newReceiver) {
        if (newReceiver == null || stackValue.isStaticPut) {
            return stackValue;
        }
        return stackValue.changeReceiver(newReceiver);
    }

    @NotNull
    public static Property property(@NotNull PropertyDescriptor descriptor2, @Nullable Type backingFieldOwner, @NotNull Type type2, boolean isStaticBackingField, @Nullable String fieldName, @Nullable CallableMethod getter2, @Nullable CallableMethod setter2, @NotNull StackValue receiver, @NotNull ExpressionCodegen codegen, @Nullable ResolvedCall resolvedCall2, boolean skipLateinitAssertion) {
        return new Property(descriptor2, backingFieldOwner, getter2, setter2, isStaticBackingField, fieldName, type2, receiver, codegen, resolvedCall2, skipLateinitAssertion);
    }

    @NotNull
    public static StackValue expression(Type type2, KtExpression expression2, ExpressionCodegen generator) {
        return new Expression(type2, expression2, generator);
    }

    private static void box(Type type2, Type toType, InstructionAdapter v2) {
        Type boxedType;
        if (type2 == Type.INT_TYPE) {
            if (toType.getInternalName().equals("java/lang/Byte")) {
                type2 = Type.BYTE_TYPE;
            } else if (toType.getInternalName().equals("java/lang/Short")) {
                type2 = Type.SHORT_TYPE;
            } else if (toType.getInternalName().equals("java/lang/Long")) {
                type2 = Type.LONG_TYPE;
            }
            v2.cast(Type.INT_TYPE, type2);
        }
        if ((boxedType = AsmUtil.boxType(type2)) == type2) {
            return;
        }
        v2.invokestatic(boxedType.getInternalName(), "valueOf", Type.getMethodDescriptor(boxedType, type2), false);
        StackValue.coerce(boxedType, toType, v2);
    }

    private static void unbox(Type methodOwner, Type type2, InstructionAdapter v2) {
        assert (AsmUtil.isPrimitive(type2)) : "Unboxing should be performed to primitive type, but " + type2.getClassName();
        v2.invokevirtual(methodOwner.getInternalName(), type2.getClassName() + "Value", "()" + type2.getDescriptor(), false);
    }

    private static void boxInlineClass(@NotNull KotlinType kotlinType, @NotNull InstructionAdapter v2) {
        Type boxedType = KotlinTypeMapper.mapInlineClassTypeAsDeclaration(kotlinType);
        Type owner = KotlinTypeMapper.mapToErasedInlineClassType(kotlinType);
        Type underlyingType = KotlinTypeMapper.mapUnderlyingTypeOfInlineClassType(kotlinType);
        if (TypeUtils.isNullableType(kotlinType) && !AsmUtil.isPrimitive(underlyingType)) {
            StackValue.boxOrUnboxWithNullCheck(v2, vv -> StackValue.invokeBoxMethod(vv, boxedType, owner, underlyingType));
        } else {
            StackValue.invokeBoxMethod(v2, boxedType, owner, underlyingType);
        }
    }

    private static void invokeBoxMethod(@NotNull InstructionAdapter v2, Type boxedType, Type owner, Type underlyingType) {
        v2.invokestatic(owner.getInternalName(), InlineClassDescriptorResolver.BOX_METHOD_NAME.asString(), Type.getMethodDescriptor(boxedType, underlyingType), false);
    }

    public static void unboxInlineClass(@NotNull Type type2, @NotNull KotlinType targetInlineClassType, @NotNull InstructionAdapter v2) {
        Type owner = KotlinTypeMapper.mapInlineClassTypeAsDeclaration(targetInlineClassType);
        StackValue.coerce(type2, owner, v2);
        Type resultType = KotlinTypeMapper.mapUnderlyingTypeOfInlineClassType(targetInlineClassType);
        if (TypeUtils.isNullableType(targetInlineClassType) && !AsmUtil.isPrimitive(type2)) {
            StackValue.boxOrUnboxWithNullCheck(v2, vv -> StackValue.invokeUnboxMethod(vv, owner, resultType));
        } else {
            StackValue.invokeUnboxMethod(v2, owner, resultType);
        }
    }

    private static void invokeUnboxMethod(@NotNull InstructionAdapter v2, Type owner, Type resultType) {
        v2.invokevirtual(owner.getInternalName(), InlineClassDescriptorResolver.UNBOX_METHOD_NAME.asString(), "()" + resultType.getDescriptor(), false);
    }

    private static void boxOrUnboxWithNullCheck(@NotNull InstructionAdapter v2, @NotNull Consumer<InstructionAdapter> body) {
        Label lNull = new Label();
        Label lDone = new Label();
        v2.dup();
        v2.ifnull(lNull);
        body.accept(v2);
        v2.goTo(lDone);
        v2.mark(lNull);
        v2.pop();
        v2.aconst(null);
        v2.mark(lDone);
    }

    protected void coerceTo(@NotNull Type toType, @Nullable KotlinType toKotlinType, @NotNull InstructionAdapter v2) {
        StackValue.coerce(this.type, this.kotlinType, toType, toKotlinType, v2);
    }

    protected void coerceFrom(@NotNull Type topOfStackType, @Nullable KotlinType topOfStackKotlinType, @NotNull InstructionAdapter v2) {
        StackValue.coerce(topOfStackType, topOfStackKotlinType, this.type, this.kotlinType, v2);
    }

    public static void coerce(@NotNull Type fromType, @Nullable KotlinType fromKotlinType, @NotNull Type toType, @Nullable KotlinType toKotlinType, @NotNull InstructionAdapter v2) {
        if (StackValue.coerceInlineClasses(fromType, fromKotlinType, toType, toKotlinType, v2)) {
            return;
        }
        StackValue.coerce(fromType, toType, v2);
    }

    private static boolean coerceInlineClasses(@NotNull Type fromType, @Nullable KotlinType fromKotlinType, @NotNull Type toType, @Nullable KotlinType toKotlinType, @NotNull InstructionAdapter v2) {
        if (fromKotlinType == null || toKotlinType == null) {
            return false;
        }
        boolean isFromTypeInlineClass = InlineClassesUtilsKt.isInlineClassType(fromKotlinType);
        boolean isToTypeInlineClass = InlineClassesUtilsKt.isInlineClassType(toKotlinType);
        if (!isFromTypeInlineClass && !isToTypeInlineClass) {
            return false;
        }
        if (fromKotlinType.equals(toKotlinType) && fromType.equals(toType)) {
            return true;
        }
        if (isFromTypeInlineClass && isToTypeInlineClass) {
            boolean isFromTypeUnboxed = StackValue.isUnboxedInlineClass(fromKotlinType, fromType);
            boolean isToTypeUnboxed = StackValue.isUnboxedInlineClass(toKotlinType, toType);
            if (isFromTypeUnboxed && !isToTypeUnboxed) {
                StackValue.boxInlineClass(fromKotlinType, v2);
                return true;
            }
            if (!isFromTypeUnboxed && isToTypeUnboxed) {
                StackValue.unboxInlineClass(fromType, toKotlinType, v2);
                return true;
            }
        } else if (isFromTypeInlineClass) {
            if (StackValue.isUnboxedInlineClass(fromKotlinType, fromType)) {
                StackValue.boxInlineClass(fromKotlinType, v2);
                return true;
            }
        } else if (StackValue.isUnboxedInlineClass(toKotlinType, toType)) {
            StackValue.unboxInlineClass(fromType, toKotlinType, v2);
            return true;
        }
        return false;
    }

    private static boolean isUnboxedInlineClass(@NotNull KotlinType kotlinType, @NotNull Type actualType) {
        return KotlinTypeMapper.mapUnderlyingTypeOfInlineClassType(kotlinType).equals(actualType);
    }

    public static void coerce(@NotNull Type fromType, @NotNull Type toType, @NotNull InstructionAdapter v2) {
        if (toType.equals(fromType)) {
            return;
        }
        if (toType.getSort() == 0) {
            AsmUtil.pop(v2, fromType);
        } else if (fromType.getSort() == 0) {
            if (toType.equals(AsmTypes.UNIT_TYPE) || toType.equals(AsmTypes.OBJECT_TYPE)) {
                StackValue.putUnitInstance(v2);
            } else if (toType.getSort() == 10 || toType.getSort() == 9) {
                v2.aconst(null);
            } else {
                AsmUtil.pushDefaultPrimitiveValueOnStack(toType, v2);
            }
        } else if (toType.equals(AsmTypes.UNIT_TYPE)) {
            if (fromType.equals(AsmTypes.getType(Object.class))) {
                v2.checkcast(AsmTypes.UNIT_TYPE);
            } else if (!fromType.equals(AsmTypes.getType(Void.class))) {
                AsmUtil.pop(v2, fromType);
                StackValue.putUnitInstance(v2);
            }
        } else if (toType.getSort() == 9) {
            if (fromType.getSort() != 9) {
                v2.checkcast(toType);
            } else if (toType.getDimensions() != fromType.getDimensions()) {
                v2.checkcast(toType);
            } else if (!toType.getElementType().equals(AsmTypes.OBJECT_TYPE)) {
                v2.checkcast(toType);
            }
        } else if (toType.getSort() == 10) {
            if (fromType.getSort() == 10 || fromType.getSort() == 9) {
                if (!toType.equals(AsmTypes.OBJECT_TYPE)) {
                    v2.checkcast(toType);
                }
            } else {
                StackValue.box(fromType, toType, v2);
            }
        } else if (fromType.getSort() == 10) {
            Type unboxedType = AsmUtil.unboxPrimitiveTypeOrNull(fromType);
            if (unboxedType != null) {
                StackValue.unbox(fromType, unboxedType, v2);
                StackValue.coerce(unboxedType, toType, v2);
            } else if (toType.getSort() == 1) {
                StackValue.coerce(fromType, AsmTypes.BOOLEAN_WRAPPER_TYPE, v2);
                StackValue.unbox(AsmTypes.BOOLEAN_WRAPPER_TYPE, Type.BOOLEAN_TYPE, v2);
            } else if (toType.getSort() == 2) {
                if (fromType.equals(AsmTypes.NUMBER_TYPE)) {
                    StackValue.unbox(AsmTypes.NUMBER_TYPE, Type.INT_TYPE, v2);
                    v2.visitInsn(146);
                } else {
                    StackValue.coerce(fromType, AsmTypes.CHARACTER_WRAPPER_TYPE, v2);
                    StackValue.unbox(AsmTypes.CHARACTER_WRAPPER_TYPE, Type.CHAR_TYPE, v2);
                }
            } else {
                StackValue.coerce(fromType, AsmTypes.NUMBER_TYPE, v2);
                StackValue.unbox(AsmTypes.NUMBER_TYPE, toType, v2);
            }
        } else {
            v2.cast(fromType, toType);
        }
    }

    public static void putUnitInstance(@NotNull InstructionAdapter v2) {
        StackValue.unit().put(AsmTypes.UNIT_TYPE, null, v2);
    }

    public static StackValue unit() {
        return UNIT;
    }

    public static StackValue none() {
        return None.INSTANCE;
    }

    public static Field receiverWithRefWrapper(@NotNull Type localType, @NotNull Type classType, @NotNull String fieldName, @NotNull StackValue receiver, @Nullable DeclarationDescriptor descriptor2) {
        return StackValue.field(StackValue.sharedTypeForType(localType), null, classType, fieldName, false, receiver, descriptor2);
    }

    public static FieldForSharedVar fieldForSharedVar(@NotNull Type localType, @NotNull Type classType, @NotNull String fieldName, @NotNull Field refWrapper, @NotNull VariableDescriptor variableDescriptor) {
        return new FieldForSharedVar(localType, classType, fieldName, refWrapper, variableDescriptor.isLateInit(), variableDescriptor.getName());
    }

    @NotNull
    public static FieldForSharedVar fieldForSharedVar(@NotNull FieldForSharedVar field, @NotNull StackValue newReceiver) {
        Field oldReceiver = (Field)field.receiver;
        Field newSharedVarReceiver = StackValue.field(oldReceiver, newReceiver);
        return new FieldForSharedVar(field.type, field.owner, field.name, newSharedVarReceiver, field.isLateinit, field.variableName);
    }

    public static StackValue coercion(@NotNull StackValue value, @NotNull Type castType, @Nullable KotlinType castKotlinType) {
        return StackValue.coercionValueForArgumentOfInlineClassConstructor(value, castType, castKotlinType, null);
    }

    public static StackValue coercionValueForArgumentOfInlineClassConstructor(@NotNull StackValue value, @NotNull Type castType, @Nullable KotlinType castKotlinType, @Nullable KotlinType underlyingKotlinType) {
        boolean kotlinTypesAreEqual;
        boolean bl = kotlinTypesAreEqual = value.kotlinType == null && castKotlinType == null || value.kotlinType != null && castKotlinType != null && castKotlinType.equals(value.kotlinType);
        if (value.type.equals(castType) && kotlinTypesAreEqual) {
            return value;
        }
        return new CoercionValue(value, castType, castKotlinType, underlyingKotlinType);
    }

    @NotNull
    public static StackValue thisOrOuter(@NotNull ExpressionCodegen codegen, @NotNull ClassDescriptor descriptor2, boolean isSuper, boolean castReceiver) {
        boolean coerceType = descriptor2.getKind() == ClassKind.INTERFACE || castReceiver && !isSuper;
        return new ThisOuter(codegen, descriptor2, isSuper, coerceType);
    }

    public static StackValue postIncrement(int index2, int increment) {
        return new PostIncrement(index2, increment);
    }

    public static StackValue preIncrementForLocalVar(int index2, int increment) {
        return new PreIncrementForLocalVar(index2, increment);
    }

    public static StackValue preIncrement(@NotNull Type type2, @NotNull StackValue stackValue, int delta, ResolvedCall resolvedCall2, @NotNull ExpressionCodegen codegen) {
        if (stackValue instanceof Local && Type.INT_TYPE == stackValue.type) {
            return StackValue.preIncrementForLocalVar(((Local)stackValue).index, delta);
        }
        return new PrefixIncrement(type2, stackValue, resolvedCall2, codegen);
    }

    public static StackValue receiver(ResolvedCall<?> resolvedCall2, StackValue receiver, ExpressionCodegen codegen, @Nullable Callable callableMethod) {
        ReceiverValue callDispatchReceiver = resolvedCall2.getDispatchReceiver();
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        if (descriptor2 instanceof SyntheticFieldDescriptor) {
            callDispatchReceiver = ((SyntheticFieldDescriptor)descriptor2).getDispatchReceiverForBackend();
        }
        ReceiverValue callExtensionReceiver = resolvedCall2.getExtensionReceiver();
        boolean isImportedObjectMember = false;
        if (descriptor2 instanceof ImportedFromObjectCallableDescriptor) {
            isImportedObjectMember = true;
            descriptor2 = ((ImportedFromObjectCallableDescriptor)descriptor2).getCallableFromObject();
        }
        if (callDispatchReceiver != null || callExtensionReceiver != null || StackValue.isLocalFunCall(callableMethod) || isImportedObjectMember) {
            ReceiverParameterDescriptor dispatchReceiverParameter2 = descriptor2.getDispatchReceiverParameter();
            ReceiverParameterDescriptor extensionReceiverParameter2 = descriptor2.getExtensionReceiverParameter();
            if (descriptor2 instanceof SyntheticFieldDescriptor) {
                dispatchReceiverParameter2 = ((SyntheticFieldDescriptor)descriptor2).getDispatchReceiverParameterForBackend();
            }
            boolean hasExtensionReceiver = callExtensionReceiver != null;
            StackValue dispatchReceiver = StackValue.platformStaticCallIfPresent(StackValue.genReceiver(hasExtensionReceiver ? StackValue.none() : receiver, codegen, (CallableDescriptor)descriptor2, callableMethod, callDispatchReceiver, false), (CallableDescriptor)descriptor2);
            StackValue extensionReceiver = StackValue.genReceiver(receiver, codegen, (CallableDescriptor)descriptor2, callableMethod, callExtensionReceiver, true);
            return CallReceiver.generateCallReceiver(resolvedCall2, codegen, callableMethod, dispatchReceiverParameter2, dispatchReceiver, extensionReceiverParameter2, extensionReceiver);
        }
        return receiver;
    }

    private static StackValue genReceiver(@NotNull StackValue receiver, @NotNull ExpressionCodegen codegen, @NotNull CallableDescriptor descriptor2, @Nullable Callable callableMethod, @Nullable ReceiverValue receiverValue, boolean isExtension) {
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        if (receiver == StackValue.none()) {
            if (receiverValue != null) {
                return codegen.generateReceiverValue(receiverValue, false);
            }
            if (StackValue.isLocalFunCall(callableMethod) && !isExtension) {
                SimpleFunctionDescriptor initial;
                if (descriptor2 instanceof SimpleFunctionDescriptor && (initial = CoroutineCodegenUtilKt.unwrapInitialDescriptorForSuspendFunction((SimpleFunctionDescriptor)descriptor2)) != null && initial.isSuspend()) {
                    StackValue value = codegen.findLocalOrCapturedValue(initial.getOriginal());
                    assert (value != null) : "Local suspend fun should be found in locals or in captured params: " + descriptor2 + " initial local suspend fun: " + initial;
                    return value;
                }
                StackValue value = codegen.findLocalOrCapturedValue(descriptor2.getOriginal());
                assert (value != null) : "Local fun should be found in locals or in captured params: " + descriptor2;
                return value;
            }
            if (!isExtension && DescriptorUtils.isObject(containingDeclaration)) {
                return StackValue.singleton((ClassDescriptor)containingDeclaration, codegen.typeMapper);
            }
        } else if (receiverValue != null) {
            return receiver;
        }
        return StackValue.none();
    }

    private static StackValue platformStaticCallIfPresent(@NotNull StackValue resultReceiver, @NotNull CallableDescriptor descriptor2) {
        if (CodegenUtilKt.isJvmStaticInObjectOrClassOrInterface(descriptor2)) {
            if (resultReceiver.canHaveSideEffects()) {
                return StackValue.coercion(resultReceiver, Type.VOID_TYPE, null);
            }
            return StackValue.none();
        }
        return resultReceiver;
    }

    @Contract(value="null -> false")
    static boolean isLocalFunCall(@Nullable Callable callableMethod) {
        return callableMethod != null && callableMethod.getGenerateCalleeType() != null;
    }

    public static StackValue receiverWithoutReceiverArgument(StackValue receiverWithParameter) {
        if (receiverWithParameter instanceof CallReceiver) {
            return ((CallReceiver)receiverWithParameter).withoutReceiverArgument();
        }
        return receiverWithParameter;
    }

    @NotNull
    public static Field enumEntry(@NotNull ClassDescriptor descriptor2, @NotNull KotlinTypeMapper typeMapper) {
        DeclarationDescriptor enumClass2 = descriptor2.getContainingDeclaration();
        assert (DescriptorUtils.isEnumClass(enumClass2)) : "Enum entry should be declared in enum class: " + descriptor2;
        SimpleType enumType = ((ClassDescriptor)enumClass2).getDefaultType();
        Type type2 = typeMapper.mapType(enumType);
        return StackValue.field(type2, enumType, type2, descriptor2.getName().asString(), true, StackValue.none(), descriptor2);
    }

    @NotNull
    public static Field singleton(@NotNull ClassDescriptor classDescriptor, @NotNull KotlinTypeMapper typeMapper) {
        return StackValue.field(FieldInfo.createForSingleton(classDescriptor, typeMapper), StackValue.none());
    }

    public static Field createSingletonViaInstance(@NotNull ClassDescriptor classDescriptor, @NotNull KotlinTypeMapper typeMapper, @NotNull String name) {
        return StackValue.field(FieldInfo.createSingletonViaInstance(classDescriptor, typeMapper, name), StackValue.none());
    }

    public static StackValue operation(Type type2, Function1<InstructionAdapter, Unit> lambda2) {
        return StackValue.operation(type2, null, lambda2);
    }

    public static StackValue operation(Type type2, KotlinType kotlinType, Function1<InstructionAdapter, Unit> lambda2) {
        return new OperationStackValue(type2, kotlinType, lambda2);
    }

    public static StackValue functionCall(Type type2, KotlinType kotlinType, Function1<InstructionAdapter, Unit> lambda2) {
        return new FunctionCallStackValue(type2, kotlinType, lambda2);
    }

    public static boolean couldSkipReceiverOnStaticCall(StackValue value) {
        return value instanceof Local || value instanceof Constant;
    }

    private static void genNonNullAssertForLateinit(@NotNull InstructionAdapter v2, @NotNull String name) {
        v2.dup();
        Label ok = new Label();
        v2.ifnonnull(ok);
        v2.visitLdcInsn(name);
        v2.invokestatic("kotlin/jvm/internal/Intrinsics", "throwUninitializedPropertyAccessException", "(Ljava/lang/String;)V", false);
        v2.mark(ok);
    }

    @NotNull
    public static Type sharedTypeForType(@NotNull Type type2) {
        switch (type2.getSort()) {
            case 9: 
            case 10: {
                return AsmTypes.OBJECT_REF_TYPE;
            }
        }
        PrimitiveType primitiveType = AsmUtil.asmPrimitiveTypeToLangPrimitiveType(type2);
        if (primitiveType == null) {
            throw new UnsupportedOperationException();
        }
        return AsmTypes.sharedTypeForPrimitive(primitiveType);
    }

    public static Type refType(Type type2) {
        if (type2.getSort() == 10 || type2.getSort() == 9) {
            return AsmTypes.OBJECT_TYPE;
        }
        return type2;
    }

    public static StackValue complexWriteReadReceiver(StackValue stackValue) {
        return StackValue.complexReceiver(stackValue, false, true);
    }

    private static StackValue complexReceiver(StackValue stackValue, boolean ... isReadOperations) {
        if (stackValue instanceof Delegate) {
            StackValue.throwUnsupportedComplexOperation(((Delegate)stackValue).variableDescriptor);
        }
        if (stackValue instanceof StackValueWithSimpleReceiver) {
            return new DelegatedForComplexReceiver(stackValue.type, (StackValueWithSimpleReceiver)stackValue, new ComplexReceiver((StackValueWithSimpleReceiver)stackValue, isReadOperations));
        }
        return stackValue;
    }

    private static void throwUnsupportedComplexOperation(@NotNull CallableDescriptor descriptor2) {
        throw new RuntimeException("Augmented assignment and increment are not supported for local delegated properties and inline properties: " + descriptor2);
    }

    static class SafeFallback
    extends StackValueWithSimpleReceiver {
        @Nullable
        private final Label ifNull;

        public SafeFallback(@NotNull Type type2, @Nullable Label ifNull, StackValue receiver) {
            super(type2, null, false, false, receiver, true);
            this.ifNull = ifNull;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
            Label end = new Label();
            v2.goTo(end);
            v2.mark(this.ifNull);
            v2.pop();
            if (!this.type.equals(Type.VOID_TYPE)) {
                v2.aconst(null);
            }
            v2.mark(end);
            this.coerceTo(type2, kotlinType, v2);
        }

        @Override
        public void store(@NotNull StackValue rightSide, @NotNull InstructionAdapter v2, boolean skipReceiver) {
            this.receiver.store(rightSide, v2, skipReceiver);
            Label end = new Label();
            v2.goTo(end);
            v2.mark(this.ifNull);
            v2.pop();
            v2.mark(end);
        }
    }

    static class SafeCall
    extends StackValue {
        @NotNull
        private final Type type;
        private final StackValue receiver;
        @Nullable
        private final Label ifNull;

        public SafeCall(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull StackValue value, @Nullable Label ifNull) {
            super(type2, kotlinType);
            this.type = type2;
            this.receiver = value;
            this.ifNull = ifNull;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
            this.receiver.put(this.type, this.kotlinType, v2);
            if (this.ifNull != null) {
                v2.dup();
                v2.ifnull(this.ifNull);
            }
            this.coerceTo(type2, kotlinType, v2);
        }
    }

    public static class DelegatedForComplexReceiver
    extends StackValueWithSimpleReceiver {
        public final StackValueWithSimpleReceiver originalValue;

        public DelegatedForComplexReceiver(@NotNull Type type2, @NotNull StackValueWithSimpleReceiver originalValue, @NotNull ComplexReceiver receiver) {
            super(type2, null, DelegatedForComplexReceiver.bothReceiverStatic(originalValue), DelegatedForComplexReceiver.bothReceiverStatic(originalValue), receiver, originalValue.canHaveSideEffects());
            this.originalValue = originalValue;
        }

        private static boolean bothReceiverStatic(StackValueWithSimpleReceiver originalValue) {
            return !originalValue.isNonStaticAccess(true) && !originalValue.isNonStaticAccess(false);
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
            this.originalValue.putSelector(type2, kotlinType, v2);
        }

        @Override
        public void store(@NotNull StackValue rightSide, @NotNull InstructionAdapter v2, boolean skipReceiver) {
            if (!skipReceiver) {
                this.putReceiver(v2, false);
            }
            this.originalValue.store(rightSide, v2, true);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
            this.originalValue.storeSelector(topOfStackType, kotlinType, v2);
        }

        @Override
        public void dup(@NotNull InstructionAdapter v2, boolean withWriteReceiver) {
            this.originalValue.dup(v2, withWriteReceiver);
        }
    }

    public static class Receiver
    extends StackValue {
        private final StackValue[] instructions;

        protected Receiver(@NotNull Type type2, StackValue ... receiverInstructions) {
            super(type2);
            this.instructions = receiverInstructions;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
            for (StackValue instruction : this.instructions) {
                instruction.put(instruction.type, instruction.kotlinType, v2);
            }
        }
    }

    private static class ComplexReceiver
    extends StackValue {
        private final StackValueWithSimpleReceiver originalValueWithReceiver;
        private final boolean[] isReadOperations;

        public ComplexReceiver(StackValueWithSimpleReceiver value, boolean[] isReadOperations) {
            super(value.type, value.receiver.canHaveSideEffects());
            this.originalValueWithReceiver = value;
            this.isReadOperations = isReadOperations;
            if (value instanceof CollectionElement && value.receiver instanceof CollectionElementReceiver) {
                ((CollectionElementReceiver)value.receiver).isComplexOperationWithDup = true;
            }
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
            boolean wasPut = false;
            StackValue receiver = this.originalValueWithReceiver.receiver;
            for (boolean operation : this.isReadOperations) {
                if (!this.originalValueWithReceiver.isNonStaticAccess(operation)) continue;
                if (!wasPut) {
                    receiver.put(receiver.type, receiver.kotlinType, v2);
                    wasPut = true;
                    continue;
                }
                receiver.dup(v2, false);
            }
            if (!wasPut && receiver.canHaveSideEffects()) {
                receiver.put(Type.VOID_TYPE, null, v2);
            }
        }
    }

    public static abstract class StackValueWithSimpleReceiver
    extends StackValue {
        public final boolean isStaticPut;
        public final boolean isStaticStore;
        @NotNull
        public final StackValue receiver;

        public StackValueWithSimpleReceiver(@NotNull Type type2, @Nullable KotlinType kotlinType, boolean isStaticPut, boolean isStaticStore, @NotNull StackValue receiver, boolean canHaveSideEffects) {
            super(type2, kotlinType, canHaveSideEffects);
            this.receiver = receiver;
            this.isStaticPut = isStaticPut;
            this.isStaticStore = isStaticStore;
        }

        @Override
        public void putReceiver(@NotNull InstructionAdapter v2, boolean isRead) {
            boolean hasReceiver = this.isNonStaticAccess(isRead);
            if (hasReceiver || this.receiver.canHaveSideEffects()) {
                this.receiver.put(hasReceiver ? this.receiver.type : Type.VOID_TYPE, hasReceiver ? this.receiver.kotlinType : null, v2);
            }
        }

        @Override
        public boolean isNonStaticAccess(boolean isRead) {
            return isRead ? !this.isStaticPut : !this.isStaticStore;
        }

        public int receiverSize() {
            return this.receiver.type.getSize();
        }

        @Override
        public void dup(@NotNull InstructionAdapter v2, boolean withWriteReceiver) {
            if (!withWriteReceiver) {
                super.dup(v2, false);
            } else {
                int receiverSize = this.isNonStaticAccess(false) ? this.receiverSize() : 0;
                switch (receiverSize) {
                    case 0: {
                        AsmUtil.dup(v2, this.type);
                        break;
                    }
                    case 1: {
                        if (this.type.getSize() == 2) {
                            v2.dup2X1();
                            break;
                        }
                        v2.dupX1();
                        break;
                    }
                    case 2: {
                        if (this.type.getSize() == 2) {
                            v2.dup2X2();
                            break;
                        }
                        v2.dupX2();
                        break;
                    }
                    case -1: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
        }

        @Override
        public void store(@NotNull StackValue rightSide, @NotNull InstructionAdapter v2, boolean skipReceiver) {
            if (!skipReceiver) {
                this.putReceiver(v2, false);
            }
            rightSide.put(rightSide.type, rightSide.kotlinType, v2);
            this.storeSelector(rightSide.type, rightSide.kotlinType, v2);
        }

        protected StackValueWithSimpleReceiver changeReceiver(@NotNull StackValue newReceiver) {
            return this;
        }
    }

    private static class PrefixIncrement
    extends StackValue {
        private final ResolvedCall resolvedCall;
        private final ExpressionCodegen codegen;
        private StackValue value;

        public PrefixIncrement(@NotNull Type type2, @NotNull StackValue value, ResolvedCall resolvedCall2, @NotNull ExpressionCodegen codegen) {
            super(type2);
            this.value = value;
            this.resolvedCall = resolvedCall2;
            this.codegen = codegen;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
            this.value = StackValue.complexReceiver(this.value, new boolean[]{true, false, true});
            this.value.put(this.type, this.kotlinType, v2);
            this.value.store(this.codegen.invokeFunction(this.resolvedCall, StackValue.onStack(this.type, this.kotlinType)), v2, true);
            this.value.put(this.type, this.kotlinType, v2, true);
            this.coerceTo(type2, kotlinType, v2);
        }
    }

    private static class PreIncrementForLocalVar
    extends StackValue {
        private final int index;
        private final int increment;

        public PreIncrementForLocalVar(int index2, int increment) {
            super(Type.INT_TYPE);
            this.index = index2;
            this.increment = increment;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
            v2.iinc(this.index, this.increment);
            if (!type2.equals(Type.VOID_TYPE)) {
                v2.load(this.index, Type.INT_TYPE);
                this.coerceTo(type2, kotlinType, v2);
            }
        }
    }

    private static class PostIncrement
    extends StackValue {
        private final int index;
        private final int increment;

        public PostIncrement(int index2, int increment) {
            super(Type.INT_TYPE);
            this.index = index2;
            this.increment = increment;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
            if (!type2.equals(Type.VOID_TYPE)) {
                v2.load(this.index, Type.INT_TYPE);
                this.coerceTo(type2, kotlinType, v2);
            }
            v2.iinc(this.index, this.increment);
        }
    }

    private static class ThisOuter
    extends StackValue {
        private final ExpressionCodegen codegen;
        private final ClassDescriptor descriptor;
        private final boolean isSuper;
        private final boolean coerceType;

        public ThisOuter(ExpressionCodegen codegen, ClassDescriptor descriptor2, boolean isSuper, boolean coerceType) {
            super(AsmTypes.OBJECT_TYPE, false);
            this.codegen = codegen;
            this.descriptor = descriptor2;
            this.isSuper = isSuper;
            this.coerceType = coerceType;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
            StackValue stackValue = this.codegen.generateThisOrOuter(this.descriptor, this.isSuper);
            stackValue.put(this.coerceType ? type2 : stackValue.type, this.coerceType ? kotlinType : stackValue.kotlinType, v2);
        }
    }

    public static class FieldForSharedVar
    extends StackValueWithSimpleReceiver {
        final Type owner;
        final String name;
        final boolean isLateinit;
        final Name variableName;

        public FieldForSharedVar(Type type2, Type owner, String name, Field receiver, boolean isLateinit, Name variableName) {
            super(type2, null, false, false, receiver, receiver.canHaveSideEffects());
            if (isLateinit && variableName == null) {
                throw new IllegalArgumentException("variableName should be non-null for captured lateinit variable " + name);
            }
            this.owner = owner;
            this.name = name;
            this.isLateinit = isLateinit;
            this.variableName = variableName;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
            Type sharedType = FieldForSharedVar.sharedTypeForType(this.type);
            Type refType = FieldForSharedVar.refType(this.type);
            v2.visitFieldInsn(180, sharedType.getInternalName(), "element", refType.getDescriptor());
            if (this.isLateinit) {
                StackValue.genNonNullAssertForLateinit(v2, this.variableName.asString());
            }
            this.coerceFrom(refType, null, v2);
            this.coerceTo(type2, kotlinType, v2);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @Nullable KotlinType topOfStackKotlinType, @NotNull InstructionAdapter v2) {
            this.coerceFrom(topOfStackType, topOfStackKotlinType, v2);
            v2.visitFieldInsn(181, FieldForSharedVar.sharedTypeForType(this.type).getInternalName(), "element", FieldForSharedVar.refType(this.type).getDescriptor());
        }

        @Override
        protected StackValueWithSimpleReceiver changeReceiver(@NotNull StackValue newReceiver) {
            return FieldForSharedVar.fieldForSharedVar(this, newReceiver);
        }
    }

    public static class Shared
    extends StackValueWithSimpleReceiver {
        private final int index;
        private final boolean isLateinit;
        private final Name name;

        public Shared(int index2, Type type2, KotlinType kotlinType, boolean isLateinit, Name name) {
            super(type2, kotlinType, false, false, Shared.local(index2, AsmTypes.OBJECT_TYPE), false);
            this.index = index2;
            if (isLateinit && name == null) {
                throw new IllegalArgumentException("Lateinit shared local variable should have name: #" + index2 + " " + type2.getDescriptor());
            }
            this.isLateinit = isLateinit;
            this.name = name;
        }

        public Shared(int index2, Type type2) {
            this(index2, type2, null, false, null);
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
            Type refType = Shared.refType(this.type);
            Type sharedType = Shared.sharedTypeForType(this.type);
            v2.visitFieldInsn(180, sharedType.getInternalName(), "element", refType.getDescriptor());
            if (this.isLateinit) {
                StackValue.genNonNullAssertForLateinit(v2, this.name.asString());
            }
            this.coerceFrom(refType, null, v2);
            this.coerceTo(type2, kotlinType, v2);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @Nullable KotlinType topOfStackKotlinType, @NotNull InstructionAdapter v2) {
            this.coerceFrom(topOfStackType, topOfStackKotlinType, v2);
            Type refType = Shared.refType(this.type);
            Type sharedType = Shared.sharedTypeForType(this.type);
            v2.visitFieldInsn(181, sharedType.getInternalName(), "element", refType.getDescriptor());
        }
    }

    private static class Expression
    extends StackValue {
        private final KtExpression expression;
        private final ExpressionCodegen generator;

        public Expression(Type type2, KtExpression expression2, ExpressionCodegen generator) {
            super(type2, generator.kotlinType(expression2));
            this.expression = expression2;
            this.generator = generator;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
            this.generator.gen(this.expression, type2, kotlinType);
        }
    }

    public static class Property
    extends StackValueWithSimpleReceiver {
        private final CallableMethod getter;
        private final CallableMethod setter;
        private final Type backingFieldOwner;
        private final PropertyDescriptor descriptor;
        private final String fieldName;
        private final ExpressionCodegen codegen;
        private final ResolvedCall resolvedCall;
        private final boolean skipLateinitAssertion;

        public Property(@NotNull PropertyDescriptor descriptor2, @Nullable Type backingFieldOwner, @Nullable CallableMethod getter2, @Nullable CallableMethod setter2, boolean isStaticBackingField, @Nullable String fieldName, @NotNull Type type2, @NotNull StackValue receiver, @NotNull ExpressionCodegen codegen, @Nullable ResolvedCall resolvedCall2, boolean skipLateinitAssertion) {
            super(type2, descriptor2.getType(), Property.isStatic(isStaticBackingField, getter2), Property.isStatic(isStaticBackingField, setter2), receiver, true);
            this.backingFieldOwner = backingFieldOwner;
            this.getter = getter2;
            this.setter = setter2;
            this.descriptor = descriptor2;
            this.fieldName = fieldName;
            this.codegen = codegen;
            this.resolvedCall = resolvedCall2;
            this.skipLateinitAssertion = skipLateinitAssertion;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
            if (this.getter == null) {
                assert (this.fieldName != null) : "Property should have either a getter or a field name: " + this.descriptor;
                assert (this.backingFieldOwner != null) : "Property should have either a getter or a backingFieldOwner: " + this.descriptor;
                if (this.inlineConstantIfNeeded(type2, kotlinType, v2)) {
                    return;
                }
                v2.visitFieldInsn(this.isStaticPut ? 178 : 180, this.backingFieldOwner.getInternalName(), this.fieldName, this.type.getDescriptor());
                if (!this.skipLateinitAssertion) {
                    this.genNotNullAssertionForLateInitIfNeeded(v2);
                }
                this.coerceTo(type2, kotlinType, v2);
            } else {
                PropertyGetterDescriptor getterDescriptor = this.descriptor.getGetter();
                assert (getterDescriptor != null) : "Getter descriptor should be not null for " + this.descriptor;
                if (this.resolvedCall != null && getterDescriptor.isInline()) {
                    CallGenerator callGenerator = this.codegen.getOrCreateCallGenerator(this.resolvedCall, getterDescriptor);
                    callGenerator.processAndPutHiddenParameters(false);
                    callGenerator.genCall(this.getter, this.resolvedCall, false, this.codegen);
                } else {
                    this.getter.genInvokeInstruction(v2);
                }
                Type typeOfValueOnStack = this.getter.getReturnType();
                KotlinType kotlinTypeOfValueOnStack = getterDescriptor.getReturnType();
                if (DescriptorUtils.isAnnotationClass(this.descriptor.getContainingDeclaration())) {
                    if (this.type.equals(AsmTypes.K_CLASS_TYPE)) {
                        AsmUtil.wrapJavaClassIntoKClass(v2);
                        typeOfValueOnStack = AsmTypes.K_CLASS_TYPE;
                        kotlinTypeOfValueOnStack = null;
                    } else if (this.type.equals(AsmTypes.K_CLASS_ARRAY_TYPE)) {
                        AsmUtil.wrapJavaClassesIntoKClasses(v2);
                        typeOfValueOnStack = AsmTypes.K_CLASS_ARRAY_TYPE;
                        kotlinTypeOfValueOnStack = null;
                    }
                }
                Property.coerce(typeOfValueOnStack, kotlinTypeOfValueOnStack, type2, kotlinType, v2);
                KotlinType returnType2 = this.descriptor.getReturnType();
                if (returnType2 != null && KotlinBuiltIns.isNothing(returnType2)) {
                    v2.aconst(null);
                    v2.athrow();
                }
            }
        }

        private boolean inlineConstantIfNeeded(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
            if (JvmCodegenUtil.isInlinedJavaConstProperty(this.descriptor)) {
                return this.inlineConstant(type2, kotlinType, v2);
            }
            if (this.descriptor.isConst() && this.codegen.getState().getShouldInlineConstVals()) {
                return this.inlineConstant(type2, kotlinType, v2);
            }
            return false;
        }

        private boolean inlineConstant(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
            assert (AsmUtil.isPrimitive(this.type) || AsmTypes.JAVA_STRING_TYPE.equals(this.type)) : "Const property should have primitive or string type: " + this.descriptor;
            assert (this.isStaticPut) : "Const property should be static" + this.descriptor;
            ConstantValue<?> constantValue = this.descriptor.getCompileTimeInitializer();
            if (constantValue == null) {
                return false;
            }
            Object value = constantValue.getValue();
            if (this.type == Type.FLOAT_TYPE && value instanceof Double) {
                value = Float.valueOf(((Double)value).floatValue());
            }
            StackValue.constant(value, this.type, this.kotlinType).putSelector(type2, kotlinType, v2);
            return true;
        }

        private void genNotNullAssertionForLateInitIfNeeded(@NotNull InstructionAdapter v2) {
            if (!this.descriptor.isLateInit()) {
                return;
            }
            StackValue.genNonNullAssertForLateinit(v2, this.descriptor.getName().asString());
        }

        @Override
        public void store(@NotNull StackValue rightSide, @NotNull InstructionAdapter v2, boolean skipReceiver) {
            PropertySetterDescriptor setterDescriptor = this.descriptor.getSetter();
            if (this.resolvedCall != null && setterDescriptor != null && setterDescriptor.isInline()) {
                assert (this.setter != null) : "Setter should be not null for " + this.descriptor;
                CallGenerator callGenerator = this.codegen.getOrCreateCallGenerator(this.resolvedCall, setterDescriptor);
                if (!skipReceiver) {
                    this.putReceiver(v2, false);
                }
                callGenerator.processAndPutHiddenParameters(true);
                callGenerator.putValueIfNeeded(new JvmKotlinType(((JvmMethodParameterSignature)CollectionsKt.last(this.setter.getValueParameters())).getAsmType(), ((ValueParameterDescriptor)CollectionsKt.last(setterDescriptor.getValueParameters())).getType()), rightSide);
                callGenerator.putHiddenParamsIntoLocals();
                callGenerator.genCall(this.setter, this.resolvedCall, false, this.codegen);
            } else {
                super.store(rightSide, v2, skipReceiver);
            }
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @Nullable KotlinType topOfStackKotlinType, @NotNull InstructionAdapter v2) {
            if (this.setter == null) {
                this.coerceFrom(topOfStackType, topOfStackKotlinType, v2);
                assert (this.fieldName != null) : "Property should have either a setter or a field name: " + this.descriptor;
                assert (this.backingFieldOwner != null) : "Property should have either a setter or a backingFieldOwner: " + this.descriptor;
                v2.visitFieldInsn(this.isStaticStore ? 179 : 181, this.backingFieldOwner.getInternalName(), this.fieldName, this.type.getDescriptor());
            } else {
                PropertySetterDescriptor setterDescriptor = this.descriptor.getSetter();
                KotlinType setterLastParameterType = setterDescriptor != null ? ((ValueParameterDescriptor)CollectionsKt.last(setterDescriptor.getValueParameters())).getReturnType() : null;
                Property.coerce(topOfStackType, topOfStackKotlinType, (Type)ArraysKt.last((Object[])this.setter.getParameterTypes()), setterLastParameterType, v2);
                this.setter.genInvokeInstruction(v2);
                Type returnType2 = this.setter.getReturnType();
                if (returnType2 != Type.VOID_TYPE) {
                    AsmUtil.pop(v2, returnType2);
                }
            }
        }

        private static boolean isStatic(boolean isStaticBackingField, @Nullable CallableMethod callable) {
            if (isStaticBackingField && callable == null) {
                return true;
            }
            if (callable != null && callable.isStaticCall()) {
                JvmMethodParameterSignature parameter;
                JvmMethodParameterKind kind;
                List<JvmMethodParameterSignature> parameters2 = callable.getValueParameters();
                Iterator<JvmMethodParameterSignature> iterator2 = parameters2.iterator();
                while (iterator2.hasNext() && (kind = (parameter = iterator2.next()).getKind()) != JvmMethodParameterKind.VALUE) {
                    if (kind != JvmMethodParameterKind.RECEIVER && kind != JvmMethodParameterKind.THIS) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    public static class Field
    extends StackValueWithSimpleReceiver {
        public final Type owner;
        public final String name;
        public final DeclarationDescriptor descriptor;

        public Field(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull Type owner, @NotNull String name, boolean isStatic, @NotNull StackValue receiver, @Nullable DeclarationDescriptor descriptor2) {
            super(type2, kotlinType, isStatic, isStatic, receiver, receiver.canHaveSideEffects());
            this.owner = owner;
            this.name = name;
            this.descriptor = descriptor2;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
            v2.visitFieldInsn(this.isStaticPut ? 178 : 180, this.owner.getInternalName(), this.name, this.type.getDescriptor());
            this.coerceTo(type2, kotlinType, v2);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @Nullable KotlinType topOfStackKotlinType, @NotNull InstructionAdapter v2) {
            this.coerceFrom(topOfStackType, topOfStackKotlinType, v2);
            v2.visitFieldInsn(this.isStaticStore ? 179 : 181, this.owner.getInternalName(), this.name, this.type.getDescriptor());
        }

        @Override
        protected StackValueWithSimpleReceiver changeReceiver(@NotNull StackValue newReceiver) {
            return Field.field(this, newReceiver);
        }
    }

    public static class CollectionElement
    extends StackValueWithSimpleReceiver {
        private final Callable getter;
        private final Callable setter;
        private final ExpressionCodegen codegen;
        private final ResolvedCall<FunctionDescriptor> resolvedGetCall;
        private final ResolvedCall<FunctionDescriptor> resolvedSetCall;

        public CollectionElement(@NotNull CollectionElementReceiver collectionElementReceiver, @NotNull Type type2, @Nullable KotlinType kotlinType, @Nullable ResolvedCall<FunctionDescriptor> resolvedGetCall, @Nullable ResolvedCall<FunctionDescriptor> resolvedSetCall, @NotNull ExpressionCodegen codegen) {
            super(type2, kotlinType, false, false, collectionElementReceiver, true);
            this.resolvedGetCall = resolvedGetCall;
            this.resolvedSetCall = resolvedSetCall;
            this.setter = resolvedSetCall == null ? null : codegen.resolveToCallable(codegen.accessibleFunctionDescriptor(resolvedSetCall), false, resolvedSetCall);
            this.getter = resolvedGetCall == null ? null : codegen.resolveToCallable(codegen.accessibleFunctionDescriptor(resolvedGetCall), false, resolvedGetCall);
            this.codegen = codegen;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
            if (this.getter == null) {
                throw new UnsupportedOperationException("no getter specified");
            }
            CallGenerator callGenerator = this.getCallGenerator();
            callGenerator.genCall(this.getter, this.resolvedGetCall, this.genDefaultMaskIfPresent(callGenerator), this.codegen);
            this.coerceTo(type2, kotlinType, v2);
        }

        private boolean genDefaultMaskIfPresent(CallGenerator callGenerator) {
            DefaultCallArgs defaultArgs = ((CollectionElementReceiver)this.receiver).defaultArgs;
            return defaultArgs.generateOnStackIfNeeded(callGenerator, true);
        }

        private CallGenerator getCallGenerator() {
            CallGenerator generator = ((CollectionElementReceiver)this.receiver).callGenerator;
            assert (generator != null) : "CollectionElementReceiver should be putted on stack before CollectionElement: getCall = " + this.resolvedGetCall + ",  setCall = " + this.resolvedSetCall;
            return generator;
        }

        @Override
        public int receiverSize() {
            if (CollectionElement.isStandardStack(this.codegen.typeMapper, this.resolvedGetCall, 1) && CollectionElement.isStandardStack(this.codegen.typeMapper, this.resolvedSetCall, 2)) {
                return 2;
            }
            return -1;
        }

        public static boolean isStandardStack(@NotNull KotlinTypeMapper typeMapper, @Nullable ResolvedCall<?> call2, int valueParamsSize) {
            if (call2 == null) {
                return true;
            }
            List<ValueParameterDescriptor> valueParameters2 = call2.getResultingDescriptor().getValueParameters();
            if (valueParameters2.size() != valueParamsSize) {
                return false;
            }
            for (ValueParameterDescriptor valueParameter : valueParameters2) {
                if (typeMapper.mapType(valueParameter.getType()).getSize() == 1) continue;
                return false;
            }
            return !(call2.getDispatchReceiver() != null ? call2.getExtensionReceiver() != null : typeMapper.mapType(call2.getResultingDescriptor().getExtensionReceiverParameter().getType()).getSize() != 1);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @Nullable KotlinType topOfStackKotlinType, @NotNull InstructionAdapter v2) {
            if (this.setter == null) {
                throw new UnsupportedOperationException("no setter specified");
            }
            Type lastParameterType = (Type)ArraysKt.last((Object[])this.setter.getParameterTypes());
            KotlinType lastParameterKotlinType = ((ValueParameterDescriptor)CollectionsKt.last(this.resolvedSetCall.getResultingDescriptor().getValueParameters())).getType();
            CollectionElement.coerce(topOfStackType, topOfStackKotlinType, lastParameterType, lastParameterKotlinType, v2);
            this.getCallGenerator().putValueIfNeeded(new JvmKotlinType(lastParameterType, lastParameterKotlinType), StackValue.onStack(lastParameterType, lastParameterKotlinType));
            CollectionElementReceiver collectionElementReceiver = (CollectionElementReceiver)this.receiver;
            if (collectionElementReceiver.isGetter) {
                List arguments2 = collectionElementReceiver.valueArguments;
                List<Type> types = this.getter.getValueParameterTypes();
                for (int i = arguments2.size() - 1; i >= 0; --i) {
                    ResolvedValueArgument argument = (ResolvedValueArgument)arguments2.get(i);
                    if (!(argument instanceof DefaultValueArgument)) continue;
                    Type defaultType = types.get(i);
                    AsmUtil.swap(v2, lastParameterType, defaultType);
                    AsmUtil.pop(v2, defaultType);
                }
            }
            this.getCallGenerator().genCall(this.setter, this.resolvedSetCall, false, this.codegen);
            Type returnType2 = this.setter.getReturnType();
            if (returnType2 != Type.VOID_TYPE) {
                AsmUtil.pop(v2, returnType2);
            }
        }
    }

    public static class CollectionElementReceiver
    extends StackValue {
        private final Callable callable;
        private final boolean isGetter;
        private final ExpressionCodegen codegen;
        private final List<ResolvedValueArgument> valueArguments;
        private final FrameMap frame;
        private final StackValue receiver;
        private final ResolvedCall<FunctionDescriptor> resolvedGetCall;
        private final ResolvedCall<FunctionDescriptor> resolvedSetCall;
        private DefaultCallArgs defaultArgs;
        private CallGenerator callGenerator;
        boolean isComplexOperationWithDup;

        public CollectionElementReceiver(@NotNull Callable callable, @NotNull StackValue receiver, ResolvedCall<FunctionDescriptor> resolvedGetCall, ResolvedCall<FunctionDescriptor> resolvedSetCall, boolean isGetter, @NotNull ExpressionCodegen codegen, List<ResolvedValueArgument> valueArguments) {
            super(AsmTypes.OBJECT_TYPE);
            this.callable = callable;
            this.isGetter = isGetter;
            this.receiver = receiver;
            this.resolvedGetCall = resolvedGetCall;
            this.resolvedSetCall = resolvedSetCall;
            this.valueArguments = valueArguments;
            this.codegen = codegen;
            this.frame = codegen.myFrameMap;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
            ResolvedCall<FunctionDescriptor> call2 = this.isGetter ? this.resolvedGetCall : this.resolvedSetCall;
            StackValue newReceiver = StackValue.receiver(call2, this.receiver, this.codegen, this.callable);
            ArgumentGenerator generator = this.createArgumentGenerator();
            newReceiver.put(newReceiver.type, newReceiver.kotlinType, v2);
            this.callGenerator.processAndPutHiddenParameters(false);
            this.defaultArgs = generator.generate(this.valueArguments, this.valueArguments, call2.getResultingDescriptor());
        }

        private ArgumentGenerator createArgumentGenerator() {
            ResolvedCall<FunctionDescriptor> resolvedCall2;
            assert (this.callGenerator == null) : "'putSelector' and 'createArgumentGenerator' methods should be called once for CollectionElementReceiver: " + this.callable;
            ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2 = this.isGetter ? this.resolvedGetCall : this.resolvedSetCall;
            assert (resolvedCall2 != null) : "Resolved call should be non-null: " + this.callable;
            this.callGenerator = !this.isComplexOperationWithDup ? this.codegen.getOrCreateCallGenerator(resolvedCall2) : this.codegen.defaultCallGenerator;
            return new CallBasedArgumentGenerator(this.codegen, this.callGenerator, resolvedCall2.getResultingDescriptor().getValueParameters(), this.callable.getValueParameterTypes());
        }

        @Override
        public void dup(@NotNull InstructionAdapter v2, boolean withReceiver) {
            this.dupReceiver(v2);
        }

        public void dupReceiver(@NotNull InstructionAdapter v2) {
            Type type2;
            int realReceiverIndex;
            Type realReceiverType;
            if (CollectionElement.isStandardStack(this.codegen.typeMapper, this.resolvedGetCall, 1) && CollectionElement.isStandardStack(this.codegen.typeMapper, this.resolvedSetCall, 2)) {
                v2.dup2();
                return;
            }
            FrameMapBase.Mark mark = this.frame.mark();
            List<ValueParameterDescriptor> valueParameters2 = this.resolvedGetCall.getResultingDescriptor().getValueParameters();
            int firstParamIndex = -1;
            for (int i = valueParameters2.size() - 1; i >= 0; --i) {
                Type type3 = this.codegen.typeMapper.mapType(valueParameters2.get(i).getType());
                firstParamIndex = this.frame.enterTemp(type3);
                v2.store(firstParamIndex, type3);
            }
            ReceiverValue receiverParameter = this.resolvedGetCall.getExtensionReceiver();
            int receiverIndex = -1;
            if (receiverParameter != null) {
                Type type4 = this.codegen.typeMapper.mapType(receiverParameter.getType());
                receiverIndex = this.frame.enterTemp(type4);
                v2.store(receiverIndex, type4);
            }
            ReceiverValue dispatchReceiver = this.resolvedGetCall.getDispatchReceiver();
            int thisIndex = -1;
            if (dispatchReceiver != null) {
                thisIndex = this.frame.enterTemp(AsmTypes.OBJECT_TYPE);
                v2.store(thisIndex, AsmTypes.OBJECT_TYPE);
            }
            if (receiverIndex != -1) {
                realReceiverType = this.codegen.typeMapper.mapType(receiverParameter.getType());
                realReceiverIndex = receiverIndex;
            } else if (thisIndex != -1) {
                realReceiverType = AsmTypes.OBJECT_TYPE;
                realReceiverIndex = thisIndex;
            } else {
                throw new UnsupportedOperationException();
            }
            if (this.resolvedSetCall.getDispatchReceiver() != null) {
                if (this.resolvedSetCall.getExtensionReceiver() != null) {
                    this.codegen.generateReceiverValue(this.resolvedSetCall.getDispatchReceiver(), false).put(AsmTypes.OBJECT_TYPE, null, v2);
                }
                v2.load(realReceiverIndex, realReceiverType);
            } else if (this.resolvedSetCall.getExtensionReceiver() != null) {
                v2.load(realReceiverIndex, realReceiverType);
            } else {
                throw new UnsupportedOperationException();
            }
            int index2 = firstParamIndex;
            for (ValueParameterDescriptor valueParameter : valueParameters2) {
                type2 = this.codegen.typeMapper.mapType(valueParameter.getType());
                v2.load(index2, type2);
                index2 -= type2.getSize();
            }
            if (thisIndex != -1) {
                v2.load(thisIndex, AsmTypes.OBJECT_TYPE);
            }
            if (receiverIndex != -1) {
                v2.load(receiverIndex, realReceiverType);
            }
            index2 = firstParamIndex;
            for (ValueParameterDescriptor valueParameter : valueParameters2) {
                type2 = this.codegen.typeMapper.mapType(valueParameter.getType());
                v2.load(index2, type2);
                index2 -= type2.getSize();
            }
            mark.dropTo();
        }
    }

    public static class UnderlyingValueOfInlineClass
    extends StackValueWithSimpleReceiver {
        public UnderlyingValueOfInlineClass(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull StackValue receiver) {
            super(type2, kotlinType, false, false, receiver, true);
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
            this.coerceTo(type2, kotlinType, v2);
        }
    }

    private static class ArrayElement
    extends StackValueWithSimpleReceiver {
        private final Type type;

        public ArrayElement(Type type2, KotlinType kotlinType, StackValue array, StackValue index2) {
            super(type2, kotlinType, false, false, new Receiver(Type.LONG_TYPE, array, index2), true);
            this.type = type2;
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @Nullable KotlinType topOfStackKotlinType, @NotNull InstructionAdapter v2) {
            this.coerceFrom(topOfStackType, topOfStackKotlinType, v2);
            v2.astore(this.type);
        }

        @Override
        public int receiverSize() {
            return 2;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
            v2.aload(this.type);
            this.coerceTo(type2, kotlinType, v2);
        }
    }

    public static class Constant
    extends StackValue {
        @Nullable
        public final Object value;

        public Constant(@Nullable Object value, Type type2, KotlinType kotlinType) {
            super(type2, kotlinType, false);
            assert (!Type.BOOLEAN_TYPE.equals(type2)) : "Boolean constants should be created via 'StackValue.constant'";
            this.value = value;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
            if (this.value instanceof Integer || this.value instanceof Byte || this.value instanceof Short) {
                v2.iconst(((Number)this.value).intValue());
            } else if (this.value instanceof Character) {
                v2.iconst(((Character)this.value).charValue());
            } else if (this.value instanceof Long) {
                v2.lconst((Long)this.value);
            } else if (this.value instanceof Float) {
                v2.fconst(((Float)this.value).floatValue());
            } else if (this.value instanceof Double) {
                v2.dconst((Double)this.value);
            } else {
                v2.aconst(this.value);
            }
            if (this.value != null || AsmUtil.isPrimitive(type2)) {
                this.coerceTo(type2, kotlinType, v2);
            }
        }
    }

    public static class OnStack
    extends StackValue {
        public OnStack(Type type2) {
            this(type2, null);
        }

        public OnStack(Type type2, KotlinType kotlinType) {
            super(type2, kotlinType);
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
            this.coerceTo(type2, kotlinType, v2);
        }

        @Override
        public void moveToTopOfStack(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2, int depth) {
            if (depth == 0) {
                this.put(type2, kotlinType, v2);
            } else if (depth == 1) {
                int size = this.type.getSize();
                if (size == 1) {
                    v2.swap();
                } else if (size == 2) {
                    v2.dupX2();
                    v2.pop();
                } else {
                    throw new UnsupportedOperationException("don't know how to move type " + type2 + " to top of stack");
                }
                this.coerceTo(type2, kotlinType, v2);
            } else if (depth == 2) {
                int size = this.type.getSize();
                if (size == 1) {
                    v2.dup2X1();
                    v2.pop2();
                } else if (size == 2) {
                    v2.dup2X2();
                    v2.pop2();
                } else {
                    throw new UnsupportedOperationException("don't know how to move type " + type2 + " to top of stack");
                }
                this.coerceTo(type2, kotlinType, v2);
            } else {
                throw new UnsupportedOperationException("unsupported move-to-top depth " + depth);
            }
        }
    }

    public static class Delegate
    extends StackValue {
        @NotNull
        private final StackValue delegateValue;
        @NotNull
        private final StackValue metadataValue;
        @NotNull
        private final VariableDescriptorWithAccessors variableDescriptor;
        @NotNull
        private final ExpressionCodegen codegen;

        private Delegate(@NotNull Type type2, @NotNull StackValue delegateValue, @NotNull StackValue metadataValue, @NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull ExpressionCodegen codegen) {
            super(type2);
            this.delegateValue = delegateValue;
            this.metadataValue = metadataValue;
            this.variableDescriptor = variableDescriptor;
            this.codegen = codegen;
        }

        private ResolvedCall<FunctionDescriptor> getResolvedCall(boolean isGetter) {
            VariableAccessorDescriptor accessor;
            BindingContext bindingContext = this.codegen.getState().getBindingContext();
            VariableAccessorDescriptor variableAccessorDescriptor = accessor = isGetter ? this.variableDescriptor.getGetter() : this.variableDescriptor.getSetter();
            assert (accessor != null) : "Accessor descriptor for delegated local property should be present " + this.variableDescriptor;
            ResolvedCall<FunctionDescriptor> resolvedCall2 = bindingContext.get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, accessor);
            assert (resolvedCall2 != null) : "Resolve call should be recorded for delegate call " + this.variableDescriptor;
            return resolvedCall2;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
            ResolvedCall<FunctionDescriptor> resolvedCall2 = this.getResolvedCall(true);
            List<? extends ValueArgument> arguments2 = resolvedCall2.getCall().getValueArguments();
            assert (arguments2.size() == 2) : "Resolved call for 'getValue' should have 2 arguments, but was " + arguments2.size() + ": " + resolvedCall2;
            this.codegen.tempVariables.put(arguments2.get(0).asElement(), StackValue.constant(null, AsmTypes.OBJECT_TYPE));
            this.codegen.tempVariables.put(arguments2.get(1).asElement(), this.metadataValue);
            StackValue lastValue = this.codegen.invokeFunction(resolvedCall2, this.delegateValue);
            lastValue.put(type2, kotlinType, v2);
            this.codegen.tempVariables.remove(arguments2.get(0).asElement());
            this.codegen.tempVariables.remove(arguments2.get(1).asElement());
        }

        @Override
        public void store(@NotNull StackValue rightSide, @NotNull InstructionAdapter v2, boolean skipReceiver) {
            ResolvedCall<FunctionDescriptor> resolvedCall2 = this.getResolvedCall(false);
            List<? extends ValueArgument> arguments2 = resolvedCall2.getCall().getValueArguments();
            assert (arguments2.size() == 3) : "Resolved call for 'setValue' should have 3 arguments, but was " + arguments2.size() + ": " + resolvedCall2;
            this.codegen.tempVariables.put(arguments2.get(0).asElement(), StackValue.constant(null, AsmTypes.OBJECT_TYPE));
            this.codegen.tempVariables.put(arguments2.get(1).asElement(), this.metadataValue);
            this.codegen.tempVariables.put(arguments2.get(2).asElement(), rightSide);
            StackValue lastValue = this.codegen.invokeFunction(resolvedCall2, this.delegateValue);
            lastValue.put(Type.VOID_TYPE, null, v2);
            this.codegen.tempVariables.remove(arguments2.get(0).asElement());
            this.codegen.tempVariables.remove(arguments2.get(1).asElement());
            this.codegen.tempVariables.remove(arguments2.get(2).asElement());
        }
    }

    public static class LateinitLocal
    extends StackValue {
        public final int index;
        private final Name name;

        private LateinitLocal(int index2, Type type2, KotlinType kotlinType, Name name) {
            super(type2, kotlinType, false);
            if (index2 < 0) {
                throw new IllegalStateException("local variable index must be non-negative");
            }
            if (name == null) {
                throw new IllegalArgumentException("Lateinit local variable should have name: #" + index2 + " " + type2.getDescriptor());
            }
            this.index = index2;
            this.name = name;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
            v2.load(this.index, this.type);
            StackValue.genNonNullAssertForLateinit(v2, this.name.asString());
            this.coerceTo(type2, kotlinType, v2);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @Nullable KotlinType topOfStackKotlinType, @NotNull InstructionAdapter v2) {
            this.coerceFrom(topOfStackType, topOfStackKotlinType, v2);
            v2.store(this.index, this.type);
            PseudoInsnsKt.storeNotNull(v2);
        }
    }

    public static class Local
    extends StackValue {
        public final int index;

        private Local(int index2, Type type2, KotlinType kotlinType) {
            super(type2, kotlinType, false);
            if (index2 < 0) {
                throw new IllegalStateException("local variable index must be non-negative");
            }
            this.index = index2;
        }

        private Local(int index2, Type type2) {
            this(index2, type2, (KotlinType)null);
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
            v2.load(this.index, this.type);
            this.coerceTo(type2, kotlinType, v2);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @Nullable KotlinType topOfStackKotlinType, @NotNull InstructionAdapter v2) {
            this.coerceFrom(topOfStackType, topOfStackKotlinType, v2);
            v2.store(this.index, this.type);
        }
    }

    private static class None
    extends StackValue {
        public static final None INSTANCE = new None();

        private None() {
            super(Type.VOID_TYPE, false);
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
            this.coerceTo(type2, kotlinType, v2);
        }
    }
}

