/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.OverloadabilitySpecificityCallbacks;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderImpl;
import org.jetbrains.kotlin.resolve.calls.results.FlatSignature;
import org.jetbrains.kotlin.resolve.calls.results.FlatSignatureKt;
import org.jetbrains.kotlin.resolve.calls.results.TypeSpecificityComparator;
import org.jetbrains.kotlin.resolve.descriptorUtil.AnnotationsForResolveKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J \u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J \u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J$\u0010\u001c\u001a\u00020\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130\u001eH\u0002J\f\u0010 \u001a\u00020\u001b*\u00020!H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/resolve/ShadowedExtensionChecker;", "", "typeSpecificityComparator", "Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;", "trace", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "(Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;)V", "getTrace", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "getTypeSpecificityComparator", "()Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;", "checkDeclaration", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "checkShadowedExtensionFunction", "extensionFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "checkShadowedExtensionProperty", "extensionProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getInvokeOperatorShadowingExtensionFunction", "extension", "member", "isExtensionFunctionShadowedByMemberFunction", "", "isSignatureNotLessSpecific", "extensionSignature", "Lorg/jetbrains/kotlin/resolve/calls/results/FlatSignature;", "memberSignature", "isPublic", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "frontend"})
public final class ShadowedExtensionChecker {
    @NotNull
    private final TypeSpecificityComparator typeSpecificityComparator;
    @NotNull
    private final DiagnosticSink trace;

    public final void checkDeclaration(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2) {
        Annotated extensionReceiverType;
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        if (declaration.getName() == null) {
            return;
        }
        if (!(descriptor2 instanceof CallableMemberDescriptor)) {
            return;
        }
        if (AnnotationsForResolveKt.hasHidesMembersAnnotation((CallableDescriptor)descriptor2)) {
            return;
        }
        Annotated annotated = ((CallableMemberDescriptor)descriptor2).getExtensionReceiverParameter();
        if (annotated == null || (annotated = annotated.getType()) == null) {
            return;
        }
        Annotated annotated2 = extensionReceiverType = annotated;
        Intrinsics.checkExpressionValueIsNotNull((Object)annotated2, (String)"extensionReceiverType");
        if (KotlinTypeKt.isError((KotlinType)annotated2)) {
            return;
        }
        if (((KotlinType)extensionReceiverType).isMarkedNullable()) {
            return;
        }
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor instanceof FunctionDescriptor) {
            this.checkShadowedExtensionFunction(declaration, (FunctionDescriptor)descriptor2, this.trace);
        } else if (declarationDescriptor instanceof PropertyDescriptor) {
            this.checkShadowedExtensionProperty(declaration, (PropertyDescriptor)descriptor2, this.trace);
        }
    }

    private final void checkShadowedExtensionFunction(KtDeclaration declaration, FunctionDescriptor extensionFunction, DiagnosticSink trace) {
        Object object = extensionFunction.getExtensionReceiverParameter();
        if (object == null || (object = object.getType()) == null || (object = ((KotlinType)object).getMemberScope()) == null) {
            return;
        }
        Object memberScope2 = object;
        Name name = extensionFunction.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"extensionFunction.name");
        Collection<SimpleFunctionDescriptor> contributedFunctions = memberScope2.getContributedFunctions(name, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
        for (SimpleFunctionDescriptor memberFunction : contributedFunctions) {
            if (!this.isPublic(memberFunction) || !this.isExtensionFunctionShadowedByMemberFunction(extensionFunction, memberFunction)) continue;
            trace.report(Errors.EXTENSION_SHADOWED_BY_MEMBER.on((KtDeclaration)((PsiElement)declaration), memberFunction));
            return;
        }
        Name name2 = extensionFunction.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"extensionFunction.name");
        ClassifierDescriptor nestedClass = memberScope2.getContributedClassifier(name2, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
        if (nestedClass instanceof ClassDescriptor && ((ClassDescriptor)nestedClass).isInner() && this.isPublic((DeclarationDescriptorWithVisibility)((Object)nestedClass))) {
            Iterator<ClassConstructorDescriptor> iterator2 = ((ClassDescriptor)nestedClass).getConstructors().iterator();
            while (iterator2.hasNext()) {
                ClassConstructorDescriptor constructor;
                ClassConstructorDescriptor classConstructorDescriptor = constructor = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)classConstructorDescriptor, (String)"constructor");
                if (!this.isPublic(classConstructorDescriptor) || !this.isExtensionFunctionShadowedByMemberFunction(extensionFunction, constructor)) continue;
                trace.report(Errors.EXTENSION_FUNCTION_SHADOWED_BY_INNER_CLASS_CONSTRUCTOR.on((KtDeclaration)((PsiElement)declaration), constructor));
                return;
            }
        }
        Name name3 = extensionFunction.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"extensionFunction.name");
        Collection<PropertyDescriptor> contributedVariables = memberScope2.getContributedVariables(name3, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
        for (PropertyDescriptor memberProperty : contributedVariables) {
            FunctionDescriptor invokeOperator;
            if (!this.isPublic(memberProperty) || (invokeOperator = this.getInvokeOperatorShadowingExtensionFunction(extensionFunction, memberProperty)) == null) continue;
            trace.report(Errors.EXTENSION_FUNCTION_SHADOWED_BY_MEMBER_PROPERTY_WITH_INVOKE.on((KtDeclaration)((PsiElement)declaration), memberProperty, invokeOperator));
            return;
        }
    }

    private final boolean isPublic(@NotNull DeclarationDescriptorWithVisibility $receiver) {
        return Intrinsics.areEqual((Object)$receiver.getVisibility().normalize(), (Object)Visibilities.PUBLIC);
    }

    private final boolean isExtensionFunctionShadowedByMemberFunction(FunctionDescriptor extension, FunctionDescriptor member) {
        if (extension.getValueParameters().size() != member.getValueParameters().size()) {
            return false;
        }
        if (DescriptorUtilsKt.varargParameterPosition(extension) != DescriptorUtilsKt.varargParameterPosition(member)) {
            return false;
        }
        if (extension.isOperator() && !member.isOperator()) {
            return false;
        }
        if (extension.isInfix() && !member.isInfix()) {
            return false;
        }
        FlatSignature<CallableDescriptor> extensionSignature = FlatSignature.Companion.createForPossiblyShadowedExtension((CallableDescriptor)extension);
        FlatSignature<CallableDescriptor> memberSignature = FlatSignature.Companion.createFromCallableDescriptor((CallableDescriptor)member);
        return this.isSignatureNotLessSpecific(extensionSignature, memberSignature);
    }

    private final FunctionDescriptor getInvokeOperatorShadowingExtensionFunction(FunctionDescriptor extension, PropertyDescriptor member) {
        Object v0;
        block1: {
            Iterable $receiver$iv = member.getType().getMemberScope().getContributedFunctions(OperatorNameConventions.INVOKE, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
            for (Object element$iv : $receiver$iv) {
                SimpleFunctionDescriptor it = (SimpleFunctionDescriptor)element$iv;
                if (!(this.isPublic(it) && it.isOperator() && this.isExtensionFunctionShadowedByMemberFunction(extension, it))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final boolean isSignatureNotLessSpecific(FlatSignature<? extends FunctionDescriptor> extensionSignature, FlatSignature<? extends FunctionDescriptor> memberSignature) {
        return FlatSignatureKt.isSignatureNotLessSpecific(ConstraintSystemBuilderImpl.Companion.forSpecificity(), extensionSignature, memberSignature, OverloadabilitySpecificityCallbacks.INSTANCE, this.typeSpecificityComparator);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkShadowedExtensionProperty(KtDeclaration declaration, PropertyDescriptor extensionProperty, DiagnosticSink trace) {
        block3: {
            Object v2;
            Object object;
            block2: {
                void $receiver$iv;
                Object object2 = extensionProperty.getExtensionReceiverParameter();
                if (object2 == null || (object2 = object2.getType()) == null || (object2 = ((KotlinType)object2).getMemberScope()) == null) {
                    return;
                }
                Object memberScope2 = object2;
                Name name = extensionProperty.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"extensionProperty.name");
                object = memberScope2.getContributedVariables(name, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
                for (Object element$iv : $receiver$iv) {
                    PropertyDescriptor it = (PropertyDescriptor)element$iv;
                    if (!(this.isPublic(it) && !DescriptorUtilsKt.isExtension(it))) continue;
                    v2 = element$iv;
                    break block2;
                }
                v2 = null;
            }
            PropertyDescriptor propertyDescriptor = v2;
            if (propertyDescriptor == null) break block3;
            Object memberProperty = object = propertyDescriptor;
            trace.report(Errors.EXTENSION_SHADOWED_BY_MEMBER.on((KtDeclaration)((PsiElement)declaration), (CallableMemberDescriptor)memberProperty));
        }
    }

    @NotNull
    public final TypeSpecificityComparator getTypeSpecificityComparator() {
        return this.typeSpecificityComparator;
    }

    @NotNull
    public final DiagnosticSink getTrace() {
        return this.trace;
    }

    public ShadowedExtensionChecker(@NotNull TypeSpecificityComparator typeSpecificityComparator, @NotNull DiagnosticSink trace) {
        Intrinsics.checkParameterIsNotNull((Object)typeSpecificityComparator, (String)"typeSpecificityComparator");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        this.typeSpecificityComparator = typeSpecificityComparator;
        this.trace = trace;
    }
}

