/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.backend.common.utils.KotlinTypeBasedUtilsKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrDeclarationToJsTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrFunctionToJsTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsClassGenerator;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsClassGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.utils.DescriptorBasedUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContext;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrClassSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsClassModel;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsGlobalBlock;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u001eH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00162\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020#H\u0002J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160\u001eH\u0002J\b\u0010%\u001a\u00020&H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsClassGenerator;", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;)V", "baseClass", "Lorg/jetbrains/kotlin/ir/types/IrType;", "baseClassName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "classBlock", "Lorg/jetbrains/kotlin/js/backend/ast/JsGlobalBlock;", "classModel", "Lorg/jetbrains/kotlin/js/backend/ast/JsClassModel;", "className", "classNameRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "classPrototypeRef", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "generate", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "generateClassMetadata", "generateGetInstanceFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "instanceVar", "instanceFunName", "", "generateInheritanceCode", "", "generateMemberFunction", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "generateSuperClasses", "Lorg/jetbrains/kotlin/js/backend/ast/JsPropertyInitializer;", "maybeGenerateObjectInstance", "maybeGeneratePrimaryConstructor", "", "backend.js"})
public final class JsClassGenerator {
    private final JsName className;
    private final JsNameRef classNameRef;
    private final IrType baseClass;
    private final JsName baseClassName;
    private final JsNameRef classPrototypeRef;
    private final JsGlobalBlock classBlock;
    private final JsClassModel classModel;
    private final IrClass irClass;
    @NotNull
    private final JsGenerationContext context;

    @NotNull
    public final JsStatement generate() {
        Object object;
        this.maybeGeneratePrimaryConstructor();
        IrDeclarationToJsTransformer transformer = new IrDeclarationToJsTransformer();
        for (IrDeclaration declaration : this.irClass.getDeclarations()) {
            Object object2;
            Object object3;
            object = declaration;
            if (object instanceof IrConstructor) {
                object3 = this.classBlock.getStatements();
                object2 = declaration.accept(transformer, this.context);
                object3.add(object2);
                object3 = this.classModel.getPreDeclarationBlock().getStatements();
                object2 = this.generateInheritanceCode();
                CollectionsKt.addAll((Collection)object3, object2);
                continue;
            }
            if (object instanceof IrSimpleFunction) {
                if (this.generateMemberFunction((IrSimpleFunction)declaration) != null) {
                    Object it = object3;
                    Collection collection = this.classBlock.getStatements();
                    collection.add(it);
                }
                continue;
            }
            if (object instanceof IrClass) {
                object3 = this.classBlock.getStatements();
                object2 = new JsClassGenerator((IrClass)declaration, this.context).generate();
                object3.add(object2);
                continue;
            }
            if (!(object instanceof IrVariable)) continue;
            object3 = this.classBlock.getStatements();
            object2 = declaration.accept(transformer, this.context);
            object3.add(object2);
        }
        Object object4 = this.classBlock.getStatements();
        Object object5 = this.generateClassMetadata();
        object4.add(object5);
        UtilsKt.onlyIf(this.irClass, generate.2.INSTANCE, (Function1)new Function1<IrClass, Unit>(this){
            final /* synthetic */ JsClassGenerator this$0;

            public final void invoke(@NotNull IrClass it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Collection collection = JsClassGenerator.access$getClassBlock$p(this.this$0).getStatements();
                Iterable iterable = JsClassGenerator.access$maybeGenerateObjectInstance(this.this$0);
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
            }
            {
                this.this$0 = jsClassGenerator;
                super(1);
            }
        });
        object4 = this.context.getStaticContext().getClassModels();
        object5 = this.className;
        object = this.classModel;
        object4.put(object5, object);
        return this.classBlock;
    }

    private final JsStatement generateMemberFunction(IrSimpleFunction declaration) {
        block6: {
            JsFunction translatedFunction;
            IrSimpleFunction irSimpleFunction = declaration;
            IrSimpleFunction $receiver = irSimpleFunction;
            JsFunction jsFunction = translatedFunction = IrUtilsKt.isReal($receiver) ? (JsFunction)$receiver.accept(new IrFunctionToJsTransformer(), this.context) : null;
            if (JsAstUtilsKt.isStatic(declaration)) {
                JsFunction jsFunction2 = translatedFunction;
                if (jsFunction2 == null) {
                    Intrinsics.throwNpe();
                }
                return jsFunction2.makeStmt();
            }
            JsName memberName = this.context.getNameForSymbol(declaration.getSymbol());
            JsNameRef memberRef = new JsNameRef(memberName, (JsExpression)this.classPrototypeRef);
            JsFunction jsFunction3 = translatedFunction;
            if (jsFunction3 != null) {
                JsFunction jsFunction4;
                JsFunction it;
                JsFunction jsFunction5 = it = (jsFunction4 = jsFunction3);
                JsExpression jsExpression = memberRef;
                JsFunction $receiver2 = jsFunction5;
                $receiver2.setName(null);
                JsFunction jsFunction6 = jsFunction5;
                return JsAstUtilsKt.jsAssignment(jsExpression, jsFunction6).makeStmt();
            }
            if (IrUtilsKt.isInterface(this.irClass)) break block6;
            IrSimpleFunction irSimpleFunction2 = IrUtilsKt.resolveFakeOverride(declaration);
            if (irSimpleFunction2 != null) {
                IrSimpleFunction irSimpleFunction3;
                IrSimpleFunction it = irSimpleFunction3 = irSimpleFunction2;
                DeclarationDescriptor declarationDescriptor = it.getDescriptor().getContainingDeclaration();
                if (declarationDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                }
                ClassDescriptor implClassDesc = (ClassDescriptor)declarationDescriptor;
                if (!KotlinBuiltIns.isAny(implClassDesc) && !DescriptorBasedUtilsKt.isEffectivelyExternal(it)) {
                    JsName implMethodName = this.context.getNameForSymbol(it.getSymbol());
                    JsName implClassName = this.context.getNameForSymbol(new IrClassSymbolImpl(implClassDesc));
                    JsNameRef jsNameRef = implClassName.makeRef();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef, (String)"implClassName.makeRef()");
                    JsNameRef implClassPrototype = JsAstUtilsKt.prototypeOf(jsNameRef);
                    JsNameRef implMemberRef = new JsNameRef(implMethodName, (JsExpression)implClassPrototype);
                    Collection collection = this.classModel.getPostDeclarationBlock().getStatements();
                    JsStatement jsStatement = JsAstUtilsKt.jsAssignment(memberRef, implMemberRef).makeStmt();
                    collection.add(jsStatement);
                }
            }
        }
        return null;
    }

    private final List<JsStatement> maybeGenerateObjectInstance() {
        String instanceVarName = this.className.getIdent() + "_instance";
        String getInstanceFunName = this.className.getIdent() + "_getInstance";
        JsName jsVarNode = this.context.getCurrentScope().declareName(instanceVarName);
        JsVars varStmt = new JsVars(new JsVars.JsVar(jsVarNode, new JsNullLiteral()));
        JsName jsName = jsVarNode;
        Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"jsVarNode");
        JsFunction function2 = this.generateGetInstanceFunction(jsName, getInstanceFunName);
        Object[] objectArray = new JsStatement[2];
        objectArray[0] = varStmt;
        JsStatement jsStatement = function2.makeStmt();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsStatement, (String)"function.makeStmt()");
        objectArray[1] = jsStatement;
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final JsFunction generateGetInstanceFunction(JsName instanceVar, String instanceFunName) {
        JsBlock functionBody = new JsBlock();
        JsFunction func = new JsFunction((JsScope)new JsFunctionScope(this.context.getCurrentScope(), "getInstance for " + this.irClass.getName() + " object"), functionBody, "getInstance");
        func.setName(this.context.getCurrentScope().declareName(instanceFunName));
        Collection collection = functionBody.getStatements();
        JsExpression jsExpression = new JsBinaryOperation(JsBinaryOperator.REF_EQ, instanceVar.makeRef(), new JsNullLiteral());
        JsNameRef jsNameRef = instanceVar.makeRef();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef, (String)"instanceVar.makeRef()");
        SourceInfoAwareJsNode sourceInfoAwareJsNode = new JsIf(jsExpression, JsAstUtilsKt.jsAssignment(jsNameRef, new JsNew(this.classNameRef)).makeStmt());
        collection.add(sourceInfoAwareJsNode);
        collection = functionBody.getStatements();
        sourceInfoAwareJsNode = new JsReturn(instanceVar.makeRef());
        collection.add(sourceInfoAwareJsNode);
        return func;
    }

    private final void maybeGeneratePrimaryConstructor() {
        boolean bl;
        block4: {
            Iterable $receiver$iv = this.irClass.getDeclarations();
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    IrDeclaration it = (IrDeclaration)element$iv;
                    if (!(it instanceof IrConstructor)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (!bl) {
            JsFunction func = new JsFunction((JsScope)new JsFunctionScope(this.context.getCurrentScope(), "Ctor for " + this.irClass.getName()), new JsBlock(), "Ctor for " + this.irClass.getName());
            func.setName(this.className);
            Object object = this.classBlock.getStatements();
            Object object2 = func.makeStmt();
            object.add(object2);
            object = this.classModel.getPreDeclarationBlock().getStatements();
            object2 = this.generateInheritanceCode();
            CollectionsKt.addAll((Collection)object, (Iterable)object2);
        }
    }

    private final List<JsStatement> generateInheritanceCode() {
        if (this.baseClass == null || IrTypePredicatesKt.isAny(this.baseClass)) {
            return CollectionsKt.emptyList();
        }
        JsExpression jsExpression = this.classPrototypeRef;
        JsExpression jsExpression2 = Namer.INSTANCE.getJS_OBJECT_CREATE_FUNCTION();
        JsExpression[] jsExpressionArray = new JsExpression[1];
        JsName jsName = this.baseClassName;
        if (jsName == null) {
            Intrinsics.throwNpe();
        }
        JsNameRef jsNameRef = jsName.makeRef();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef, (String)"baseClassName!!.makeRef()");
        jsExpressionArray[0] = JsAstUtilsKt.prototypeOf(jsNameRef);
        JsStatement createCall = JsAstUtilsKt.jsAssignment(jsExpression, new JsInvocation(jsExpression2, jsExpressionArray)).makeStmt();
        JsExpression jsExpression3 = new JsNameRef(Namer.INSTANCE.getCONSTRUCTOR_NAME(), (JsExpression)this.classPrototypeRef);
        JsNameRef jsNameRef2 = this.classNameRef;
        Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef2, (String)"classNameRef");
        JsStatement ctorAssign = JsAstUtilsKt.jsAssignment(jsExpression3, jsNameRef2).makeStmt();
        Object[] objectArray = new JsStatement[2];
        JsStatement jsStatement = createCall;
        Intrinsics.checkExpressionValueIsNotNull((Object)jsStatement, (String)"createCall");
        objectArray[0] = jsStatement;
        JsStatement jsStatement2 = ctorAssign;
        Intrinsics.checkExpressionValueIsNotNull((Object)jsStatement2, (String)"ctorAssign");
        objectArray[1] = jsStatement2;
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final JsStatement generateClassMetadata() {
        Collection collection;
        JsObjectLiteral metadataLiteral = new JsObjectLiteral(true);
        Name simpleName = this.irClass.getName();
        if (!simpleName.isSpecial()) {
            JsPropertyInitializer simpleNameProp = new JsPropertyInitializer(new JsNameRef(Namer.INSTANCE.getMETADATA_SIMPLE_NAME()), new JsStringLiteral(simpleName.getIdentifier()));
            collection = metadataLiteral.getPropertyInitializers();
            collection.add(simpleNameProp);
        }
        JsStringLiteral classKind = new JsStringLiteral(IrUtilsKt.isInterface(this.irClass) ? "interface" : (IrUtilsKt.isObject(this.irClass) ? "object" : "class"));
        collection = metadataLiteral.getPropertyInitializers();
        JsPropertyInitializer jsPropertyInitializer = new JsPropertyInitializer(new JsNameRef(Namer.INSTANCE.getMETADATA_CLASS_KIND()), classKind);
        collection.add(jsPropertyInitializer);
        collection = metadataLiteral.getPropertyInitializers();
        jsPropertyInitializer = this.generateSuperClasses();
        collection.add(jsPropertyInitializer);
        JsStatement jsStatement = JsAstUtilsKt.jsAssignment(new JsNameRef(Namer.INSTANCE.getMETADATA(), (JsExpression)this.classNameRef), metadataLiteral).makeStmt();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsStatement, (String)"jsAssignment(JsNameRef(N\u2026tadataLiteral).makeStmt()");
        return jsStatement;
    }

    /*
     * WARNING - void declaration
     */
    private final JsPropertyInitializer generateSuperClasses() {
        void var3_4;
        List list2;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = this.irClass.getSuperTypes();
        JsExpression jsExpression = new JsNameRef(Namer.INSTANCE.getMETADATA_INTERFACES());
        void var2_3 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            JsNameRef jsNameRef;
            Object element$iv$iv = element$iv$iv$iv;
            IrType it = (IrType)element$iv$iv;
            IrClassifierSymbol symbol2 = IrTypesKt.getClassifierOrFail(it);
            JsNameRef jsNameRef2 = JsClassGeneratorKt.access$isInterface$p(symbol2) && !KotlinTypeBasedUtilsKt.isBuiltinFunctionalTypeOrSubtype(IrUtilsKt.getDefaultType(this.irClass)) && !DescriptorBasedUtilsKt.isEffectivelyExternal(symbol2) ? new JsNameRef(this.context.getNameForSymbol(symbol2)) : null;
            if (jsNameRef2 == null) continue;
            JsNameRef it$iv$iv = jsNameRef = jsNameRef2;
            destination$iv$iv.add(it$iv$iv);
        }
        List list3 = list2 = (List)var3_4;
        JsExpression jsExpression2 = new JsArrayLiteral(list3);
        JsExpression jsExpression3 = jsExpression;
        return new JsPropertyInitializer(jsExpression3, jsExpression2);
    }

    @NotNull
    public final JsGenerationContext getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    public JsClassGenerator(@NotNull IrClass irClass, @NotNull JsGenerationContext context) {
        JsName jsName;
        JsName jsName2;
        JsClassGenerator jsClassGenerator;
        Object object;
        block3: {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.irClass = irClass;
            this.context = context;
            this.className = this.context.getNameForSymbol((IrSymbol)this.irClass.getSymbol());
            this.classNameRef = this.className.makeRef();
            object = this.irClass.getSuperTypes();
            jsClassGenerator = this;
            for (Object element$iv : $receiver$iv) {
                IrType it = (IrType)element$iv;
                if (!(!JsClassGeneratorKt.access$isInterface$p(IrTypesKt.getClassifierOrFail(it)))) continue;
                jsName2 = (JsName)element$iv;
                break block3;
            }
            jsName2 = null;
        }
        JsName jsName3 = jsName2;
        jsClassGenerator.baseClass = (IrType)((Object)jsName3);
        JsClassGenerator jsClassGenerator2 = this;
        IrType irType = this.baseClass;
        if (irType != null) {
            object = irType;
            jsClassGenerator = jsClassGenerator2;
            Object it = object;
            jsName3 = this.context.getNameForSymbol(IrTypesKt.getClassifierOrFail((IrType)it));
            jsClassGenerator2 = jsClassGenerator;
            jsName = jsName3;
        } else {
            jsName = null;
        }
        jsClassGenerator2.baseClassName = jsName;
        JsNameRef jsNameRef = this.classNameRef;
        Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef, (String)"classNameRef");
        this.classPrototypeRef = JsAstUtilsKt.prototypeOf(jsNameRef);
        this.classBlock = new JsGlobalBlock();
        this.classModel = new JsClassModel(this.className, this.baseClassName);
    }

    @NotNull
    public static final /* synthetic */ JsGlobalBlock access$getClassBlock$p(JsClassGenerator $this) {
        return $this.classBlock;
    }

    @NotNull
    public static final /* synthetic */ List access$maybeGenerateObjectInstance(JsClassGenerator $this) {
        return $this.maybeGenerateObjectInstance();
    }
}

