/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/InlineClassDescriptorResolver;", "", "()V", "BOXING_VALUE_PARAMETER_NAME", "Lorg/jetbrains/kotlin/name/Name;", "BOX_METHOD_NAME", "UNBOX_METHOD_NAME", "createBoxFunctionDescriptor", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "owner", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "createConversionFunctionDescriptor", "isBoxMethod", "", "createUnboxFunctionDescriptor", "createValueParameterForBoxing", "Lorg/jetbrains/kotlin/descriptors/impl/ValueParameterDescriptorImpl;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "inlinedValue", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "frontend"})
public final class InlineClassDescriptorResolver {
    @JvmField
    @NotNull
    public static final Name BOX_METHOD_NAME;
    @JvmField
    @NotNull
    public static final Name UNBOX_METHOD_NAME;
    private static final Name BOXING_VALUE_PARAMETER_NAME;
    public static final InlineClassDescriptorResolver INSTANCE;

    @Nullable
    public final SimpleFunctionDescriptor createBoxFunctionDescriptor(@NotNull ClassDescriptor owner) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        return this.createConversionFunctionDescriptor(true, owner);
    }

    @Nullable
    public final SimpleFunctionDescriptor createUnboxFunctionDescriptor(@NotNull ClassDescriptor owner) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        return this.createConversionFunctionDescriptor(false, owner);
    }

    private final SimpleFunctionDescriptor createConversionFunctionDescriptor(boolean isBoxMethod, ClassDescriptor owner) {
        List list2;
        ValueParameterDescriptor valueParameterDescriptor = InlineClassesUtilsKt.underlyingRepresentation(owner);
        if (valueParameterDescriptor == null) {
            return null;
        }
        ValueParameterDescriptor inlinedValue = valueParameterDescriptor;
        SimpleFunctionDescriptorImpl functionDescriptor = SimpleFunctionDescriptorImpl.create(owner, Annotations.Companion.getEMPTY(), isBoxMethod ? BOX_METHOD_NAME : UNBOX_METHOD_NAME, CallableMemberDescriptor.Kind.SYNTHESIZED, SourceElement.NO_SOURCE);
        ReceiverParameterDescriptor receiverParameterDescriptor = isBoxMethod ? null : owner.getThisAsReceiverParameter();
        List list3 = CollectionsKt.emptyList();
        if (isBoxMethod) {
            SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = functionDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleFunctionDescriptorImpl, (String)"functionDescriptor");
            list2 = CollectionsKt.listOf((Object)this.createValueParameterForBoxing(simpleFunctionDescriptorImpl, inlinedValue));
        } else {
            list2 = CollectionsKt.emptyList();
        }
        functionDescriptor.initialize((KotlinType)null, receiverParameterDescriptor, list3, list2, isBoxMethod ? (KotlinType)owner.getDefaultType() : inlinedValue.getReturnType(), Modality.FINAL, Visibilities.PUBLIC);
        return functionDescriptor;
    }

    private final ValueParameterDescriptorImpl createValueParameterForBoxing(FunctionDescriptor functionDescriptor, ValueParameterDescriptor inlinedValue) {
        CallableDescriptor callableDescriptor = functionDescriptor;
        Annotations annotations2 = Annotations.Companion.getEMPTY();
        Name name = BOXING_VALUE_PARAMETER_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"BOXING_VALUE_PARAMETER_NAME");
        KotlinType kotlinType = inlinedValue.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"inlinedValue.type");
        SourceElement sourceElement = SourceElement.NO_SOURCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"SourceElement.NO_SOURCE");
        return new ValueParameterDescriptorImpl(callableDescriptor, null, 0, annotations2, name, kotlinType, false, false, false, null, sourceElement);
    }

    private InlineClassDescriptorResolver() {
    }

    static {
        InlineClassDescriptorResolver inlineClassDescriptorResolver;
        INSTANCE = inlineClassDescriptorResolver = new InlineClassDescriptorResolver();
        BOX_METHOD_NAME = Name.identifier("box");
        UNBOX_METHOD_NAME = Name.identifier("unbox");
        BOXING_VALUE_PARAMETER_NAME = Name.identifier("v");
    }
}

