/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.editor.impl.ManualRangeMarker;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.editor.impl.event.RetargetRangeMarkers;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.smartPointers.Identikit;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerTracker;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MarkerCache {
    static final Comparator<SelfElementInfo> INFO_COMPARATOR = (info1, info2) -> {
        int o1 = info1.getPsiStartOffset();
        int o2 = info2.getPsiStartOffset();
        if (o1 < 0 || o2 < 0) {
            return o1 >= 0 ? -1 : (o2 >= 0 ? 1 : 0);
        }
        if (o1 != o2) {
            return o1 > o2 ? 1 : -1;
        }
        o1 = info1.getPsiEndOffset();
        if (o1 != (o2 = info2.getPsiEndOffset())) {
            return o1 > o2 ? 1 : -1;
        }
        return (info1.isGreedy() ? 1 : 0) - (info2.isGreedy() ? 1 : 0);
    };
    private final SmartPointerTracker myPointers;
    private UpdatedRanges myUpdatedRanges;

    MarkerCache(SmartPointerTracker pointers) {
        this.myPointers = pointers;
    }

    private UpdatedRanges getUpdatedMarkers(@NotNull FrozenDocument frozen, @NotNull List<DocumentEvent> events) {
        UpdatedRanges answer;
        if (frozen == null) {
            MarkerCache.$$$reportNull$$$0(0);
        }
        if (events == null) {
            MarkerCache.$$$reportNull$$$0(1);
        }
        int eventCount = events.size();
        assert (eventCount > 0);
        UpdatedRanges cache2 = this.myUpdatedRanges;
        if (cache2 != null && cache2.myEventCount == eventCount) {
            return cache2;
        }
        if (cache2 != null && cache2.myEventCount < eventCount) {
            answer = MarkerCache.applyEvents(events.subList(cache2.myEventCount, eventCount), cache2);
        } else {
            List<SelfElementInfo> infos2 = this.myPointers.getSortedInfos();
            ManualRangeMarker[] markers = MarkerCache.createMarkers(infos2);
            answer = MarkerCache.applyEvents(events, new UpdatedRanges(0, frozen, infos2, markers));
        }
        this.myUpdatedRanges = answer;
        return answer;
    }

    @NotNull
    private static ManualRangeMarker[] createMarkers(List<SelfElementInfo> infos2) {
        ManualRangeMarker[] markers = new ManualRangeMarker[infos2.size()];
        int i = 0;
        while (i < markers.length) {
            SelfElementInfo info = infos2.get(i);
            boolean greedy = info.isGreedy();
            int start = info.getPsiStartOffset();
            int end = info.getPsiEndOffset();
            markers[i] = new ManualRangeMarker(start, end, greedy, greedy, !greedy, null);
            ++i;
            while (i < markers.length && MarkerCache.rangeEquals(infos2.get(i), start, end, greedy)) {
                markers[i] = markers[i - 1];
                ++i;
            }
        }
        if (markers == null) {
            MarkerCache.$$$reportNull$$$0(2);
        }
        return markers;
    }

    private static boolean rangeEquals(SelfElementInfo info, int start, int end, boolean greedy) {
        return start == info.getPsiStartOffset() && end == info.getPsiEndOffset() && greedy == info.isGreedy();
    }

    private static UpdatedRanges applyEvents(@NotNull List<DocumentEvent> events, UpdatedRanges struct) {
        if (events == null) {
            MarkerCache.$$$reportNull$$$0(3);
        }
        FrozenDocument frozen = struct.myResultDocument;
        ManualRangeMarker[] resultMarkers = (ManualRangeMarker[])struct.myMarkers.clone();
        for (DocumentEvent event : events) {
            DocumentEventImpl corrected;
            FrozenDocument before = frozen;
            if (event instanceof RetargetRangeMarkers) {
                RetargetRangeMarkers retarget = (RetargetRangeMarkers)event;
                corrected = new RetargetRangeMarkers(frozen, retarget.getStartOffset(), retarget.getEndOffset(), retarget.getMoveDestinationOffset());
            } else {
                frozen = frozen.applyEvent(event, 0);
                corrected = new DocumentEventImpl(frozen, event.getOffset(), event.getOldFragment(), event.getNewFragment(), event.getOldTimeStamp(), event.isWholeTextReplaced(), ((DocumentEventImpl)event).getInitialStartOffset(), ((DocumentEventImpl)event).getInitialOldLength());
            }
            int i = 0;
            while (i < resultMarkers.length) {
                ManualRangeMarker updatedRange;
                int sameMarkersEnd;
                ManualRangeMarker currentRange = resultMarkers[i];
                for (sameMarkersEnd = i + 1; sameMarkersEnd < resultMarkers.length && resultMarkers[sameMarkersEnd] == currentRange; ++sameMarkersEnd) {
                }
                ManualRangeMarker manualRangeMarker = updatedRange = currentRange == null ? null : currentRange.getUpdatedRange(corrected, before);
                while (i < sameMarkersEnd) {
                    resultMarkers[i] = updatedRange;
                    ++i;
                }
            }
        }
        return new UpdatedRanges(struct.myEventCount + events.size(), frozen, struct.mySortedInfos, resultMarkers);
    }

    boolean updateMarkers(@NotNull FrozenDocument frozen, @NotNull List<DocumentEvent> events) {
        if (frozen == null) {
            MarkerCache.$$$reportNull$$$0(4);
        }
        if (events == null) {
            MarkerCache.$$$reportNull$$$0(5);
        }
        UpdatedRanges updated = this.getUpdatedMarkers(frozen, events);
        boolean sorted = true;
        for (int i = 0; i < updated.myMarkers.length; ++i) {
            SelfElementInfo info = (SelfElementInfo)updated.mySortedInfos.get(i);
            info.setRange(updated.myMarkers[i]);
            if (!sorted || i <= 0 || INFO_COMPARATOR.compare((SelfElementInfo)updated.mySortedInfos.get(i - 1), info) <= 0) continue;
            sorted = false;
        }
        this.myUpdatedRanges = null;
        return sorted;
    }

    @Nullable
    TextRange getUpdatedRange(@NotNull SelfElementInfo info, @NotNull FrozenDocument frozen, @NotNull List<DocumentEvent> events) {
        UpdatedRanges struct;
        int i;
        if (info == null) {
            MarkerCache.$$$reportNull$$$0(6);
        }
        if (frozen == null) {
            MarkerCache.$$$reportNull$$$0(7);
        }
        if (events == null) {
            MarkerCache.$$$reportNull$$$0(8);
        }
        ManualRangeMarker updated = (i = Collections.binarySearch((struct = this.getUpdatedMarkers(frozen, events)).mySortedInfos, info, INFO_COMPARATOR)) >= 0 ? struct.myMarkers[i] : null;
        return updated == null ? null : new UnfairTextRange(updated.getStartOffset(), updated.getEndOffset());
    }

    @Nullable
    static Segment getUpdatedRange(@NotNull PsiFile containingFile, @NotNull Segment segment, boolean isSegmentGreedy, @NotNull FrozenDocument frozen, @NotNull List<DocumentEvent> events) {
        if (containingFile == null) {
            MarkerCache.$$$reportNull$$$0(9);
        }
        if (segment == null) {
            MarkerCache.$$$reportNull$$$0(10);
        }
        if (frozen == null) {
            MarkerCache.$$$reportNull$$$0(11);
        }
        if (events == null) {
            MarkerCache.$$$reportNull$$$0(12);
        }
        SelfElementInfo info = new SelfElementInfo(ProperTextRange.create(segment), new Identikit(){

            @Override
            @Nullable
            public PsiElement findPsiElement(@NotNull PsiFile file2, int startOffset, int endOffset) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return null;
            }

            @Override
            @NotNull
            public Language getFileLanguage() {
                throw new IllegalStateException();
            }

            @Override
            public boolean isForPsiFile() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/MarkerCache$1", "findPsiElement"));
            }
        }, containingFile, isSegmentGreedy);
        List<SelfElementInfo> infos2 = Collections.singletonList(info);
        boolean greedy = info.isGreedy();
        int start = info.getPsiStartOffset();
        int end = info.getPsiEndOffset();
        boolean surviveOnExternalChange = events.stream().anyMatch(event -> {
            if (frozen == null) {
                MarkerCache.$$$reportNull$$$0(16);
            }
            return MarkerCache.isWholeDocumentReplace(frozen, (DocumentEventImpl)event);
        });
        ManualRangeMarker marker = new ManualRangeMarker(start, end, greedy, greedy, surviveOnExternalChange, null);
        UpdatedRanges ranges2 = new UpdatedRanges(0, frozen, infos2, new ManualRangeMarker[]{marker});
        List<DocumentEvent> newEvents = events.stream().map(event -> {
            if (frozen == null) {
                MarkerCache.$$$reportNull$$$0(15);
            }
            return MarkerCache.isWholeDocumentReplace(frozen, (DocumentEventImpl)event) ? new DocumentEventImpl(event.getDocument(), event.getOffset(), event.getOldFragment(), event.getNewFragment(), event.getOldTimeStamp(), true, ((DocumentEventImpl)event).getInitialStartOffset(), ((DocumentEventImpl)event).getInitialOldLength()) : event;
        }).collect(Collectors.toList());
        UpdatedRanges updated = MarkerCache.applyEvents(newEvents, ranges2);
        return updated.myMarkers[0];
    }

    private static boolean isWholeDocumentReplace(@NotNull FrozenDocument frozen, @NotNull DocumentEventImpl event) {
        if (frozen == null) {
            MarkerCache.$$$reportNull$$$0(13);
        }
        if (event == null) {
            MarkerCache.$$$reportNull$$$0(14);
        }
        return event.getInitialStartOffset() == 0 && event.getInitialOldLength() == frozen.getTextLength();
    }

    void rangeChanged() {
        this.myUpdatedRanges = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frozen";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/smartPointers/MarkerCache";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/smartPointers/MarkerCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createMarkers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUpdatedMarkers";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyEvents";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateMarkers";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getUpdatedRange";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isWholeDocumentReplace";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getUpdatedRange$2";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getUpdatedRange$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UpdatedRanges {
        private final int myEventCount;
        private final FrozenDocument myResultDocument;
        private final List<SelfElementInfo> mySortedInfos;
        private final ManualRangeMarker[] myMarkers;

        UpdatedRanges(int eventCount, @NotNull FrozenDocument resultDocument, @NotNull List<SelfElementInfo> sortedInfos, @NotNull ManualRangeMarker[] markers) {
            if (resultDocument == null) {
                UpdatedRanges.$$$reportNull$$$0(0);
            }
            if (sortedInfos == null) {
                UpdatedRanges.$$$reportNull$$$0(1);
            }
            if (markers == null) {
                UpdatedRanges.$$$reportNull$$$0(2);
            }
            this.myEventCount = eventCount;
            this.myResultDocument = resultDocument;
            this.mySortedInfos = sortedInfos;
            this.myMarkers = markers;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resultDocument";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sortedInfos";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "markers";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/smartPointers/MarkerCache$UpdatedRanges";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

