/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredStatementOrigin;
import org.jetbrains.kotlin.backend.jvm.codegen.IrCodegenUtilsKt;
import org.jetbrains.kotlin.backend.jvm.descriptors.DefaultImplsClassDescriptor;
import org.jetbrains.kotlin.backend.jvm.descriptors.JvmDeclarationFactory;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.impl.IrFunctionImpl;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.ReferenceSymbolTable;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/InterfaceDelegationLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "getState", "()Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "generateDelegationToDefaultImpl", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "interfaceFun", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "inheritedFun", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "isDefaultImplsGeneration", "", "generateInterfaceMethods", "lower", "backend"})
public final class InterfaceDelegationLowering
extends IrElementTransformerVoid
implements ClassLoweringPass {
    @NotNull
    private final GenerationState state;
    @NotNull
    private final JvmBackendContext context;

    @NotNull
    public final GenerationState getState() {
        return this.state;
    }

    @Override
    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
        if (IrCodegenUtilsKt.isJvmInterface(irClass)) {
            return;
        }
        IrElementTransformerVoidKt.transformChildrenVoid(irClass, this);
        this.generateInterfaceMethods(irClass);
    }

    private final void generateInterfaceMethods(IrClass irClass) {
        ClassDescriptor classDescriptor2;
        ClassDescriptor irClassDescriptor = irClass.getDescriptor();
        ClassDescriptor classDescriptor3 = irClassDescriptor;
        if (!(classDescriptor3 instanceof DefaultImplsClassDescriptor)) {
            classDescriptor3 = null;
        }
        if ((classDescriptor2 = (DefaultImplsClassDescriptor)classDescriptor3) == null || (classDescriptor2 = classDescriptor2.getCorrespondingInterface()) == null) {
            classDescriptor2 = irClassDescriptor;
        }
        ClassDescriptor actualClassDescriptor = classDescriptor2;
        boolean isDefaultImplsGeneration = actualClassDescriptor != irClassDescriptor;
        Map<FunctionDescriptor, FunctionDescriptor> map2 = CodegenUtil.getNonPrivateTraitMethods(actualClassDescriptor, !isDefaultImplsGeneration);
        Iterator<Map.Entry<FunctionDescriptor, FunctionDescriptor>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<FunctionDescriptor, FunctionDescriptor> entry;
            Map.Entry<FunctionDescriptor, FunctionDescriptor> entry2 = entry = iterator2.next();
            FunctionDescriptor interfaceFun = entry2.getKey();
            entry2 = entry;
            FunctionDescriptor value = entry2.getValue();
            if (CodegenUtilKt.isDefinitelyNotDefaultImplsMethod(interfaceFun) || FunctionCodegen.isMethodOfAny(interfaceFun)) continue;
            ReferenceSymbolTable referenceSymbolTable = this.context.getIr().getSymbols().getExternalSymbolTable();
            FunctionDescriptor functionDescriptor = interfaceFun.getOriginal();
            Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor, (String)"interfaceFun.original");
            this.generateDelegationToDefaultImpl(irClass, (IrFunction)referenceSymbolTable.referenceSimpleFunction(functionDescriptor).getOwner(), value, isDefaultImplsGeneration);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void generateDelegationToDefaultImpl(IrClass irClass, IrFunction interfaceFun, FunctionDescriptor inheritedFun, boolean isDefaultImplsGeneration) {
        void $receiver$iv$iv;
        int n;
        Object it;
        IrValueParameter irValueParameter;
        IrFunction irFunction;
        IrFunction defaultImplFun = this.context.getDeclarationFactory().getDefaultImplsFunction(interfaceFun);
        if (!isDefaultImplsGeneration) {
            IrFunctionImpl irFunctionImpl;
            IrFunctionImpl it2 = irFunctionImpl = new IrFunctionImpl(-1, -1, IrDeclarationOrigin.DEFINED.INSTANCE, inheritedFun, null);
            IrUtilsKt.createParameterDeclarations(it2);
            it2.setReturnType(defaultImplFun.getReturnType());
            irFunction = irFunctionImpl;
        } else {
            JvmDeclarationFactory jvmDeclarationFactory = this.context.getDeclarationFactory();
            ReferenceSymbolTable referenceSymbolTable = this.context.getIr().getSymbols().getExternalSymbolTable();
            FunctionDescriptor functionDescriptor = inheritedFun.getOriginal();
            Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor, (String)"inheritedFun.original");
            irFunction = jvmDeclarationFactory.getDefaultImplsFunction((IrFunction)referenceSymbolTable.referenceSimpleFunction(functionDescriptor).getOwner());
        }
        IrFunction irFunction2 = irFunction;
        IrBlockBodyImpl irBody = new IrBlockBodyImpl(-1, -1);
        irFunction2.setBody(irBody);
        irClass.getDeclarations().add(irFunction2);
        IrCallImpl irCallImpl = new IrCallImpl(-1, -1, defaultImplFun.getReturnType(), defaultImplFun.getSymbol(), defaultImplFun.getDescriptor(), (IrStatementOrigin)JvmLoweredStatementOrigin.DEFAULT_IMPLS_DELEGATION.INSTANCE, null, 64, null);
        irBody.getStatements().add(new IrReturnImpl(-1, -1, irFunction2.getReturnType(), irFunction2.getSymbol(), (IrExpression)irCallImpl));
        int offset2 = 0;
        IrValueParameter irValueParameter2 = irFunction2.getDispatchReceiverParameter();
        if (irValueParameter2 != null) {
            irValueParameter = irValueParameter2;
            it = irValueParameter;
            irCallImpl.putValueArgument(offset2, new IrGetValueImpl(-1, -1, (IrValueSymbol)it.getSymbol(), null, 8, null));
            n = offset2;
            offset2 = n + 1;
        }
        IrValueParameter irValueParameter3 = irFunction2.getExtensionReceiverParameter();
        if (irValueParameter3 != null) {
            irValueParameter = irValueParameter3;
            it = irValueParameter;
            irCallImpl.putValueArgument(offset2, new IrGetValueImpl(-1, -1, (IrValueSymbol)it.getSymbol(), null, 8, null));
            n = offset2;
            offset2 = n + 1;
        }
        Iterable $receiver$iv = irFunction2.getValueParameters();
        it = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            void parameter;
            void i;
            int n2 = index$iv$iv++;
            Collection collection = destination$iv$iv;
            if (n2 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n3 = n2;
            IrValueParameter irValueParameter4 = (IrValueParameter)item$iv$iv;
            int n4 = n3;
            Collection collection2 = collection;
            irCallImpl.putValueArgument((int)(i + offset2), new IrGetValueImpl(-1, -1, (IrValueSymbol)parameter.getSymbol(), null));
            Unit unit = Unit.INSTANCE;
            collection2.add(unit);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public InterfaceDelegationLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.state = this.context.getState();
    }
}

