/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.parsing;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.contracts.description.ContractDescription;
import org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import org.jetbrains.kotlin.contracts.description.LazyContractProvider;
import org.jetbrains.kotlin.contracts.parsing.ContractCallContext;
import org.jetbrains.kotlin.contracts.parsing.ContractParsingDiagnosticsCollector;
import org.jetbrains.kotlin.contracts.parsing.PsiContractParserDispatcher;
import org.jetbrains.kotlin.contracts.parsing.PsiContractsUtilsKt;
import org.jetbrains.kotlin.contracts.parsing.TraceBasedCollector;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J&\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\u0019\u001a\u00020\u0015*\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingServices;", "", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "checkContractAllowedHere", "", "collector", "Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingDiagnosticsCollector;", "callContext", "Lorg/jetbrains/kotlin/contracts/parsing/ContractCallContext;", "checkContractAndRecordIfPresent", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "isFirstStatement", "", "checkFeatureEnabled", "doCheckContract", "Lorg/jetbrains/kotlin/contracts/description/ContractDescription;", "isContractDescriptionCallPreciseCheck", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "frontend"})
public final class ContractParsingServices {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;

    public final void checkContractAndRecordIfPresent(@NotNull KtExpression expression2, @NotNull BindingTrace trace, @NotNull LexicalScope scope, boolean isFirstStatement) {
        block3: {
            LazyContractProvider contractProviderIfAny;
            ContractDescription parsedContract;
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
                Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
                if (!KtPsiUtilKt.isContractDescriptionCallPsiCheck(expression2)) {
                    return;
                }
                TraceBasedCollector collector2 = new TraceBasedCollector(trace, expression2);
                BindingContext bindingContext = trace.getBindingContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
                ContractCallContext callContext = new ContractCallContext(expression2, isFirstStatement, scope, bindingContext);
                parsedContract = this.doCheckContract(collector2, callContext);
                collector2.flushDiagnostics(parsedContract == null);
                DeclarationDescriptor declarationDescriptor = scope.getOwnerDescriptor();
                if (!(declarationDescriptor instanceof FunctionDescriptor)) {
                    declarationDescriptor = null;
                }
                FunctionDescriptor functionDescriptor = (FunctionDescriptor)declarationDescriptor;
                LazyContractProvider lazyContractProvider = contractProviderIfAny = functionDescriptor != null ? (LazyContractProvider)functionDescriptor.getUserData(ContractProviderKey.INSTANCE) : null;
                if (!collector2.hasErrors()) break block2;
                LazyContractProvider lazyContractProvider2 = contractProviderIfAny;
                if (lazyContractProvider2 == null) break block3;
                lazyContractProvider2.setContractDescription(null);
                break block3;
            }
            LazyContractProvider lazyContractProvider = contractProviderIfAny;
            if (lazyContractProvider == null) break block3;
            lazyContractProvider.setContractDescription(parsedContract);
        }
    }

    private final ContractDescription doCheckContract(ContractParsingDiagnosticsCollector collector2, ContractCallContext callContext) {
        BindingContext bindingContext;
        KtExpression expression2 = callContext.getContractCallExpression();
        if (!this.isContractDescriptionCallPreciseCheck(expression2, bindingContext = callContext.getBindingContext())) {
            return null;
        }
        this.checkFeatureEnabled(collector2);
        this.checkContractAllowedHere(collector2, callContext);
        return !collector2.hasErrors() ? new PsiContractParserDispatcher(collector2, callContext).parseContract() : null;
    }

    private final void checkFeatureEnabled(ContractParsingDiagnosticsCollector collector2) {
        boolean isFeatureTurnedOn;
        boolean bl = isFeatureTurnedOn = this.languageVersionSettings.supportsFeature(LanguageFeature.AllowContractsForCustomFunctions) || this.languageVersionSettings.getFlag(AnalysisFlag.Flags.getAllowKotlinPackage()) != false;
        if (!isFeatureTurnedOn) {
            collector2.unsupportedFeature(this.languageVersionSettings);
        }
    }

    private final void checkContractAllowedHere(ContractParsingDiagnosticsCollector collector2, ContractCallContext callContext) {
        FunctionDescriptor functionDescriptor;
        block15: {
            block14: {
                DeclarationDescriptor declarationDescriptor = callContext.getOwnerDescriptor();
                if (!(declarationDescriptor instanceof FunctionDescriptor)) {
                    declarationDescriptor = null;
                }
                functionDescriptor = (FunctionDescriptor)declarationDescriptor;
                LexicalScope scope = callContext.getScope();
                if (!callContext.isFirstStatement()) {
                    collector2.contractNotAllowed("Contract should be the first statement");
                }
                if (functionDescriptor == null) {
                    collector2.contractNotAllowed("Contracts are allowed only for functions");
                }
                if (!(callContext.getOwnerDescriptor().getContainingDeclaration() instanceof PackageFragmentDescriptor) || scope.getKind() != LexicalScopeKind.CODE_BLOCK) break block14;
                HierarchicalScope hierarchicalScope = scope.getParent();
                if (!(hierarchicalScope instanceof LexicalScope)) {
                    hierarchicalScope = null;
                }
                LexicalScope lexicalScope = (LexicalScope)hierarchicalScope;
                if ((lexicalScope != null ? lexicalScope.getKind() : null) == LexicalScopeKind.FUNCTION_INNER_SCOPE) break block15;
            }
            collector2.contractNotAllowed("Contracts are allowed only for top-level functions");
        }
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        if (functionDescriptor2 != null) {
            if (functionDescriptor2.isOperator()) {
                collector2.contractNotAllowed("Contracts are not allowed for operator functions");
            }
        }
        FunctionDescriptor functionDescriptor3 = functionDescriptor;
        if (functionDescriptor3 != null) {
            if (functionDescriptor3.isSuspend()) {
                collector2.contractNotAllowed("Contracts are not allowed for suspend functions");
            }
        }
        FunctionDescriptor functionDescriptor4 = functionDescriptor;
        if (functionDescriptor4 != null) {
            if (ModalityKt.isOverridable(functionDescriptor4)) {
                collector2.contractNotAllowed("Contracts are not allowed for open functions");
            }
        }
    }

    private final boolean isContractDescriptionCallPreciseCheck(@NotNull KtExpression $receiver, BindingContext context) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($receiver, context);
        return resolvedCall2 != null && (resolvedCall2 = resolvedCall2.getResultingDescriptor()) != null ? PsiContractsUtilsKt.isContractCallDescriptor((DeclarationDescriptor)((Object)resolvedCall2)) : false;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    public ContractParsingServices(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.languageVersionSettings = languageVersionSettings;
    }
}

