/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\rH\u0002J \u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmAnnotationsTargetNonExistentAccessorChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "isSpecialStaticProperty", "", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "reportOnAnnotationWithNonSourceRetention", "entry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "declarationName", "", "Companion", "frontend.java"})
public final class JvmAnnotationsTargetNonExistentAccessorChecker
implements DeclarationChecker {
    private static final Set<AnnotationUseSiteTarget> getterUselessTargets;
    private static final Set<AnnotationUseSiteTarget> setterUselessTargets;
    public static final Companion Companion;

    /*
     * Unable to fully structure code
     */
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!(descriptor instanceof MemberDescriptor)) {
            return;
        }
        if (!(declaration instanceof KtParameter) && !(declaration instanceof KtProperty)) {
            return;
        }
        if (!Visibilities.isPrivate(((MemberDescriptor)descriptor).getVisibility()) && !this.isSpecialStaticProperty((MemberDescriptor)descriptor)) {
            return;
        }
        if (!(declaration instanceof KtProperty)) ** GOTO lbl-1000
        v0 = ((KtProperty)declaration).getGetter();
        if (v0 == null) ** GOTO lbl-1000
        if (v0.hasBody()) {
            v1 = true;
        } else lbl-1000:
        // 3 sources

        {
            v1 = hasGetterWithBody = false;
        }
        if (!(declaration instanceof KtProperty)) ** GOTO lbl-1000
        v2 = ((KtProperty)declaration).getSetter();
        if (v2 == null) ** GOTO lbl-1000
        if (v2.hasBody()) {
            v3 = true;
        } else lbl-1000:
        // 3 sources

        {
            v3 = hasSetterWithBody = false;
        }
        if (hasGetterWithBody && hasSetterWithBody) {
            return;
        }
        if (declaration instanceof KtProperty && ((KtProperty)declaration).hasDelegate()) {
            return;
        }
        v4 = declaration.getName();
        if (v4 == null) {
            v4 = ((MemberDescriptor)descriptor).getName().asString();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"declaration.name ?: descriptor.name.asString()");
        declarationName = v4;
        var8_7 = declaration.getAnnotationEntries().iterator();
        while (var8_7.hasNext()) {
            v5 = annotation = var8_7.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"annotation");
            if (v5.getUseSiteTarget() == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiTarget, (String)"annotation.useSiteTarget ?: continue");
            useSiteTarget = psiTarget.getAnnotationUseSiteTarget();
            if ((hasGetterWithBody || !JvmAnnotationsTargetNonExistentAccessorChecker.getterUselessTargets.contains((Object)useSiteTarget)) && (hasSetterWithBody || !JvmAnnotationsTargetNonExistentAccessorChecker.setterUselessTargets.contains((Object)useSiteTarget))) continue;
            this.reportOnAnnotationWithNonSourceRetention(annotation, declarationName, context);
        }
        if (declaration instanceof KtProperty) {
            if (!hasGetterWithBody && (v6 = ((KtProperty)declaration).getGetter()) != null && (v6 = v6.getAnnotationEntries()) != null) {
                $receiver$iv = (Iterable)v6;
                var8_7 = $receiver$iv.iterator();
                while (var8_7.hasNext()) {
                    v7 = it = (element$iv = var8_7.next());
                    Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"it");
                    this.reportOnAnnotationWithNonSourceRetention(v7, declarationName, context);
                }
            }
            if (!hasSetterWithBody && (v8 = ((KtProperty)declaration).getSetter()) != null && (v8 = v8.getAnnotationEntries()) != null) {
                $receiver$iv = (Iterable)v8;
                var8_7 = $receiver$iv.iterator();
                while (var8_7.hasNext()) {
                    v9 = it = (element$iv = var8_7.next());
                    Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"it");
                    this.reportOnAnnotationWithNonSourceRetention(v9, declarationName, context);
                }
            }
        }
    }

    private final void reportOnAnnotationWithNonSourceRetention(KtAnnotationEntry entry, String declarationName, DeclarationCheckerContext context) {
        AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)context.getTrace().get(BindingContext.ANNOTATION, entry);
        if (annotationDescriptor == null) {
            return;
        }
        AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
        ClassDescriptor classDescriptor2 = DescriptorUtilsKt.getAnnotationClass(annotationDescriptor2);
        if ((classDescriptor2 != null ? DescriptorUtilsKt.getAnnotationRetention(classDescriptor2) : null) == KotlinRetention.SOURCE) {
            return;
        }
        BindingTrace bindingTrace = context.getTrace();
        ParametrizedDiagnostic<KtAnnotationEntry> parametrizedDiagnostic = ErrorsJvm.ANNOTATION_TARGETS_NON_EXISTENT_ACCESSOR.on((KtAnnotationEntry)((PsiElement)entry), declarationName);
        Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, (String)"ErrorsJvm.ANNOTATION_TAR\u2026n(entry, declarationName)");
        DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, parametrizedDiagnostic);
    }

    private final boolean isSpecialStaticProperty(MemberDescriptor descriptor2) {
        return JvmAnnotationUtilKt.hasJvmFieldAnnotation(descriptor2) || descriptor2 instanceof VariableDescriptor && ((VariableDescriptor)((Object)descriptor2)).isConst();
    }

    static {
        Companion = new Companion(null);
        getterUselessTargets = SetsKt.setOf((Object)((Object)AnnotationUseSiteTarget.PROPERTY_GETTER));
        setterUselessTargets = SetsKt.setOf((Object[])new AnnotationUseSiteTarget[]{AnnotationUseSiteTarget.PROPERTY_SETTER, AnnotationUseSiteTarget.SETTER_PARAMETER});
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmAnnotationsTargetNonExistentAccessorChecker$Companion;", "", "()V", "getterUselessTargets", "", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "setterUselessTargets", "frontend.java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

