/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.index.JavaRoot;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.load.kotlin.ModuleMappingUtilKt;
import org.jetbrains.kotlin.load.kotlin.PackagePartProvider;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMetadataVersion;
import org.jetbrains.kotlin.metadata.jvm.deserialization.ModuleMapping;
import org.jetbrains.kotlin.metadata.jvm.deserialization.PackageParts;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.CompilerDeserializationConfiguration;
import org.jetbrains.kotlin.serialization.deserialization.MetadataPartProvider;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u001fB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00102\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u00102\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00102\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\u001c\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\u0016\u001a\u00020\u0015H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/JvmPackagePartProvider;", "Lorg/jetbrains/kotlin/load/kotlin/PackagePartProvider;", "Lorg/jetbrains/kotlin/serialization/deserialization/MetadataPartProvider;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lcom/intellij/psi/search/GlobalSearchScope;)V", "deserializationConfiguration", "Lorg/jetbrains/kotlin/resolve/CompilerDeserializationConfiguration;", "loadedModules", "", "Lorg/jetbrains/kotlin/cli/jvm/compiler/JvmPackagePartProvider$ModuleMappingInfo;", "addRoots", "", "roots", "", "Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "findMetadataPackageParts", "", "packageFqName", "findPackageParts", "getAnnotationsOnBinaryModule", "Lorg/jetbrains/kotlin/name/ClassId;", "moduleName", "getPackageParts", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/PackageParts;", "ModuleMappingInfo", "cli"})
public final class JvmPackagePartProvider
implements PackagePartProvider,
MetadataPartProvider {
    private final CompilerDeserializationConfiguration deserializationConfiguration;
    private final List<ModuleMappingInfo> loadedModules;
    private final GlobalSearchScope scope;

    @Override
    @NotNull
    public List<String> findPackageParts(@NotNull String packageFqName) {
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        Map<VirtualFile, PackageParts> rootToPackageParts = this.getPackageParts(packageFqName);
        if (rootToPackageParts.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        LinkedHashSet visitedMultifileFacades = new LinkedHashSet();
        Map<VirtualFile, PackageParts> map2 = rootToPackageParts;
        Iterator<Map.Entry<VirtualFile, PackageParts>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Iterable $receiver$iv;
            Map.Entry<VirtualFile, PackageParts> entry;
            Map.Entry<VirtualFile, PackageParts> entry2 = entry = iterator2.next();
            PackageParts packageParts = entry2.getValue();
            for (String name : packageParts.getParts()) {
                String facadeName = packageParts.getMultifileFacadeName(name);
                if (facadeName != null && visitedMultifileFacades.contains(facadeName)) continue;
                result2.add(name);
            }
            Iterable $receiver$iv$iv = $receiver$iv = (Iterable)packageParts.getParts();
            for (Object element$iv$iv : $receiver$iv$iv) {
                String string;
                Object element$iv = element$iv$iv;
                String p1 = (String)element$iv;
                if (packageParts.getMultifileFacadeName(p1) == null) continue;
                String it$iv = string;
                ((Collection)visitedMultifileFacades).add(it$iv);
            }
        }
        return CollectionsKt.toList((Iterable)result2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> findMetadataPackageParts(@NotNull String packageFqName) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        Iterable iterable = $receiver$iv = (Iterable)this.getPackageParts(packageFqName).values();
        Collection destination$iv$iv = new ArrayList();
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv;
            Object receiver2 = element$iv$iv = iterator2.next();
            Iterable list$iv$iv = ((PackageParts)receiver2).getMetadataParts();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    private final synchronized Map<VirtualFile, PackageParts> getPackageParts(String packageFqName) {
        Map result2 = new LinkedHashMap();
        for (ModuleMappingInfo moduleMappingInfo : this.loadedModules) {
            PackageParts newParts;
            VirtualFile root2 = moduleMappingInfo.component1();
            ModuleMapping mapping2 = moduleMappingInfo.component2();
            if (mapping2.findPackageParts(packageFqName) == null) {
                continue;
            }
            if ((PackageParts)result2.get(root2) != null) {
                PackageParts packageParts;
                PackageParts parts = packageParts;
                parts.plusAssign(newParts);
                continue;
            }
            result2.put(root2, newParts);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ClassId> getAnnotationsOnBinaryModule(@NotNull String moduleName) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
        Iterable iterable = $receiver$iv = (Iterable)this.loadedModules;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator2 = $receiver$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            List list2;
            List list3;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            ModuleMappingInfo $$_$_mapping_name = (ModuleMappingInfo)element$iv$iv;
            ModuleMapping mapping2 = $$_$_mapping_name.component2();
            String name = $$_$_mapping_name.component3();
            if (Intrinsics.areEqual((Object)name, (Object)moduleName)) {
                void $receiver$iv$iv2;
                Iterable $receiver$iv2;
                Iterable iterable2 = $receiver$iv2 = (Iterable)mapping2.getModuleData().getAnnotations();
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv2) {
                    void p1;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    ClassId classId = ClassId.fromString((String)p1);
                    collection.add(classId);
                }
                list3 = (List)destination$iv$iv2;
            } else {
                list3 = null;
            }
            if (list3 == null) continue;
            List it$iv$iv = list2 = list3;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    public final void addRoots(@NotNull List<JavaRoot> roots2, @NotNull MessageCollector messageCollector2) {
        Intrinsics.checkParameterIsNotNull(roots2, (String)"roots");
        Intrinsics.checkParameterIsNotNull((Object)messageCollector2, (String)"messageCollector");
        for (JavaRoot javaRoot : roots2) {
            VirtualFile metaInf;
            VirtualFile root2 = javaRoot.component1();
            JavaRoot.RootType type2 = javaRoot.component2();
            if (type2 != JavaRoot.RootType.BINARY || !this.scope.contains(root2)) continue;
            if (root2.findChild("META-INF") == null) {
                continue;
            }
            VirtualFile virtualFile2 = metaInf;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"metaInf");
            VirtualFile[] virtualFileArray = virtualFile2.getChildren();
            int n = virtualFileArray.length;
            for (int i = 0; i < n; ++i) {
                VirtualFile moduleFile;
                VirtualFile virtualFile3 = moduleFile = virtualFileArray[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"moduleFile");
                String string = virtualFile3.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"moduleFile.name");
                if (!StringsKt.endsWith$default((String)string, (String)"kotlin_module", (boolean)false, (int)2, null)) continue;
                try {
                    byte[] byArray = moduleFile.contentsToByteArray();
                    String string2 = moduleFile.toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"moduleFile.toString()");
                    ModuleMapping mapping2 = ModuleMappingUtilKt.loadModuleMapping(ModuleMapping.Companion, byArray, string2, this.deserializationConfiguration, (Function1<? super JvmMetadataVersion, Unit>)((Function1)new Function1<JvmMetadataVersion, Unit>(messageCollector2, moduleFile){
                        final /* synthetic */ MessageCollector $messageCollector;
                        final /* synthetic */ VirtualFile $moduleFile;

                        public final void invoke(@NotNull JvmMetadataVersion incompatibleVersion) {
                            Intrinsics.checkParameterIsNotNull((Object)incompatibleVersion, (String)"incompatibleVersion");
                            String string = "Module was compiled with an incompatible version of Kotlin. The binary version of its metadata is " + incompatibleVersion + ", expected version is " + JvmMetadataVersion.INSTANCE + '.';
                            VirtualFile virtualFile2 = this.$moduleFile;
                            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"moduleFile");
                            this.$messageCollector.report(CompilerMessageSeverity.ERROR, string, CompilerMessageLocation.Companion.create(virtualFile2.getPath()));
                        }
                        {
                            this.$messageCollector = messageCollector2;
                            this.$moduleFile = virtualFile2;
                            super(1);
                        }
                    }));
                    String string3 = moduleFile.getNameWithoutExtension();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"moduleFile.nameWithoutExtension");
                    this.loadedModules.add(new ModuleMappingInfo(root2, mapping2, string3));
                    continue;
                }
                catch (EOFException e) {
                    messageCollector2.report(CompilerMessageSeverity.ERROR, "Error occurred when reading the module: " + e.getMessage(), CompilerMessageLocation.Companion.create(moduleFile.getPath()));
                    Object object = new ByteArrayOutputStream();
                    CompilerMessageSeverity compilerMessageSeverity = CompilerMessageSeverity.LOGGING;
                    MessageCollector messageCollector3 = messageCollector2;
                    ByteArrayOutputStream it = object;
                    e.printStackTrace(new PrintStream(it));
                    Object object2 = object;
                    byte[] byArray = ((ByteArrayOutputStream)object2).toByteArray();
                    Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"ByteArrayOutputStream().\u2026ream(it)) }.toByteArray()");
                    object = byArray;
                    object2 = new String((byte[])object, Charsets.UTF_8);
                    messageCollector3.report(compilerMessageSeverity, (String)object2, CompilerMessageLocation.Companion.create(moduleFile.getPath()));
                }
            }
        }
    }

    public JvmPackagePartProvider(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        this.scope = scope;
        this.deserializationConfiguration = new CompilerDeserializationConfiguration(languageVersionSettings);
        this.loadedModules = new SmartList();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/JvmPackagePartProvider$ModuleMappingInfo;", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "mapping", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/ModuleMapping;", "name", "", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/metadata/jvm/deserialization/ModuleMapping;Ljava/lang/String;)V", "getMapping", "()Lorg/jetbrains/kotlin/metadata/jvm/deserialization/ModuleMapping;", "getName", "()Ljava/lang/String;", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "cli"})
    private static final class ModuleMappingInfo {
        @NotNull
        private final VirtualFile root;
        @NotNull
        private final ModuleMapping mapping;
        @NotNull
        private final String name;

        @NotNull
        public final VirtualFile getRoot() {
            return this.root;
        }

        @NotNull
        public final ModuleMapping getMapping() {
            return this.mapping;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public ModuleMappingInfo(@NotNull VirtualFile root2, @NotNull ModuleMapping mapping2, @NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            Intrinsics.checkParameterIsNotNull((Object)mapping2, (String)"mapping");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            this.root = root2;
            this.mapping = mapping2;
            this.name = name;
        }

        @NotNull
        public final VirtualFile component1() {
            return this.root;
        }

        @NotNull
        public final ModuleMapping component2() {
            return this.mapping;
        }

        @NotNull
        public final String component3() {
            return this.name;
        }

        @NotNull
        public final ModuleMappingInfo copy(@NotNull VirtualFile root2, @NotNull ModuleMapping mapping2, @NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            Intrinsics.checkParameterIsNotNull((Object)mapping2, (String)"mapping");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            return new ModuleMappingInfo(root2, mapping2, name);
        }

        @NotNull
        public static /* synthetic */ ModuleMappingInfo copy$default(ModuleMappingInfo moduleMappingInfo, VirtualFile virtualFile2, ModuleMapping moduleMapping, String string, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile2 = moduleMappingInfo.root;
            }
            if ((n & 2) != 0) {
                moduleMapping = moduleMappingInfo.mapping;
            }
            if ((n & 4) != 0) {
                string = moduleMappingInfo.name;
            }
            return moduleMappingInfo.copy(virtualFile2, moduleMapping, string);
        }

        @NotNull
        public String toString() {
            return "ModuleMappingInfo(root=" + this.root + ", mapping=" + this.mapping + ", name=" + this.name + ")";
        }

        public int hashCode() {
            VirtualFile virtualFile2 = this.root;
            ModuleMapping moduleMapping = this.mapping;
            String string = this.name;
            return ((virtualFile2 != null ? virtualFile2.hashCode() : 0) * 31 + (moduleMapping != null ? moduleMapping.hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ModuleMappingInfo)) break block3;
                    ModuleMappingInfo moduleMappingInfo = (ModuleMappingInfo)object;
                    if (!Intrinsics.areEqual((Object)this.root, (Object)moduleMappingInfo.root) || !Intrinsics.areEqual((Object)this.mapping, (Object)moduleMappingInfo.mapping) || !Intrinsics.areEqual((Object)this.name, (Object)moduleMappingInfo.name)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

