/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy;

import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import kotlin.annotations.jvm.ReadOnly;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.context.GlobalContext;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SupertypeLoopChecker;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.FunctionDescriptorResolver;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.checkers.PlatformDiagnosticSuppressor;
import org.jetbrains.kotlin.resolve.extensions.SyntheticResolveExtension;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProviderImpl;
import org.jetbrains.kotlin.resolve.lazy.DelegationFilter;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.KotlinCodeAnalyzer;
import org.jetbrains.kotlin.resolve.lazy.LazyClassContext;
import org.jetbrains.kotlin.resolve.lazy.LazyDeclarationResolver;
import org.jetbrains.kotlin.resolve.lazy.LocalDescriptorResolver;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassOrObjectInfo;
import org.jetbrains.kotlin.resolve.lazy.data.KtScriptInfo;
import org.jetbrains.kotlin.resolve.lazy.declarations.DeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotations;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotationsContextImpl;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyPackageDescriptor;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.storage.CacheWithNotNullValues;
import org.jetbrains.kotlin.storage.ExceptionTracker;
import org.jetbrains.kotlin.storage.LazyResolveStorageManager;
import org.jetbrains.kotlin.storage.LockBasedLazyResolveStorageManager;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNotNull;
import org.jetbrains.kotlin.types.WrappedTypeFactory;
import org.jetbrains.kotlin.utils.SmartList;

public class ResolveSession
implements KotlinCodeAnalyzer,
LazyClassContext {
    private final LazyResolveStorageManager storageManager;
    private final ExceptionTracker exceptionTracker;
    private final ModuleDescriptor module;
    private final BindingTrace trace;
    private final DeclarationProviderFactory declarationProviderFactory;
    private final CacheWithNotNullValues<FqName, LazyPackageDescriptor> packages;
    private final PackageFragmentProvider packageFragmentProvider;
    private final MemoizedFunctionToNotNull<KtFile, LazyAnnotations> fileAnnotations;
    private final MemoizedFunctionToNotNull<KtFile, LazyAnnotations> danglingAnnotations;
    private AnnotationResolver annotationResolver;
    private DescriptorResolver descriptorResolver;
    private FunctionDescriptorResolver functionDescriptorResolver;
    private TypeResolver typeResolver;
    private LazyDeclarationResolver lazyDeclarationResolver;
    private FileScopeProvider fileScopeProvider;
    private DeclarationScopeProvider declarationScopeProvider;
    private LookupTracker lookupTracker;
    private LocalDescriptorResolver localDescriptorResolver;
    private SupertypeLoopChecker supertypeLoopsResolver;
    private LanguageVersionSettings languageVersionSettings;
    private DelegationFilter delegationFilter;
    private WrappedTypeFactory wrappedTypeFactory;
    private PlatformDiagnosticSuppressor platformDiagnosticSuppressor;
    private final SyntheticResolveExtension syntheticResolveExtension;

    @Inject
    public void setAnnotationResolve(AnnotationResolver annotationResolver) {
        this.annotationResolver = annotationResolver;
    }

    @Inject
    public void setDescriptorResolver(DescriptorResolver descriptorResolver) {
        this.descriptorResolver = descriptorResolver;
    }

    @Inject
    public void setFunctionDescriptorResolver(FunctionDescriptorResolver functionDescriptorResolver) {
        this.functionDescriptorResolver = functionDescriptorResolver;
    }

    @Inject
    public void setTypeResolver(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    @Inject
    public void setLazyDeclarationResolver(LazyDeclarationResolver lazyDeclarationResolver) {
        this.lazyDeclarationResolver = lazyDeclarationResolver;
    }

    @Inject
    public void setFileScopeProvider(@NotNull FileScopeProvider fileScopeProvider) {
        this.fileScopeProvider = fileScopeProvider;
    }

    @Inject
    public void setDeclarationScopeProvider(@NotNull DeclarationScopeProviderImpl declarationScopeProvider) {
        this.declarationScopeProvider = declarationScopeProvider;
    }

    @Inject
    public void setLookupTracker(@NotNull LookupTracker lookupTracker) {
        this.lookupTracker = lookupTracker;
    }

    @Inject
    public void setLanguageVersionSettings(@NotNull LanguageVersionSettings languageVersionSettings) {
        this.languageVersionSettings = languageVersionSettings;
    }

    @Inject
    public void setDelegationFilter(@NotNull DelegationFilter delegationFilter) {
        this.delegationFilter = delegationFilter;
    }

    @Inject
    public void setWrappedTypeFactory(@NotNull WrappedTypeFactory wrappedTypeFactory) {
        this.wrappedTypeFactory = wrappedTypeFactory;
    }

    @Inject
    public void setPlatformDiagnosticSuppressor(@NotNull PlatformDiagnosticSuppressor platformDiagnosticSuppressor) {
        this.platformDiagnosticSuppressor = platformDiagnosticSuppressor;
    }

    @Deprecated
    public ResolveSession(@NotNull Project project, @NotNull GlobalContext globalContext, @NotNull ModuleDescriptor rootDescriptor, @NotNull DeclarationProviderFactory declarationProviderFactory2, @NotNull BindingTrace delegationTrace) {
        LockBasedLazyResolveStorageManager lockBasedLazyResolveStorageManager = new LockBasedLazyResolveStorageManager(globalContext.getStorageManager());
        this.storageManager = lockBasedLazyResolveStorageManager;
        this.exceptionTracker = globalContext.getExceptionTracker();
        this.trace = lockBasedLazyResolveStorageManager.createSafeTrace(delegationTrace);
        this.module = rootDescriptor;
        this.packages = this.storageManager.createCacheWithNotNullValues();
        this.declarationProviderFactory = declarationProviderFactory2;
        this.packageFragmentProvider = new PackageFragmentProvider(){

            @Override
            @NotNull
            public List<PackageFragmentDescriptor> getPackageFragments(@NotNull FqName fqName2) {
                return ContainerUtil.createMaybeSingletonList(ResolveSession.this.getPackageFragment(fqName2));
            }

            @Override
            @NotNull
            public Collection<FqName> getSubPackagesOf(@NotNull FqName fqName2, @NotNull Function1<? super Name, Boolean> nameFilter2) {
                LazyPackageDescriptor packageDescriptor = ResolveSession.this.getPackageFragment(fqName2);
                if (packageDescriptor == null) {
                    return Collections.emptyList();
                }
                return packageDescriptor.getDeclarationProvider().getAllDeclaredSubPackages(nameFilter2);
            }
        };
        this.fileAnnotations = this.storageManager.createMemoizedFunction(file2 -> this.createAnnotations((KtFile)file2, file2.getAnnotationEntries()));
        this.danglingAnnotations = this.storageManager.createMemoizedFunction(file2 -> this.createAnnotations((KtFile)file2, file2.getDanglingAnnotations()));
        this.syntheticResolveExtension = SyntheticResolveExtension.Companion.getInstance(project);
    }

    private LazyAnnotations createAnnotations(KtFile file2, List<KtAnnotationEntry> annotationEntries) {
        LexicalScope scope = this.fileScopeProvider.getFileResolutionScope(file2);
        LazyAnnotationsContextImpl lazyAnnotationContext = new LazyAnnotationsContextImpl(this.annotationResolver, this.storageManager, this.trace, scope);
        return new LazyAnnotations(lazyAnnotationContext, annotationEntries);
    }

    @Override
    @NotNull
    public PackageFragmentProvider getPackageFragmentProvider() {
        return this.packageFragmentProvider;
    }

    @Override
    @Nullable
    public LazyPackageDescriptor getPackageFragment(@NotNull FqName fqName2) {
        PackageMemberDeclarationProvider provider = this.declarationProviderFactory.getPackageMemberDeclarationProvider(fqName2);
        if (provider == null) {
            return null;
        }
        return this.packages.computeIfAbsent(fqName2, (Function0<LazyPackageDescriptor>)((Function0)() -> new LazyPackageDescriptor(this.module, fqName2, this, provider)));
    }

    @Override
    @NotNull
    public LazyPackageDescriptor getPackageFragmentOrDiagnoseFailure(@NotNull FqName fqName2, @Nullable KtFile from) {
        LazyPackageDescriptor packageDescriptor = this.getPackageFragment(fqName2);
        if (packageDescriptor == null) {
            this.declarationProviderFactory.diagnoseMissingPackageFragment(fqName2, from);
            assert (false) : "diagnoseMissingPackageFragment should throw!";
        }
        return packageDescriptor;
    }

    @Override
    @NotNull
    public ModuleDescriptor getModuleDescriptor() {
        return this.module;
    }

    @Override
    @NotNull
    public LazyResolveStorageManager getStorageManager() {
        return this.storageManager;
    }

    @NotNull
    public ExceptionTracker getExceptionTracker() {
        return this.exceptionTracker;
    }

    @Override
    @NotNull
    @ReadOnly
    public Collection<ClassifierDescriptor> getTopLevelClassifierDescriptors(@NotNull FqName fqName2, @NotNull LookupLocation location2) {
        if (fqName2.isRoot()) {
            return Collections.emptyList();
        }
        PackageMemberDeclarationProvider provider = this.declarationProviderFactory.getPackageMemberDeclarationProvider(fqName2.parent());
        if (provider == null) {
            return Collections.emptyList();
        }
        SmartList<ClassifierDescriptor> result2 = new SmartList<ClassifierDescriptor>();
        result2.addAll(ContainerUtil.mapNotNull(provider.getClassOrObjectDeclarations(fqName2.shortName()), classLikeInfo -> {
            if (classLikeInfo instanceof KtClassOrObjectInfo) {
                return this.getClassDescriptor(((KtClassOrObjectInfo)classLikeInfo).getCorrespondingClassOrObject(), location2);
            }
            if (classLikeInfo instanceof KtScriptInfo) {
                return this.getScriptDescriptor(((KtScriptInfo)classLikeInfo).getScript());
            }
            throw new IllegalStateException("Unexpected " + classLikeInfo + " of type " + classLikeInfo.getClass().getName());
        }));
        result2.addAll(ContainerUtil.map(provider.getTypeAliasDeclarations(fqName2.shortName()), alias -> (ClassifierDescriptor)this.lazyDeclarationResolver.resolveToDescriptor((KtDeclaration)alias)));
        return result2;
    }

    @Override
    @NotNull
    public ClassDescriptor getClassDescriptor(@NotNull KtClassOrObject classOrObject, @NotNull LookupLocation location2) {
        return this.lazyDeclarationResolver.getClassDescriptor(classOrObject, location2);
    }

    @NotNull
    public ScriptDescriptor getScriptDescriptor(@NotNull KtScript script) {
        return this.lazyDeclarationResolver.getScriptDescriptor(script, NoLookupLocation.FOR_SCRIPT);
    }

    @Override
    @NotNull
    public BindingContext getBindingContext() {
        return this.trace.getBindingContext();
    }

    @Override
    @NotNull
    public BindingTrace getTrace() {
        return this.trace;
    }

    @Override
    @NotNull
    public DeclarationProviderFactory getDeclarationProviderFactory() {
        return this.declarationProviderFactory;
    }

    @Override
    @NotNull
    public DeclarationDescriptor resolveToDescriptor(@NotNull KtDeclaration declaration) {
        this.assertValid();
        if (!ResolveSession.areDescriptorsCreatedForDeclaration(declaration)) {
            throw new IllegalStateException("No descriptors are created for declarations of type " + declaration.getClass().getSimpleName() + "\n. Change the caller accordingly");
        }
        if (!KtPsiUtil.isLocal(declaration)) {
            return this.lazyDeclarationResolver.resolveToDescriptor(declaration);
        }
        return this.localDescriptorResolver.resolveLocalDeclaration(declaration);
    }

    public static boolean areDescriptorsCreatedForDeclaration(@NotNull KtDeclaration declaration) {
        return !(declaration instanceof KtAnonymousInitializer) && !(declaration instanceof KtDestructuringDeclaration);
    }

    @NotNull
    public Annotations getFileAnnotations(@NotNull KtFile file2) {
        return (Annotations)this.fileAnnotations.invoke(file2);
    }

    @NotNull
    public Annotations getDanglingAnnotations(@NotNull KtFile file2) {
        return (Annotations)this.danglingAnnotations.invoke(file2);
    }

    @NotNull
    private List<LazyPackageDescriptor> getAllPackages() {
        LazyPackageDescriptor rootPackage = this.getPackageFragment(FqName.ROOT);
        assert (rootPackage != null) : "Root package must be initialized";
        return this.collectAllPackages(Lists.newArrayList(), rootPackage);
    }

    @NotNull
    private List<LazyPackageDescriptor> collectAllPackages(@NotNull List<LazyPackageDescriptor> result2, @NotNull LazyPackageDescriptor current) {
        result2.add(current);
        for (FqName subPackage : this.packageFragmentProvider.getSubPackagesOf(current.getFqName(), MemberScope.Companion.getALL_NAME_FILTER())) {
            LazyPackageDescriptor fragment = this.getPackageFragmentOrDiagnoseFailure(subPackage, null);
            this.collectAllPackages(result2, fragment);
        }
        return result2;
    }

    @Override
    public void forceResolveAll() {
        for (LazyPackageDescriptor lazyPackage : this.getAllPackages()) {
            ForceResolveUtil.forceResolveAllContents(lazyPackage);
        }
    }

    @Override
    @NotNull
    public AnnotationResolver getAnnotationResolver() {
        return this.annotationResolver;
    }

    @Override
    @NotNull
    public DescriptorResolver getDescriptorResolver() {
        return this.descriptorResolver;
    }

    @Override
    @NotNull
    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    @Override
    @NotNull
    public FunctionDescriptorResolver getFunctionDescriptorResolver() {
        return this.functionDescriptorResolver;
    }

    @Override
    @NotNull
    public DeclarationScopeProvider getDeclarationScopeProvider() {
        return this.declarationScopeProvider;
    }

    @Override
    @NotNull
    public FileScopeProvider getFileScopeProvider() {
        return this.fileScopeProvider;
    }

    @Override
    @NotNull
    public LookupTracker getLookupTracker() {
        return this.lookupTracker;
    }

    @Override
    @NotNull
    public SupertypeLoopChecker getSupertypeLoopChecker() {
        return this.supertypeLoopsResolver;
    }

    @Inject
    public void setSupertypeLoopsResolver(@NotNull SupertypeLoopChecker supertypeLoopsResolver) {
        this.supertypeLoopsResolver = supertypeLoopsResolver;
    }

    @Inject
    public void setLocalDescriptorResolver(@NotNull LocalDescriptorResolver localDescriptorResolver) {
        this.localDescriptorResolver = localDescriptorResolver;
    }

    @Override
    @NotNull
    public LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    @Override
    @NotNull
    public DelegationFilter getDelegationFilter() {
        return this.delegationFilter;
    }

    @Override
    @NotNull
    public SyntheticResolveExtension getSyntheticResolveExtension() {
        return this.syntheticResolveExtension;
    }

    @Override
    @NotNull
    public WrappedTypeFactory getWrappedTypeFactory() {
        return this.wrappedTypeFactory;
    }

    @NotNull
    public PlatformDiagnosticSuppressor getPlatformDiagnosticSuppressor() {
        return this.platformDiagnosticSuppressor;
    }

    @Override
    public void assertValid() {
        this.module.assertValid();
    }
}

