/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import com.intellij.util.containers.ContainerUtil;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLITool;
import org.jetbrains.kotlin.cli.common.arguments.Argument;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;

public class Usage {
    @NotNull
    public static <A extends CommonToolArguments> String render(@NotNull CLITool<A> tool, @NotNull A arguments2) {
        boolean extraHelp = arguments2.getExtraHelp();
        StringBuilder sb = new StringBuilder();
        Usage.appendln(sb, "Usage: " + tool.executableScriptFileName() + " <options> <source files>");
        Usage.appendln(sb, "where " + (extraHelp ? "advanced" : "possible") + " options include:");
        KClass kClass2 = JvmClassMappingKt.getKotlinClass(arguments2.getClass());
        for (KCallable callable : kClass2.getMembers()) {
            if (!(callable instanceof KProperty1)) continue;
            Usage.propertyUsage(sb, (KProperty1)callable, extraHelp);
        }
        if (extraHelp) {
            Usage.appendln(sb, "");
            Usage.appendln(sb, "Advanced options are non-standard and may be changed or removed without any notice.");
        } else {
            Usage.renderArgfileUsage(sb);
        }
        return sb.toString();
    }

    private static void propertyUsage(@NotNull StringBuilder sb, @NotNull KProperty1 property, boolean extraHelp) {
        Argument argument = ContainerUtil.findInstance(property.getAnnotations(), Argument.class);
        if (argument == null) {
            return;
        }
        if (extraHelp != ParseCommandLineArgumentsKt.isAdvanced(argument)) {
            return;
        }
        int startLength = sb.length();
        sb.append("  ");
        sb.append(argument.value());
        if (!argument.shortName().isEmpty()) {
            sb.append(" (");
            sb.append(argument.shortName());
            sb.append(")");
        }
        if (!argument.valueDescription().isEmpty()) {
            sb.append(ParseCommandLineArgumentsKt.isAdvanced(argument) ? "=" : " ");
            sb.append(argument.valueDescription());
        }
        int margin = startLength + 29 - 1;
        if (sb.length() >= margin + 5) {
            sb.append("\n");
            margin += sb.length() - startLength;
        }
        while (sb.length() < margin) {
            sb.append(" ");
        }
        sb.append(" ");
        Usage.appendln(sb, argument.description().replace("\n", "\n" + StringsKt.repeat((CharSequence)" ", (int)29)));
    }

    private static void renderArgfileUsage(@NotNull StringBuilder sb) {
        int descriptionStart = sb.length() + 29;
        sb.append("  ");
        sb.append("@");
        sb.append("<argfile>");
        while (sb.length() < descriptionStart) {
            sb.append(" ");
        }
        Usage.appendln(sb, "Expand compiler arguments from the given file, containing one argument or file path per line");
    }

    private static void appendln(@NotNull StringBuilder sb, @NotNull String string) {
        sb.append(string);
        StringsKt.appendln((StringBuilder)sb);
    }
}

