/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.checkers.diagnostics;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.checkers.diagnostics.AbstractTestDiagnostic;
import org.jetbrains.kotlin.checkers.diagnostics.ActualDiagnostic;
import org.jetbrains.kotlin.checkers.diagnostics.TextDiagnostic;
import org.jetbrains.kotlin.checkers.diagnostics.factories.DebugInfoDiagnosticFactory1;
import org.jetbrains.kotlin.checkers.utils.CheckerTestUtil;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.rendering.AbstractDiagnosticWithParametersRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticWithParameters1Renderer;
import org.jetbrains.kotlin.diagnostics.rendering.Renderers;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 !2\u00020\u0001:\u0002!\"B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0016\u001a\u00020\u0003J\u0011\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0001H\u0096\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\b\u0010\u001f\u001a\u00020\u0018H\u0016J\b\u0010 \u001a\u00020\u0003H\u0016R\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0019\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\f\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic;", "Lorg/jetbrains/kotlin/checkers/diagnostics/AbstractTestDiagnostic;", "name", "", "platform", "parameters", "", "inference", "Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic$InferenceCompatibility;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic$InferenceCompatibility;)V", "description", "getDescription", "()Ljava/lang/String;", "inferenceCompatibility", "getInferenceCompatibility", "()Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic$InferenceCompatibility;", "setInferenceCompatibility", "(Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic$InferenceCompatibility;)V", "getName", "getParameters", "()Ljava/util/List;", "getPlatform", "asString", "compareTo", "", "other", "enhanceInferenceCompatibility", "", "equals", "", "", "hashCode", "toString", "Companion", "InferenceCompatibility", "frontend"})
public final class TextDiagnostic
implements AbstractTestDiagnostic {
    @NotNull
    private InferenceCompatibility inferenceCompatibility;
    @NotNull
    private final String name;
    @Nullable
    private final String platform;
    @Nullable
    private final List<String> parameters;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public InferenceCompatibility getInferenceCompatibility() {
        return this.inferenceCompatibility;
    }

    public void setInferenceCompatibility(@NotNull InferenceCompatibility inferenceCompatibility) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)inferenceCompatibility), (String)"<set-?>");
        this.inferenceCompatibility = inferenceCompatibility;
    }

    @NotNull
    public final String getDescription() {
        return (this.getPlatform() != null ? this.getPlatform() + ':' : "") + this.getName();
    }

    @Override
    public int compareTo(@NotNull AbstractTestDiagnostic other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.getName().compareTo(other.getName());
    }

    @Override
    public void enhanceInferenceCompatibility(@NotNull InferenceCompatibility inferenceCompatibility) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)inferenceCompatibility), (String)"inferenceCompatibility");
        this.setInferenceCompatibility(inferenceCompatibility);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || Intrinsics.areEqual(this.getClass(), other.getClass()) ^ true) {
            return false;
        }
        TextDiagnostic that = (TextDiagnostic)other;
        if (Intrinsics.areEqual((Object)this.getName(), (Object)that.getName()) ^ true) {
            return false;
        }
        if (this.getPlatform() != null ? Intrinsics.areEqual((Object)this.getPlatform(), (Object)that.getPlatform()) ^ true : that.getPlatform() != null) {
            return false;
        }
        if (this.parameters != null ? Intrinsics.areEqual(this.parameters, that.parameters) ^ true : that.parameters != null) {
            return false;
        }
        return this.getInferenceCompatibility() == that.getInferenceCompatibility();
    }

    public int hashCode() {
        int result2 = this.getName().hashCode();
        String string = this.getPlatform();
        result2 = 31 * result2 + (string != null ? string.hashCode() : 0);
        List<String> list2 = this.parameters;
        result2 = 31 * result2 + (list2 != null ? ((Object)list2).hashCode() : 0);
        result2 = 31 * result2 + this.getInferenceCompatibility().hashCode();
        return result2;
    }

    @NotNull
    public final String asString() {
        StringBuilder result2 = new StringBuilder();
        if (this.getInferenceCompatibility().getAbbreviation$frontend() != null) {
            result2.append(this.getInferenceCompatibility().getAbbreviation$frontend());
            result2.append(";");
        }
        if (this.getPlatform() != null) {
            result2.append(this.getPlatform());
            result2.append(":");
        }
        result2.append(this.getName());
        if (this.parameters != null) {
            result2.append("(");
            result2.append(StringUtil.join((Collection)this.parameters, (Function)asString.1.INSTANCE, ", "));
            result2.append(")");
        }
        String string = result2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
        return string;
    }

    @NotNull
    public String toString() {
        return this.asString();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getPlatform() {
        return this.platform;
    }

    @Nullable
    public final List<String> getParameters() {
        return this.parameters;
    }

    public TextDiagnostic(@NotNull String name, @Nullable String platform, @Nullable List<String> parameters2, @Nullable InferenceCompatibility inference) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.name = name;
        this.platform = platform;
        this.parameters = parameters2;
        InferenceCompatibility inferenceCompatibility = inference;
        if (inferenceCompatibility == null) {
            inferenceCompatibility = InferenceCompatibility.ALL;
        }
        this.inferenceCompatibility = inferenceCompatibility;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0000R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic$InferenceCompatibility;", "", "abbreviation", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getAbbreviation$frontend", "()Ljava/lang/String;", "setAbbreviation$frontend", "(Ljava/lang/String;)V", "isCompatible", "", "other", "NEW", "OLD", "ALL", "frontend"})
    public static final class InferenceCompatibility
    extends Enum<InferenceCompatibility> {
        public static final /* enum */ InferenceCompatibility NEW;
        public static final /* enum */ InferenceCompatibility OLD;
        public static final /* enum */ InferenceCompatibility ALL;
        private static final /* synthetic */ InferenceCompatibility[] $VALUES;
        @Nullable
        private String abbreviation;

        static {
            InferenceCompatibility[] inferenceCompatibilityArray = new InferenceCompatibility[3];
            InferenceCompatibility[] inferenceCompatibilityArray2 = inferenceCompatibilityArray;
            inferenceCompatibilityArray[0] = NEW = new InferenceCompatibility("NI");
            inferenceCompatibilityArray[1] = OLD = new InferenceCompatibility("OI");
            inferenceCompatibilityArray[2] = ALL = new InferenceCompatibility(null);
            $VALUES = inferenceCompatibilityArray;
        }

        public final boolean isCompatible(@NotNull InferenceCompatibility other) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)other), (String)"other");
            return this == other || this == ALL || other == ALL;
        }

        @Nullable
        public final String getAbbreviation$frontend() {
            return this.abbreviation;
        }

        public final void setAbbreviation$frontend(@Nullable String string) {
            this.abbreviation = string;
        }

        private InferenceCompatibility(String abbreviation) {
            this.abbreviation = abbreviation;
        }

        public static InferenceCompatibility[] values() {
            return (InferenceCompatibility[])$VALUES.clone();
        }

        public static InferenceCompatibility valueOf(String string) {
            return Enum.valueOf(InferenceCompatibility.class, string);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u001c\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\f\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic$Companion;", "", "()V", "asTextDiagnostic", "Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic;", "abstractTestDiagnostic", "Lorg/jetbrains/kotlin/checkers/diagnostics/AbstractTestDiagnostic;", "actualDiagnostic", "Lorg/jetbrains/kotlin/checkers/diagnostics/ActualDiagnostic;", "computeInferenceCompatibility", "Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic$InferenceCompatibility;", "abbreviation", "", "extractDataBefore", "prefix", "anchor", "parseDiagnostic", "text", "frontend"})
    public static final class Companion {
        @NotNull
        public final TextDiagnostic parseDiagnostic(@NotNull String text2) {
            Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
            Matcher matcher = CheckerTestUtil.INSTANCE.getIndividualDiagnosticPattern().matcher(text2);
            if (!matcher.find()) {
                throw (Throwable)new IllegalArgumentException("Could not parse diagnostic: " + text2);
            }
            InferenceCompatibility inference = this.computeInferenceCompatibility(this.extractDataBefore(matcher.group(1), ";"));
            String platform = this.extractDataBefore(matcher.group(2), ":");
            String name = matcher.group(3);
            String string = matcher.group(4);
            if (string == null) {
                String string2 = name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
                return new TextDiagnostic(string2, platform, null, inference);
            }
            String parameters2 = string;
            String string3 = name;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"name");
            CharSequence charSequence = StringsKt.trim((String)parameters2, (char[])new char[]{'\"'});
            Regex regex = new Regex("\",\\s*\"");
            String string4 = platform;
            String string5 = string3;
            int n = 0;
            boolean bl = false;
            List list2 = regex.split(charSequence, n);
            InferenceCompatibility inferenceCompatibility = inference;
            List list3 = list2;
            String string6 = string4;
            String string7 = string5;
            return new TextDiagnostic(string7, string6, list3, inferenceCompatibility);
        }

        private final InferenceCompatibility computeInferenceCompatibility(String abbreviation) {
            InferenceCompatibility inferenceCompatibility;
            if (abbreviation == null) {
                inferenceCompatibility = InferenceCompatibility.ALL;
            } else {
                InferenceCompatibility[] $this$single$iv = InferenceCompatibility.values();
                boolean $i$f$single = false;
                InferenceCompatibility single$iv = null;
                boolean found$iv = false;
                InferenceCompatibility[] inferenceCompatibilityArray = $this$single$iv;
                int n = inferenceCompatibilityArray.length;
                for (int i = 0; i < n; ++i) {
                    InferenceCompatibility element$iv;
                    InferenceCompatibility inference = element$iv = inferenceCompatibilityArray[i];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)abbreviation, (Object)inference.getAbbreviation$frontend())) continue;
                    if (found$iv) {
                        throw (Throwable)new IllegalArgumentException("Array contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
                }
                inferenceCompatibility = single$iv;
            }
            return inferenceCompatibility;
        }

        private final String extractDataBefore(String prefix, String anchor2) {
            boolean bl = prefix == null || StringsKt.endsWith$default((String)prefix, (String)anchor2, (boolean)false, (int)2, null);
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = prefix;
                if (string == null) {
                    string = "";
                }
                String string2 = string;
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            String string = prefix;
            return string != null ? StringsKt.substringBeforeLast((String)string, (String)anchor2, (String)prefix) : null;
        }

        @NotNull
        public final TextDiagnostic asTextDiagnostic(@NotNull AbstractTestDiagnostic abstractTestDiagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)abstractTestDiagnostic, (String)"abstractTestDiagnostic");
            return abstractTestDiagnostic instanceof ActualDiagnostic ? this.asTextDiagnostic((ActualDiagnostic)abstractTestDiagnostic) : (TextDiagnostic)abstractTestDiagnostic;
        }

        private final TextDiagnostic asTextDiagnostic(ActualDiagnostic actualDiagnostic) {
            Diagnostic diagnostic = actualDiagnostic.getDiagnostic();
            DiagnosticFactory<?> diagnosticFactory = diagnostic.getFactory();
            DiagnosticRenderer renderer = diagnosticFactory instanceof DebugInfoDiagnosticFactory1 ? (DiagnosticRenderer)new DiagnosticWithParameters1Renderer<Object>("{0}", Renderers.TO_STRING) : DefaultErrorMessages.getRendererForDiagnostic(diagnostic);
            String diagnosticName = actualDiagnostic.getName();
            if (renderer instanceof AbstractDiagnosticWithParametersRenderer) {
                Object[] renderParameters = ((AbstractDiagnosticWithParametersRenderer)renderer).renderParameters(diagnostic);
                List<String> list2 = ContainerUtil.map(renderParameters, (Function)asTextDiagnostic.parameters.1.INSTANCE);
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"ContainerUtil.map(render\u2026eters, { it.toString() })");
                List<String> parameters2 = list2;
                return new TextDiagnostic(diagnosticName, actualDiagnostic.getPlatform(), parameters2, actualDiagnostic.getInferenceCompatibility());
            }
            return new TextDiagnostic(diagnosticName, actualDiagnostic.getPlatform(), null, actualDiagnostic.getInferenceCompatibility());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

