/*
 * Copyright 2010-2019 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */
package org.jetbrains.kotlin.fir.visitors

import org.jetbrains.kotlin.fir.*
import org.jetbrains.kotlin.fir.declarations.*
import org.jetbrains.kotlin.fir.declarations.impl.*
import org.jetbrains.kotlin.fir.expressions.*
import org.jetbrains.kotlin.fir.expressions.impl.*
import org.jetbrains.kotlin.fir.references.*
import org.jetbrains.kotlin.fir.types.*


/** This file generated by :compiler:fir:tree:generateVisitors. DO NOT MODIFY MANUALLY! */
abstract class FirVisitor<out R, in D> {
    abstract fun visitElement(element: FirElement, data: D): R

    open fun visitCatch(catch: FirCatch, data: D): R {
        return visitElement(catch, data)
    }

    open fun visitDeclaration(declaration: FirDeclaration, data: D): R {
        return visitElement(declaration, data)
    }

    open fun <F : FirCallableDeclaration<F>> visitCallableDeclaration(callableDeclaration: FirCallableDeclaration<F>, data: D): R {
        return visitElement(callableDeclaration, data)
    }

    open fun <F : FirCallableMemberDeclaration<F>> visitCallableMemberDeclaration(callableMemberDeclaration: FirCallableMemberDeclaration<F>, data: D): R {
        return visitElement(callableMemberDeclaration, data)
    }

    open fun visitDeclarationWithBody(declarationWithBody: FirDeclarationWithBody, data: D): R {
        return visitElement(declarationWithBody, data)
    }

    open fun visitAnonymousInitializer(anonymousInitializer: FirAnonymousInitializer, data: D): R {
        return visitElement(anonymousInitializer, data)
    }

    open fun <F : FirFunction<F>> visitFunction(function: FirFunction<F>, data: D): R {
        return visitElement(function, data)
    }

    open fun visitAnonymousFunction(anonymousFunction: FirAnonymousFunction, data: D): R {
        return visitElement(anonymousFunction, data)
    }

    open fun <F : FirMemberFunction<F>> visitMemberFunction(memberFunction: FirMemberFunction<F>, data: D): R {
        return visitElement(memberFunction, data)
    }

    open fun visitConstructor(constructor: FirConstructor, data: D): R {
        return visitElement(constructor, data)
    }

    open fun visitNamedFunction(namedFunction: FirNamedFunction, data: D): R {
        return visitElement(namedFunction, data)
    }

    open fun <F : FirFunction<F>> visitModifiableFunction(modifiableFunction: FirModifiableFunction<F>, data: D): R {
        return visitElement(modifiableFunction, data)
    }

    open fun visitPropertyAccessor(propertyAccessor: FirPropertyAccessor, data: D): R {
        return visitElement(propertyAccessor, data)
    }

    open fun visitErrorDeclaration(errorDeclaration: FirErrorDeclaration, data: D): R {
        return visitElement(errorDeclaration, data)
    }

    open fun visitField(field: FirField, data: D): R {
        return visitElement(field, data)
    }

    open fun visitNamedDeclaration(namedDeclaration: FirNamedDeclaration, data: D): R {
        return visitElement(namedDeclaration, data)
    }

    open fun visitMemberDeclaration(memberDeclaration: FirMemberDeclaration, data: D): R {
        return visitElement(memberDeclaration, data)
    }

    open fun <F : FirClassLikeDeclaration<F>> visitClassLikeDeclaration(classLikeDeclaration: FirClassLikeDeclaration<F>, data: D): R {
        return visitElement(classLikeDeclaration, data)
    }

    open fun visitRegularClass(regularClass: FirRegularClass, data: D): R {
        return visitElement(regularClass, data)
    }

    open fun visitEnumEntry(enumEntry: FirEnumEntry, data: D): R {
        return visitElement(enumEntry, data)
    }

    open fun visitTypeAlias(typeAlias: FirTypeAlias, data: D): R {
        return visitElement(typeAlias, data)
    }

    open fun visitTypeParameter(typeParameter: FirTypeParameter, data: D): R {
        return visitElement(typeParameter, data)
    }

    open fun visitProperty(property: FirProperty, data: D): R {
        return visitElement(property, data)
    }

    open fun visitTypedDeclaration(typedDeclaration: FirTypedDeclaration, data: D): R {
        return visitElement(typedDeclaration, data)
    }

    open fun visitValueParameter(valueParameter: FirValueParameter, data: D): R {
        return visitElement(valueParameter, data)
    }

    open fun <F : FirVariable<F>> visitVariable(variable: FirVariable<F>, data: D): R {
        return visitElement(variable, data)
    }

    open fun visitDeclarationStatus(declarationStatus: FirDeclarationStatus, data: D): R {
        return visitElement(declarationStatus, data)
    }

    open fun visitResolvedDeclarationStatus(resolvedDeclarationStatus: FirResolvedDeclarationStatus, data: D): R {
        return visitElement(resolvedDeclarationStatus, data)
    }

    open fun visitImport(import: FirImport, data: D): R {
        return visitElement(import, data)
    }

    open fun visitResolvedImport(resolvedImport: FirResolvedImport, data: D): R {
        return visitElement(resolvedImport, data)
    }

    open fun visitLabel(label: FirLabel, data: D): R {
        return visitElement(label, data)
    }

    open fun visitPackageFragment(packageFragment: FirPackageFragment, data: D): R {
        return visitElement(packageFragment, data)
    }

    open fun visitFile(file: FirFile, data: D): R {
        return visitElement(file, data)
    }

    open fun visitReference(reference: FirReference, data: D): R {
        return visitElement(reference, data)
    }

    open fun visitControlFlowGraphReference(controlFlowGraphReference: FirControlFlowGraphReference, data: D): R {
        return visitElement(controlFlowGraphReference, data)
    }

    open fun visitNamedReference(namedReference: FirNamedReference, data: D): R {
        return visitElement(namedReference, data)
    }

    open fun visitResolvedCallableReference(resolvedCallableReference: FirResolvedCallableReference, data: D): R {
        return visitElement(resolvedCallableReference, data)
    }

    open fun visitBackingFieldReference(backingFieldReference: FirBackingFieldReference, data: D): R {
        return visitElement(backingFieldReference, data)
    }

    open fun visitDelegateFieldReference(delegateFieldReference: FirDelegateFieldReference, data: D): R {
        return visitElement(delegateFieldReference, data)
    }

    open fun visitSuperReference(superReference: FirSuperReference, data: D): R {
        return visitElement(superReference, data)
    }

    open fun visitThisReference(thisReference: FirThisReference, data: D): R {
        return visitElement(thisReference, data)
    }

    open fun visitStatement(statement: FirStatement, data: D): R {
        return visitElement(statement, data)
    }

    open fun visitAnnotatedStatement(annotatedStatement: FirAnnotatedStatement, data: D): R {
        return visitElement(annotatedStatement, data)
    }

    open fun visitExpression(expression: FirExpression, data: D): R {
        return visitElement(expression, data)
    }

    open fun visitCall(call: FirCall, data: D): R {
        return visitElement(call, data)
    }

    open fun visitArraySetCall(arraySetCall: FirArraySetCall, data: D): R {
        return visitElement(arraySetCall, data)
    }

    open fun visitCallWithArgumentList(callWithArgumentList: FirCallWithArgumentList, data: D): R {
        return visitElement(callWithArgumentList, data)
    }

    open fun visitAnnotationCall(annotationCall: FirAnnotationCall, data: D): R {
        return visitElement(annotationCall, data)
    }

    open fun visitDelegatedConstructorCall(delegatedConstructorCall: FirDelegatedConstructorCall, data: D): R {
        return visitElement(delegatedConstructorCall, data)
    }

    open fun visitOperatorCall(operatorCall: FirOperatorCall, data: D): R {
        return visitElement(operatorCall, data)
    }

    open fun visitOperationBasedCall(operationBasedCall: FirOperationBasedCall, data: D): R {
        return visitElement(operationBasedCall, data)
    }

    open fun visitTypeOperatorCall(typeOperatorCall: FirTypeOperatorCall, data: D): R {
        return visitElement(typeOperatorCall, data)
    }

    open fun visitStringConcatenationCall(stringConcatenationCall: FirStringConcatenationCall, data: D): R {
        return visitElement(stringConcatenationCall, data)
    }

    open fun visitUnknownTypeCallWithArgumentList(unknownTypeCallWithArgumentList: FirUnknownTypeCallWithArgumentList, data: D): R {
        return visitElement(unknownTypeCallWithArgumentList, data)
    }

    open fun visitArrayOfCall(arrayOfCall: FirArrayOfCall, data: D): R {
        return visitElement(arrayOfCall, data)
    }

    open fun visitFunctionCall(functionCall: FirFunctionCall, data: D): R {
        return visitElement(functionCall, data)
    }

    open fun visitComponentCall(componentCall: FirComponentCall, data: D): R {
        return visitElement(componentCall, data)
    }

    open fun visitGetClassCall(getClassCall: FirGetClassCall, data: D): R {
        return visitElement(getClassCall, data)
    }

    open fun visitUncheckedNotNullCast(uncheckedNotNullCast: FirUncheckedNotNullCast, data: D): R {
        return visitElement(uncheckedNotNullCast, data)
    }

    open fun <E : FirTargetElement> visitJump(jump: FirJump<E>, data: D): R {
        return visitElement(jump, data)
    }

    open fun visitLoopJump(loopJump: FirLoopJump, data: D): R {
        return visitElement(loopJump, data)
    }

    open fun visitBreakExpression(breakExpression: FirBreakExpression, data: D): R {
        return visitElement(breakExpression, data)
    }

    open fun visitContinueExpression(continueExpression: FirContinueExpression, data: D): R {
        return visitElement(continueExpression, data)
    }

    open fun visitReturnExpression(returnExpression: FirReturnExpression, data: D): R {
        return visitElement(returnExpression, data)
    }

    open fun visitThrowExpression(throwExpression: FirThrowExpression, data: D): R {
        return visitElement(throwExpression, data)
    }

    open fun visitUnknownTypeExpression(unknownTypeExpression: FirUnknownTypeExpression, data: D): R {
        return visitElement(unknownTypeExpression, data)
    }

    open fun visitBinaryLogicExpression(binaryLogicExpression: FirBinaryLogicExpression, data: D): R {
        return visitElement(binaryLogicExpression, data)
    }

    open fun visitBlock(block: FirBlock, data: D): R {
        return visitElement(block, data)
    }

    open fun visitCallLikeControlFlowExpression(callLikeControlFlowExpression: FirCallLikeControlFlowExpression, data: D): R {
        return visitElement(callLikeControlFlowExpression, data)
    }

    open fun visitTryExpression(tryExpression: FirTryExpression, data: D): R {
        return visitElement(tryExpression, data)
    }

    open fun visitWhenExpression(whenExpression: FirWhenExpression, data: D): R {
        return visitElement(whenExpression, data)
    }

    open fun visitClassReferenceExpression(classReferenceExpression: FirClassReferenceExpression, data: D): R {
        return visitElement(classReferenceExpression, data)
    }

    open fun <T> visitConstExpression(constExpression: FirConstExpression<T>, data: D): R {
        return visitElement(constExpression, data)
    }

    open fun visitErrorExpression(errorExpression: FirErrorExpression, data: D): R {
        return visitElement(errorExpression, data)
    }

    open fun visitQualifiedAccessExpression(qualifiedAccessExpression: FirQualifiedAccessExpression, data: D): R {
        return visitElement(qualifiedAccessExpression, data)
    }

    open fun visitCallableReferenceAccess(callableReferenceAccess: FirCallableReferenceAccess, data: D): R {
        return visitElement(callableReferenceAccess, data)
    }

    open fun visitExpressionWithSmartcast(expressionWithSmartcast: FirExpressionWithSmartcast, data: D): R {
        return visitElement(expressionWithSmartcast, data)
    }

    open fun visitResolvedQualifier(resolvedQualifier: FirResolvedQualifier, data: D): R {
        return visitElement(resolvedQualifier, data)
    }

    open fun visitWhenSubjectExpression(whenSubjectExpression: FirWhenSubjectExpression, data: D): R {
        return visitElement(whenSubjectExpression, data)
    }

    open fun visitWrappedExpression(wrappedExpression: FirWrappedExpression, data: D): R {
        return visitElement(wrappedExpression, data)
    }

    open fun visitWrappedArgumentExpression(wrappedArgumentExpression: FirWrappedArgumentExpression, data: D): R {
        return visitElement(wrappedArgumentExpression, data)
    }

    open fun visitLambdaArgumentExpression(lambdaArgumentExpression: FirLambdaArgumentExpression, data: D): R {
        return visitElement(lambdaArgumentExpression, data)
    }

    open fun visitNamedArgumentExpression(namedArgumentExpression: FirNamedArgumentExpression, data: D): R {
        return visitElement(namedArgumentExpression, data)
    }

    open fun visitSpreadArgumentExpression(spreadArgumentExpression: FirSpreadArgumentExpression, data: D): R {
        return visitElement(spreadArgumentExpression, data)
    }

    open fun visitWrappedDelegateExpression(wrappedDelegateExpression: FirWrappedDelegateExpression, data: D): R {
        return visitElement(wrappedDelegateExpression, data)
    }

    open fun visitClass(klass: FirClass, data: D): R {
        return visitElement(klass, data)
    }

    open fun visitAnonymousObject(anonymousObject: FirAnonymousObject, data: D): R {
        return visitElement(anonymousObject, data)
    }

    open fun visitModifiableClass(modifiableClass: FirModifiableClass, data: D): R {
        return visitElement(modifiableClass, data)
    }

    open fun visitErrorStatement(errorStatement: FirErrorStatement, data: D): R {
        return visitElement(errorStatement, data)
    }

    open fun visitLoop(loop: FirLoop, data: D): R {
        return visitElement(loop, data)
    }

    open fun visitDoWhileLoop(doWhileLoop: FirDoWhileLoop, data: D): R {
        return visitElement(doWhileLoop, data)
    }

    open fun visitWhileLoop(whileLoop: FirWhileLoop, data: D): R {
        return visitElement(whileLoop, data)
    }

    open fun visitResolvable(resolvable: FirResolvable, data: D): R {
        return visitElement(resolvable, data)
    }

    open fun visitQualifiedAccess(qualifiedAccess: FirQualifiedAccess, data: D): R {
        return visitElement(qualifiedAccess, data)
    }

    open fun visitAssignment(assignment: FirAssignment, data: D): R {
        return visitElement(assignment, data)
    }

    open fun visitVariableAssignment(variableAssignment: FirVariableAssignment, data: D): R {
        return visitElement(variableAssignment, data)
    }

    open fun <C : FirReference> visitModifiableQualifiedAccess(modifiableQualifiedAccess: FirModifiableQualifiedAccess<C>, data: D): R {
        return visitElement(modifiableQualifiedAccess, data)
    }

    open fun visitTargetElement(targetElement: FirTargetElement, data: D): R {
        return visitElement(targetElement, data)
    }

    open fun visitLabeledElement(labeledElement: FirLabeledElement, data: D): R {
        return visitElement(labeledElement, data)
    }

    open fun visitTypeProjection(typeProjection: FirTypeProjection, data: D): R {
        return visitElement(typeProjection, data)
    }

    open fun visitStarProjection(starProjection: FirStarProjection, data: D): R {
        return visitElement(starProjection, data)
    }

    open fun visitTypeProjectionWithVariance(typeProjectionWithVariance: FirTypeProjectionWithVariance, data: D): R {
        return visitElement(typeProjectionWithVariance, data)
    }

    open fun visitTypeRef(typeRef: FirTypeRef, data: D): R {
        return visitElement(typeRef, data)
    }

    open fun visitDelegatedTypeRef(delegatedTypeRef: FirDelegatedTypeRef, data: D): R {
        return visitElement(delegatedTypeRef, data)
    }

    open fun visitImplicitTypeRef(implicitTypeRef: FirImplicitTypeRef, data: D): R {
        return visitElement(implicitTypeRef, data)
    }

    open fun visitResolvedTypeRef(resolvedTypeRef: FirResolvedTypeRef, data: D): R {
        return visitElement(resolvedTypeRef, data)
    }

    open fun visitErrorTypeRef(errorTypeRef: FirErrorTypeRef, data: D): R {
        return visitElement(errorTypeRef, data)
    }

    open fun visitResolvedFunctionTypeRef(resolvedFunctionTypeRef: FirResolvedFunctionTypeRef, data: D): R {
        return visitElement(resolvedFunctionTypeRef, data)
    }

    open fun visitTypeRefWithNullability(typeRefWithNullability: FirTypeRefWithNullability, data: D): R {
        return visitElement(typeRefWithNullability, data)
    }

    open fun visitDynamicTypeRef(dynamicTypeRef: FirDynamicTypeRef, data: D): R {
        return visitElement(dynamicTypeRef, data)
    }

    open fun visitFunctionTypeRef(functionTypeRef: FirFunctionTypeRef, data: D): R {
        return visitElement(functionTypeRef, data)
    }

    open fun visitUserTypeRef(userTypeRef: FirUserTypeRef, data: D): R {
        return visitElement(userTypeRef, data)
    }

    open fun visitWhenBranch(whenBranch: FirWhenBranch, data: D): R {
        return visitElement(whenBranch, data)
    }

}
