/*
 * Copyright 2010-2019 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.fir

import org.jetbrains.kotlin.fir.types.FirTypeRef
import org.jetbrains.kotlin.fir.visitors.FirVisitor

interface FirSuperReference : FirReference {
    val superTypeRef: FirTypeRef

    fun replaceSuperTypeRef(newSuperTypeRef: FirTypeRef)

    override fun <R, D> accept(visitor: FirVisitor<R, D>, data: D): R =
        visitor.visitSuperReference(this, data)

    override fun <R, D> acceptChildren(visitor: FirVisitor<R, D>, data: D) {
        superTypeRef.accept(visitor, data)
    }
}