/*
 * Copyright 2010-2019 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.fir.expressions

import org.jetbrains.kotlin.fir.FirLabeledElement
import org.jetbrains.kotlin.fir.VisitedSupertype
import org.jetbrains.kotlin.fir.visitors.FirTransformer
import org.jetbrains.kotlin.fir.visitors.FirVisitor

interface FirLoop : @VisitedSupertype FirStatement, FirLabeledElement, FirAnnotationContainer {
    val condition: FirExpression

    val block: FirBlock

    override fun <R, D> accept(visitor: FirVisitor<R, D>, data: D): R =
        visitor.visitLoop(this, data)

    override fun <R, D> acceptChildren(visitor: FirVisitor<R, D>, data: D) {
        condition.accept(visitor, data)
        block.accept(visitor, data)
        super<FirLabeledElement>.acceptChildren(visitor, data)
    }

    fun <D> transformCondition(transformer: FirTransformer<D>, data: D): FirLoop
    fun <D> transformBlock(transformer: FirTransformer<D>, data: D): FirLoop
    fun <D> transformRestChildren(transformer: FirTransformer<D>, data: D): FirLoop
}